/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.servlets;

import com.apcc.m11.components.omaha.LogUtils;
import com.apcc.m11.components.webserver.cfgwizard.pages.LoginPage;
import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.pages.OmahaConfigurePage;
import com.apcc.m11.components.webserver.servlets.M11Servlet;
import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.m11.components.webserver.util.virtualization.nutanix.NutanixDetails;
import com.apcc.m11.components.webserver.util.virtualization.vmware.VMWareDetails;
import com.apcc.m11.ds.powersource.communication.TCPIPCommunication;
import com.apcc.m11.ds.services.WebServerGroup;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.configservice.ConfigurationKeys;
import com.apcc.pcns.configservice.configurationmanagers.ConfigurationManager;
import com.apcc.pcns.configservice.validation.UserFilePathValidator;
import com.apcc.pcns.hyperflex.HyperflexDetails;
import com.apcc.pcns.vxrail.VxRailDetails;
import com.vmware.vim25.mo.ServiceInstance;
import java.io.IOException;
import javax.servlet.ServletException;
import org.apache.commons.configuration2.ex.ConversionException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Configure
extends M11Servlet {
    private static final long serialVersionUID = 2206355848780068178L;
    private static final Logger logger = LogManager.getLogger(Configure.class);
    public static final String VALUE_INVALID_VCENTER_CREDENTIALS = "vcenter_server_invalid";
    public static final String VALUE_INVALID_SCVMM_IP = "scvmm_ip_invalid";
    public static final String VALUE_INVALID_ESXI_HOST_CREDENTIALS = "esxi_host_invalid";

    public Configure(ServiceManager serviceManager) {
        super(serviceManager);
    }

    @Override
    protected void doGet(PageContext pageContext) throws ServletException, IOException {
        OmahaConfigurePage omahaConfigurePage = new OmahaConfigurePage(this.services);
        this.setFormToken(pageContext.getRequest());
        this.update(pageContext);
        pageContext.writeHTML(omahaConfigurePage);
    }

    @Override
    protected void doPost(PageContext pageContext) throws ServletException, IOException {
        if (this.verifyFormToken(pageContext)) {
            this.setPostData(pageContext);
            pageContext.getResponse().sendRedirect(pageContext.getResponse().encodeRedirectURL("/configure"));
        }
    }

    private void update(PageContext pageContext) {
        Object object;
        String string = pageContext.format(TCPIPCommunication.PollInterval.getObjectId());
        if (string != null) {
            pageContext.setValue("HeartbeatPollingInvterval", string);
        } else {
            pageContext.setValue("HeartbeatPollingIntervalError", "");
        }
        String string2 = pageContext.format(TCPIPCommunication.EventReceiverPort.getObjectId());
        if (string2 != null) {
            pageContext.setValue("ReceiverPort", string2);
        } else {
            pageContext.setValue("ReceiverPortError", "");
        }
        String string3 = pageContext.format(TCPIPCommunication.AuthKey.getObjectId());
        if (string3 != null) {
            pageContext.setValue("AuthenticationKey", string3);
        } else {
            pageContext.setValue("AuthenticationKeyError", "");
        }
        String string4 = pageContext.format(TCPIPCommunication.AuthUserName.getObjectId());
        if (string4 != null) {
            pageContext.setValue("AuthenticationKeyUserName", string4);
        } else {
            pageContext.setValue("AuthenticationKeyUserNameError", "");
        }
        if (this.services.getVirtualConfigurationManager().isSimplivity()) {
            object = this.services.getSimplivityUtils().loadSimplivityDetails();
            pageContext.setValue("simplivity_details", object);
        }
        if (this.services.getVirtualConfigurationManager().isHyperflex()) {
            object = this.services.getHyperflexUtils().loadHyperflexDetails();
            pageContext.setValue("hyperflex_details", object);
        }
        boolean bl = this.services.getVirtualConfigurationManager().isManagedHost();
        ConfigurationManager configurationManager = this.services.getConfigurationManager();
        if (this.services.getVirtualConfigurationManager().isESXi()) {
            if (bl) {
                String string5;
                VMWareDetails vMWareDetails = this.services.getVirtualConfigurationManager().loadVCenterServerDetails();
                if (vMWareDetails == null) {
                    vMWareDetails = new VMWareDetails();
                }
                if ((string5 = vMWareDetails.getPassword()) != null) {
                    pageContext.setValue("vcenter_server_password", string5);
                } else {
                    pageContext.setValue("VcenterAuthenticationKeyError", "");
                }
                String string6 = vMWareDetails.getServerIp();
                if (string6 != null) {
                    pageContext.setValue("VcenterServerIpName", string6);
                } else {
                    pageContext.setValue("VcenterServerIpError", "");
                }
                String string7 = vMWareDetails.getUsername();
                if (string7 != null) {
                    pageContext.setValue("VcenterAuthenticationKeyUserNameName", string7);
                } else {
                    pageContext.setValue("VcenterAuthenticationKeyUserNameError", "");
                }
                Boolean bl2 = false;
                Boolean bl3 = false;
                Boolean bl4 = false;
                String string8 = "";
                try {
                    if (configurationManager.containsKey("HostConfigSettings", ConfigurationKeys.ENABLE_PLUGIN)) {
                        bl4 = configurationManager.getBoolean("HostConfigSettings", ConfigurationKeys.ENABLE_PLUGIN);
                    }
                    if (configurationManager.containsKey("HostConfigSettings", ConfigurationKeys.PLUGIN_TYPE)) {
                        string8 = configurationManager.getString("HostConfigSettings", ConfigurationKeys.PLUGIN_TYPE);
                    }
                }
                catch (ConversionException conversionException) {
                    logger.error((Object)conversionException);
                }
                bl2 = string8 != null && bl4 == true && string8.equals(ConfigurationKeys.LEGACY_PLUGIN);
                bl3 = string8 != null && bl4 == true && string8.equals(ConfigurationKeys.WEB_CLIENT_PLUGIN);
                pageContext.setValue("VSpherePluginName", bl2);
                pageContext.setValue("VSphereWebPluginName", bl3);
            } else {
                String string9;
                VMWareDetails vMWareDetails = this.services.getVirtualConfigurationManager().loadESXiHostServerDetails();
                if (vMWareDetails == null) {
                    vMWareDetails = new VMWareDetails();
                }
                if ((string9 = vMWareDetails.getPassword()) != null) {
                    pageContext.setValue("esxi_host_password", string9);
                } else {
                    pageContext.setValue("ESXiAuthenticationKeyError", "");
                }
                String string10 = vMWareDetails.getUsername();
                if (string10 != null) {
                    pageContext.setValue("ESXiAuthenticationKeyUserNameName", string10);
                } else {
                    pageContext.setValue("ESXiAuthenticationKeyUserNameError", "");
                }
                String string11 = vMWareDetails.getServerIp();
                if (string11 != null) {
                    pageContext.setValue("ESXiHostServerAddressName", string11);
                } else {
                    pageContext.setValue("ESXiHostServerAddressNameError", "");
                }
            }
        } else if (this.services.getVirtualConfigurationManager().isNutanixAHV()) {
            this.getNutanixConnectionCredentials(pageContext);
        }
        pageContext.setValue("SSLEnabledFlag", Boolean.valueOf(M11Servlet.getSslEnabled()).toString());
    }

    private void setPostData(PageContext pageContext) {
        String string;
        String string2 = Utils.getRemoteAddress(pageContext);
        String string3 = string = (String)pageContext.get(TCPIPCommunication.AuthUserName.getObjectId());
        String string4 = pageContext.getPostQueryValue("AuthenticationKeyUserName");
        if (string4 != null && !string4.equals(string)) {
            if (pageContext.set(TCPIPCommunication.AuthUserName.getObjectId(), string4)) {
                string3 = string4;
                LogUtils.logMessage("UserNameChanged", string, string2, string3);
            } else {
                pageContext.setValue("AuthenticationKeyUserNameError", string4);
            }
        }
        String string5 = (String)pageContext.get(TCPIPCommunication.AuthKey.getObjectId());
        string4 = pageContext.getPostQueryValue("AuthenticationKey");
        if (StringUtils.isNotBlank((CharSequence)string4) && !string4.equals(string5)) {
            if (pageContext.set(TCPIPCommunication.AuthKey.getObjectId(), string4)) {
                LogUtils.logMessage("PasswordChanged", string3, string2);
            } else {
                pageContext.setValue("AuthenticationKeyError", string4);
            }
        }
        if ((string4 = pageContext.getPostQueryValue("MD5PassPhrase")) != null) {
            string4 = string4.trim();
            String string6 = (String)pageContext.get(TCPIPCommunication.PasswordPhrase.getObjectId());
            if (!string4.equals(LoginPage.theHiddenPhrase) && !string4.equals(string6)) {
                if (pageContext.set(TCPIPCommunication.PasswordPhrase.getObjectId(), string4)) {
                    LogUtils.logMessage("AuthPhraseChanged", string3, string2);
                } else {
                    pageContext.setValue("MD5PassPhraseError", string4);
                }
            }
        }
        if ((string4 = pageContext.getPostQueryValue("SSLEnabledFlag")) != null) {
            boolean bl = true;
            bl = string4.compareToIgnoreCase("true") == 0;
            pageContext.set(WebServerGroup.SSLEnabled.getObjectId(), bl);
        }
        boolean bl = this.services.getVirtualConfigurationManager().isManagedHost();
        if (this.services.getVirtualConfigurationManager().isESXi()) {
            if (bl) {
                this.setVCenterCredentials(pageContext);
                if (this.services.getVirtualConfigurationManager().isSimplivity()) {
                    this.setSimplivityDetails(pageContext);
                }
                if (this.services.getVirtualConfigurationManager().isHyperflex()) {
                    this.setHyperflexDetails(pageContext);
                }
                if (this.services.getVirtualConfigurationManager().isVxRail()) {
                    this.setVxRailDetails(pageContext);
                }
            } else {
                this.setESXiCredentials(pageContext);
            }
        }
        if (this.services.getVirtualConfigurationManager().isNutanixAHV()) {
            this.setNutanixConnectionCredentials(pageContext);
        }
        if (bl && this.services.getVirtualConfigurationManager().isHyperV()) {
            this.setSCVMMIP(pageContext);
        }
    }

    private void setSCVMMIP(PageContext pageContext) {
        String string = null;
        String string2 = this.services.getVirtualConfigurationManager().getServerIP();
        string = pageContext.getPostQueryValue("SCVMMIpName");
        if (string != null && !string.equals(string2)) {
            this.services.getConfigurationManager().setProperty("HostDetails", "Server", string);
        }
    }

    private void setSimplivityDetails(PageContext pageContext) {
        String string = null;
        String string2 = this.services.getSimplivityUtils().getSimplivityUser();
        String string3 = this.services.getSimplivityUtils().getSimplivityPassword();
        string = StringUtils.trim((String)pageContext.getPostQueryValue("simplivity_ovc_user"));
        if (!StringUtils.equals((CharSequence)string2, (CharSequence)string)) {
            this.services.getSimplivityUtils().setSimplivityUser(string);
        }
        if (StringUtils.isNotBlank((CharSequence)(string = pageContext.getPostQueryValue("simplivity_ovc_password"))) && !StringUtils.equals((CharSequence)string3, (CharSequence)string)) {
            this.services.getSimplivityUtils().setSimplivityPassword(string);
        }
    }

    private void setHyperflexDetails(PageContext pageContext) {
        String string = null;
        boolean bl = false;
        HyperflexDetails hyperflexDetails = this.services.getHyperflexUtils().loadHyperflexDetails();
        string = pageContext.getPostQueryValue("hyperflex_cvm");
        if (string != null && !string.equals(hyperflexDetails.getHost())) {
            bl = true;
            hyperflexDetails.setHost(string);
        }
        if ((string = pageContext.getPostQueryValue("hyperflex_user")) != null && !string.equals(hyperflexDetails.getUsername())) {
            bl = true;
            hyperflexDetails.setUsername(string);
        }
        if (StringUtils.isNotBlank((CharSequence)(string = pageContext.getPostQueryValue("hyperflex_password"))) && !string.equals(hyperflexDetails.getPassword())) {
            bl = true;
            hyperflexDetails.setPassword(string);
        }
        if (bl) {
            this.services.getHyperflexUtils().saveHyperflexDetails(hyperflexDetails);
        }
    }

    private void setVxRailDetails(PageContext pageContext) {
        String string = null;
        boolean bl = false;
        VxRailDetails vxRailDetails = this.services.getVxRailUtils().loadVxRailDetails();
        string = pageContext.getPostQueryValue("vxrail_cluster_ip");
        if (string != null && !string.equals(vxRailDetails.getVxRailManagerIp())) {
            bl = true;
            vxRailDetails.setVxRailManagerIp(string);
        }
        if (bl) {
            this.services.getVxRailUtils().saveVxRailDetails(vxRailDetails);
        }
    }

    private void setVCenterCredentials(PageContext pageContext) {
        Object object = null;
        boolean bl = false;
        VMWareDetails vMWareDetails = this.services.getVirtualConfigurationManager().loadVCenterServerDetails();
        if (vMWareDetails == null) {
            vMWareDetails = new VMWareDetails();
        }
        String string = vMWareDetails.getProtocol();
        String string2 = vMWareDetails.getPort();
        String string3 = this.services.getAuthHelper().getVCenterPassword();
        vMWareDetails.setPassword(string3);
        String string4 = vMWareDetails.getUsername();
        String string5 = vMWareDetails.getServerIp();
        boolean bl2 = vMWareDetails.isSkipCertCheck();
        boolean bl3 = vMWareDetails.isVCenterInstalledOnaVM();
        object = pageContext.getPostQueryValue("vcenter_server_protocol");
        if (object != null && !((String)object).equals(string)) {
            bl = true;
            vMWareDetails.setProtocol((String)object);
        }
        if ((object = pageContext.getPostQueryValue("vcenter_server_port")) != null && !((String)object).equals(string2)) {
            bl = true;
            vMWareDetails.setPort((String)object);
        }
        if ((object = pageContext.getPostQueryValue("vcenter_server_ip")) != null && !((String)object).equals(string5)) {
            if (((String)object).indexOf(":") >= 0) {
                object = "[" + (String)object + "]";
            }
            bl = true;
            vMWareDetails.setServerIp((String)object);
        }
        if (StringUtils.isNotBlank((CharSequence)(object = pageContext.getPostQueryValue("vcenter_server_password"))) && !((String)object).equals(string3)) {
            bl = true;
            vMWareDetails.setPassword((String)object);
        }
        if ((object = pageContext.getPostQueryValue("vcenter_server_username")) != null && !((String)object).equals(string4)) {
            bl = true;
            vMWareDetails.setUsername((String)object);
        }
        vMWareDetails.setSkipCertCheck(false);
        object = pageContext.getPostQueryValue("vcenter_installed_on_vm");
        if (object != null && !bl3) {
            bl = true;
            vMWareDetails.setVCenterInstalledOnaVM(true);
        } else if (object == null && bl3) {
            bl = true;
            vMWareDetails.setVCenterInstalledOnaVM(false);
        }
        if (bl) {
            this.services.getVirtualConfigurationManager().saveVMWareDetails(vMWareDetails, true);
            this.services.getVmWareConnection().logoutVCenterServer(true);
        }
    }

    private ServiceInstance getServiceInstance(String string, String string2, boolean bl) {
        ServiceInstance serviceInstance = this.services.getVmWareConnection().getVCenterConnection();
        if (serviceInstance == null) {
            serviceInstance = this.services.getVmWareConnection().getVCenterConnection(null, string, string2, bl, false);
        }
        return serviceInstance;
    }

    private void setESXiCredentials(PageContext pageContext) {
        boolean bl = false;
        VMWareDetails vMWareDetails = this.services.getVirtualConfigurationManager().loadESXiHostServerDetails();
        if (vMWareDetails == null) {
            vMWareDetails = new VMWareDetails();
        }
        String string = vMWareDetails.getProtocol();
        String string2 = vMWareDetails.getPort();
        String string3 = this.services.getAuthHelper().getEsxHostPassword();
        String string4 = vMWareDetails.getUsername();
        String string5 = vMWareDetails.getServerIp();
        boolean bl2 = vMWareDetails.isSkipCertCheck();
        String string6 = pageContext.getPostQueryValue("esxi_host_protocol");
        if (string6 != null && !string6.equals(string)) {
            bl = true;
            vMWareDetails.setProtocol(string6);
        }
        vMWareDetails.setSkipCertCheck(false);
        string6 = pageContext.getPostQueryValue("esxi_host_port");
        if (string6 != null && !string6.equals(string2)) {
            bl = true;
            vMWareDetails.setPort(string6);
        }
        if (StringUtils.isNotBlank((CharSequence)(string6 = pageContext.getPostQueryValue("esxi_host_password"))) && !string6.equals(string3)) {
            bl = true;
            vMWareDetails.setPassword(string6);
        }
        if ((string6 = pageContext.getPostQueryValue("esxi_host_username")) != null && !string6.equals(string4)) {
            bl = true;
            vMWareDetails.setUsername(string6);
        }
        if ((string6 = pageContext.getPostQueryValue("esxi_host_ip")) != null && !string6.equals(string5)) {
            bl = true;
            vMWareDetails.setServerIp(string6);
            this.services.getVmWareConnection().logoutESXiHost(string5);
        }
        if (bl) {
            this.services.getVirtualConfigurationManager().saveVMWareDetails(vMWareDetails, false);
        }
    }

    protected void setNutanixConnectionCredentials(PageContext pageContext) {
        boolean bl = false;
        NutanixDetails nutanixDetails = this.getNutanixDetails();
        String string = nutanixDetails.getClusterPassword();
        String string2 = nutanixDetails.getHostPassword();
        String string3 = nutanixDetails.getClusterIp();
        String string4 = nutanixDetails.getSshKeyPath();
        String string5 = nutanixDetails.getSshKeyPassphrase();
        String string6 = pageContext.getPostQueryValue("nutanix_cluster_ip");
        if (StringUtils.isNotBlank((CharSequence)string6) && !string6.equals(string3)) {
            bl = true;
            nutanixDetails.setClusterIp(string6);
        }
        if (StringUtils.isNotBlank((CharSequence)(string6 = pageContext.getPostQueryValue("nutanix_ssh_key_passphrase"))) && !string6.equals(string5)) {
            bl = true;
            nutanixDetails.setSshKeyPassphrase(string6);
        }
        UserFilePathValidator userFilePathValidator = new UserFilePathValidator();
        string6 = pageContext.getPostQueryValue("nutanix_ssh_key_path");
        if (StringUtils.isNotBlank((CharSequence)string6) && !string6.equals(string4) && userFilePathValidator.isValid(string6)) {
            bl = true;
            nutanixDetails.setSshKeyPath(string6);
            nutanixDetails.setClusterPassword(null);
            nutanixDetails.setHostPassword(null);
        } else {
            string6 = pageContext.getPostQueryValue("nutanix_cluster_password");
            if (StringUtils.isNotBlank((CharSequence)string6) && !string6.equals(string)) {
                bl = true;
                nutanixDetails.setClusterPassword(string6);
                nutanixDetails.setSshKeyPath(null);
                nutanixDetails.setSshKeyPassphrase(null);
            }
            if (StringUtils.isNotBlank((CharSequence)(string6 = pageContext.getPostQueryValue("NutanixAHVHostAuthenticationKeyName"))) && !string6.equals(string2)) {
                bl = true;
                nutanixDetails.setHostPassword(string6);
                nutanixDetails.setSshKeyPath(null);
                nutanixDetails.setSshKeyPassphrase(null);
            }
        }
        if (bl) {
            this.setNutanixDetails(nutanixDetails);
        }
        nutanixDetails = null;
        string = null;
        string2 = null;
        string3 = null;
        string4 = null;
        string5 = null;
    }

    protected void getNutanixConnectionCredentials(PageContext pageContext) {
        String string;
        String string2;
        String string3;
        String string4;
        NutanixDetails nutanixDetails = this.getNutanixDetails();
        String string5 = nutanixDetails.getClusterPassword();
        if (string5 != null) {
            pageContext.setValue("nutanix_cluster_password", string5);
        }
        if ((string4 = nutanixDetails.getHostPassword()) != null) {
            pageContext.setValue("NutanixAHVHostAuthenticationKeyName", string5);
        }
        if ((string3 = nutanixDetails.getClusterIp()) != null) {
            pageContext.setValue("NutanixAHVClusterIpName", string3);
        }
        if ((string2 = nutanixDetails.getSshKeyPath()) != null) {
            pageContext.setValue("NutanixAHVAuthenticationKeySshKeyName", string2);
        }
        if ((string = nutanixDetails.getSshKeyPassphrase()) != null) {
            pageContext.setValue("nutanix_ssh_key_passphrase", string);
        }
        nutanixDetails = null;
        string5 = null;
        string3 = null;
        string2 = null;
        string = null;
    }

    protected NutanixDetails getNutanixDetails() {
        return this.services.getNutanixUtils().loadNutanixDetails();
    }

    protected void setNutanixDetails(NutanixDetails nutanixDetails) {
        this.services.getNutanixUtils().saveNutanixDetails(nutanixDetails);
    }
}

