/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.servlets;

import com.apcc.m11.components.stdpowersource.OutletGroup;
import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.pages.OmahaHostNMCMappingPage;
import com.apcc.m11.components.webserver.servlets.M11Servlet;
import com.apcc.m11.ds.powersource.communication.TCPIPCommunication;
import com.apcc.pcns.ServiceManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfigureHostNMCMapping
extends M11Servlet {
    private static final Logger logger = LogManager.getLogger(ConfigureHostNMCMapping.class);
    public static final String VALUE_REG_SUCCESS = "reg_success";
    public static final String VALUE_REG_ERROR = "reg_error";
    public static final String VALUE_OUTLET_OFF = "outlet_off";
    public static final String VALUE_OUTLET_PENDING_OFF = "outlet_pending_off";

    public ConfigureHostNMCMapping(ServiceManager serviceManager) {
        super(serviceManager);
    }

    @Override
    protected void doGet(PageContext pageContext) throws ServletException, IOException {
        if (this.services.getAdvancedSetupHelper().isAdvancedShutdownMode() && (this.services.getVirtualConfigurationManager().isManagedHost() || this.services.getVirtualConfigurationManager().isNutanixAHV())) {
            if (this.services.getAdvancedSetupHelper().getSingleUPSSetupSetting()) {
                this.getPoweredOffOutletGroups(pageContext);
                this.getPendingOffOutletGroups(pageContext);
            }
            this.setFormToken(pageContext.getRequest());
            OmahaHostNMCMappingPage omahaHostNMCMappingPage = new OmahaHostNMCMappingPage(this.services);
            pageContext.writeHTML(omahaHostNMCMappingPage);
        } else {
            pageContext.getResponse().sendRedirect(pageContext.getResponse().encodeRedirectURL("/index.html"));
        }
    }

    private void getPoweredOffOutletGroups(PageContext pageContext) {
        List<OutletGroup> list;
        pageContext.getSession().setAttribute(VALUE_OUTLET_OFF, null);
        if (pageContext.getSession().getAttribute(VALUE_REG_ERROR) == null && (list = this.services.getAdvancedSetupHelper().getMappedOutletGroups(pageContext)) != null) {
            ArrayList<OutletGroup> arrayList = new ArrayList<OutletGroup>();
            for (OutletGroup outletGroup : list) {
                if (!outletGroup.isSelected() || outletGroup.getState() != 0) continue;
                arrayList.add(outletGroup);
            }
            if (!arrayList.isEmpty()) {
                pageContext.getSession().setAttribute(VALUE_OUTLET_OFF, arrayList);
            }
        }
    }

    private void getPendingOffOutletGroups(PageContext pageContext) {
        List<OutletGroup> list;
        pageContext.getSession().setAttribute(VALUE_OUTLET_PENDING_OFF, null);
        if (pageContext.getSession().getAttribute(VALUE_REG_ERROR) == null && (list = this.services.getAdvancedSetupHelper().getMappedOutletGroups(pageContext)) != null) {
            ArrayList<OutletGroup> arrayList = new ArrayList<OutletGroup>();
            for (OutletGroup outletGroup : list) {
                if (!outletGroup.isSelected() || outletGroup.getState() != 3) continue;
                arrayList.add(outletGroup);
            }
            if (!arrayList.isEmpty()) {
                pageContext.getSession().setAttribute(VALUE_OUTLET_PENDING_OFF, arrayList);
            }
        }
    }

    @Override
    protected void doPost(PageContext pageContext) throws ServletException, IOException {
        if (this.verifyFormToken(pageContext)) {
            if (pageContext.getPostQueryValue("reset") == null) {
                this.services.getAdvancedSetupHelper().saveMappedHostsToConfig(pageContext);
                if (this.services.getAdvancedSetupHelper().getSingleUPSSetupSetting()) {
                    this.registerWithMappedOutletGroups(pageContext);
                }
                this.services.getAdvancedSetupHelper().updateUPSSetupsTurnOffOutletGroups(pageContext);
                if (this.services.getVirtualConfigurationManager().isHyperflex()) {
                    this.services.getHyperflexUtils().saveCvmDetailsToConfig(this.services.getWebServerUtils().readMappedHostsFromRequest(pageContext.getPostQueryValues()));
                }
            }
            pageContext.getResponse().sendRedirect(pageContext.getResponse().encodeRedirectURL("/hostnmcmapping"));
        }
    }

    private void registerWithMappedOutletGroups(PageContext pageContext) {
        List<OutletGroup> list = this.services.getAdvancedSetupHelper().getMappedOutletGroups(pageContext);
        if (list == null) {
            return;
        }
        for (OutletGroup outletGroup : list) {
            List<OutletGroup> list2;
            if (pageContext.set(TCPIPCommunication.OutletGroup.getObjectId(), outletGroup)) {
                list2 = (ArrayList<OutletGroup>)pageContext.getSession().getAttribute(VALUE_REG_SUCCESS);
                if (list2 == null) {
                    list2 = new ArrayList<OutletGroup>();
                    pageContext.getSession().setAttribute(VALUE_REG_SUCCESS, list2);
                }
                list2.add(outletGroup);
                continue;
            }
            list2 = (List)pageContext.getSession().getAttribute(VALUE_REG_ERROR);
            if (list2 == null) {
                list2 = new ArrayList();
                pageContext.getSession().setAttribute(VALUE_REG_ERROR, list2);
            }
            list2.add(outletGroup);
        }
    }
}

