/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.servlets;

import com.apcc.m11.arch.storage.IPermanentStorage;
import com.apcc.m11.arch.storage.StorageEntryException;
import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.pages.OmahaSNMPSettingsPage;
import com.apcc.m11.components.webserver.servlets.M11Servlet;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.configservice.configurationmanagers.ConfigurationManager;
import com.apcc.pcns.snmp.PcnsBaseAgent;
import com.apcc.pcns.snmp.PcnsTrapGenerator;
import com.apcc.pcns.snmp.utils.ApcSNMPTrapNMS;
import com.apcc.pcns.snmp.utils.ApcSNMPv1User;
import com.apcc.pcns.snmp.utils.ApcSNMPv3User;
import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.servlet.ServletException;
import org.apache.commons.configuration2.ex.ConversionException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.snmp4j.smi.OctetString;

public class ConfigureSNMPSettings
extends M11Servlet {
    private static final int NAME_IDX = 0;
    private static final int AUTH_PROTOCOL_IDX = 1;
    private static final int AUTH_PASS_IDX = 2;
    private static final int PRIV_PROTOCOL_IDX = 3;
    private static final int PRIV_PASS_IDX = 4;
    private static final int ACCESS_TYPE_IDX = 5;
    private static final Logger logger = LogManager.getLogger(ConfigureSNMPSettings.class);
    public static final String VALUE_SNMPDISCOVERYPORT = "SNMPDiscoveryPort";
    public static final int DEFAULT_SNMP_DISCOVERY_PORT = 161;
    public static final String VALUE_SNMPV1ENABLED = "SNMPV1Enabled";
    public static final String VALUE_SNMPV1PROFILES = "SNMPV1Profiles";
    public static final String VALUE_SNMPV1PROFILESRETURN = "V1ProfilesReturn";
    public static final String VALUE_SNMPV3ENABLED = "SNMPV3Enabled";
    public static final String VALUE_SNMPV3PROFILES = "SNMPV3Profiles";
    public static final String VALUE_SNMPV3PROFILESRETURN = "V3ProfilesReturn";
    public static final String VALUE_CRITICALTRAPENABLED = "CriticalTrapEnabled";
    public static final String VALUE_COMMTRAPENABLED = "CommTrapEnabled";
    public static final String VALUE_TRAPRECEIVERS = "SNMPTrapReceivers";
    public static final String VALUE_TRAPRECEIVERSRETURN = "TrapReceiversReturn";
    private IPermanentStorage thePermanentStorage;

    public ConfigureSNMPSettings(IPermanentStorage iPermanentStorage, ServiceManager serviceManager) {
        super(serviceManager);
        this.thePermanentStorage = iPermanentStorage;
    }

    @Override
    protected void doGet(PageContext pageContext) throws ServletException, IOException {
        logger.debug("doGet");
        this.setFormToken(pageContext.getRequest());
        Object object = pageContext.getSession().getAttribute("activeAcc");
        if (object != null) {
            pageContext.setValue("activeAcc", object);
            pageContext.getSession().removeAttribute("activeAcc");
        }
        this.loadSettings(pageContext);
        OmahaSNMPSettingsPage omahaSNMPSettingsPage = new OmahaSNMPSettingsPage(this.services);
        logger.debug("page made");
        pageContext.writeHTML(omahaSNMPSettingsPage);
    }

    @Override
    protected void doPost(PageContext pageContext) throws ServletException, IOException {
        if (this.verifyFormToken(pageContext)) {
            if (pageContext.getPostQueryValue("resetSNMPSettings") == null) {
                this.setSettings(pageContext);
                pageContext.getSession().setAttribute("activeAcc", (Object)pageContext.getPostQueryValue("activeAcc"));
            }
            pageContext.getResponse().sendRedirect(pageContext.getResponse().encodeRedirectURL("/configuresnmpsettings"));
        }
    }

    private void loadSettings(PageContext pageContext) {
        Object object;
        logger.debug("loadSettings() - start");
        try {
            object = (OctetString)this.thePermanentStorage.readData(PcnsBaseAgent.kComponentId, "localEngineID");
            if (object != null) {
                pageContext.setValue("localEngineID", object.toString());
            }
        }
        catch (StorageEntryException storageEntryException) {
            logger.debug("No engineID in storage, making a new one");
        }
        try {
            object = this.services.getConfigurationManager();
            int n = 161;
            if (object.containsKey("SNMP", "SNMP_DiscoveryPort")) {
                try {
                    n = object.getInt("SNMP", "SNMP_DiscoveryPort");
                }
                catch (NoSuchElementException | ConversionException throwable) {
                    logger.error("Error getting the Discovery Port Value, using the default value: {}", (Object)161, (Object)throwable);
                }
            } else {
                logger.debug("Using default SNMP port");
            }
            pageContext.setValue(VALUE_SNMPDISCOVERYPORT, n);
            if (object.containsKey("SNMP", "SNMPv1_Enabled")) {
                try {
                    pageContext.setValue(VALUE_SNMPV1ENABLED, object.getBoolean("SNMP", "SNMPv1_Enabled"));
                }
                catch (NoSuchElementException | ConversionException throwable) {
                    logger.error("Error getting the v1 enabled flag", throwable);
                }
            } else {
                pageContext.setValue(VALUE_SNMPV1ENABLED, false);
                logger.debug("Default SNMPv1 not enabled");
            }
            Vector<ApcSNMPv1User> vector = PcnsBaseAgent.getSNMPv1ProfilesStatic((ConfigurationManager)object);
            pageContext.getSession().setAttribute(VALUE_SNMPV1PROFILES, vector);
            if (object.containsKey("SNMP", "SNMPv3_Enabled")) {
                try {
                    pageContext.setValue(VALUE_SNMPV3ENABLED, object.getBoolean("SNMP", "SNMPv3_Enabled"));
                }
                catch (NoSuchElementException | ConversionException throwable) {
                    logger.error("Error getting the v3 enabled flag", throwable);
                }
            } else {
                pageContext.setValue(VALUE_SNMPV1ENABLED, false);
                logger.debug("Default SNMPv1 not enabled");
            }
            Vector<ApcSNMPv3User> vector2 = PcnsBaseAgent.getSNMPv3UsersStatic(this.thePermanentStorage, (ConfigurationManager)object);
            pageContext.getSession().setAttribute(VALUE_SNMPV3PROFILES, vector2);
            for (String string : new String[]{"UPSCriticalEvents", "LostCommsEvents"}) {
                try {
                    pageContext.setValue(string + "_Enabled", object.getBoolean("SNMP", string + "_Enabled"));
                }
                catch (NoSuchElementException | ConversionException throwable) {
                    pageContext.setValue(string + "_Enabled", false);
                }
                try {
                    pageContext.setValue(string + "_SendClearingTrap", object.getBoolean("SNMP", string + "_SendClearingTrap"));
                }
                catch (NoSuchElementException | ConversionException throwable) {
                    pageContext.setValue(string + "_SendClearingTrap", false);
                }
                try {
                    pageContext.setValue(string + "_Delay", object.getInt("SNMP", string + "_Delay").toString());
                }
                catch (NoSuchElementException | ConversionException throwable) {
                    pageContext.setValue(string + "_Delay", "0");
                }
                try {
                    pageContext.setValue(string + "_RepeatInterval", object.getInt("SNMP", string + "_RepeatInterval").toString());
                }
                catch (NoSuchElementException | ConversionException throwable) {
                    pageContext.setValue(string + "_RepeatInterval", "1");
                }
                try {
                    pageContext.setValue(string + "_RepeatTimes", object.getInt("SNMP", string + "_RepeatTimes").toString());
                }
                catch (NoSuchElementException | ConversionException throwable) {
                    pageContext.setValue(string + "_RepeatTimes", "");
                }
                try {
                    pageContext.setValue(string + "_RepeatUntilCleared", object.getBoolean("SNMP", string + "_RepeatUntilCleared"));
                }
                catch (NoSuchElementException | ConversionException throwable) {
                    pageContext.setValue(string + "_RepeatUntilCleared", false);
                }
            }
            Vector<ApcSNMPTrapNMS> vector3 = PcnsTrapGenerator.getTrapNMSs(null);
            pageContext.getSession().setAttribute(VALUE_TRAPRECEIVERS, vector3);
        }
        catch (Exception exception) {
            logger.error("loadSettings error:", (Throwable)exception);
            throw exception;
        }
        logger.debug("loadSettings() - end");
    }

    private void setSettings(PageContext pageContext) {
        Object object;
        Object object322;
        Object object4;
        Object object5;
        Object object6;
        logger.debug("setSettings - start()");
        ConfigurationManager configurationManager = this.services.getConfigurationManager();
        boolean bl = false;
        bl = configurationManager.isAutoSave();
        configurationManager.setAutoSave(false);
        int n = Integer.parseInt(pageContext.getPostQueryValue(VALUE_SNMPDISCOVERYPORT));
        logger.debug("set SNMP port");
        configurationManager.setProperty("SNMP", "SNMP_DiscoveryPort", n);
        Boolean bl2 = pageContext.getPostQueryValue(VALUE_SNMPV1ENABLED) != null;
        configurationManager.setProperty("SNMP", "SNMPv1_Enabled", bl2);
        String string = pageContext.getPostQueryValue(VALUE_SNMPV1PROFILESRETURN);
        if (string != null) {
            object6 = string.split("\r\n");
            object5 = new Vector();
            object4 = object6;
            int n2 = ((String[])object4).length;
            for (int i = 0; i < n2; ++i) {
                String string2 = object4[i];
                object322 = string2.split("\t");
                if (((String[])object322).length == 3) {
                    try {
                        ((Vector)object5).add(new ApcSNMPv1User(object322[0], ApcSNMPv1User.AccessType.valueOf(object322[2]), (String)object322[1]));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        logger.error("Error creating SNMPv1User from: {}", (Object)string2);
                    }
                    continue;
                }
                logger.debug("invalid SNMPv1 user string returned: {}", (Object)string2);
            }
            logger.debug("Users received from UI");
            PcnsBaseAgent.setSNMPv1ProfilesStatic((Vector<ApcSNMPv1User>)object5, configurationManager);
        }
        bl2 = pageContext.getPostQueryValue(VALUE_SNMPV3ENABLED) != null;
        configurationManager.setProperty("SNMP", "SNMPv3_Enabled", bl2);
        object6 = pageContext.getPostQueryValue(VALUE_SNMPV3PROFILESRETURN);
        if (object6 != null) {
            object5 = ((String)object6).split("\r\n");
            object4 = new Vector();
            for (Object object322 : object5) {
                String[] stringArray = ((String)object322).split("\t");
                if (stringArray.length == 6) {
                    try {
                        ((Vector)object4).add(new ApcSNMPv3User(stringArray[0], ApcSNMPv3User.AuthProtocol.valueOf(StringUtils.toRootUpperCase((String)stringArray[1])), stringArray[2], ApcSNMPv3User.PrivProtocol.valueOf(StringUtils.toRootUpperCase((String)stringArray[3])), stringArray[4], ApcSNMPv1User.AccessType.valueOf(stringArray[5])));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        logger.error("Error creating SNMPv3User from : {}", object322);
                    }
                    continue;
                }
                logger.debug("invalid SNMPv1 user string returned: {}", object322);
            }
            logger.debug("Users received from UI");
            PcnsBaseAgent.setSNMPv3UsersStatic((Vector<ApcSNMPv3User>)object4, this.thePermanentStorage, configurationManager);
        }
        for (String string3 : new String[]{"UPSCriticalEvents", "LostCommsEvents"}) {
            String string2;
            Boolean bl3 = Boolean.valueOf(pageContext.getPostQueryValue(string3 + "_Enabled"));
            configurationManager.setProperty("SNMP", string3 + "_Enabled", bl3);
            object322 = Boolean.valueOf(pageContext.getPostQueryValue(string3 + "_SendClearingTrap"));
            configurationManager.setProperty("SNMP", string3 + "_SendClearingTrap", object322);
            String string4 = pageContext.getPostQueryValue(string3 + "_Delay");
            if (this.isInteger(string4)) {
                configurationManager.setProperty("SNMP", string3 + "_Delay", string4);
            }
            if (this.isInteger((String)(object = pageContext.getPostQueryValue(string3 + "_RepeatInterval")))) {
                configurationManager.setProperty("SNMP", string3 + "_RepeatInterval", object);
            }
            if (this.isInteger(string2 = pageContext.getPostQueryValue(string3 + "_RepeatTimes"))) {
                configurationManager.setProperty("SNMP", string3 + "_RepeatTimes", string2);
            }
            Boolean bl4 = Boolean.valueOf(pageContext.getPostQueryValue(string3 + "_RepeatUntilCleared"));
            configurationManager.setProperty("SNMP", string3 + "_RepeatUntilCleared", bl4);
        }
        object5 = pageContext.getPostQueryValue(VALUE_TRAPRECEIVERSRETURN);
        if (object5 != null) {
            String[] stringArray = ((String)object5).split("\r\n");
            Vector<ApcSNMPTrapNMS> vector = new Vector<ApcSNMPTrapNMS>();
            for (String string5 : stringArray) {
                object = string5.split("\t");
                if (((String[])object).length == 5) {
                    try {
                        vector.add(new ApcSNMPTrapNMS(object[1], Integer.valueOf(object[2]), ApcSNMPTrapNMS.SNMPType.valueOf(object[3]), object[4], Boolean.valueOf(object[0])));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        logger.error("Error creating ApcSNMPTrapNMS from: {}", (Object)string5);
                    }
                    continue;
                }
                logger.debug("invalid trapReceiver user string returned: {}", (Object)string5);
            }
            logger.debug("Trap Receivers received from UI");
            PcnsTrapGenerator.setTrapNMSs(vector);
        }
        configurationManager.save();
        if (bl) {
            configurationManager.setAutoSave(true);
        }
    }

    private boolean isInteger(String string) {
        try {
            Integer.parseInt(string);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

