/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.servlets;

import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.VariableBinding;
import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.pages.OmahaConfigureShutdownSettingsPage;
import com.apcc.m11.components.webserver.servlets.M11Servlet;
import com.apcc.m11.components.webserver.util.NotificationHelper;
import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.m11.ds.events.flexevents.powersource.MultipleEvent;
import com.apcc.m11.ds.powersource.Control;
import com.apcc.m11.ds.powersource.Identification;
import com.apcc.m11.ds.powersource.communication.TCPIPCommunication;
import com.apcc.m11.ds.services.ShutdownGroup;
import com.apcc.m11.ds.services.commandExecution.CommandFile;
import com.apcc.m11.ds.services.omaha.IFlexEventDescriptor;
import com.apcc.m11.ds.services.omaha.Omaha;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.configservice.configurationmanagers.ConfigurationManager;
import com.apcc.pcns.configservice.validation.UserFilePathValidator;
import java.io.IOException;
import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.servlet.ServletException;
import org.apache.commons.configuration2.ex.ConversionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfigureShutdownSettings
extends M11Servlet {
    private static final long serialVersionUID = 6564328439494662273L;
    private static final Logger logger = LogManager.getLogger(ConfigureShutdownSettings.class);
    public static final String VALUE_REDUNDANT = "is_redundant";
    public static final String VALUE_SINGLE_POWER_FAILED = "single_power_failed_trigger";
    public static final String VALUE_BROADCAST_SUPPORTED = "is_broadcast_supported";
    public static final String VALUE_HAS_OUTLETGROUPS = "has_outletgroups";
    public static final String VALUE_CMDFILE = "cmdfile";
    public static final String VALUE_INVALID_CMDFILE = "cmdfile_invalid";
    public static final String PARAM_TURNOFF_SETTING = "TurnOff";
    public static final String VALUE_TURNOFF_NONE = "TurnOffNone";
    public static final String VALUE_TURNOFF_UPS = "TurnOffUPS";
    public static final String VALUE_TURNOFF_SOG = "TurnOffSOG";
    public static final String PARAM_SINGLE_TURNOFF = "SingleTurnOff";
    public static final String PARAM_SINGLE_TURNOFF_DELAY = "SingleTurnOffDelay";
    public static final String PARAM_CMDFILE_PATH = "cmdFilePath";
    public static final String PARAM_CMDFILE_DURATION = "CmdFileDuration";
    public static final String PARAM_CMDFILE_DELAY = "cmdFileDelay";
    public static final String PARAM_EXECUTE_COMMAND_FILE_AFTER_HOST_SHUTDOWN = "executeCommandFileAfterHostShutdown";
    public static final String PARAM_NOTIFY_ENABLED = "notifyEnabled";
    public static final String VALUE_NOTIFY_ALL_USERS = "notifyAllUsers";
    public static final String VALUE_NOTIFY_SINGLE_USER = "notifySingleUser";
    public static final String PARAM_NOTIFY_USER = "notifyUser";
    public static final String PARAM_NOTIFY_SINGLE_USER = "singleUserName";
    public static final String PARAM_NOTIFY_INTERVAL = "notifyInterval";
    public static final String VALUE_NOTIFY_ENABLED = "notifyEnabled";
    public static final String VALUE_BROADCAST_RECIPIENT = "recipient";
    public static final Integer DEFAULT_SINTLE_TURNOFF_DELAY = 60;
    private static final ObjectId SINGLE_POWER_FAILED_OID = MultipleEvent.SinglePowerFailed.getObjectId();

    public ConfigureShutdownSettings(ServiceManager serviceManager) {
        super(serviceManager);
    }

    @Override
    protected void doGet(PageContext pageContext) throws ServletException, IOException {
        if (!this.services.getAdvancedSetupHelper().isAdvancedShutdownMode()) {
            Object object;
            Serializable serializable;
            this.setFormToken(pageContext.getRequest());
            Object object2 = pageContext.getSession().getAttribute("activeAcc");
            if (object2 != null) {
                pageContext.setValue("activeAcc", object2);
                pageContext.getSession().removeAttribute("activeAcc");
            }
            Boolean bl = Utils.isBroadcastSupported() && !this.services.getVirtualConfigurationManager().isESXi() && !this.services.getVirtualConfigurationManager().isHyperV();
            pageContext.setValue(VALUE_BROADCAST_SUPPORTED, bl);
            if (bl.booleanValue() && (serializable = NotificationHelper.getShutdownNotificationRecipient(pageContext)) != null) {
                pageContext.setValue(VALUE_BROADCAST_RECIPIENT, serializable);
            }
            pageContext.setValue(VALUE_HAS_OUTLETGROUPS, Utils.hasOutletGroups(pageContext));
            serializable = Boolean.valueOf(this.isMultipleSmartOrSymmetra(pageContext));
            pageContext.setValue(VALUE_REDUNDANT, serializable);
            if (((Boolean)serializable).booleanValue() && (object = this.getSinglePowerFailedTrigger(pageContext)) != null) {
                pageContext.setValue(VALUE_SINGLE_POWER_FAILED, object);
            }
            if ((object = this.getShutdownStartingCommandFile(pageContext)) != null) {
                pageContext.setValue(VALUE_CMDFILE, object);
            }
            if (this.services.getVirtualConfigurationManager().isExecuteCommandFileAfterHostShutdownSupported()) {
                boolean bl2 = false;
                int n = 0;
                ConfigurationManager configurationManager = this.services.getConfigurationManager();
                try {
                    bl2 = configurationManager.getBoolean("Shutdown", PARAM_EXECUTE_COMMAND_FILE_AFTER_HOST_SHUTDOWN);
                    n = configurationManager.getInt("Shutdown", "shutdownCommandFileDelay");
                }
                catch (NoSuchElementException | ConversionException throwable) {
                    logger.debug((Object)throwable);
                }
                pageContext.setValue(PARAM_EXECUTE_COMMAND_FILE_AFTER_HOST_SHUTDOWN, bl2);
                pageContext.setValue(PARAM_CMDFILE_DELAY, n);
            }
            OmahaConfigureShutdownSettingsPage omahaConfigureShutdownSettingsPage = new OmahaConfigureShutdownSettingsPage(this.services);
            pageContext.writeHTML(omahaConfigureShutdownSettingsPage);
        } else {
            pageContext.getResponse().sendError(404);
        }
    }

    @Override
    protected void doPost(PageContext pageContext) throws ServletException, IOException {
        if (this.verifyFormToken(pageContext)) {
            this.setUPSShutdownSettings(pageContext);
            this.setCmdFileSettings(pageContext);
            NotificationHelper.setShutdownNotification(pageContext);
            pageContext.getSession().setAttribute("activeAcc", (Object)pageContext.getPostQueryValue("activeAcc"));
            pageContext.getResponse().sendRedirect(pageContext.getResponse().encodeRedirectURL("/configureshutdownsettings"));
        }
    }

    private void setUPSShutdownSettings(PageContext pageContext) {
        String string = pageContext.getPostQueryValue(PARAM_TURNOFF_SETTING);
        pageContext.set(Control.TurnOffPowerSourceOnShutdown.getObjectId(), VALUE_TURNOFF_UPS.equals(string));
        pageContext.set(Control.TurnOffSOGOnShutdown.getObjectId(), VALUE_TURNOFF_SOG.equals(string));
        if (this.isMultipleSmartOrSymmetra(pageContext)) {
            VariableBinding variableBinding = new VariableBinding();
            boolean bl = pageContext.getPostQueryValue(PARAM_SINGLE_TURNOFF) != null;
            String string2 = pageContext.getPostQueryValue(PARAM_SINGLE_TURNOFF_DELAY);
            Vector vector = (Vector)pageContext.get(Omaha.FlexEventList.getObjectId());
            IFlexEventDescriptor iFlexEventDescriptor = null;
            if (vector != null) {
                for (IFlexEventDescriptor iFlexEventDescriptor2 : vector) {
                    if (!iFlexEventDescriptor2.getHMTLId().equals(MultipleEvent.SinglePowerFailed.name())) continue;
                    iFlexEventDescriptor = iFlexEventDescriptor2;
                    break;
                }
            }
            if (iFlexEventDescriptor != null) {
                variableBinding.setObjectId(iFlexEventDescriptor.getObjectId());
                try {
                    variableBinding.setValue((Object)Integer.valueOf(string2));
                }
                catch (NumberFormatException numberFormatException) {
                    variableBinding.setValue((Object)DEFAULT_SINTLE_TURNOFF_DELAY);
                }
            }
            pageContext.set(Control.TurnOffPowerSourceOnShutdown.getObjectId(), string.equals(VALUE_TURNOFF_UPS));
            pageContext.set(Control.TurnOffSOGOnShutdown.getObjectId(), string.equals(VALUE_TURNOFF_SOG));
            if (bl && (string.equals(VALUE_TURNOFF_UPS) || string.equals(VALUE_TURNOFF_SOG))) {
                if (!pageContext.set(ShutdownGroup.AddShutdownTrigger.getObjectId(), variableBinding)) {
                    logger.info("Add turn off on-battery UPS :error ");
                }
            } else if (!pageContext.set(ShutdownGroup.RemoveShutdownTrigger.getObjectId(), variableBinding)) {
                logger.info("Remove turn off on-battery UPS :error ");
            }
        }
    }

    private void setCmdFileSettings(PageContext pageContext) {
        String string = pageContext.getPostQueryValue(PARAM_CMDFILE_PATH);
        String string2 = pageContext.getPostQueryValue(PARAM_CMDFILE_DURATION);
        ConfigurationManager configurationManager = this.services.getConfigurationManager();
        int n = 0;
        try {
            n = Integer.valueOf(string2);
        }
        catch (NumberFormatException numberFormatException) {
            logger.error((Object)numberFormatException);
        }
        configurationManager.setProperty("Shutdown", "shutdownCommandFile", string);
        configurationManager.setProperty("Shutdown", "shutdownCommandFileDuration", n);
        if (string != null && !string.trim().isEmpty()) {
            configurationManager.setProperty("Shutdown", "shutdownCommandFileEnabled", Boolean.TRUE);
        } else {
            configurationManager.setProperty("Shutdown", "shutdownCommandFileEnabled", Boolean.FALSE);
        }
        if (this.services.getVirtualConfigurationManager().isExecuteCommandFileAfterHostShutdownSupported()) {
            boolean bl = pageContext.getPostQueryValue(PARAM_EXECUTE_COMMAND_FILE_AFTER_HOST_SHUTDOWN) != null;
            configurationManager.setProperty("Shutdown", PARAM_EXECUTE_COMMAND_FILE_AFTER_HOST_SHUTDOWN, bl);
            int n2 = 0;
            if (bl) {
                try {
                    n2 = Integer.valueOf(pageContext.getPostQueryValue(PARAM_CMDFILE_DELAY));
                }
                catch (NumberFormatException numberFormatException) {
                    logger.error((Object)numberFormatException);
                }
            }
            configurationManager.setProperty("Shutdown", "shutdownCommandFileDelay", n2);
        }
    }

    private CommandFile getShutdownStartingCommandFile(PageContext pageContext) {
        CommandFile commandFile = null;
        try {
            int n = this.services.getConfigurationManager().getInt("Shutdown", "shutdownCommandFileDuration");
            String string = this.services.getConfigurationManager().getString("Shutdown", "shutdownCommandFile");
            UserFilePathValidator userFilePathValidator = new UserFilePathValidator();
            if (userFilePathValidator.isValid(string, true)) {
                commandFile = new CommandFile(string, null, 0, n);
            } else {
                logger.error("getShutdownStartingCommandFile() - Invalid file path detected.  Removing key {}.{} from the INI.", (Object)"Shutdown", (Object)"shutdownCommandFile");
                this.services.getConfigurationManager().clearProperty("Shutdown", "shutdownCommandFile");
            }
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
        return commandFile;
    }

    private VariableBinding getSinglePowerFailedTrigger(PageContext pageContext) {
        VariableBinding variableBinding = null;
        Vector vector = (Vector)pageContext.get(ShutdownGroup.ShutdownTriggers.getObjectId());
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                VariableBinding variableBinding2 = (VariableBinding)vector.elementAt(i);
                if (variableBinding2 == null || !variableBinding2.getObjectId().equals((Object)SINGLE_POWER_FAILED_OID)) continue;
                variableBinding = variableBinding2;
                break;
            }
        }
        return variableBinding;
    }

    private boolean isMultipleSmartOrSymmetra(PageContext pageContext) {
        boolean bl = false;
        String string = "Redundant";
        if (this.isMultipleUPS(pageContext)) {
            String string2 = (String)pageContext.get(Identification.ModelName.getObjectId());
            if (string2 == null) {
                bl = false;
            } else if (string2.startsWith(string)) {
                bl = true;
            }
        }
        return bl;
    }

    private boolean isMultipleUPS(PageContext pageContext) {
        Vector vector;
        boolean bl = false;
        Object object = pageContext.get(TCPIPCommunication.IpAddress.getObjectId());
        if (object instanceof Vector && (vector = (Vector)object).size() > 1) {
            bl = true;
        }
        return bl;
    }
}

