/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.servlets;

import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.pages.OmahaTargetHostSelectionPage;
import com.apcc.m11.components.webserver.servlets.M11Servlet;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.simplivity.SimplivityDetails;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;

public class ConfigureTargetHostSelection
extends M11Servlet {
    private static final long serialVersionUID = 3511672897747569293L;

    public ConfigureTargetHostSelection(ServiceManager serviceManager) {
        super(serviceManager);
    }

    @Override
    protected void doGet(PageContext pageContext) throws ServletException, IOException {
        if ((this.services.getVirtualConfigurationManager().isNutanixAHV() || this.services.getVirtualConfigurationManager().isManagedHost()) && !this.services.getAdvancedSetupHelper().isAdvancedShutdownMode()) {
            this.setFormToken(pageContext.getRequest());
            OmahaTargetHostSelectionPage omahaTargetHostSelectionPage = new OmahaTargetHostSelectionPage(this.services);
            pageContext.writeHTML(omahaTargetHostSelectionPage);
        } else {
            pageContext.getResponse().sendRedirect(pageContext.getResponse().encodeRedirectURL("/index.html"));
        }
    }

    @Override
    protected void doPost(PageContext pageContext) throws ServletException, IOException {
        if (this.verifyFormToken(pageContext)) {
            if (pageContext.getPostQueryValue("reset") == null) {
                this.services.getWebServerUtils().saveTargetHostSelectionToConfig(pageContext);
                if (this.services.getVirtualConfigurationManager().isSimplivity()) {
                    List<SimplivityDetails> list = this.services.getSimplivityUtils().parseSimplivityDetails(pageContext);
                    this.services.getSimplivityUtils().clearSimplivityDetails();
                    this.services.getSimplivityUtils().saveSimplivityHostDetails(list);
                }
                if (this.services.getVirtualConfigurationManager().isHyperflex()) {
                    this.services.getHyperflexUtils().saveCvmDetailsToConfig(this.services.getWebServerUtils().readTargetHostSelectionFromRequest(pageContext.getPostQueryValues()));
                }
            }
            pageContext.getResponse().sendRedirect(pageContext.getResponse().encodeRedirectURL("/targethostselection"));
        }
    }
}

