/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.servlets;

import com.apcc.m11.components.webserver.html.HTML;
import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.model.VMSettings;
import com.apcc.m11.components.webserver.pages.OmahaVMSettingsPage;
import com.apcc.m11.components.webserver.servlets.M11Servlet;
import com.apcc.pcns.ServiceManager;
import java.io.IOException;
import javax.servlet.ServletException;

public class ConfigureVMSettings
extends M11Servlet {
    private static final long serialVersionUID = -7563607589510777367L;
    public static final String VALUE_VM_SETTINGS = "vm_settings";

    public ConfigureVMSettings(ServiceManager serviceManager) {
        super(serviceManager);
    }

    @Override
    protected void doGet(PageContext pageContext) throws ServletException, IOException {
        Object object;
        this.setFormToken(pageContext.getRequest());
        Object object2 = pageContext.getSession().getAttribute("activeAcc");
        if (object2 != null) {
            pageContext.setValue("activeAcc", object2);
            pageContext.getSession().removeAttribute("activeAcc");
        }
        if (this.services.getVirtualConfigurationManager().isManagedESXiOrNutanixAHV()) {
            object = this.services.getWebServerUtils().readVMSettingsFromConfigAndCluster();
            pageContext.setValue(VALUE_VM_SETTINGS, object);
            pageContext.getSession().setAttribute(VALUE_VM_SETTINGS, object);
        } else if (this.services.getVirtualConfigurationManager().isHyperV()) {
            object = this.services.getWebServerUtils().readHypervVMSettingsFromConfig();
            pageContext.setValue(VALUE_VM_SETTINGS, object);
            pageContext.getSession().setAttribute(VALUE_VM_SETTINGS, object);
        } else {
            pageContext.getResponse().sendError(404);
            return;
        }
        object = new OmahaVMSettingsPage(this.services);
        pageContext.writeHTML((HTML)object);
    }

    @Override
    protected void doPost(PageContext pageContext) throws ServletException, IOException {
        if (this.verifyFormToken(pageContext)) {
            if (pageContext.getPostQueryValue("resetVMSettings") == null) {
                this.setVMSettings(pageContext);
                pageContext.getSession().setAttribute("activeAcc", (Object)pageContext.getPostQueryValue("activeAcc"));
            }
            pageContext.getResponse().sendRedirect(pageContext.getResponse().encodeRedirectURL("/vmsettings"));
        }
    }

    private void setVMSettings(PageContext pageContext) {
        VMSettings vMSettings = this.services.getWebServerUtils().readVMSettingsFromRequest(pageContext);
        if (vMSettings != null) {
            this.services.getWebServerUtils().saveVMSettingsToConfig(vMSettings, vMSettings.isApplySettingsToAllGroups());
            pageContext.getSession().setAttribute("VMSettings", (Object)vMSettings);
        }
    }
}

