/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.servlets;

import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.servlets.AJAXServlet;
import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.m11.ds.services.eventlogginggroup.EventLoggingGroup;
import com.apcc.m11.ds.services.eventlogginggroup.ILogAccessor;
import com.apcc.pcns.ServiceManager;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExportLog
extends AJAXServlet {
    private static final Logger logger = LogManager.getLogger(ExportLog.class);

    public ExportLog(ServiceManager serviceManager) {
        super(serviceManager);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void doPost(PageContext pageContext) throws ServletException, IOException {
        if (this.verifyFormToken(pageContext, false)) {
            HttpServletResponse httpServletResponse = pageContext.getResponse();
            httpServletResponse.setContentType("text/plain");
            httpServletResponse.setContentType("application/force-download");
            httpServletResponse.addHeader("Content-Disposition", "attachment; filename=EventLog.txt");
            PrintWriter printWriter = httpServletResponse.getWriter();
            ILogAccessor iLogAccessor = (ILogAccessor)pageContext.get(EventLoggingGroup.LoggedEvents.getObjectId());
            List<Object> list = null;
            if (iLogAccessor != null) {
                list = iLogAccessor.getAll();
            }
            if (list == null) throw new ServletException("no events found");
            for (Object object : list) {
                String string;
                String[] stringArray;
                if (!(object instanceof String) || (stringArray = (string = (String)object).split("\t", 4)).length < 3) continue;
                String string2 = stringArray[2];
                if (string2.contains("<") && string2.contains(">")) {
                    string2 = Utils.stripoutHTML(string2);
                }
                printWriter.println(stringArray[0] + "\t" + stringArray[1] + "\t" + string2);
            }
            printWriter.flush();
            return;
        } else {
            pageContext.getResponse().sendError(401);
        }
    }
}

