/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.servlets;

import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.model.UPSSetup;
import com.apcc.m11.components.webserver.model.VMSettings;
import com.apcc.m11.components.webserver.pages.OmahaVMSettingsPage;
import com.apcc.m11.components.webserver.servlets.M11Servlet;
import com.apcc.pcns.ServiceManager;
import java.io.IOException;
import javax.servlet.ServletException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IndividualVMSettings
extends M11Servlet {
    private static Logger logger = LogManager.getLogger(IndividualVMSettings.class);
    public static final String VALUE_VM_SETTINGS = "vm_settings";
    public static final String SETUP_ID = "setup";
    public static final String PARAM_SETUP = "param_setup";

    public IndividualVMSettings(ServiceManager serviceManager) {
        super(serviceManager);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void doGet(PageContext pageContext) throws ServletException, IOException {
        if (!this.services.getAdvancedSetupHelper().isAdvancedShutdownMode()) {
            pageContext.getResponse().sendError(404);
            return;
        }
        Integer n = IndividualVMSettings.getSetupId(pageContext);
        if (n == null) {
            pageContext.getResponse().sendError(404);
            return;
        }
        pageContext.getSession().setAttribute(PARAM_SETUP, (Object)n);
        this.setFormToken(pageContext.getRequest());
        UPSSetup uPSSetup = this.services.getAdvancedSetupHelper().readUPSSetupFromConfig(n);
        if (uPSSetup == null) {
            pageContext.getResponse().sendError(404);
            return;
        }
        Object object = pageContext.getSession().getAttribute("activeAcc");
        if (object != null) {
            pageContext.setValue("activeAcc", object);
            pageContext.getSession().removeAttribute("activeAcc");
        }
        String string = uPSSetup.getName();
        if (this.services.getVirtualConfigurationManager().isManagedESXiOrNutanixAHV()) {
            if (uPSSetup.getHosts().size() <= 0) {
                pageContext.getResponse().sendError(404);
                return;
            }
            pageContext.setValue(SETUP_ID, n);
            pageContext.setValue(VALUE_VM_SETTINGS, this.services.getWebServerUtils().readVMSettingsFromConfigAndCluster(string));
            pageContext.getSession().setAttribute(VALUE_VM_SETTINGS, (Object)this.services.getWebServerUtils().readVMSettingsFromConfig(string));
        } else {
            if (!this.services.getVirtualConfigurationManager().isHyperV()) {
                pageContext.getResponse().sendError(404);
                return;
            }
            pageContext.setValue(SETUP_ID, n);
            pageContext.setValue(VALUE_VM_SETTINGS, this.services.getWebServerUtils().readHypervVMSettingsFromConfig(string));
            pageContext.getSession().setAttribute(VALUE_VM_SETTINGS, (Object)this.services.getWebServerUtils().readVMSettingsFromConfig(string));
        }
        OmahaVMSettingsPage omahaVMSettingsPage = new OmahaVMSettingsPage(this.services);
        omahaVMSettingsPage.setIsGlobal(false);
        pageContext.writeHTML(omahaVMSettingsPage);
    }

    @Override
    protected void doPost(PageContext pageContext) throws ServletException, IOException {
        if (this.verifyFormToken(pageContext)) {
            if (pageContext.getPostQueryValue("resetVMSettings") == null) {
                this.setVMSettings(pageContext);
                pageContext.getSession().setAttribute("activeAcc", (Object)pageContext.getPostQueryValue("activeAcc"));
            }
            String string = pageContext.getPostQueryValue(SETUP_ID);
            pageContext.getSession().setAttribute(PARAM_SETUP, (Object)string);
            pageContext.getResponse().sendRedirect(pageContext.getResponse().encodeRedirectURL("/individualvmsettings?setup=" + string));
        }
    }

    public static Integer getSetupId(PageContext pageContext) {
        String string = pageContext.getPostQueryValue(SETUP_ID);
        Integer n = null;
        if (string != null) {
            try {
                n = Integer.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                logger.error("getSetupId " + numberFormatException.getMessage());
            }
        } else if (pageContext.getSession().getAttribute(PARAM_SETUP) != null) {
            try {
                n = Integer.parseInt(pageContext.getSession().getAttribute(PARAM_SETUP).toString());
            }
            catch (NumberFormatException numberFormatException) {
                logger.error((Object)numberFormatException);
                n = null;
            }
        }
        return n;
    }

    private void setVMSettings(PageContext pageContext) {
        VMSettings vMSettings;
        String string;
        Integer n = IndividualVMSettings.getSetupId(pageContext);
        if (n != null && (string = this.services.getAdvancedSetupHelper().getUPSSetupGroupNameFromConfig(n)) != null && (vMSettings = this.services.getWebServerUtils().readVMSettingsFromRequest(pageContext)) != null) {
            this.services.getWebServerUtils().saveVMSettingsToConfig(vMSettings, string);
        }
    }
}

