/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.servlets;

import com.apcc.m11.arch.IFormatter;
import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.components.webserver.formatters.AccountLockOutFormatter;
import com.apcc.m11.components.webserver.html.HTML;
import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.pages.OmahaLoginPage;
import com.apcc.m11.components.webserver.servlets.M11Servlet;
import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.m11.ds.events.flexevents.WebServerEvents;
import com.apcc.pcns.ServiceManager;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Login
extends M11Servlet {
    private static final long serialVersionUID = -161047779930501641L;
    private static final Logger logger = LogManager.getLogger(Login.class);
    private static int maxLoginFailedCount;
    private static long lockOutDuration;
    private static Hashtable<String, Vector<Comparable>> theLockOutAddress;
    private static final ObjectId kAccountLockOutOid;
    private Boolean lockoutShown;

    public Login(ServiceManager serviceManager) {
        super(serviceManager);
    }

    @Override
    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Locale locale = this.getCurrentLocale(httpServletRequest);
        this.initRequest(httpServletRequest, httpServletResponse, locale);
        HttpSession httpSession = httpServletRequest.getSession(true);
        PrintWriter printWriter = httpServletResponse.getWriter();
        this.writeDoctype(printWriter);
        PageContext pageContext = new PageContext(locale, printWriter, M11Servlet.getDataSource(), httpSession, httpServletRequest, httpServletResponse);
        String string = Utils.getRemoteAddress(pageContext);
        this.setFormToken(httpServletRequest);
        Object object = httpSession.getAttribute("inUse");
        httpSession.removeAttribute("inUse");
        if (object != null) {
            pageContext.setValue("InUse", object);
            OmahaLoginPage omahaLoginPage = new OmahaLoginPage(this.services);
            pageContext.writeHTML(omahaLoginPage);
        } else if (!this.isAuthenticationInitialised()) {
            httpServletResponse.sendRedirect(httpServletResponse.encodeRedirectURL("/cfgwizard"));
        } else if (this.isLoginActiveBySession(httpSession.getId())) {
            logger.info("Already logged on: redirecting to home page");
            httpServletResponse.sendRedirect(httpServletResponse.encodeRedirectURL("/index.html"));
        } else {
            Object object2;
            if (Login.isLockedOut(string)) {
                httpSession.setAttribute("LockOut", (Object)Boolean.TRUE);
                pageContext.setValue("Login", Boolean.FALSE);
                if (this.lockoutShown == null || this.lockoutShown == Boolean.FALSE) {
                    this.lockoutShown = Boolean.TRUE;
                    pageContext.setValue("LockedOut", Boolean.FALSE);
                } else {
                    pageContext.setValue("LockedOut", Boolean.TRUE);
                    this.lockoutShown = Boolean.FALSE;
                }
            } else {
                httpSession.setAttribute("LockOut", (Object)Boolean.FALSE);
                object2 = httpSession.getAttribute("status");
                if (object2 != null) {
                    pageContext.setValue("Login", Boolean.FALSE);
                } else {
                    pageContext.setValue("Login", Boolean.TRUE);
                }
            }
            object2 = new OmahaLoginPage(this.services);
            pageContext.writeHTML((HTML)object2);
        }
        printWriter.close();
    }

    @Override
    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        if (!this.isAuthenticationInitialised()) {
            httpServletResponse.sendRedirect(httpServletResponse.encodeRedirectURL("/cfgwizard"));
        } else {
            maxLoginFailedCount = this.services.getLoginHelper().getLockoutFailCount();
            lockOutDuration = TimeUnit.MILLISECONDS.convert(this.services.getLoginHelper().getLockoutDuration(), TimeUnit.SECONDS);
            String string = httpServletRequest.getParameter("user");
            String string2 = httpServletRequest.getParameter("pass");
            HttpSession httpSession = httpServletRequest.getSession(false);
            Locale locale = this.getCurrentLocale(httpServletRequest);
            PrintWriter printWriter = httpServletResponse.getWriter();
            PageContext pageContext = new PageContext(locale, printWriter, M11Servlet.getDataSource(), httpSession, httpServletRequest, httpServletResponse);
            String string3 = Utils.getRemoteAddress(pageContext);
            if (httpSession != null) {
                this.initRequest(httpServletRequest, httpServletResponse, locale);
                if (this.verifyFormToken(pageContext)) {
                    boolean bl = false;
                    boolean bl2 = false;
                    if (!Login.isLockedOut(string3)) {
                        bl = this.services.getAuthHelper().checkCredentials(string, string2);
                    } else {
                        logger.debug("doPost() - remote address {} already locked out, not checking credentials", (Object)string3);
                        bl2 = true;
                        pageContext.setValue("LockedOut", Boolean.TRUE);
                    }
                    httpSession.removeAttribute("InUse");
                    int n = (Integer)httpSession.getAttribute("fromPage");
                    if (httpSession.getAttribute("LockOut") != null) {
                        bl2 = (Boolean)httpSession.getAttribute("LockOut");
                    }
                    if (bl && !bl2) {
                        if (this.isLoginSessionFree(httpSession.getId())) {
                            httpSession.setAttribute("login", (Object)"OK");
                            String string4 = httpServletRequest.changeSessionId();
                            this.addLoginSession(string4);
                            theLockOutAddress.remove(string3);
                            String string5 = "/index.html";
                            if (httpSession.getAttribute("original_url") != null) {
                                string5 = (String)httpSession.getAttribute("original_url");
                                httpSession.removeAttribute("original_url");
                            }
                            httpSession.setAttribute("isInUse", (Object)Boolean.FALSE);
                            httpServletResponse.sendRedirect(httpServletResponse.encodeRedirectURL(string5));
                        } else {
                            httpSession.setAttribute("inUse", (Object)this.getLoggedInUserSession());
                            httpSession.setAttribute("isInUse", (Object)Boolean.TRUE);
                            httpServletResponse.sendRedirect(httpServletResponse.encodeRedirectURL("/login"));
                        }
                    } else {
                        String string6 = "";
                        try {
                            string6 = this.getLoggedInUserSession();
                        }
                        catch (Exception exception) {
                            string6 = "";
                        }
                        boolean bl3 = false;
                        if (string6 != null && string6.length() > 0) {
                            bl3 = true;
                        }
                        if (bl3) {
                            httpSession.setAttribute("showMsg", (Object)2);
                        }
                        httpSession.setAttribute("isInUse", (Object)Boolean.FALSE);
                        if (n == 0) {
                            Login.countUpLockOut(string3);
                        }
                        this.services.getVirtualLoggingUtils().logLoginFailure(string, string3);
                        httpSession.setAttribute("status", (Object)"Not Auth");
                        httpServletResponse.sendRedirect(httpServletResponse.encodeRedirectURL("/login"));
                    }
                }
            } else {
                httpServletResponse.sendRedirect(httpServletResponse.encodeRedirectURL("/login"));
            }
        }
    }

    public static synchronized void countUpLockOut(String string) {
        Vector<Object> vector = new Vector<Integer>();
        Login.cleanUpLockOutList();
        if (theLockOutAddress.containsKey(string)) {
            vector = theLockOutAddress.get(string);
            Integer n = (Integer)vector.elementAt(0);
            int n2 = n;
            if (n2 >= maxLoginFailedCount - 1) {
                if (vector.size() <= 1) {
                    vector.add(1, new Date());
                    AccountLockOutFormatter accountLockOutFormatter = new AccountLockOutFormatter(string);
                    Event event = new Event(kAccountLockOutOid, true, (IFormatter)accountLockOutFormatter);
                    Login.getEventProducer().postEvent(event);
                    logger.info("account locked out :" + string);
                }
            } else {
                n = ++n2;
                vector.clear();
                vector.add(0, n);
                theLockOutAddress.put(string, vector);
            }
        } else {
            vector.add(0, 1);
            theLockOutAddress.put(string, vector);
        }
    }

    public static synchronized boolean isLockedOut(String string) {
        boolean bl = false;
        Login.cleanUpLockOutList();
        if (theLockOutAddress.containsKey(string)) {
            Vector<Comparable> vector = theLockOutAddress.get(string);
            try {
                vector.elementAt(1);
                bl = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bl;
    }

    private static synchronized void cleanUpLockOutList() {
        Enumeration<String> enumeration = theLockOutAddress.keys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            Vector<Comparable> vector = theLockOutAddress.get(string);
            try {
                Date date = (Date)vector.elementAt(1);
                Date date2 = new Date();
                if (date2.getTime() <= date.getTime() + lockOutDuration) continue;
                theLockOutAddress.remove(string);
                logger.info("account unlock :" + string);
            }
            catch (Exception exception) {}
        }
    }

    static {
        theLockOutAddress = new Hashtable();
        kAccountLockOutOid = WebServerEvents.AccountLockOut.getObjectId();
    }
}

