/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.servlets;

import com.apcc.pcns.configservice.configurationmanagers.ConfigurationManager;
import com.apcc.pcns.configservice.validation.IntRangeSetValidator;
import lombok.Generated;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LoginHelper {
    private static final Logger logger = LogManager.getLogger(LoginHelper.class);
    @NonNull
    private ConfigurationManager config;
    private int defaultFailCount = 3;
    private int minFailCount = 1;
    private int maxFailCount = 17800;
    private int defaultLockoutDuration = 120;
    private int minLockoutDuration = 0;
    private int maxLockoutDuration = 86400;
    private long lockoutDuration;
    private int lockoutFailCount;

    public LoginHelper() {
    }

    public LoginHelper(ConfigurationManager configurationManager) {
        this.config = configurationManager;
    }

    public void initialize() {
        this.lockoutDuration = this.setLockoutDuration();
        this.lockoutFailCount = this.setLockoutFailCount();
    }

    public int setLockoutFailCount() {
        int n = this.defaultFailCount;
        IntRangeSetValidator intRangeSetValidator = new IntRangeSetValidator(this.defaultFailCount);
        intRangeSetValidator.add(this.minFailCount, this.maxFailCount);
        try {
            if (this.config.containsKey("Networking", "LockoutFailCount")) {
                n = this.config.getInt("Networking", "LockoutFailCount", intRangeSetValidator);
            } else {
                this.config.setProperty("Networking", "LockoutFailCount", this.defaultFailCount);
                n = this.defaultFailCount;
                logger.debug("setLockoutFailCount() - Value for lockout Fail Count not found in INI, default value assigned: {}", (Object)n);
            }
        }
        catch (Exception exception) {
            logger.debug((Object)exception);
        }
        logger.debug("setLockoutFailCount() - Value for fail count is: {}", (Object)n);
        return n;
    }

    public long setLockoutDuration() {
        int n = this.defaultLockoutDuration;
        IntRangeSetValidator intRangeSetValidator = new IntRangeSetValidator(this.defaultLockoutDuration);
        intRangeSetValidator.add(this.minLockoutDuration, this.maxLockoutDuration);
        try {
            if (this.config.containsKey("Networking", "LockoutDuration")) {
                n = this.config.getInt("Networking", "LockoutDuration", intRangeSetValidator);
            } else {
                this.config.setProperty("Networking", "LockoutDuration", this.defaultLockoutDuration);
                n = this.defaultLockoutDuration;
                logger.debug("setLockoutDuration() - Value for lockout duration not found in INI, default value assigned: {}", (Object)n);
            }
        }
        catch (Exception exception) {
            logger.debug((Object)exception);
        }
        logger.debug("setLockoutDuration() - Value for lockout duration is : {}", (Object)n);
        return n;
    }

    @Generated
    public void setConfig(@NonNull ConfigurationManager configurationManager) {
        if (configurationManager == null) {
            throw new IllegalArgumentException("config is marked non-null but is null");
        }
        this.config = configurationManager;
    }

    @Generated
    public long getLockoutDuration() {
        return this.lockoutDuration;
    }

    @Generated
    public int getLockoutFailCount() {
        return this.lockoutFailCount;
    }
}

