/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.servlets;

import com.apcc.m11.arch.datasource.IDataSource;
import com.apcc.m11.components.webserver.WebServerEventProducer;
import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.util.SecurityUtils;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.configservice.VirtualConfigurationManager;
import com.apcc.pcns.licensing.ILicensingManager;
import com.apcc.pcns.licensing.ILicensingUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URLDecoder;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class M11Servlet
extends HttpServlet {
    private static final String LOGIN_KEY = "login";
    private static final long serialVersionUID = 5574476591486292503L;
    private static final Logger logger = LogManager.getLogger(M11Servlet.class);
    public static final String ATTR_TOKEN_KEY = "formtoken";
    public static final String ATTR_TOKEN_ID = "formtokenid";
    public static final String ATTR_ORIGINAL_URL = "original_url";
    protected static IDataSource theDataSource = null;
    private static WebServerEventProducer theEventProducer = null;
    private static String thePassword = null;
    private static String theUsername = null;
    private static int theInstallGroup = -1;
    private static int theInstalledGroupCount = -1;
    private static boolean theSslEnabled = true;
    private static boolean theWebUIProtocolChangePendingFlag = false;
    public static final String kWizardFlag = "wizardFlag";
    protected static final Hashtable<String, Date> theLoginSession = new Hashtable();
    protected ServiceManager services;
    protected static ILicensingManager licensingManager;

    public M11Servlet(@NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        this.services = serviceManager;
        licensingManager = this.services.getLicensingManager();
    }

    public static void setDataSource(IDataSource iDataSource) {
        theDataSource = iDataSource;
    }

    public static int getInstalledGroupCount() {
        return theInstalledGroupCount;
    }

    public static void setEventProducer(WebServerEventProducer webServerEventProducer) {
        theEventProducer = webServerEventProducer;
    }

    public static void setInstallGroup(int n) {
        theInstallGroup = n;
    }

    public static void setSslEnabled(boolean bl) {
        theSslEnabled = bl;
    }

    public static boolean getSslEnabled() {
        return theSslEnabled;
    }

    public static void setWebUIProtocolChangePending(boolean bl) {
        theWebUIProtocolChangePendingFlag = bl;
    }

    public static boolean isWebUIProtocolChangePending() {
        return theWebUIProtocolChangePendingFlag;
    }

    public static boolean isSecondaryGroup() {
        boolean bl = true;
        if (theInstallGroup > 1) {
            bl = false;
        }
        return bl;
    }

    public static int getCurrentGroup() {
        return theInstallGroup;
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        PageContext pageContext = new PageContext(null, null, theDataSource, null, null, null);
        this.init(pageContext);
    }

    public Locale getCurrentLocale(HttpServletRequest httpServletRequest) {
        return Locale.getDefault();
    }

    public String getLocalHostIpAddress() {
        String string;
        block8: {
            string = "127.0.0.1";
            try {
                string = InetAddress.getLocalHost().getHostAddress();
                if (!string.equals("127.0.0.1")) break block8;
                try {
                    Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
                    block6: while (enumeration.hasMoreElements()) {
                        Enumeration<InetAddress> enumeration2 = enumeration.nextElement().getInetAddresses();
                        while (enumeration2.hasMoreElements()) {
                            try {
                                String string2 = enumeration2.nextElement().getHostAddress();
                                if (string2.equals("127.0.0.1")) continue;
                                string = string2;
                                continue block6;
                            }
                            catch (Exception exception) {
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    logger.error((Object)exception);
                }
            }
            catch (Exception exception) {
                logger.error((Object)exception);
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        block13: {
            logger.debug("doGet() - start");
            try {
                if (this.isWizardNeeded(httpServletRequest)) {
                    httpServletResponse.sendRedirect("/cfgwizard");
                    break block13;
                }
                Locale locale = this.getCurrentLocale(httpServletRequest);
                this.initRequest(httpServletRequest, httpServletResponse, locale);
                HttpSession httpSession = httpServletRequest.getSession(false);
                PrintWriter printWriter = httpServletResponse.getWriter();
                PageContext pageContext = new PageContext(locale, printWriter, theDataSource, httpSession, httpServletRequest, httpServletResponse);
                this.writeDoctype(printWriter);
                if (httpSession == null) {
                    httpSession = httpServletRequest.getSession(true);
                    httpSession.setAttribute(ATTR_ORIGINAL_URL, (Object)this.createOriginalURL(httpServletRequest));
                    this.notLoggedIn(httpServletResponse, printWriter);
                } else {
                    boolean bl;
                    Object object = httpSession.getAttribute(LOGIN_KEY);
                    boolean bl2 = bl = !this.isLoginActiveBySession(httpSession.getId());
                    if (bl || object == null) {
                        httpSession.invalidate();
                        httpSession = httpServletRequest.getSession(true);
                        httpSession.setAttribute(ATTR_ORIGINAL_URL, (Object)this.createOriginalURL(httpServletRequest));
                        this.notLoggedIn(httpServletResponse, printWriter);
                    } else {
                        this.addLoginSession(httpSession.getId());
                        if (!(httpServletRequest.getServletPath().startsWith("/cfgwizard") || httpServletRequest.getServletPath().startsWith("/error") || httpServletRequest.getServletPath().contains("/licensing"))) {
                            this.checkLicense(httpServletResponse);
                        }
                        M11Servlet m11Servlet = this;
                        synchronized (m11Servlet) {
                            try {
                                this.doGet(pageContext);
                            }
                            catch (Throwable throwable) {
                                logger.error("Error retreiving page {}", (Object)httpServletRequest.getRequestURI(), (Object)throwable);
                                throw throwable;
                            }
                        }
                    }
                }
                printWriter.close();
            }
            catch (IOException | ServletException throwable) {
                logger.debug("doGet() - Exception: ", throwable);
            }
        }
    }

    private String createOriginalURL(HttpServletRequest httpServletRequest) {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(httpServletRequest.getRequestURI());
        String string2 = httpServletRequest.getPathInfo();
        if (string2 != null) {
            stringBuffer.append(string2);
        }
        if ((string = httpServletRequest.getQueryString()) != null) {
            stringBuffer.append("?");
            try {
                stringBuffer.append(URLDecoder.decode(string, "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                stringBuffer.append(string);
            }
        }
        logger.debug("originalURL=" + String.valueOf(stringBuffer));
        return stringBuffer.toString();
    }

    protected void notLoggedIn(HttpServletResponse httpServletResponse, PrintWriter printWriter) throws IOException {
        httpServletResponse.sendRedirect("/login");
    }

    protected void checkLicense(HttpServletResponse httpServletResponse) {
        licensingManager.init();
        ILicensingUtils iLicensingUtils = this.services.getLicensingUtils();
        VirtualConfigurationManager virtualConfigurationManager = this.services.getVirtualConfigurationManager();
        boolean bl = iLicensingUtils.isLicensedTier();
        boolean bl2 = virtualConfigurationManager.isConfigWizardComplete();
        boolean bl3 = licensingManager.isLicensed();
        try {
            if (!bl2) {
                httpServletResponse.sendRedirect("/cfgwizard");
            } else if (bl && !bl3) {
                httpServletResponse.sendRedirect("/licensing");
            }
        }
        catch (IOException iOException) {
            logger.error((Object)iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        block11: {
            try {
                if (this.isWizardNeeded(httpServletRequest)) {
                    httpServletResponse.sendRedirect("/cfgwizard");
                    break block11;
                }
                Locale locale = this.getCurrentLocale(httpServletRequest);
                this.initRequest(httpServletRequest, httpServletResponse, locale);
                HttpSession httpSession = httpServletRequest.getSession(false);
                PrintWriter printWriter = httpServletResponse.getWriter();
                PageContext pageContext = new PageContext(locale, printWriter, theDataSource, httpSession, httpServletRequest, httpServletResponse);
                this.writeDoctype(printWriter);
                if (httpSession == null) {
                    this.notLoggedIn(httpServletResponse, printWriter);
                } else {
                    boolean bl;
                    Object object = httpSession.getAttribute(LOGIN_KEY);
                    boolean bl2 = bl = !this.isLoginActiveBySession(httpSession.getId());
                    if (object == null || bl) {
                        httpSession.invalidate();
                        this.notLoggedIn(httpServletResponse, printWriter);
                    } else {
                        this.addLoginSession(httpSession.getId());
                        if (!(httpServletRequest.getServletPath().startsWith("/cfgwizard") || httpServletRequest.getServletPath().startsWith("/error") || httpServletRequest.getServletPath().equals("/licensing"))) {
                            this.checkLicense(httpServletResponse);
                        }
                        M11Servlet m11Servlet = this;
                        synchronized (m11Servlet) {
                            this.doPost(pageContext);
                        }
                    }
                }
                printWriter.close();
            }
            catch (IOException | ServletException throwable) {
                logger.debug("doPost() - Exception: ", throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDelete(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        block11: {
            try {
                if (this.isWizardNeeded(httpServletRequest)) {
                    httpServletResponse.sendRedirect("/cfgwizard");
                    break block11;
                }
                Locale locale = this.getCurrentLocale(httpServletRequest);
                this.initRequest(httpServletRequest, httpServletResponse, locale);
                HttpSession httpSession = httpServletRequest.getSession(false);
                PrintWriter printWriter = httpServletResponse.getWriter();
                PageContext pageContext = new PageContext(locale, printWriter, theDataSource, httpSession, httpServletRequest, httpServletResponse);
                this.writeDoctype(printWriter);
                if (httpSession == null) {
                    this.notLoggedIn(httpServletResponse, printWriter);
                } else {
                    boolean bl;
                    Object object = httpSession.getAttribute(LOGIN_KEY);
                    boolean bl2 = bl = !this.isLoginActiveBySession(httpSession.getId());
                    if (object == null || bl) {
                        httpSession.invalidate();
                        this.notLoggedIn(httpServletResponse, printWriter);
                    } else {
                        this.addLoginSession(httpSession.getId());
                        if (!(httpServletRequest.getServletPath().startsWith("/cfgwizard") || httpServletRequest.getServletPath().startsWith("/error") || httpServletRequest.getServletPath().equals("/licensing"))) {
                            this.checkLicense(httpServletResponse);
                        }
                        M11Servlet m11Servlet = this;
                        synchronized (m11Servlet) {
                            this.doDelete(pageContext, false);
                        }
                    }
                }
                printWriter.close();
            }
            catch (IOException | ServletException throwable) {
                logger.error("doDelete() - Exception: ", throwable);
            }
        }
    }

    protected boolean isValidLocale(Locale locale) {
        try {
            return locale.getISO3Language() != null && locale.getISO3Country() != null;
        }
        catch (MissingResourceException missingResourceException) {
            return false;
        }
    }

    protected void initRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Locale locale) {
        this.setDefaultResponseHeader(httpServletRequest, httpServletResponse, locale);
        try {
            httpServletRequest.setCharacterEncoding("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            logger.error("initRequest", (Throwable)unsupportedEncodingException);
        }
    }

    private void setDefaultResponseHeader(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Locale locale) {
        httpServletResponse.setHeader("Expires", "Sat, 6 May 1995 12:00:00 GMT");
        httpServletResponse.setHeader("Cache-Control", "no-store, no-cache, must-revalidate");
        httpServletResponse.setHeader("Pragma", "no-cache");
        if (!this.services.getVirtualConfigurationManager().isWebClientPluginEnabled()) {
            httpServletResponse.setHeader("X-Frame-Options", "sameorigin");
        }
        httpServletResponse.setHeader("X-UA-Compatible", "IE=edge");
        httpServletResponse.setLocale(locale);
        httpServletResponse.setContentType("text/html;charset=utf-8");
    }

    protected void init(PageContext pageContext) throws ServletException {
    }

    protected void doGet(PageContext pageContext) throws ServletException, IOException {
        this.sendNotImplemented(pageContext);
    }

    protected void doPost(PageContext pageContext) throws ServletException, IOException {
        this.sendNotImplemented(pageContext);
    }

    protected void doDelete(PageContext pageContext, boolean bl) throws ServletException, IOException {
        this.sendNotImplemented(pageContext);
    }

    protected void sendNotFound(@NonNull PageContext pageContext) {
        if (pageContext == null) {
            throw new IllegalArgumentException("aCtx is marked non-null but is null");
        }
        try {
            pageContext.getResponse().sendError(404);
        }
        catch (IOException iOException) {
            logger.error((Object)iOException);
        }
    }

    protected void sendBadRequest(@NonNull PageContext pageContext) {
        if (pageContext == null) {
            throw new IllegalArgumentException("aCtx is marked non-null but is null");
        }
        try {
            pageContext.getResponse().sendError(400);
        }
        catch (IOException iOException) {
            logger.error((Object)iOException);
        }
    }

    protected void sendNotImplemented(PageContext pageContext) {
        try {
            pageContext.getResponse().sendError(501);
        }
        catch (IOException iOException) {
            logger.error((Object)iOException);
        }
    }

    protected boolean isWizardNeeded(HttpServletRequest httpServletRequest) {
        boolean bl = false;
        if (!httpServletRequest.getServletPath().startsWith("/cfgwizard") && !httpServletRequest.getServletPath().startsWith("/error")) {
            if (!this.isAuthenticationInitialised() || !this.isAppInitialised()) {
                bl = true;
            } else {
                Object object;
                HttpSession httpSession = httpServletRequest.getSession(false);
                if (httpSession != null && (object = httpSession.getAttribute(kWizardFlag)) instanceof Boolean && ((Boolean)object).booleanValue()) {
                    bl = true;
                }
            }
        }
        return bl;
    }

    public boolean isAuthenticationInitialised() {
        return this.services.getAuthHelper().hasCredentials();
    }

    protected boolean isAppInitialised() {
        return this.services.getVirtualConfigurationManager().isConfigWizardComplete();
    }

    protected void writeDoctype(PrintWriter printWriter) {
        printWriter.print("<!doctype html>");
    }

    public static IDataSource getDataSource() {
        return theDataSource;
    }

    protected static WebServerEventProducer getEventProducer() {
        return theEventProducer;
    }

    protected boolean isLoginActive(HttpServletRequest httpServletRequest) {
        boolean bl = false;
        if (this.isAuthenticationInitialised()) {
            String string = httpServletRequest.getSession().getId();
            if (this.isLoginActiveBySession(string)) {
                bl = true;
            }
        } else {
            bl = true;
        }
        logger.info("login active :" + bl);
        return bl;
    }

    protected synchronized void logout(HttpServletRequest httpServletRequest) {
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession != null) {
            theLoginSession.remove(httpSession.getId());
            httpSession.invalidate();
        }
    }

    protected synchronized void addLoginSession(String string) {
        Date date = new Date();
        theLoginSession.put(string, date);
    }

    public synchronized boolean isLoginActiveBySession(String string) {
        boolean bl = false;
        this.cleanUpLoginList();
        if (theLoginSession.containsKey(string)) {
            bl = true;
        }
        return bl;
    }

    public synchronized boolean isLoginSessionFree(String string) {
        logger.info("isLoginFree: " + string);
        logger.info("isLoginFree: login before Cleanup" + String.valueOf(theLoginSession));
        this.cleanUpLoginList();
        logger.info("isLoginFree: login after Cleanup" + String.valueOf(theLoginSession));
        logger.info("isLoginFree: Return" + (theLoginSession.containsKey(string) || theLoginSession.isEmpty()));
        return theLoginSession.containsKey(string) || theLoginSession.isEmpty();
    }

    protected synchronized String getLoggedInUserSession() {
        return theLoginSession.keys().nextElement();
    }

    private synchronized void cleanUpLoginList() {
        Enumeration<String> enumeration = theLoginSession.keys();
        while (enumeration.hasMoreElements()) {
            try {
                String string = enumeration.nextElement();
                Date date = theLoginSession.get(string);
                Date date2 = new Date();
                if (date2.getTime() - date.getTime() <= TimeUnit.MILLISECONDS.convert(this.services.getApplicationSettings().getSessionTimeoutSeconds(), TimeUnit.SECONDS)) continue;
                theLoginSession.remove(string);
            }
            catch (Exception exception) {}
        }
    }

    protected String getIPv4Address(String string) {
        String string2 = string;
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            if (inetAddress instanceof Inet4Address) {
                string2 = inetAddress.getHostAddress();
            } else if (inetAddress instanceof Inet6Address) {
                inetAddress = InetAddress.getByName(inetAddress.getHostName());
                string2 = inetAddress.getHostAddress();
            }
        }
        catch (Exception exception) {
            logger.error("Invalid address : ", (Throwable)exception);
        }
        return string2;
    }

    protected void setFormToken(HttpServletRequest httpServletRequest) throws ServletException {
        this.setFormToken(httpServletRequest, this.createFormTokenKey(httpServletRequest));
    }

    protected void setFormToken(HttpServletRequest httpServletRequest, String string) throws ServletException {
        String string2 = "";
        try {
            string2 = SecurityUtils.getRandomToken(httpServletRequest.getSession(), string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new ServletException((Throwable)noSuchAlgorithmException);
        }
        httpServletRequest.setAttribute(ATTR_TOKEN_KEY, (Object)string2);
        httpServletRequest.setAttribute(ATTR_TOKEN_ID, (Object)string);
    }

    protected String createFormTokenKey(HttpServletRequest httpServletRequest) {
        return httpServletRequest.getServletPath() + "_formtoken";
    }

    protected boolean verifyFormToken(PageContext pageContext) throws ServletException, IOException {
        boolean bl = true;
        HttpSession httpSession = pageContext.getSession();
        if (httpSession == null) {
            throw new ServletException("No valid session found");
        }
        boolean bl2 = Boolean.valueOf(httpSession.getServletContext().getInitParameter("FormTokenPerRequest"));
        if (!this.verifyFormToken(pageContext, bl2)) {
            bl = false;
            this.logout(pageContext.getRequest());
            this.notLoggedIn(pageContext.getResponse(), pageContext.getOutputWriter());
        }
        return bl;
    }

    protected boolean verifyFormToken(PageContext pageContext, boolean bl) {
        boolean bl2 = false;
        String string = pageContext.getPostQueryValue(ATTR_TOKEN_ID);
        if (string != null) {
            try {
                bl2 = SecurityUtils.verifyRandomToken(pageContext, ATTR_TOKEN_KEY, string, bl);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                logger.error((Object)noSuchAlgorithmException);
                bl2 = false;
            }
        }
        return bl2;
    }
}

