/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.servlets;

import com.apcc.m11.components.stdpowersource.OutletGroup;
import com.apcc.m11.components.webserver.html.HTML;
import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.model.NMC;
import com.apcc.m11.components.webserver.model.UPSSetup;
import com.apcc.m11.components.webserver.pages.OmahaNMCDetailsPage;
import com.apcc.m11.components.webserver.servlets.M11Servlet;
import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.m11.ds.powersource.communication.TCPIPCommunication;
import com.apcc.pcns.ServiceManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NMCDetails
extends M11Servlet {
    private static final Logger logger = LogManager.getLogger(NMCDetails.class);
    public static final String PARAM_NMC_IP = "nmcip";
    public static final String PARAM_OUTLET = "outlet";
    public static final String VALUE_VCENTER_MANAGED = "is_vcenter_managed";
    public static final String VALUE_CLUSTER_MODE = "is_cluster_mode";
    public static final String VALUE_NMC_DATA = "nmc_data";
    public static final String OUTLET_REG_ERROR = "OutletRegistrationError";
    public static final String NMC_GROUP_NAME = "NMCGroupName";

    public NMCDetails(ServiceManager serviceManager) {
        super(serviceManager);
    }

    private Map<String, ArrayList<OutletGroup>> getOutletGroups(NMC nMC, String string) {
        HashMap<String, ArrayList<OutletGroup>> hashMap = new HashMap<String, ArrayList<OutletGroup>>();
        hashMap.put(string, new ArrayList<OutletGroup>(nMC.getOutletGroups()));
        return hashMap;
    }

    @Override
    protected void doGet(PageContext pageContext) throws ServletException, IOException {
        String string = pageContext.getPostQueryValue(PARAM_NMC_IP);
        if (string == null) {
            string = (String)pageContext.getSession().getAttribute(PARAM_NMC_IP);
        }
        if (string != null) {
            pageContext.getSession().setAttribute(PARAM_NMC_IP, (Object)string);
            NMC nMC = Utils.getNMC(pageContext, string, true);
            if (nMC != null) {
                Object object;
                this.setFormToken(pageContext.getRequest());
                if (this.services.getAdvancedSetupHelper().isAdvancedShutdownMode()) {
                    object = "";
                    List<UPSSetup> list = this.services.getAdvancedSetupHelper().readUPSSetupsFromConfig();
                    object = this.services.getAdvancedSetupHelper().getNMCGroup(string, list);
                    pageContext.setValue(NMC_GROUP_NAME, object);
                    if (this.services.getVirtualConfigurationManager().isManagedHostOrNutanixAHV() && this.services.getAdvancedSetupHelper().getSingleUPSSetupSetting()) {
                        if (!this.hasHostsMapped(list, nMC.getIPAddress()) && nMC.hasOutletGroups()) {
                            pageContext.setValue("OutletGroupList", this.getOutletGroups(nMC, string));
                        }
                    } else if (nMC.hasOutletGroups()) {
                        pageContext.setValue("OutletGroupList", this.getOutletGroups(nMC, string));
                    }
                } else if (nMC.hasOutletGroups()) {
                    pageContext.setValue("OutletGroupList", this.getOutletGroups(nMC, string));
                }
                pageContext.getSession().setAttribute(VALUE_NMC_DATA, (Object)nMC);
                object = new OmahaNMCDetailsPage(this.services);
                pageContext.writeHTML((HTML)object);
            } else {
                pageContext.getResponse().sendError(400, "NMC was not found!");
            }
        } else {
            pageContext.getResponse().sendError(400, "NMC was not found!");
        }
    }

    @Override
    protected void doPost(PageContext pageContext) throws ServletException, IOException {
        if (this.verifyFormToken(pageContext)) {
            String string = pageContext.getPostQueryValue(PARAM_NMC_IP);
            if (string == null) {
                logger.error("NMC IP Address is missing in post data");
            } else {
                this.setOutletGroups(pageContext);
            }
            pageContext.getSession().setAttribute(PARAM_NMC_IP, (Object)string);
            pageContext.getResponse().sendRedirect(pageContext.getResponse().encodeRedirectURL("/upsconfig"));
        }
    }

    private void setOutletGroups(PageContext pageContext) {
        Map<String, String[]> map = pageContext.getPostQueryValues();
        ArrayList<OutletGroup> arrayList = new ArrayList<OutletGroup>();
        for (Map.Entry<String, String[]> object : map.entrySet()) {
            String string = object.getKey();
            String[] stringArray = object.getValue();
            if (!string.startsWith("GroupFor")) continue;
            String string2 = new String(string.substring("GroupFor".length()));
            Integer n = Integer.valueOf(stringArray[0]);
            OutletGroup outletGroup = new OutletGroup(n, null, null, string2, false);
            arrayList.add(outletGroup);
            if (stringArray.length <= 1) continue;
            logger.error("Only one outlet group per IP is allowed");
        }
        boolean bl = false;
        for (OutletGroup outletGroup : arrayList) {
            bl = pageContext.set(TCPIPCommunication.OutletGroup.getObjectId(), outletGroup);
            if (bl) continue;
            pageContext.setValue(OUTLET_REG_ERROR, outletGroup.getIpAddress());
        }
    }

    private boolean hasHostsMapped(List<UPSSetup> list, String string) {
        for (UPSSetup uPSSetup : list) {
            if (!uPSSetup.containsNMC(string).booleanValue()) continue;
            return !uPSSetup.getHosts().isEmpty();
        }
        return false;
    }
}

