/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.servlets;

import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.pages.OmahaNutanixSettingsPage;
import com.apcc.m11.components.webserver.servlets.Configure;
import com.apcc.m11.components.webserver.servlets.M11Servlet;
import com.apcc.m11.ds.powersource.communication.TCPIPCommunication;
import com.apcc.pcns.ServiceManager;
import java.io.IOException;
import javax.servlet.ServletException;

public class NutanixSettings
extends M11Servlet {
    private static final long serialVersionUID = 3950748404476399658L;

    public NutanixSettings(ServiceManager serviceManager) {
        super(serviceManager);
    }

    @Override
    protected void doGet(PageContext pageContext) throws ServletException, IOException {
        OmahaNutanixSettingsPage omahaNutanixSettingsPage = new OmahaNutanixSettingsPage(this.services);
        this.setFormToken(pageContext.getRequest());
        this.update(pageContext);
        pageContext.writeHTML(omahaNutanixSettingsPage);
    }

    @Override
    protected void doPost(PageContext pageContext) throws ServletException, IOException {
        if (this.verifyFormToken(pageContext)) {
            this.setPostData(pageContext);
            pageContext.getResponse().sendRedirect(pageContext.getResponse().encodeRedirectURL("/NutanixSettings"));
        }
    }

    private void update(PageContext pageContext) {
        String string = pageContext.format(TCPIPCommunication.PollInterval.getObjectId());
        if (string != null) {
            pageContext.setValue("HeartbeatPollingInvterval", string);
        } else {
            pageContext.setValue("HeartbeatPollingIntervalError", "");
        }
        String string2 = pageContext.format(TCPIPCommunication.EventReceiverPort.getObjectId());
        if (string2 != null) {
            pageContext.setValue("ReceiverPort", string2);
        } else {
            pageContext.setValue("ReceiverPortError", "");
        }
        if (this.services.getVirtualConfigurationManager().isNutanixESXi()) {
            new Configure(this.services).getNutanixConnectionCredentials(pageContext);
        }
    }

    private void setPostData(PageContext pageContext) {
        new Configure(this.services).setNutanixConnectionCredentials(pageContext);
    }
}

