/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.servlets;

import com.apcc.m11.components.webserver.html.HTML;
import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.model.PrioritizedVM;
import com.apcc.m11.components.webserver.model.VMOperations;
import com.apcc.m11.components.webserver.model.VMPrioritizationDurations;
import com.apcc.m11.components.webserver.model.VMPrioritizationOperations;
import com.apcc.m11.components.webserver.model.VMPriority;
import com.apcc.m11.components.webserver.pages.OmahaVMPrioritization;
import com.apcc.m11.components.webserver.servlets.M11Servlet;
import com.apcc.m11.components.webserver.util.VMPriorityTreeHelper;
import com.apcc.pcns.ServiceManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.ServletException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VMPrioritization
extends M11Servlet {
    private static final long serialVersionUID = -239827659005532442L;
    private static final Logger logger = LogManager.getLogger(VMPrioritization.class);

    public VMPrioritization(ServiceManager serviceManager) {
        super(serviceManager);
    }

    @Override
    protected void doGet(PageContext pageContext) throws ServletException, IOException {
        boolean bl = this.services.getVirtualConfigurationManager().isHyperV();
        boolean bl2 = this.services.getVirtualConfigurationManager().isManagedHost();
        boolean bl3 = this.services.getVirtualConfigurationManager().isManagedESXiOrNutanixAHV();
        logger.debug("doGet() - start");
        if (bl3 || !bl2 && bl) {
            Object object;
            Object object2 = pageContext.getSession().getAttribute("activeAcc");
            if (object2 != null) {
                pageContext.setValue("activeAcc", object2);
                pageContext.getSession().removeAttribute("activeAcc");
            }
            boolean bl4 = this.services.getVMPrioritizationUtils().isVMPrioritizationEnabled();
            pageContext.setValue("VMPrioritizationEnabled", bl4);
            if (bl4 && (object = (VMPrioritizationOperations)pageContext.getValue("VMPrioritizationData")) == null) {
                object = this.services.getVMPrioritizationUtils().readVMPrioritizationFromConfig(this.services.getVMPriorityTreeHelper().getInventoryList());
                pageContext.setValue("VMPrioritizationData", object);
            }
            this.setFormToken(pageContext.getRequest());
            object = new OmahaVMPrioritization(this.services);
            pageContext.writeHTML((HTML)object);
        } else {
            pageContext.getResponse().sendError(404);
        }
    }

    @Override
    protected void doPost(PageContext pageContext) throws ServletException, IOException {
        if (this.verifyFormToken(pageContext)) {
            logger.debug("doPost() - start");
            if (pageContext.getPostQueryValue("resetVMPrioritization") == null) {
                this.setVMPrioritization(pageContext);
            }
            pageContext.getResponse().sendRedirect(pageContext.getResponse().encodeRedirectURL("/vmprioritization"));
        }
    }

    private void setVMPrioritization(PageContext pageContext) {
        logger.debug("setVMPrioritization");
        boolean bl = pageContext.getPostQueryValue("VMPrioritizationEnabled") != null;
        this.services.getVMPrioritizationUtils().saveVMPrioritizatonEnabledToConfig(bl);
        if (bl) {
            this.setVMPrioritizationLists(pageContext);
            this.setVMPrioritizationDurations(pageContext);
            pageContext.getSession().setAttribute("activeAcc", (Object)pageContext.getPostQueryValue("activeAcc"));
        }
    }

    private void setVMPrioritizationLists(PageContext pageContext) {
        logger.debug("setVMPrioritizationLists");
        try {
            VMPriorityTreeHelper vMPriorityTreeHelper = this.services.getVMPriorityTreeHelper();
            logger.debug("got Helper");
            List<PrioritizedVM> list = vMPriorityTreeHelper.readPriorityVMListFromRequest(pageContext, VMPriority.HIGH);
            this.services.getVMPrioritizationUtils().savePrioritizedVMListToConfig(VMPriority.HIGH, list);
            list = vMPriorityTreeHelper.readPriorityVMListFromRequest(pageContext, VMPriority.MEDIUM);
            this.services.getVMPrioritizationUtils().savePrioritizedVMListToConfig(VMPriority.MEDIUM, list);
            list = vMPriorityTreeHelper.readPriorityVMListFromRequest(pageContext, VMPriority.LOW);
            this.services.getVMPrioritizationUtils().savePrioritizedVMListToConfig(VMPriority.LOW, list);
            list = vMPriorityTreeHelper.readPriorityVMListFromRequest(pageContext, VMPriority.GROUP_1);
            this.services.getVMPrioritizationUtils().savePrioritizedVMListToConfig(VMPriority.GROUP_1, list);
            list = vMPriorityTreeHelper.readPriorityVMListFromRequest(pageContext, VMPriority.GROUP_2);
            this.services.getVMPrioritizationUtils().savePrioritizedVMListToConfig(VMPriority.GROUP_2, list);
        }
        catch (Exception exception) {
            logger.debug("Exception", (Throwable)exception);
            throw exception;
        }
        logger.debug("setVMPrioritizationLists DONE");
    }

    private void setVMPrioritizationDurations(PageContext pageContext) {
        logger.debug("setVMPrioritizationDurations");
        String string = "";
        Object object = "";
        int n = 0;
        List<Object> list = new ArrayList<VMOperations>();
        if (this.services.getVirtualConfigurationManager().isNutanixAHV()) {
            list.add((Object)VMOperations.SHUTDOWN);
            list.add((Object)VMOperations.STARTUP);
        } else {
            list = Arrays.asList(VMOperations.values());
        }
        for (VMOperations vMOperations : list) {
            string = vMOperations.toString();
            VMPrioritizationDurations vMPrioritizationDurations = new VMPrioritizationDurations();
            block11: for (VMPriority vMPriority : VMPriority.values()) {
                object = string + vMPriority.toString();
                try {
                    n = Integer.valueOf(pageContext.getPostQueryValue((String)object));
                }
                catch (NumberFormatException numberFormatException) {
                    logger.error((Object)numberFormatException);
                    n = 0;
                }
                switch (vMPriority) {
                    case HIGH: {
                        vMPrioritizationDurations.setHighDuration(n);
                        continue block11;
                    }
                    case MEDIUM: {
                        vMPrioritizationDurations.setMediumDuration(n);
                        continue block11;
                    }
                    case LOW: {
                        vMPrioritizationDurations.setLowDuration(n);
                        continue block11;
                    }
                    case GROUP_1: {
                        vMPrioritizationDurations.setGroup1Duration(n);
                        continue block11;
                    }
                    case GROUP_2: {
                        vMPrioritizationDurations.setGroup2Duration(n);
                        continue block11;
                    }
                    case NONE: {
                        vMPrioritizationDurations.setUnPrioritizedDuration(n);
                    }
                }
            }
            this.services.getVMPrioritizationUtils().saveVMPrioritizationDurationsToConfig(vMOperations, vMPrioritizationDurations);
        }
    }
}

