/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.servlets.cfgwizard;

import com.apcc.m11.arch.FormatterException;
import com.apcc.m11.arch.UnsupportedLocaleException;
import com.apcc.m11.components.shutdowner.formatters.VirtualizationFeaturesFormatter;
import com.apcc.m11.components.webserver.cfgwizard.states.CertificateManagement;
import com.apcc.m11.components.webserver.cfgwizard.states.CfgWizardFactory;
import com.apcc.m11.components.webserver.cfgwizard.states.CfgWizardState;
import com.apcc.m11.components.webserver.cfgwizard.states.CfgWizardStateAPC;
import com.apcc.m11.components.webserver.cfgwizard.states.CfgWizardStateNode;
import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.servlets.M11Servlet;
import com.apcc.m11.components.webserver.servlets.cfgwizard.HTTPServletParameterMap;
import com.apcc.m11.components.webserver.servlets.cfgwizard.M11DataSourceAccessor;
import com.apcc.pcns.ServiceManager;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Deque;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedDeque;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CfgWizardServlet
extends M11Servlet {
    public static final long serialVersionUID = 4046698120117828404L;
    private static final Logger logger = LogManager.getLogger(CfgWizardServlet.class);
    public static final String CURRENT_STATE = "currentState";
    public static final String WIZ_HISTORY = "wizHistory";
    public static final String ATTR_NEXT = "next";
    public static final String ATTR_PREVIOUS = "previous";
    public static final String ATTR_APPLY = "apply";
    public static final String ATTR_CANCEL = "cancel";
    public static final String EXIT_WIZARD = "exitWizard";
    public static final String ATTR_HAS_SOG = "hasSOG";
    public static final String ATTR_FIX_PAGE = "fixPage";
    public static final String HOST_NMC_MAPPING_SESSION = "HostNMCMappingPage";
    public static final String TARGET_HOST_SELECTION_SESSION = "TargetHostSelectionPage";
    public static final String PARAM_UPS_GROUP = "upsgroup";
    public static final String PARAM_UPS_IP = "upsip";
    public static final String CEIP_ENABLED = "CEIPEnabled";
    public static final String PARAM_IS_MANAGED_HOST = "isManagedHost";
    public static final String CHECKED = "on";
    private final Map<String, CfgWizardState> states;

    public CfgWizardServlet(@NonNull ServiceManager serviceManager, CfgWizardFactory cfgWizardFactory) {
        super(serviceManager);
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        logger.debug("CfgWizardServlet() - start");
        this.states = cfgWizardFactory.makeWizard();
    }

    protected final CfgWizardState getCurrentState(HttpSession httpSession) {
        CfgWizardState cfgWizardState = (CfgWizardState)httpSession.getAttribute(CURRENT_STATE);
        if (cfgWizardState == null) {
            logger.debug("getCurrentState() - setting the start page to Welcome");
            cfgWizardState = this.states.get("/Welcome");
            this.setCurrentState(httpSession, cfgWizardState);
        }
        return cfgWizardState;
    }

    protected void setCurrentState(HttpSession httpSession, CfgWizardState cfgWizardState) {
        httpSession.setAttribute(CURRENT_STATE, (Object)cfgWizardState);
    }

    protected void removeCurrentState(HttpSession httpSession) {
        httpSession.removeAttribute(CURRENT_STATE);
        httpSession.removeAttribute(WIZ_HISTORY);
    }

    protected Deque<CfgWizardState> getHistory(HttpSession httpSession) {
        Object object = httpSession.getAttribute(WIZ_HISTORY);
        ConcurrentLinkedDeque concurrentLinkedDeque = null;
        if (object instanceof ConcurrentLinkedDeque) {
            concurrentLinkedDeque = (ConcurrentLinkedDeque)object;
        }
        if (concurrentLinkedDeque == null) {
            concurrentLinkedDeque = new ConcurrentLinkedDeque();
            httpSession.setAttribute(WIZ_HISTORY, concurrentLinkedDeque);
        }
        return concurrentLinkedDeque;
    }

    protected void moveToNextState(HttpSession httpSession, String string) {
        logger.debug("moveToNextState() - start {}", (Object)string);
        CfgWizardState cfgWizardState = this.getCurrentState(httpSession);
        this.getHistory(httpSession).push(cfgWizardState);
        if (this.states.containsKey(string)) {
            this.setCurrentState(httpSession, this.states.get(string));
        } else {
            logger.error("moveToNextState() - forward to invalid State {}", (Object)string);
        }
    }

    protected void moveBacktoState(HttpSession httpSession, String string) {
        logger.debug("moveBacktoState() - start");
        CfgWizardState cfgWizardState = null;
        if (string != null) {
            cfgWizardState = this.states.get(string);
        }
        Deque<CfgWizardState> deque = this.getHistory(httpSession);
        if (cfgWizardState instanceof CertificateManagement) {
            logger.debug("moveBackToState() - Moving to state: {}", (Object)string);
            this.moveToNextState(httpSession, string);
            return;
        }
        if (deque.peek() != null) {
            CfgWizardState cfgWizardState2 = deque.pop();
            while (!cfgWizardState2.isABackPage() || cfgWizardState != null && cfgWizardState != cfgWizardState2) {
                cfgWizardState2 = deque.pop();
            }
            logger.debug("moveBackToState() - Moving back to state: {}", (Object)cfgWizardState2);
            this.setCurrentState(httpSession, cfgWizardState2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        logger.debug("doGet() - start");
        if (this.isAuthenticationInitialised()) {
            super.doGet(httpServletRequest, httpServletResponse);
        } else {
            Locale locale = this.getCurrentLocale(httpServletRequest);
            this.initRequest(httpServletRequest, httpServletResponse, locale);
            HttpSession httpSession = httpServletRequest.getSession(true);
            PrintWriter printWriter = null;
            try {
                printWriter = httpServletResponse.getWriter();
            }
            catch (IOException iOException) {
                logger.error("doGet() - error calling doGet", (Throwable)iOException);
                this.reDirectToError(httpServletResponse);
                return;
            }
            this.writeDoctype(printWriter);
            if (!this.isLoginSessionFree(httpSession.getId())) {
                httpSession.setAttribute("inUse", (Object)this.getLoggedInUserSession());
                this.reDirectToURL(httpServletResponse, "/login");
            } else {
                httpSession.setAttribute("login", (Object)Boolean.TRUE);
                this.addLoginSession(httpSession.getId());
                PageContext pageContext = new PageContext(locale, printWriter, CfgWizardServlet.getDataSource(), httpSession, httpServletRequest, httpServletResponse);
                CfgWizardServlet cfgWizardServlet = this;
                synchronized (cfgWizardServlet) {
                    try {
                        this.doGet(pageContext);
                    }
                    catch (Exception exception) {
                        logger.error("Error retreiving page {}", (Object)httpServletRequest.getRequestURI(), (Object)exception);
                        this.reDirectToError(httpServletResponse);
                    }
                }
                printWriter.close();
            }
        }
    }

    @Override
    protected void doGet(PageContext pageContext) throws ServletException, IOException {
        logger.debug("doGet() - start");
        this.setFormToken(pageContext.getRequest());
        CfgWizardState cfgWizardState = this.getCurrentState(pageContext.getSession());
        pageContext.getSession().setAttribute("wizardFlag", (Object)Boolean.TRUE);
        cfgWizardState.setSessionValuesForPage(pageContext.getSession(), this.services);
        if (cfgWizardState instanceof CfgWizardStateAPC) {
            pageContext.writeHTML(((CfgWizardStateAPC)cfgWizardState).doLoadPage(this.services));
        }
        if (cfgWizardState instanceof CfgWizardStateNode) {
            CfgWizardStateNode cfgWizardStateNode = (CfgWizardStateNode)cfgWizardState;
            M11DataSourceAccessor m11DataSourceAccessor = new M11DataSourceAccessor(CfgWizardServlet.getDataSource());
            String string = cfgWizardStateNode.doGetNextPage(pageContext.getSession(), this.services, m11DataSourceAccessor);
            this.moveToNextState(pageContext.getSession(), string);
            try {
                pageContext.getRequest().getRequestDispatcher("/cfgwizard").forward((ServletRequest)pageContext.getRequest(), (ServletResponse)pageContext.getResponse());
            }
            catch (IOException | ServletException throwable) {
                this.reDirectToError(pageContext.getResponse());
            }
        }
    }

    private void reDirectToURL(HttpServletResponse httpServletResponse, String string) {
        try {
            httpServletResponse.sendRedirect(string);
        }
        catch (IOException iOException) {
            this.reDirectToError(httpServletResponse);
        }
    }

    private void reDirectToError(HttpServletResponse httpServletResponse) {
        try {
            httpServletResponse.sendRedirect("/error");
        }
        catch (IOException iOException) {
            logger.error("reDirectToError() - Unable to redirect Error", (Throwable)iOException);
        }
    }

    @Override
    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        logger.debug("doPost() - start");
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (!this.isAuthenticationInitialised() || this.isLoggedIn(httpSession, httpServletResponse)) {
            HTTPServletParameterMap hTTPServletParameterMap = new HTTPServletParameterMap(httpServletRequest.getParameterMap());
            M11DataSourceAccessor m11DataSourceAccessor = new M11DataSourceAccessor(CfgWizardServlet.getDataSource());
            if (hTTPServletParameterMap.containsKey(ATTR_CANCEL) && hTTPServletParameterMap.containsKey("finish")) {
                logger.debug("doPost() - Finished");
                CfgWizardState cfgWizardState = this.getCurrentState(httpSession);
                cfgWizardState.doUpdateSession(httpSession, hTTPServletParameterMap, this.services);
                cfgWizardState.doApplySessionToApplication(httpSession, this.services, m11DataSourceAccessor);
                this.doCancel(httpSession, httpServletResponse, true);
            } else if (hTTPServletParameterMap.containsKey(ATTR_CANCEL)) {
                logger.debug("doPost() - cancel Pressed");
                this.doCancel(httpSession, httpServletResponse, false);
            } else {
                CfgWizardState cfgWizardState = this.getCurrentState(httpSession);
                cfgWizardState.doUpdateSession(httpSession, hTTPServletParameterMap, this.services);
                if (hTTPServletParameterMap.containsKey(ATTR_PREVIOUS)) {
                    String string = cfgWizardState.doGetBackPage(httpSession, this.services);
                    this.moveBacktoState(httpSession, string);
                } else {
                    cfgWizardState.doApplySessionToApplication(httpSession, this.services, m11DataSourceAccessor);
                    String string = cfgWizardState.doGetNextPage(httpSession, this.services, m11DataSourceAccessor);
                    this.moveToNextState(httpSession, string);
                }
                this.reDirectToURL(httpServletResponse, "/cfgwizard");
            }
        }
    }

    private boolean isLoggedIn(HttpSession httpSession, HttpServletResponse httpServletResponse) {
        boolean bl = false;
        if (httpSession == null) {
            this.reDirectToURL(httpServletResponse, "/login");
        } else {
            boolean bl2;
            Object object = httpSession.getAttribute("login");
            boolean bl3 = bl2 = !this.isLoginActiveBySession(httpSession.getId());
            if (object == null || bl2) {
                logger.debug("doGet() - incorrect login or timeout");
                httpSession.invalidate();
                this.reDirectToURL(httpServletResponse, "/login");
            } else {
                this.addLoginSession(httpSession.getId());
                bl = true;
            }
        }
        return bl;
    }

    protected void doCancel(HttpSession httpSession, HttpServletResponse httpServletResponse, boolean bl) {
        if (httpSession.getAttribute(HOST_NMC_MAPPING_SESSION) != null) {
            httpSession.removeAttribute(HOST_NMC_MAPPING_SESSION);
            httpSession.removeAttribute("mappedHosts");
            if (!bl) {
                try {
                    String string = new VirtualizationFeaturesFormatter(14).format(null);
                    this.services.getApplicationErrorHandler().put(string);
                }
                catch (FormatterException formatterException) {
                    logger.debug("FormatterException ", (Throwable)formatterException);
                }
                catch (UnsupportedLocaleException unsupportedLocaleException) {
                    logger.debug("UnsupportedLocaleException ", (Throwable)unsupportedLocaleException);
                }
            }
        }
        if (httpSession.getAttribute(TARGET_HOST_SELECTION_SESSION) != null) {
            httpSession.removeAttribute(TARGET_HOST_SELECTION_SESSION);
            httpSession.removeAttribute("targetHosts");
        }
        httpSession.removeAttribute("wizardFlag");
        this.removeCurrentState(httpSession);
        httpSession.removeAttribute(ATTR_NEXT);
        httpSession.removeAttribute(ATTR_PREVIOUS);
        httpSession.removeAttribute(ATTR_APPLY);
        httpSession.removeAttribute(ATTR_CANCEL);
        httpSession.removeAttribute("finish");
        this.reDirectToURL(httpServletResponse, "/index.html");
    }
}

