/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.servlets.cfgwizard;

import com.apcc.m11.arch.CommunicationException;
import com.apcc.m11.arch.IFormatter;
import com.apcc.m11.arch.InvalidObjectIdException;
import com.apcc.m11.arch.InvalidValueException;
import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.datasource.GetResult;
import com.apcc.m11.arch.datasource.IDataSource;
import com.apcc.m11.arch.datasource.SetResult;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class M11DataSourceAccessor {
    private static final Logger logger = LogManager.getLogger(M11DataSourceAccessor.class);
    private static final String INVALID_OBJECT_ID = "Invalid ObjectID:{}";
    private IDataSource theDataSource = null;

    public M11DataSourceAccessor(IDataSource iDataSource) {
        this.theDataSource = iDataSource;
    }

    public Object get(ObjectId objectId) {
        Object object = null;
        try {
            GetResult getResult = this.theDataSource.get(objectId);
            if (getResult != null) {
                object = getResult.getValue();
            }
        }
        catch (InvalidObjectIdException invalidObjectIdException) {
            logger.debug(INVALID_OBJECT_ID, (Object)objectId, (Object)invalidObjectIdException);
        }
        catch (CommunicationException communicationException) {
            logger.error((Object)communicationException);
            logger.debug("get oid={}", (Object)objectId, (Object)communicationException);
        }
        return object;
    }

    public Object get(ObjectId objectId, Object object) {
        Object object2 = null;
        try {
            GetResult getResult = this.theDataSource.get(objectId, object);
            if (getResult != null) {
                object2 = getResult.getValue();
            }
        }
        catch (InvalidObjectIdException invalidObjectIdException) {
            logger.debug(INVALID_OBJECT_ID, (Object)objectId, (Object)invalidObjectIdException);
        }
        catch (InvalidValueException invalidValueException) {
            logger.error((Object)invalidValueException);
            logger.debug("Invalid Value{}", object, (Object)invalidValueException);
        }
        catch (CommunicationException communicationException) {
            logger.error((Object)communicationException);
            logger.debug("get oid={}", (Object)objectId, (Object)communicationException);
        }
        return object2;
    }

    public IFormatter getFormatter(ObjectId objectId) {
        IFormatter iFormatter = null;
        try {
            GetResult getResult = this.theDataSource.get(objectId, 3);
            iFormatter = (IFormatter)getResult.getValue();
        }
        catch (InvalidObjectIdException invalidObjectIdException) {
            logger.debug(INVALID_OBJECT_ID, (Object)objectId, (Object)invalidObjectIdException);
        }
        catch (CommunicationException communicationException) {
            logger.error((Object)communicationException);
            logger.debug("getFormatter oid={}", (Object)objectId, (Object)communicationException);
        }
        return iFormatter;
    }

    public boolean set(ObjectId objectId, Object object) {
        boolean bl = false;
        SetResult setResult = this.setNoWait(objectId, object);
        try {
            bl = setResult.wasSuccessful();
        }
        catch (CommunicationException communicationException) {
            logger.error("set failed oid={} value={}", (Object)objectId, object, (Object)communicationException);
        }
        return bl;
    }

    public SetResult setNoWait(ObjectId objectId, Object object) {
        SetResult setResult = new SetResult();
        setResult.setSuccessful(false);
        try {
            setResult = this.theDataSource.set(objectId, object);
        }
        catch (InvalidValueException invalidValueException) {
            logger.error((Object)invalidValueException);
            logger.debug("Invalid Value{}", object, (Object)invalidValueException);
        }
        catch (InvalidObjectIdException invalidObjectIdException) {
            logger.debug(INVALID_OBJECT_ID, (Object)objectId, (Object)invalidObjectIdException);
        }
        catch (CommunicationException communicationException) {
            logger.error((Object)communicationException);
            logger.error("set failed oid={} value={}", (Object)objectId, object, (Object)communicationException);
        }
        return setResult;
    }
}

