/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.servlets.rest;

import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.servlets.rest.RESTServlet;
import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.trustmanagement.CertificateUtils;
import com.apcc.pcns.trustmanagement.UnverifiedCertificateManager;
import com.apcc.pcns.util.DateTimeFormatUtils;
import com.apcc.pcns.util.ResourceBundleWrapper;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.ResourceBundle;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import lombok.NonNull;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class CertificatesREST
extends RESTServlet {
    private static final String SUBJECT = "subject";
    private static final String PUBLIC_KEY = "publicKey";
    private static final String SIGNATURE_ALGORITHM = "signatureAlgorithm";
    private static final String VALID_TO = "validTo";
    private static final String VALID_FROM = "validFrom";
    private static final String SERIAL_NUMBER = "serialNumber";
    private static final String VERSION = "version";
    private static final String ISSUER = "issuer";
    private static final String PUBLIC_KEY_FORMAT = "CfgWizard.CertificateManagementPage.PublicKey";
    private static final String VALID = "valid";
    private static final String EXPIRY_DATE = "expiry";
    private static final String INDEX_PARAM = "index";
    private static final String ALIAS_PARAM = "alias";
    private static final String COMMON_NAME_PARAM = "commonName";
    private static final String ERROR_PARAM = "errors";
    private static final String TRUST_ACTION = "trust";
    private static final String POST_ACTION = "action";
    private static final long serialVersionUID = 5675697792739691731L;
    private static final Logger logger = LogManager.getLogger(CertificatesREST.class);
    private static UnverifiedCertificateManager unverifiedCertificateManager;
    private static DateTimeFormatUtils dateUtils;
    private static CertificateUtils certUtils;

    public CertificatesREST(ServiceManager serviceManager) {
        super(serviceManager);
        unverifiedCertificateManager = serviceManager.getUnverifiedCertificateManager();
        dateUtils = serviceManager.getDateTimeFormatUtils();
        certUtils = serviceManager.getCertificateUtils();
    }

    @Override
    protected synchronized void doGet(PageContext pageContext) throws ServletException, IOException {
        logger.debug("doGet() - start");
        try {
            boolean bl = BooleanUtils.toBoolean((String)StringUtils.trim((String)pageContext.getPostQueryValue("unverified")));
            if (bl) {
                this.getUnverifiedCerts(pageContext);
                return;
            }
            String string = StringUtils.trim((String)pageContext.getPostQueryValue(ALIAS_PARAM));
            String string2 = StringUtils.trim((String)pageContext.getPostQueryValue(ERROR_PARAM));
            if (StringUtils.isNotBlank((CharSequence)string2)) {
                this.handleValidateCertificate(string2, pageContext);
            } else if (StringUtils.isNotBlank((CharSequence)string)) {
                this.handleGetCertByAlias(string, pageContext);
                return;
            }
            this.sendNotImplemented(pageContext);
        }
        catch (IOException iOException) {
            logger.debug("Certificate Rest - error: {}", (Throwable)iOException);
        }
    }

    @Override
    protected synchronized void doPost(PageContext pageContext) throws ServletException, IOException {
        logger.debug("doPost() - start");
        if (this.verifyFormToken(pageContext, false)) {
            String string;
            switch (string = pageContext.getPostQueryValue(POST_ACTION)) {
                case "trust": {
                    this.handleTrustAction(pageContext);
                    break;
                }
                default: {
                    this.sendNotImplemented(pageContext);
                }
            }
        }
    }

    private void handleTrustAction(PageContext pageContext) {
        String string = pageContext.getPostQueryValue(ALIAS_PARAM);
        String string2 = pageContext.getPostQueryValue(INDEX_PARAM);
        int n = 0;
        if (StringUtils.isBlank((CharSequence)string)) {
            this.sendBadRequest(pageContext);
            return;
        }
        String[] stringArray = string2.split(",");
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (String string3 : stringArray) {
            if (!NumberUtils.isParsable((String)string3)) {
                this.sendBadRequest(pageContext);
                return;
            }
            n = NumberUtils.toInt((String)string3);
            if (n < 0) {
                this.sendBadRequest(pageContext);
                return;
            }
            arrayList.add(n);
        }
        for (Integer n2 : arrayList) {
            if (unverifiedCertificateManager.hasCertificate(string, n2)) {
                unverifiedCertificateManager.moveCertToTrustStore(string, n2);
                logger.debug("handleTrustAction() - Cert with Alias {} and index {} were added to trust store", (Object)string, (Object)n);
                continue;
            }
            logger.warn("handleTrustAction: Cert at index {} was not added", (Object)n);
        }
        unverifiedCertificateManager.removeCertificateChainByAlias(string);
    }

    private void handleGetCertByAlias(String string, PageContext pageContext) throws IOException {
        HttpServletResponse httpServletResponse = pageContext.getResponse();
        httpServletResponse.setContentType("application/json");
        JSONArray jSONArray = null;
        List<X509Certificate> list = unverifiedCertificateManager.getCertificateChainByAlias(string);
        ResourceBundleWrapper resourceBundleWrapper = Utils.getWebServerResourceBundle(pageContext.getLocale());
        if (list != null && !list.isEmpty()) {
            jSONArray = this.createCertificateResponse(list, resourceBundleWrapper.getResourceBundle());
            httpServletResponse.setStatus(200);
            httpServletResponse.getWriter().print(jSONArray);
        } else {
            httpServletResponse.setStatus(404);
        }
        httpServletResponse.getWriter().close();
    }

    private void getUnverifiedCerts(PageContext pageContext) throws IOException {
        HttpServletResponse httpServletResponse = pageContext.getResponse();
        httpServletResponse.setContentType("application/json");
        JSONArray jSONArray = new JSONArray();
        unverifiedCertificateManager.getAllCertificateChains().forEach((string, list) -> {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put(ALIAS_PARAM, string);
            jSONObject.put(EXPIRY_DATE, (Object)dateUtils.dateToISOString(certUtils.findExpiryDate((List<X509Certificate>)list)));
            jSONObject.put(VALID, certUtils.verifyCertificateDate((List<X509Certificate>)list));
            jSONArray.put((Object)jSONObject);
        });
        httpServletResponse.getWriter().print(jSONArray);
        httpServletResponse.getWriter().close();
    }

    private JSONArray createCertificateResponse(@NonNull List<X509Certificate> list, @NonNull ResourceBundle resourceBundle) {
        if (list == null) {
            throw new IllegalArgumentException("certificateChain is marked non-null but is null");
        }
        if (resourceBundle == null) {
            throw new IllegalArgumentException("resources is marked non-null but is null");
        }
        ListIterator<X509Certificate> listIterator = list.listIterator();
        JSONArray jSONArray = new JSONArray();
        while (listIterator.hasNext()) {
            X509Certificate x509Certificate = listIterator.next();
            JSONObject jSONObject = this.writeCertDetailsToJSON(x509Certificate, resourceBundle);
            jSONArray.put((Object)jSONObject);
        }
        return jSONArray;
    }

    private JSONObject writeCertDetailsToJSON(@NonNull X509Certificate x509Certificate, @NonNull ResourceBundle resourceBundle) {
        if (x509Certificate == null) {
            throw new IllegalArgumentException("cert is marked non-null but is null");
        }
        if (resourceBundle == null) {
            throw new IllegalArgumentException("resources is marked non-null but is null");
        }
        String string = resourceBundle.getString(PUBLIC_KEY_FORMAT);
        String string2 = MessageFormat.format(string, x509Certificate.getPublicKey().getAlgorithm(), Integer.toString(certUtils.getKeySize(x509Certificate.getPublicKey())));
        JSONObject jSONObject = new JSONObject();
        String string3 = certUtils.getSubjectName(x509Certificate);
        jSONObject.put(SUBJECT, (Object)string3);
        String string4 = certUtils.getIssuerName(x509Certificate);
        jSONObject.put(ISSUER, (Object)string4);
        jSONObject.put(VERSION, x509Certificate.getVersion());
        jSONObject.put(SERIAL_NUMBER, (Object)x509Certificate.getSerialNumber().toString(16));
        jSONObject.put(VALID_FROM, (Object)dateUtils.dateToISOString(x509Certificate.getNotBefore()));
        jSONObject.put(VALID_TO, (Object)dateUtils.dateToISOString(x509Certificate.getNotAfter()));
        jSONObject.put(SIGNATURE_ALGORITHM, (Object)x509Certificate.getSigAlgName());
        jSONObject.put(PUBLIC_KEY, (Object)string2);
        String string5 = certUtils.getCommonName(x509Certificate);
        if (StringUtils.isNotBlank((CharSequence)string5)) {
            jSONObject.put(COMMON_NAME_PARAM, (Object)string5);
        } else {
            jSONObject.put(COMMON_NAME_PARAM, (Object)string3);
        }
        return jSONObject;
    }

    private void handleValidateCertificate(String string2, PageContext pageContext) throws IOException {
        HttpServletResponse httpServletResponse = pageContext.getResponse();
        httpServletResponse.setContentType("application/json");
        if (this.verifyFormToken(pageContext, false)) {
            HashMap<String, HashMap<String, Boolean>> hashMap2 = unverifiedCertificateManager.validateCertificateChain(string2);
            if (hashMap2 != null) {
                JSONObject jSONObject = new JSONObject();
                hashMap2.forEach((string, hashMap) -> jSONObject.put(string, (Object)this.convertValidityResponse((HashMap<String, Boolean>)hashMap)));
                httpServletResponse.setStatus(200);
                httpServletResponse.getWriter().print(jSONObject);
            } else {
                httpServletResponse.setStatus(404);
            }
            httpServletResponse.getWriter().close();
        }
    }

    private JSONObject convertValidityResponse(HashMap<String, Boolean> hashMap) {
        JSONObject jSONObject = new JSONObject();
        hashMap.forEach((string, bl) -> jSONObject.put(string, bl));
        return jSONObject;
    }
}

