/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.servlets.rest;

import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.servlets.rest.RESTServlet;
import com.apcc.m11.components.webserver.util.JREUtils;
import com.apcc.pcns.ServiceManager;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JREUpdateREST
extends RESTServlet {
    private static final long serialVersionUID = -9185406120064579115L;
    private static final Logger logger = LogManager.getLogger(JREUpdateREST.class);

    public JREUpdateREST(ServiceManager serviceManager) {
        super(serviceManager);
    }

    @Override
    protected synchronized void doPost(PageContext pageContext) throws ServletException, IOException {
        logger.debug("doPost");
        HttpServletResponse httpServletResponse = pageContext.getResponse();
        HttpServletRequest httpServletRequest = pageContext.getRequest();
        httpServletResponse.setContentType("application/json");
        String string = httpServletRequest.getParameter("updateJRE");
        if (StringUtils.isNotBlank((CharSequence)string)) {
            JREUtils.applyJREUpdates(string);
        }
        logger.debug("doPost DONE");
    }

    @Override
    protected void doGet(PageContext pageContext) throws ServletException, IOException {
        HttpServletResponse httpServletResponse = pageContext.getResponse();
        httpServletResponse.setContentType("application/json");
        List<File> list = JREUtils.getAvailableJREUpdates();
        if (list.isEmpty()) {
            httpServletResponse.getWriter().print("No JRE Updates\n");
        } else {
            for (File file : list) {
                try {
                    httpServletResponse.getWriter().print(file.getName() + "\n");
                }
                catch (IOException iOException) {
                    logger.warn((Object)iOException);
                }
            }
        }
        httpServletResponse.getWriter().close();
    }
}

