/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.servlets.rest;

import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.servlets.rest.RESTServlet;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.licensing.LicenseDetails;
import java.io.IOException;
import java.util.Optional;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class LicenseDetailsREST
extends RESTServlet {
    private static final long serialVersionUID = 994548214568448515L;
    private static final Logger logger = LogManager.getLogger(LicenseDetailsREST.class);

    public LicenseDetailsREST(ServiceManager serviceManager) {
        super(serviceManager);
    }

    @Override
    protected synchronized void doGet(PageContext pageContext) throws ServletException, IOException {
        logger.debug("doGet() - start");
        try {
            HttpServletResponse httpServletResponse = pageContext.getResponse();
            httpServletResponse.setContentType("application/json");
            Optional<LicenseDetails> optional = this.services.getLicensingManager().getLicense();
            JSONObject jSONObject = new JSONObject();
            this.services.getLicensingManager().init();
            if (optional.isPresent()) {
                LicenseDetails licenseDetails = optional.get();
                jSONObject.put("featureName", (Object)licenseDetails.getFeatureName());
                jSONObject.put("activationDate", (Object)licenseDetails.getActivationDate().toString());
                jSONObject.put("renewalDate", (Object)licenseDetails.getExpiryDate().toString());
                jSONObject.put("activationId", (Object)this.services.getAuthHelper().getLicensingActivationId());
            } else {
                jSONObject.put("featureName", (Object)"");
                jSONObject.put("activationDate", (Object)"");
                jSONObject.put("renewalDate", (Object)"");
                jSONObject.put("activationId", (Object)"");
            }
            httpServletResponse.getWriter().print(jSONObject);
            httpServletResponse.getWriter().close();
        }
        catch (IOException | JSONException throwable) {
            logger.error((Object)throwable);
        }
    }
}

