/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.servlets.rest;

import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.servlets.rest.RESTServlet;
import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.licensing.ActivationMethod;
import com.apcc.pcns.licensing.ILicensingConfigManager;
import com.apcc.pcns.licensing.provider.LicenseProviderOfflineActivation;
import com.apcc.pcns.licensing.provider.LicensingValidationException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Base64;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;

public class LicensingOfflineREST
extends RESTServlet {
    private static final long serialVersionUID = -918540669545862415L;
    private static final String IS_ACTIVATED = "isActivated";
    private static final String FILE = "file";
    private static final long MAX_FILE_SIZE_BYTES = 0x200000L;
    private static final String ACTIVATION_METHOD = "activationMethod";
    private static final String ACTIVATION_ID = "activationId";
    private static final String QUANTITY = "quantity";
    private static final Logger logger = LogManager.getLogger(LicensingOfflineREST.class);

    public LicensingOfflineREST(ServiceManager serviceManager) {
        super(serviceManager);
    }

    @Override
    protected synchronized void doPost(PageContext pageContext) throws ServletException, IOException {
        logger.debug("doPost() - start");
        try {
            if (this.verifyFormToken(pageContext, false)) {
                this.processCapabilityResponse(pageContext);
            } else {
                pageContext.getResponse().sendError(401);
            }
        }
        catch (IOException iOException) {
            logger.error("doPost() - failed to process capability response, error: {}", (Throwable)iOException);
        }
        logger.debug("doPost() - end");
    }

    private void processCapabilityResponse(PageContext pageContext) throws IOException {
        logger.debug("processCapabilityResponse() - start");
        HttpServletRequest httpServletRequest = pageContext.getRequest();
        HttpServletResponse httpServletResponse = pageContext.getResponse();
        String string = httpServletRequest.getParameter(FILE);
        boolean bl = false;
        byte[] byArray = Base64.getDecoder().decode(string);
        JSONObject jSONObject = new JSONObject();
        if ((long)byArray.length < 0x200000L) {
            licensingManager.init();
            try {
                bl = licensingManager.processResponse(byArray);
                jSONObject.put(IS_ACTIVATED, bl);
            }
            catch (LicensingValidationException licensingValidationException) {
                httpServletResponse.setStatus(500);
                jSONObject.put("errorMessage", (Object)licensingValidationException.getMessage());
                jSONObject.put(IS_ACTIVATED, false);
            }
        } else {
            logger.error("processCapabilityResponse() - License file is too big {}", (Object)byArray.length);
            httpServletResponse.setStatus(400);
            String string2 = Utils.getResourceString(Utils.getWebServerResourceBundle(Locale.getDefault()), "Licensing.Exceptions.InvalidResponse");
            jSONObject.put("errorMessage", (Object)string2);
            jSONObject.put(IS_ACTIVATED, false);
        }
        httpServletResponse.getWriter().print(jSONObject);
        httpServletResponse.getWriter().close();
        logger.debug("processCapabilityResponse() - end");
    }

    @Override
    protected synchronized void doGet(PageContext pageContext) throws ServletException, IOException {
        logger.debug("doGet() - start");
        try {
            if (this.verifyFormToken(pageContext, false)) {
                this.createCapabilityRequest(pageContext);
            } else {
                pageContext.getResponse().sendError(401);
            }
        }
        catch (IOException iOException) {
            logger.error("doGet() - failed to create capability request, error: {}", (Throwable)iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createCapabilityRequest(PageContext pageContext) throws IOException {
        logger.debug("createCapabilityRequest() - start");
        HttpServletRequest httpServletRequest = pageContext.getRequest();
        HttpServletResponse httpServletResponse = pageContext.getResponse();
        String string = httpServletRequest.getParameter(ACTIVATION_ID);
        String string2 = httpServletRequest.getParameter(QUANTITY);
        ActivationMethod activationMethod = ActivationMethod.getMethod(httpServletRequest.getParameter(ACTIVATION_METHOD));
        int n = this.services.getLicensingUtils().getQuantityFromParameter(string2);
        ILicensingConfigManager iLicensingConfigManager = this.services.getLicensingConfigManager();
        iLicensingConfigManager.setActivationMethod(activationMethod);
        iLicensingConfigManager.clearProxyDetails();
        iLicensingConfigManager.clearLLSAddress();
        licensingManager.reloadProviders();
        try {
            licensingManager.activateLicense(string, n);
            String string3 = LicenseProviderOfflineActivation.getCapabilityFileName();
            String string4 = LicenseProviderOfflineActivation.getCapabilityFilePath();
            this.sendFile(httpServletRequest, httpServletResponse, string3, string4);
        }
        finally {
            logger.debug("createCapabilityRequest() - end");
        }
    }

    private void sendFile(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, String string2) {
        logger.debug("sendFile() - start, preparing download for {}", (Object)string);
        int n = 1048;
        httpServletResponse.reset();
        String string3 = String.format("attachment; filename=\"%s\"", string);
        httpServletResponse.setHeader("Content-disposition", string3);
        httpServletResponse.setHeader("Download-filename", string);
        httpServletResponse.setContentType("application/x-download");
        try (FileInputStream fileInputStream = new FileInputStream(new File(string2));
             ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();){
            int n2;
            byte[] byArray = new byte[n];
            while ((n2 = fileInputStream.read(byArray)) > 0) {
                servletOutputStream.write(byArray, 0, n2);
            }
            servletOutputStream.flush();
        }
        catch (Exception exception) {
            logger.error("sendFile() - failed to write file to response, error: {}", (Throwable)exception);
            this.sendErrorResponse(httpServletResponse, "failed to write file");
        }
    }

    private void sendErrorResponse(HttpServletResponse httpServletResponse, String string) {
        try {
            logger.debug("sendErrorResponse() - message: {}", (Object)string);
            httpServletResponse.setHeader("errorMessage", string);
            httpServletResponse.sendError(500, string);
        }
        catch (IOException iOException) {
            logger.error("sendErrorResponse() - failed, error: {}", (Object)iOException.getMessage());
        }
    }
}

