/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.servlets.rest;

import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.servlets.rest.RESTServlet;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.configservice.AuthHelper;
import com.apcc.pcns.licensing.ActivationMethod;
import com.apcc.pcns.licensing.ILicensingConfigManager;
import com.apcc.pcns.licensing.ILicensingUtils;
import com.apcc.pcns.licensing.provider.LicenseProvider;
import com.apcc.pcns.licensing.provider.LicensingServerException;
import com.apcc.pcns.licensing.provider.LicensingValidationException;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class LicensingREST
extends RESTServlet {
    private static final long serialVersionUID = -9185406120065862415L;
    private static final String TRIAL_DEPLOYED = "trialDeployed";
    private static final String IS_ACTIVATED = "isActivated";
    private static final String ACTIVATION_METHOD = "activationMethod";
    private static final String ACTIVATION_ID = "activationId";
    private static final String QUANTITY = "quantity";
    private static final String PROXY_ADDRESS = "proxyAddress";
    private static final String PROXY_PORT = "proxyPort";
    private static final String PROXY_USERNAME = "proxyUsername";
    private static final String PROXY_PASSWORD = "proxyPassword";
    private static final Logger logger = LogManager.getLogger(LicensingREST.class);

    public LicensingREST(ServiceManager serviceManager) {
        super(serviceManager);
    }

    @Override
    protected synchronized void doPost(PageContext pageContext) throws ServletException, IOException {
        logger.debug("doPost() - start");
        try {
            if (this.verifyFormToken(pageContext, false)) {
                this.createLicense(pageContext);
            } else {
                pageContext.getResponse().sendError(401);
            }
        }
        catch (IOException iOException) {
            logger.debug("doPost() - unable to create license, error: {}", (Throwable)iOException);
        }
        logger.debug("doPost() - end");
    }

    private void createLicense(PageContext pageContext) {
        try {
            HttpServletRequest httpServletRequest = pageContext.getRequest();
            HttpServletResponse httpServletResponse = pageContext.getResponse();
            httpServletResponse.setContentType("application/json");
            ILicensingConfigManager iLicensingConfigManager = this.services.getLicensingConfigManager();
            ILicensingUtils iLicensingUtils = this.services.getLicensingUtils();
            AuthHelper authHelper = this.services.getAuthHelper();
            ActivationMethod activationMethod = ActivationMethod.getMethod(httpServletRequest.getParameter(ACTIVATION_METHOD));
            String string = httpServletRequest.getParameter(ACTIVATION_ID);
            String string2 = httpServletRequest.getParameter(QUANTITY);
            String string3 = httpServletRequest.getParameter(PROXY_ADDRESS);
            String string4 = httpServletRequest.getParameter(PROXY_PORT);
            int n = iLicensingUtils.getQuantityFromParameter(string2);
            iLicensingConfigManager.setActivationMethod(activationMethod);
            logger.debug("createLicense() - activationMethod: {}", (Object)activationMethod);
            this.updateProxyConfig(httpServletRequest, iLicensingConfigManager, authHelper, string3, string4);
            licensingManager.reloadProviders();
            logger.debug("createLicense() - activationMethod: {}", (Object)activationMethod.getValue());
            this.sendActivatedResponse(httpServletResponse, string, n);
        }
        catch (IOException | JSONException throwable) {
            logger.error((Object)throwable);
        }
    }

    private void updateProxyConfig(HttpServletRequest httpServletRequest, ILicensingConfigManager iLicensingConfigManager, AuthHelper authHelper, String string, String string2) {
        if (StringUtils.isNotBlank((CharSequence)string) && NumberUtils.isCreatable((String)string2)) {
            String string3 = httpServletRequest.getParameter(PROXY_USERNAME);
            String string4 = httpServletRequest.getParameter(PROXY_PASSWORD);
            iLicensingConfigManager.setProxyAddress(string);
            iLicensingConfigManager.setProxyPort(NumberUtils.createInteger((String)string2));
            if (StringUtils.isNotBlank((CharSequence)string3) && StringUtils.isNotBlank((CharSequence)string4)) {
                authHelper.setLicensingProxyUsername(string3);
                authHelper.setLicensingProxyPassword(string4);
            } else if (StringUtils.isBlank((CharSequence)string3) && StringUtils.isBlank((CharSequence)string4)) {
                authHelper.removeLicensingProxyUsername();
                authHelper.removeLicensingProxyPassword();
            }
        } else {
            iLicensingConfigManager.clearProxyDetails();
            authHelper.removeLicensingProxyUsername();
            authHelper.removeLicensingProxyPassword();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendActivatedResponse(HttpServletResponse httpServletResponse, String string, int n) throws IOException {
        JSONObject jSONObject = new JSONObject();
        try {
            Boolean bl = licensingManager.activateLicense(string, n);
            jSONObject.put(IS_ACTIVATED, (Object)bl);
        }
        catch (LicensingServerException | LicensingValidationException runtimeException) {
            jSONObject.put("errorMessage", (Object)runtimeException.getMessage());
            jSONObject.put(IS_ACTIVATED, false);
        }
        finally {
            httpServletResponse.getWriter().print(jSONObject);
            httpServletResponse.getWriter().close();
        }
    }

    @Override
    protected synchronized void doGet(PageContext pageContext) throws ServletException, IOException {
        logger.debug("doGet() - start");
        try {
            HttpServletResponse httpServletResponse = pageContext.getResponse();
            httpServletResponse.setContentType("application/json");
            JSONObject jSONObject = new JSONObject();
            licensingManager.init();
            jSONObject.put(IS_ACTIVATED, licensingManager.isLicensed());
            LicenseProvider licenseProvider = licensingManager.getLicenseProvider();
            boolean bl = licenseProvider.hasAnyTrialLicense() || !licenseProvider.isTrialFileAvailable();
            jSONObject.put(TRIAL_DEPLOYED, bl);
            httpServletResponse.getWriter().print(jSONObject);
            httpServletResponse.getWriter().close();
        }
        catch (IOException | JSONException throwable) {
            logger.error((Object)throwable);
        }
        logger.debug("doGet() - end");
    }

    @Override
    protected void doDelete(PageContext pageContext, boolean bl) throws ServletException, IOException {
        logger.debug("doDelete() - start");
        try {
            if (this.verifyFormToken(pageContext, false) || bl) {
                this.deleteLicense(pageContext);
            } else {
                pageContext.getResponse().sendError(401);
            }
        }
        catch (IOException iOException) {
            logger.debug("doDelete() - failed to return license, error: {}", (Throwable)iOException);
        }
        logger.debug("doDelete() - end");
    }

    private void deleteLicense(PageContext pageContext) {
        try {
            HttpServletResponse httpServletResponse = pageContext.getResponse();
            httpServletResponse.setContentType("application/json");
            licensingManager.init();
            JSONObject jSONObject = new JSONObject();
            this.returnLicense(jSONObject, httpServletResponse);
            httpServletResponse.getWriter().print(jSONObject);
            httpServletResponse.getWriter().close();
        }
        catch (IOException iOException) {
            logger.error("deleteLicense() - failed to delete license, error: {}", (Throwable)iOException);
        }
    }

    private void returnLicense(JSONObject jSONObject, HttpServletResponse httpServletResponse) {
        try {
            licensingManager.returnLicense();
        }
        catch (LicensingServerException licensingServerException) {
            jSONObject.put("errorMessage", (Object)licensingServerException.getMessage());
            httpServletResponse.setStatus(409);
        }
    }
}

