/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.servlets.rest;

import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.servlets.rest.RESTServlet;
import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.util.ResourceBundleWrapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;

public class LogBundleREST
extends RESTServlet {
    private static final long serialVersionUID = 181377335070233798L;
    private static final Logger logger = LogManager.getLogger(LogBundleREST.class);

    public LogBundleREST(ServiceManager serviceManager) {
        super(serviceManager);
    }

    @Override
    protected synchronized void doGet(PageContext pageContext) throws ServletException, IOException {
        logger.debug("doGet() - start");
        try {
            if (this.isAuthorized(pageContext, false)) {
                this.createLogBundleResponse(pageContext);
            } else {
                pageContext.getResponse().sendError(401);
            }
        }
        catch (IOException | ServletException throwable) {
            logger.error("doGet() - failed to create log bundle response, error: {}", throwable);
        }
    }

    private void sendFile(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, File file) throws IOException {
        String string = file.getName();
        String string2 = file.getPath();
        logger.debug("sendFile() - start, preparing download for {}", (Object)string);
        int n = 1048;
        httpServletResponse.reset();
        String string3 = String.format("attachment; filename=\"%s\"", string);
        httpServletResponse.setHeader("Content-disposition", string3);
        httpServletResponse.setHeader("Download-filename", string);
        httpServletResponse.setContentType("application/x-download");
        try (FileInputStream fileInputStream = new FileInputStream(new File(string2));
             ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();){
            int n2;
            byte[] byArray = new byte[n];
            while ((n2 = fileInputStream.read(byArray)) > 0) {
                servletOutputStream.write(byArray, 0, n2);
            }
            servletOutputStream.flush();
        }
        catch (Exception exception) {
            logger.error("sendFile() - failed to write file to response, error: {}", (Throwable)exception);
            httpServletResponse.setStatus(500);
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("errorMessage", (Object)"failed to write file");
            httpServletResponse.getWriter().print(jSONObject);
            httpServletResponse.getWriter().close();
        }
        httpServletResponse.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createLogBundleResponse(PageContext pageContext) {
        logger.trace("createLogBundleResponse() - start");
        File file = null;
        try {
            file = this.services.getLogBundleUtils().getLogBundle();
        }
        catch (IOException iOException) {
            logger.error("sendFile() - failed to retrieve log bundle, error: {}", (Throwable)iOException);
            ResourceBundleWrapper resourceBundleWrapper = Utils.getWebServerResourceBundle(pageContext.getLocale());
            String string = Utils.getResourceString(resourceBundleWrapper, "LogBundle.Error.CreateFail");
            this.sendErrorResponse(pageContext.getResponse(), string);
        }
        catch (Exception exception) {
            logger.error("sendFile() - failed to retrieve log bundle, error: {}", (Throwable)exception);
            ResourceBundleWrapper resourceBundleWrapper = Utils.getWebServerResourceBundle(pageContext.getLocale());
            String string = Utils.getResourceString(resourceBundleWrapper, "LogBundle.Error.Error");
            this.sendErrorResponse(pageContext.getResponse(), string);
        }
        try {
            this.sendFile(pageContext.getRequest(), pageContext.getResponse(), file);
        }
        catch (IOException iOException) {
            logger.error("createLogBundleResponse() - failed to write response, error: {}", (Object)iOException.getMessage());
        }
        finally {
            logger.trace("createLogBundleResponse() - end");
        }
    }

    @Override
    protected void doDelete(PageContext pageContext, boolean bl) throws ServletException, IOException {
        logger.trace("doDelete() - start");
        try {
            if (this.isAuthorized(pageContext, false)) {
                this.deleteLogBundle(pageContext);
            } else {
                pageContext.getResponse().sendError(401);
            }
        }
        catch (IOException | ServletException throwable) {
            logger.debug("doDelete() - failed to delete log bundle, error: {}", throwable);
        }
        logger.trace("doDelete() - end");
    }

    private void deleteLogBundle(PageContext pageContext) {
        HttpServletResponse httpServletResponse = pageContext.getResponse();
        httpServletResponse.setContentType("application/json");
        JSONObject jSONObject = new JSONObject();
        try {
            this.services.getLogBundleUtils().deleteLogBundle();
        }
        catch (IOException iOException) {
            logger.error("deleteLogBundle() - failed to delete log bundle, error: {}", (Object)iOException.getMessage());
            ResourceBundleWrapper resourceBundleWrapper = Utils.getWebServerResourceBundle(pageContext.getLocale());
            String string = Utils.getResourceString(resourceBundleWrapper, "LogBundle.Error.DeleteError");
            jSONObject.put("errorMessage", (Object)string);
            httpServletResponse.setStatus(500);
        }
        try {
            httpServletResponse.getWriter().print(jSONObject);
            httpServletResponse.getWriter().close();
        }
        catch (IOException iOException) {
            logger.error("deleteLicense() - failed to write response, error: {}", (Throwable)iOException);
        }
    }

    private void sendErrorResponse(HttpServletResponse httpServletResponse, String string) {
        try {
            logger.debug("sendErrorResponse() - message: {}", (Object)string);
            httpServletResponse.setHeader("errorMessage", string);
            httpServletResponse.sendError(500, string);
        }
        catch (IOException iOException) {
            logger.error("sendErrorResponse() - failed, error: {}", (Object)iOException.getMessage());
        }
    }
}

