/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.servlets.rest;

import com.apcc.m11.arch.IFormatter;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.components.psaggregator.rules.advanced.AdvancedGroupEvent;
import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.servlets.rest.RESTFormatter;
import com.apcc.m11.components.webserver.servlets.rest.RESTServlet;
import com.apcc.m11.ds.events.flexevents.RESTEvents;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.configservice.configurationmanagers.ConfigurationManager;
import com.apcc.pcns.util.CountdownTimer;
import com.github.cliftonlabs.json_simple.Jsoner;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import org.apache.commons.configuration2.ex.ConversionException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RESTRemoteShutdownEvent
extends RESTServlet {
    private static final String ADVANCED_GROUP_PARAM = "advancedGroup";
    private static final String REASON_PARAM = "reason";
    private static final String SOURCE_PARAM = "source";
    private static final String ACTIVE_PARAM = "active";
    private static final Logger logger = LogManager.getLogger(RESTRemoteShutdownEvent.class);
    private static Map<Integer, String> activeEvents;
    private String source;
    private String reason;
    private Boolean active;
    private Integer group;
    private String sourceAddress;
    private String groupName;

    public RESTRemoteShutdownEvent(ServiceManager serviceManager) {
        super(serviceManager);
        activeEvents = new HashMap<Integer, String>();
    }

    public static String getActiveEventName(int n) {
        return activeEvents.get(n);
    }

    private void parseParameters(PageContext pageContext) {
        this.sourceAddress = pageContext.getRequest().getRemoteAddr();
        this.active = null;
        if (StringUtils.isNotEmpty((CharSequence)pageContext.getPostQueryValue(ACTIVE_PARAM))) {
            this.active = Boolean.parseBoolean(StringUtils.trim((String)pageContext.getPostQueryValue(ACTIVE_PARAM)));
        }
        this.source = StringEscapeUtils.escapeHtml4((String)StringUtils.trim((String)pageContext.getPostQueryValue(SOURCE_PARAM)));
        this.reason = StringEscapeUtils.escapeHtml4((String)StringUtils.trim((String)pageContext.getPostQueryValue(REASON_PARAM)));
        this.group = null;
        if (StringUtils.isNotEmpty((CharSequence)pageContext.getPostQueryValue(ADVANCED_GROUP_PARAM))) {
            try {
                this.group = Integer.parseInt(StringUtils.trim((String)pageContext.getPostQueryValue(ADVANCED_GROUP_PARAM)));
            }
            catch (NumberFormatException numberFormatException) {
                this.group = null;
            }
        }
    }

    private boolean validParams(boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = this.source != null && this.reason != null && this.active != null;
        if (bl) {
            bl2 = bl2 && this.group != null;
        }
        return bl2;
    }

    @Override
    protected synchronized void doPost(PageContext pageContext) throws ServletException, IOException {
        logger.debug("doPost");
        String string = "error";
        pageContext.getResponse().setContentType("application/json");
        try {
            this.parseParameters(pageContext);
            ConfigurationManager configurationManager = ServiceManager.getInstance().getConfigurationManager();
            boolean bl = configurationManager.containsKey("advanced_ups_setup_0", "setup_name");
            if (!this.validParams(bl)) {
                string = Jsoner.serialize((Object)"Invalid Parameters");
                pageContext.getOutputWriter().print(string);
                return;
            }
            this.groupName = null;
            if (this.group != null) {
                this.groupName = configurationManager.getString("advanced_ups_setup_" + this.group, "setup_name");
                if (this.groupName == null) {
                    string = Jsoner.serialize((Object)"Invalid Advanced Group");
                    pageContext.getOutputWriter().print(string);
                    return;
                }
            }
            Object[] objectArray = new Object[]{this.sourceAddress, this.reason, this.source};
            Integer n = this.group != null ? this.group : 0;
            if (this.active.booleanValue()) {
                if (activeEvents.get(n) == null) {
                    logger.debug("send the critical event");
                    Object object = null;
                    activeEvents.put(n, this.reason);
                    object = this.group == null ? new Event(RESTEvents.RemoteShutdownEvent.getObjectId(), true, (IFormatter)new RESTFormatter("REST.RemoteShutdownEvent", objectArray)) : new AdvancedGroupEvent(RESTEvents.RemoteShutdownEvent.getObjectId(), true, (IFormatter)new RESTFormatter("REST.RemoteShutdownEvent", objectArray), this.group, this.groupName);
                    RESTServlet.getEventProducer().postEvent((Event)object);
                    string = Jsoner.serialize((Object)"Event set");
                } else {
                    string = Jsoner.serialize((Object)"Already Set");
                }
            } else if (activeEvents.get(n) != null) {
                Object object = null;
                object = this.group == null ? new Event(RESTEvents.RemoteShutdownEvent.getObjectId(), false, (IFormatter)new RESTFormatter("REST.RemoteShutdownEvent", objectArray)) : new AdvancedGroupEvent(RESTEvents.RemoteShutdownEvent.getObjectId(), false, (IFormatter)new RESTFormatter("REST.RemoteShutdownEvent", objectArray), this.group, this.groupName);
                RESTServlet.getEventProducer().postEvent((Event)object);
                object = this.group == null ? new Event(RESTEvents.RemoteShutdownEventResolved.getObjectId(), true, (IFormatter)new RESTFormatter("REST.RemoteShutdownEventResolved", objectArray)) : new AdvancedGroupEvent(RESTEvents.RemoteShutdownEventResolved.getObjectId(), true, (IFormatter)new RESTFormatter("REST.RemoteShutdownEventResolved", objectArray), this.group, this.groupName);
                RESTServlet.getEventProducer().postEvent((Event)object);
                new CountdownTimer(300L, TimeUnit.MILLISECONDS).sleep();
                activeEvents.put(n, null);
                string = Jsoner.serialize((Object)"Event Resolved");
            } else {
                string = Jsoner.serialize((Object)"No Active Event");
            }
        }
        catch (ConversionException conversionException) {
            string = Jsoner.serialize((Object)"Invalid Parameters");
        }
        pageContext.getOutputWriter().print(string);
    }
}

