/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.servlets.rest;

import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.servlets.Login;
import com.apcc.m11.components.webserver.servlets.M11Servlet;
import com.apcc.m11.util.Base64;
import com.apcc.pcns.ServiceManager;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class RESTServlet
extends M11Servlet {
    private static final String AUTHORIZATION_HEADER = "Authorization";
    protected static final String APPLICATION_JSON = "application/json";
    private static final Logger logger = LogManager.getLogger(RESTServlet.class);
    private static final long serialVersionUID = 1L;

    public RESTServlet(ServiceManager serviceManager) {
        super(serviceManager);
    }

    @Override
    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string;
        Locale locale = this.getCurrentLocale(httpServletRequest);
        this.initRequest(httpServletRequest, httpServletResponse, locale);
        HttpSession httpSession = httpServletRequest.getSession(true);
        PrintWriter printWriter = httpServletResponse.getWriter();
        PageContext pageContext = new PageContext(locale, printWriter, RESTServlet.getDataSource(), httpSession, httpServletRequest, httpServletResponse);
        String string2 = "";
        try {
            string2 = httpServletRequest.getRemoteAddr();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (Login.isLockedOut(string2)) {
            pageContext.getResponse().sendError(403);
        }
        if ((string = httpServletRequest.getHeader(AUTHORIZATION_HEADER)) != null && string.startsWith("Basic")) {
            String string3 = string.substring("Basic".length()).trim();
            String string4 = new String(Base64.decode((char[])string3.toCharArray()), StandardCharsets.UTF_8);
            String[] stringArray = string4.split(":", 2);
            String string5 = stringArray[0];
            if (!this.services.getAuthHelper().checkCredentials(string5, stringArray[1])) {
                this.services.getVirtualLoggingUtils().logLoginFailure(string5, string2);
                Login.countUpLockOut(string2);
                this.sendUnauthorized(pageContext);
            } else {
                this.doGet(pageContext);
            }
        } else if (httpSession != null && this.isLoginActiveBySession(httpSession.getId())) {
            this.doGet(pageContext);
        } else {
            this.sendUnauthorized(pageContext);
        }
        printWriter.close();
    }

    @Override
    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string;
        Locale locale = this.getCurrentLocale(httpServletRequest);
        this.initRequest(httpServletRequest, httpServletResponse, locale);
        HttpSession httpSession = httpServletRequest.getSession(true);
        PrintWriter printWriter = httpServletResponse.getWriter();
        PageContext pageContext = new PageContext(locale, printWriter, RESTServlet.getDataSource(), httpSession, httpServletRequest, httpServletResponse);
        String string2 = "";
        try {
            string2 = httpServletRequest.getRemoteAddr();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (Login.isLockedOut(string2)) {
            pageContext.getResponse().sendError(403);
        }
        if ((string = httpServletRequest.getHeader(AUTHORIZATION_HEADER)) != null && string.startsWith("Basic")) {
            String string3 = string.substring("Basic".length()).trim();
            String string4 = new String(Base64.decode((char[])string3.toCharArray()), StandardCharsets.UTF_8);
            String[] stringArray = string4.split(":", 2);
            String string5 = stringArray[0];
            if (!this.services.getAuthHelper().checkCredentials(string5, stringArray[1])) {
                this.services.getVirtualLoggingUtils().logLoginFailure(string5, string2);
                Login.countUpLockOut(string2);
                this.sendUnauthorized(pageContext);
            } else {
                this.doPost(pageContext);
            }
        } else if (httpSession != null && this.isLoginActiveBySession(httpSession.getId())) {
            this.doPost(pageContext);
        } else {
            this.sendUnauthorized(pageContext);
        }
        printWriter.close();
    }

    @Override
    protected void doDelete(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        try {
            String string;
            Locale locale = this.getCurrentLocale(httpServletRequest);
            this.initRequest(httpServletRequest, httpServletResponse, locale);
            HttpSession httpSession = httpServletRequest.getSession(true);
            PrintWriter printWriter = httpServletResponse.getWriter();
            PageContext pageContext = new PageContext(locale, printWriter, RESTServlet.getDataSource(), httpSession, httpServletRequest, httpServletResponse);
            String string2 = "";
            string2 = httpServletRequest.getRemoteAddr();
            if (Login.isLockedOut(string2)) {
                pageContext.getResponse().sendError(403);
            }
            if ((string = httpServletRequest.getHeader(AUTHORIZATION_HEADER)) != null && string.startsWith("Basic")) {
                String string3 = string.substring("Basic".length()).trim();
                String string4 = new String(Base64.decode((char[])string3.toCharArray()), StandardCharsets.UTF_8);
                String[] stringArray = string4.split(":", 2);
                String string5 = stringArray[0];
                if (!this.services.getAuthHelper().checkCredentials(string5, stringArray[1])) {
                    this.services.getVirtualLoggingUtils().logLoginFailure(string5, string2);
                    Login.countUpLockOut(string2);
                    this.sendUnauthorized(pageContext);
                } else {
                    this.doDelete(pageContext, true);
                }
            } else if (httpSession != null && this.isLoginActiveBySession(httpSession.getId())) {
                this.doDelete(pageContext, false);
            } else {
                this.sendUnauthorized(pageContext);
            }
            printWriter.close();
        }
        catch (Exception exception) {
            logger.error((Object)exception);
        }
    }

    protected void sendUnauthorized(PageContext pageContext) {
        try {
            pageContext.getResponse().sendError(401);
        }
        catch (IOException iOException) {
            logger.error((Object)iOException);
        }
    }

    protected boolean isAuthorized(PageContext pageContext, boolean bl) throws ServletException {
        logger.trace("isAuthorized() - start");
        if (this.verifyFormToken(pageContext, bl)) {
            logger.trace("isAuthorized() - valid form token, authorized");
            return true;
        }
        HttpServletRequest httpServletRequest = pageContext.getRequest();
        String string = httpServletRequest.getHeader(AUTHORIZATION_HEADER);
        if (string != null && string.startsWith("Basic")) {
            String string2 = string.substring("Basic".length()).trim();
            String string3 = new String(Base64.decode((char[])string2.toCharArray()), StandardCharsets.UTF_8);
            String[] stringArray = string3.split(":", 2);
            String string4 = stringArray[0];
            if (!this.services.getAuthHelper().checkCredentials(string4, stringArray[1])) {
                String string5 = "";
                string5 = httpServletRequest.getRemoteAddr();
                this.services.getVirtualLoggingUtils().logLoginFailure(string4, string5);
                Login.countUpLockOut(string5);
                logger.debug("isAuthorized() - invalid basic auth credentials, not authorized");
                return false;
            }
            logger.trace("isAuthorized() - valid basic auth credentials, authorized");
            return true;
        }
        logger.debug("isAuthorized() - no valid form token or basic auth credentials, not authorized");
        return false;
    }
}

