/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.util;

import com.apcc.m11.components.webserver.html.Container;
import com.apcc.m11.components.webserver.html.HTML;
import com.apcc.m11.components.webserver.html.HTMLTagWithClassStyle;
import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.html.Text;
import com.apcc.m11.components.webserver.html.document.Division;
import com.apcc.m11.components.webserver.html.document.Heading;
import com.apcc.m11.components.webserver.html.document.Span;
import com.apcc.m11.components.webserver.html.form.Option;
import com.apcc.m11.components.webserver.html.util.Image;
import com.apcc.m11.components.webserver.model.NMC;
import com.apcc.m11.components.webserver.model.UPSSetup;
import com.apcc.m11.components.webserver.util.FormHelper;
import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.util.HostNameLookUpTable;
import com.apcc.pcns.util.ResourceBundleWrapper;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AdvancedSetupHTMLHelper {
    private static final Logger logger = LogManager.getLogger(AdvancedSetupHTMLHelper.class);
    private static final String kErrorContainer = "AdvancedShutdown.ErrorContainer";
    private static final String kNumUPSRequired = "AdvancedShutdown.NumUPSRequiredLabel";
    private static final String kNumUPSRedundant = "AdvancedShutdown.NumUPSRedundantLabel";
    private static final String kNumUPSTotal = "AdvancedShutdown.NumUPSTotalLabel";
    private static final String kRunCommandLabel = "AdvancedShutdown.RunCommandLabel";
    private static final String kShutdownOnRedundancyLostLabel = "AdvancedShutdown.ShutdownOnRedundancyLostLabel";
    private static final String kCommandFileLabel = "AdvancedShutdown.CommandFileLabel";
    private static final String kCommandDuration = "AdvancedShutdown.CommandDurationLabel";
    private static final String kCommandDurationNote = "AdvancedShutdown.CommandDurationNote";
    private static final String kExecuteCommandFileAfterHostShutdown = "Shutdown.ExecuteCommandFileAfterHostShutdown";
    private static final String kCommandDelayLabel = "Shutdown.CommandDelayLabel";
    private static final String kUPSShutdownLabel = "Shutdown.UPSShutdownHeader";
    private static final String kInvalidCommandFile = "Shutdown.InvalidCommandFile";
    private static final String kSeconds = "PCNS.SecondsUnitLabel";
    private static final String kRequiredField = "PCNS.RequiredField";
    private static final String kRangeValidation = "PCNS.RangeValidation";
    private static final String kTurnOffTheSOGId = "Shutdown.TurnOffTheSOG";
    private static final String kTurnOffTheUPSId = "Shutdown.TurnOffTheUPS";
    private static final String kTurnOffNoneId = "Shutdown.TurnOffNone";
    private static final String kShutdownLocalMachineLabel = "AdvancedShutdown.ShutdownLocalMachineLabel";
    private static final String kShutdownVirtualHostsLabel = "AdvancedShutdown.ShutdownVirtualHostsLabel";
    private static final String kShutdownVirtualHostsTooltip = "AdvancedShutdown.ShutdownVirtualHostsTooltip";
    private static final String kShutdownLocalMachineTooltip = "AdvancedShutdown.ShutdownLocalMachineTooltip";
    private static final String kShutdownWarning = "AdvancedShutdown.ShutdownWarning";
    public static final String PARAM_UPS_REQUIRED = "upsRequired";
    public static final String PARAM_CMDFILE_ENABLED = "cmdFileEnabled";
    public static final String PARAM_CMDFILE_PATH = "cmdFilePath";
    public static final String PARAM_SHUTDOWN_LOCALMACHINE = "shutdownLocalMachine";
    public static final String PARAM_SHUTDOWN_ON_REDUNDANCY_LOST = "shutdownRedundancyLost";
    public static final String PARAM_CMDFILE_DURATION = "cmdFileDuration";
    public static final String PARAM_CMDFILE_DELAY = "cmdFileDelay";
    public static final String PARAM_EXECUTE_COMMAND_FILE_AFTER_HOST_SHUTDOWN = "executeCommandFileAfterHostShutdown";
    public static final String PARAM_SHUTDOWN_VIRTUAL_HOSTS = "shutdownVirtualHosts";
    public static final String theTurnOffTheUPSName = "TurnOffUPS";
    public static final String theTurnOffTheSOGName = "TurnOffSOG";
    public static final String theTurnOffNoneName = "TurnOffNone";
    public static final String PARAM_TURNOFF = "TurnOff";
    private Map<String, String> resMap = new HashMap<String, String>();
    private ServiceManager services;

    public AdvancedSetupHTMLHelper(Locale locale, @NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        this.getConfigureGroupShutdownResourceStrings(locale);
        this.services = serviceManager;
    }

    private void createShutdownPCNSWarning(Container container, int n) {
        Division division = new Division();
        division.setId("pcnsWarning_" + n);
        Image image = new Image("/images/exclamation.gif");
        image.setCssClass("warningImg");
        division.add(image);
        division.add(new Text(this.resMap.get(kShutdownWarning)));
        division.setCssClass("pcnsWarning treemsg ui-state-default ui-corner-all");
        container.add(division);
    }

    public void createConfigureGroupShutdownHTML(PageContext pageContext, Container container, List<UPSSetup> list) {
        Division division = new Division();
        container.add(division);
        division.setId("errorcontainer");
        division.setCssClass("ui-state-error ui-corner-all");
        division.add(new Text(this.resMap.get(kErrorContainer)));
        Division division2 = new Division();
        container.add(division2);
        division2.setId("maindiv");
        division2.setCssClass("formdiv");
        int n = 0;
        String string = "UPSSetupGroup";
        String string2 = "UPSSetupSingle";
        for (UPSSetup uPSSetup : list) {
            Heading heading = new Heading(3);
            division2.add(heading);
            Span span = new Span();
            String string3 = uPSSetup.getTotalNumberOfUPS() > 1 ? string : string2;
            span.setCssClass(string3);
            heading.add(span);
            heading.add(new Text(uPSSetup.getNameEsc()));
            division2.add(this.createGroupShutdownDiv(pageContext, uPSSetup, n));
            ++n;
        }
        container.add(this.createResourceStrings());
    }

    public HTML createGroupShutdownDiv(PageContext pageContext, UPSSetup uPSSetup, int n) {
        Object object;
        Object object2;
        Object object3;
        boolean bl = uPSSetup.getTotalNumberOfUPS() <= 1;
        boolean bl2 = this.services.getVirtualConfigurationManager().isManagedHost();
        boolean bl3 = this.services.getVirtualConfigurationManager().isESXi();
        boolean bl4 = this.services.getVirtualConfigurationManager().isHyperV();
        boolean bl5 = this.services.getVirtualConfigurationManager().isNutanixAHV();
        boolean bl6 = bl2 || bl5;
        Division division = new Division();
        if (bl6 || !bl3 && !bl4) {
            this.createShutdownPCNSWarning(division, n);
        }
        Vector<Option> vector = new Vector<Option>();
        for (int i = 1; i <= uPSSetup.getTotalNumberOfUPS(); ++i) {
            vector.add(new Option(String.valueOf(i)));
        }
        Division division2 = FormHelper.createLabelSelectValueDiv(null, this.resMap.get(kNumUPSRequired), Integer.toString(uPSSetup.getUpsRequiredForLoad()), "upsRequired_" + n, PARAM_UPS_REQUIRED, vector);
        division.add(division2);
        division2.setCssClass("upsRequiredDiv labelvaluediv");
        if (bl) {
            division2.setCssClass("hidden labelvaluediv");
        } else {
            object3 = FormHelper.createLabelValueDiv(null, this.resMap.get(kNumUPSRedundant), Integer.toString(uPSSetup.getNumberOfRedundantUPS()), null);
            division.add((HTML)object3);
            ((HTMLTagWithClassStyle)object3).setCssClass("upsRedundantDiv labelvaluediv");
        }
        if (bl && !uPSSetup.getNMCList().isEmpty()) {
            object3 = null;
            object2 = null;
            object = uPSSetup.getNMCList().get(0);
            try {
                object3 = InetAddress.getByName((String)object);
            }
            catch (UnknownHostException unknownHostException) {
                logger.debug((Object)unknownHostException);
            }
            if (object3 != null && (object2 = HostNameLookUpTable.getInstance().lookUp((InetAddress)object3)) != null && !((String)object).equalsIgnoreCase((String)object2)) {
                object = (String)object + " - " + (String)object2;
            }
            Division division3 = new Division();
            division.add(division3);
            division3.setCssClass("singleip");
            division3.add(new Text((String)object));
        } else {
            object3 = FormHelper.createLabelValueDiv(null, this.resMap.get(kNumUPSTotal), Integer.toString(uPSSetup.getTotalNumberOfUPS()), null);
            division.add((HTML)object3);
            ((HTMLTagWithClassStyle)object3).setCssClass("upsTotalDiv labelvaluediv");
        }
        object3 = FormHelper.createLabelCheckboxValueDiv(null, this.resMap.get(kRunCommandLabel), uPSSetup.getCmdFileEnabled(), null, "cmdFileEnabled_" + n, "cmdFileCheckbox", null);
        ((HTMLTagWithClassStyle)object3).setCssClass("cmdFileCheckboxDiv labelvaluediv");
        division.add((HTML)object3);
        division.add(FormHelper.createLabelTextInputValueDiv(null, this.resMap.get(kCommandFileLabel), uPSSetup.getCmdFilePath(), null, "cmdFilePath_" + n, "cmdfilepath", 256, 32, null));
        division.add(FormHelper.createLabelTextInputValueDiv(null, this.resMap.get(kCommandDuration), Integer.toString(uPSSetup.getCmdFileDuration()), null, "cmdFileDuration_" + n, "cmdfileduration", 6, null, this.resMap.get(kSeconds), false, this.resMap.get(kCommandDurationNote)));
        if (this.services.getVirtualConfigurationManager().isExecuteCommandFileAfterHostShutdownSupported()) {
            object2 = new Division();
            division.add((HTML)object2);
            ((HTMLTagWithClassStyle)object2).setCssClass("cmfFileDelayDiv");
            ((Container)object2).add(FormHelper.createLabelCheckboxValueDiv(null, this.resMap.get(kExecuteCommandFileAfterHostShutdown), uPSSetup.isExecuteCommandFileAfterHostShutdown(), null, "executeCommandFileAfterHostShutdown_" + n, "cmdFileDelayCheckbox", null));
            ((Container)object2).add(FormHelper.createLabelTextInputValueDiv(null, this.resMap.get(kCommandDelayLabel), Integer.toString(uPSSetup.getCmdFileDelay()), null, "cmdFileDelay_" + n, "cmdfiledelay", 6, null, this.resMap.get(kSeconds)));
        }
        if (bl6 || !bl3 && !bl4) {
            object2 = null;
            object = null;
            if (bl6) {
                object2 = this.resMap.get(kShutdownLocalMachineTooltip);
                object = this.resMap.get(kShutdownVirtualHostsTooltip);
            }
            boolean bl7 = this.services.getVirtualConfigurationManager().isConfigWizardComplete();
            boolean bl8 = uPSSetup.getLocalMachineShutdownEnabled();
            if (!bl7 && uPSSetup.getHosts().isEmpty()) {
                bl8 = true;
            }
            division.add(FormHelper.createLabelCheckboxValueDiv(null, this.resMap.get(kShutdownLocalMachineLabel), bl8, null, "shutdownLocalMachine_" + n, "shutdownLocalMachineCheckbox", (String)object2));
            if (bl6) {
                String string = "shutdownVirtualHostsCheckbox";
                boolean bl9 = uPSSetup.isVirtualHostsShutdownEnabled();
                if (uPSSetup.getHosts().isEmpty()) {
                    string = "shutdownVirtualHostsCheckbox physical";
                    if (!bl7) {
                        bl9 = true;
                    }
                }
                Division division4 = FormHelper.createLabelCheckboxValueDiv(null, this.resMap.get(kShutdownVirtualHostsLabel), bl9, null, "shutdownVirtualHosts_" + n, string, (String)object);
                division4.setCssClass("shutdownVirtualHostsCheckboxDiv labelvaluediv");
                division.add(division4);
            }
        }
        object2 = FormHelper.createLabelCheckboxValueDiv(null, this.resMap.get(kShutdownOnRedundancyLostLabel), uPSSetup.getRedundancyLostShutdownEnabled(), null, "shutdownRedundancyLost_" + n);
        ((HTMLTagWithClassStyle)object2).setCssClass("redundancyLostDiv labelvaluediv");
        division.add((HTML)object2);
        if (bl) {
            ((HTMLTagWithClassStyle)object2).setCssClass("hidden labelvaluediv");
        }
        division.add(this.createUPSSetupTurnOff(n, pageContext, uPSSetup));
        return division;
    }

    public HTML createResourceStrings() {
        Division division = new Division();
        division.setId("jsres");
        Span span = new Span(this.resMap.get(kRequiredField));
        span.setId("resRequiredFieldValidation");
        division.add(span);
        span = new Span(this.resMap.get(kRangeValidation));
        span.setId("resRangeValidation");
        division.add(span);
        span = new Span(this.resMap.get(kInvalidCommandFile));
        span.setId("resInvalidCommandFileValidation");
        division.add(span);
        return division;
    }

    private void getConfigureGroupShutdownResourceStrings(Locale locale) {
        ResourceBundleWrapper resourceBundleWrapper = Utils.getWebServerResourceBundle(locale);
        this.resMap.put(kErrorContainer, Utils.getResourceString(resourceBundleWrapper, kErrorContainer));
        this.resMap.put(kNumUPSRequired, Utils.getResourceString(resourceBundleWrapper, kNumUPSRequired));
        this.resMap.put(kNumUPSRedundant, Utils.getResourceString(resourceBundleWrapper, kNumUPSRedundant));
        this.resMap.put(kNumUPSTotal, Utils.getResourceString(resourceBundleWrapper, kNumUPSTotal));
        this.resMap.put(kRunCommandLabel, Utils.getResourceString(resourceBundleWrapper, kRunCommandLabel));
        this.resMap.put(kCommandFileLabel, Utils.getResourceString(resourceBundleWrapper, kCommandFileLabel));
        this.resMap.put(kCommandDuration, Utils.getResourceString(resourceBundleWrapper, kCommandDuration));
        this.resMap.put(kExecuteCommandFileAfterHostShutdown, Utils.getResourceString(resourceBundleWrapper, kExecuteCommandFileAfterHostShutdown));
        this.resMap.put(kCommandDelayLabel, Utils.getResourceString(resourceBundleWrapper, kCommandDelayLabel));
        this.resMap.put(kInvalidCommandFile, Utils.getResourceString(resourceBundleWrapper, kInvalidCommandFile));
        this.resMap.put(kShutdownOnRedundancyLostLabel, Utils.getResourceString(resourceBundleWrapper, kShutdownOnRedundancyLostLabel));
        this.resMap.put(kSeconds, Utils.getResourceString(resourceBundleWrapper, kSeconds));
        this.resMap.put(kRequiredField, Utils.getResourceString(resourceBundleWrapper, kRequiredField));
        this.resMap.put(kRangeValidation, Utils.getResourceString(resourceBundleWrapper, kRangeValidation));
        this.resMap.put(kUPSShutdownLabel, Utils.getResourceString(resourceBundleWrapper, kUPSShutdownLabel));
        this.resMap.put(kTurnOffTheSOGId, Utils.getResourceString(resourceBundleWrapper, kTurnOffTheSOGId));
        this.resMap.put(kTurnOffTheUPSId, Utils.getResourceString(resourceBundleWrapper, kTurnOffTheUPSId));
        this.resMap.put(kTurnOffNoneId, Utils.getResourceString(resourceBundleWrapper, kTurnOffNoneId));
        this.resMap.put(kCommandDurationNote, Utils.getResourceString(resourceBundleWrapper, kCommandDurationNote));
        this.resMap.put(kShutdownLocalMachineLabel, Utils.getResourceString(resourceBundleWrapper, kShutdownLocalMachineLabel));
        this.resMap.put(kShutdownLocalMachineTooltip, Utils.getResourceString(resourceBundleWrapper, kShutdownLocalMachineTooltip));
        this.resMap.put(kShutdownVirtualHostsLabel, Utils.getResourceString(resourceBundleWrapper, kShutdownVirtualHostsLabel));
        this.resMap.put(kShutdownVirtualHostsTooltip, Utils.getResourceString(resourceBundleWrapper, kShutdownVirtualHostsTooltip));
        this.resMap.put(kShutdownWarning, Utils.getResourceString(resourceBundleWrapper, kShutdownWarning));
    }

    public Division createUPSSetupTurnOff(int n, PageContext pageContext, UPSSetup uPSSetup) {
        Division division = new Division();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (uPSSetup.getTurnOffUps().booleanValue()) {
            bl2 = true;
        } else if (uPSSetup.getTurnOffSOG().booleanValue()) {
            bl3 = true;
        } else {
            bl = true;
        }
        String string = "TurnOff_" + n;
        division.add(FormHelper.createLabelRadioButtonLabelValueDiv(null, this.resMap.get(kUPSShutdownLabel), theTurnOffNoneName, bl, this.resMap.get(kTurnOffNoneId), string + "_TurnOffNone", string));
        division.add(FormHelper.createLabelRadioButtonLabelValueDiv(null, "", theTurnOffTheUPSName, bl2, this.resMap.get(kTurnOffTheUPSId), string + "_TurnOffUPS", string));
        List<NMC> list = Utils.getNMCList(pageContext, false, true);
        if (this.services.getAdvancedSetupHelper().isUPSSetupOutletGroupTurnOffSupported(list, uPSSetup)) {
            division.add(FormHelper.createLabelRadioButtonLabelValueDiv(null, "", theTurnOffTheSOGName, bl3, this.resMap.get(kTurnOffTheSOGId), string + "_TurnOffSOG", string));
        }
        return division;
    }
}

