/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.util;

import com.apcc.m11.components.shutdowner.vmware.vsan.VsanUtils;
import com.apcc.m11.components.stdpowersource.OutletGroup;
import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.model.MappedHost;
import com.apcc.m11.components.webserver.model.NMC;
import com.apcc.m11.components.webserver.model.UPSSetup;
import com.apcc.m11.components.webserver.model.VMSettings;
import com.apcc.m11.components.webserver.servlets.cfgwizard.HTTPServletParameterMap;
import com.apcc.m11.components.webserver.servlets.cfgwizard.M11DataSourceAccessor;
import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.m11.components.webserver.util.virtualization.vmware.HostSystemUtils;
import com.apcc.pcns.configservice.ConfigurationKeys;
import com.apcc.pcns.configservice.VirtualConfigurationManager;
import com.apcc.pcns.configservice.configurationmanagers.ConfigurationManager;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.configuration2.ex.ConversionException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AdvancedSetupHelper {
    private final Logger logger = LogManager.getLogger(AdvancedSetupHelper.class);
    @NonNull
    private HostSystemUtils hostSystemUtils;
    @NonNull
    private VirtualConfigurationManager virtualConfigurationManager;
    @NonNull
    private ConfigurationManager configurationManager;
    private Utils utils;
    private VsanUtils vsanUtils;

    public int readUPSSetupCountFromConfig() {
        String string;
        int n;
        for (n = 0; n < 100 && this.configurationManager.containsSection(string = ConfigurationKeys.getAdvancedSetupKey(n)); ++n) {
        }
        return n;
    }

    public List<UPSSetup> readUPSSetupsFromConfig() {
        ArrayList<UPSSetup> arrayList = new ArrayList<UPSSetup>();
        this.logger.trace("readUPSSetupsFromConfig() - start");
        int n = 0;
        boolean bl = false;
        do {
            UPSSetup uPSSetup;
            if ((uPSSetup = this.readUPSSetupFromConfig(n)) != null) {
                arrayList.add(uPSSetup);
            } else {
                bl = true;
            }
            ++n;
        } while (!bl);
        return arrayList;
    }

    public List<String> getNMCListForUPSSetup(int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            String string = this.configurationManager.getString(ConfigurationKeys.getAdvancedSetupKey(n), "ip_addresses");
            if (string != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    arrayList.add(string2);
                }
            } else {
                arrayList = null;
            }
        }
        catch (ConversionException conversionException) {
            // empty catch block
        }
        return arrayList;
    }

    public List<List<String>> getNMCListsForUPSSetups() {
        ArrayList<List<String>> arrayList = new ArrayList<List<String>>();
        int n = 0;
        boolean bl = false;
        do {
            List<String> list;
            if ((list = this.getNMCListForUPSSetup(n)) != null) {
                arrayList.add(list);
            } else {
                bl = true;
            }
            ++n;
        } while (!bl);
        return arrayList;
    }

    public void clearNMCAddress() {
        String string;
        int n = 0;
        boolean bl = false;
        do {
            if (this.configurationManager.containsKey("NetworkManagementCard", string = ConfigurationKeys.getNMCAddressKey(n))) {
                this.configurationManager.clearProperty("NetworkManagementCard", string);
            } else {
                bl = true;
            }
            ++n;
        } while (!bl);
        n = 0;
        bl = false;
        do {
            if (this.configurationManager.containsKey("NetworkManagementCard", string = ConfigurationKeys.getOutletGroupKey(n))) {
                this.configurationManager.clearProperty("NetworkManagementCard", string);
            } else {
                bl = true;
            }
            ++n;
        } while (!bl);
    }

    public Integer getGroupCount() {
        int n = 0;
        boolean bl = false;
        do {
            if (this.configurationManager.containsSection("advanced_ups_setup_" + n)) {
                ++n;
                continue;
            }
            bl = true;
        } while (!bl);
        return n;
    }

    public UPSSetup readUPSSetupFromConfig(int n) {
        UPSSetup uPSSetup;
        block83: {
            uPSSetup = null;
            this.logger.trace("readUPSSetupFromConfig() - start, idx: {}", (Object)n);
            String string = ConfigurationKeys.getAdvancedSetupKey(n);
            if (this.configurationManager.containsSection(string)) {
                String string2;
                StringTokenizer stringTokenizer;
                Object object;
                uPSSetup = new UPSSetup();
                uPSSetup.setGroup(n);
                try {
                    uPSSetup.setName(this.configurationManager.getString(string, "setup_name"));
                }
                catch (ConversionException conversionException) {
                    this.logger.debug((Object)conversionException);
                }
                try {
                    object = this.configurationManager.getString(string, "ip_addresses");
                    if (object != null) {
                        stringTokenizer = new StringTokenizer((String)object, "|");
                        while (stringTokenizer.hasMoreTokens()) {
                            string2 = stringTokenizer.nextToken();
                            uPSSetup.addNMC(string2);
                        }
                    }
                }
                catch (ConversionException conversionException) {
                    this.logger.info((Object)conversionException);
                }
                try {
                    object = this.configurationManager.getInt(string, "ups_required_for_load");
                    uPSSetup.setUpsRequiredForLoad((Integer)object);
                }
                catch (ConversionException conversionException) {
                    this.logger.info((Object)conversionException);
                }
                catch (NoSuchElementException noSuchElementException) {
                    this.logger.info((Object)noSuchElementException);
                }
                try {
                    object = this.configurationManager.getBoolean(string, "shutdownCommandFileEnabled");
                    uPSSetup.setCmdFileEnabled((Boolean)object);
                }
                catch (ConversionException conversionException) {
                    this.logger.info((Object)conversionException);
                }
                catch (NoSuchElementException noSuchElementException) {
                    this.logger.trace((Object)noSuchElementException);
                }
                try {
                    object = this.configurationManager.getString(string, "shutdownCommandFile");
                    uPSSetup.setCmdFilePath((String)object);
                }
                catch (ConversionException conversionException) {
                    this.logger.info((Object)conversionException);
                }
                try {
                    object = this.configurationManager.getInt(string, "shutdownCommandFileDuration");
                    uPSSetup.setCmdFileDuration((Integer)object);
                }
                catch (ConversionException conversionException) {
                    this.logger.info((Object)conversionException);
                }
                catch (NoSuchElementException noSuchElementException) {
                    this.logger.trace((Object)noSuchElementException);
                }
                try {
                    object = this.configurationManager.getInt(string, "shutdownCommandFileDelay");
                    uPSSetup.setCmdFileDelay((Integer)object);
                }
                catch (ConversionException conversionException) {
                    this.logger.info((Object)conversionException);
                }
                catch (NoSuchElementException noSuchElementException) {
                    this.logger.trace((Object)noSuchElementException);
                }
                try {
                    object = this.configurationManager.getBoolean(string, "executeCommandFileAfterHostShutdown");
                    uPSSetup.setExecuteCommandFileAfterHostShutdown((Boolean)object);
                }
                catch (ConversionException conversionException) {
                    this.logger.info((Object)conversionException);
                }
                catch (NoSuchElementException noSuchElementException) {
                    this.logger.trace((Object)noSuchElementException);
                }
                try {
                    object = this.configurationManager.getBoolean(string, "shutdownPowerchuteServer");
                    uPSSetup.setLocalMachineShutdownEnabled((Boolean)object);
                }
                catch (ConversionException conversionException) {
                    this.logger.info((Object)conversionException);
                }
                catch (NoSuchElementException noSuchElementException) {
                    this.logger.trace((Object)noSuchElementException);
                }
                try {
                    object = this.configurationManager.getBoolean(string, "ShutdownVirtualHosts");
                    uPSSetup.setVirtualHostsShutdownEnabled((Boolean)object);
                }
                catch (ConversionException conversionException) {
                    this.logger.info((Object)conversionException);
                }
                catch (NoSuchElementException noSuchElementException) {
                    this.logger.trace((Object)noSuchElementException);
                }
                try {
                    object = this.configurationManager.getBoolean(string, "shutdownOnLostRedundancy");
                    uPSSetup.setRedundancyLostShutdownEnabled((Boolean)object);
                }
                catch (ConversionException conversionException) {
                    this.logger.info((Object)conversionException);
                }
                catch (NoSuchElementException noSuchElementException) {
                    this.logger.trace((Object)noSuchElementException);
                }
                try {
                    object = this.configurationManager.getBoolean(string, "turnOffUps");
                    uPSSetup.setTurnOffUps((Boolean)object);
                }
                catch (ConversionException conversionException) {
                    this.logger.info((Object)conversionException);
                }
                catch (NoSuchElementException noSuchElementException) {
                    this.logger.trace((Object)noSuchElementException);
                }
                try {
                    object = this.configurationManager.getBoolean(string, "turnOffSOG");
                    uPSSetup.setTurnOffSOG((Boolean)object);
                }
                catch (ConversionException conversionException) {
                    this.logger.info((Object)conversionException);
                }
                catch (NoSuchElementException noSuchElementException) {
                    this.logger.trace((Object)noSuchElementException);
                }
                try {
                    object = this.configurationManager.getBoolean(string, "force_VApp_shutdown");
                    uPSSetup.getVMSettings().setForcevAppShutdownEnabled((Boolean)object);
                }
                catch (ConversionException conversionException) {
                    this.logger.info((Object)conversionException);
                }
                catch (NoSuchElementException noSuchElementException) {
                    this.logger.trace((Object)noSuchElementException);
                }
                try {
                    object = this.configurationManager.getBoolean(string, "enable_guest_vm_migration");
                    uPSSetup.getVMSettings().setGuestVMMigrationEnabled((Boolean)object);
                }
                catch (ConversionException conversionException) {
                    this.logger.info((Object)conversionException);
                }
                catch (NoSuchElementException noSuchElementException) {
                    this.logger.trace((Object)noSuchElementException);
                }
                try {
                    object = this.configurationManager.getInt(string, "guest_vm_migration_duration");
                    uPSSetup.getVMSettings().setGuestVMMigrationDuration((Integer)object);
                }
                catch (ConversionException conversionException) {
                    this.logger.info((Object)conversionException);
                }
                catch (NoSuchElementException noSuchElementException) {
                    this.logger.trace((Object)noSuchElementException);
                }
                try {
                    object = this.configurationManager.getBoolean(string, "enable_custom_target_vm_migration");
                    uPSSetup.getVMSettings().setGuestVMMigrationTargetEnabled((Boolean)object);
                }
                catch (ConversionException conversionException) {
                    this.logger.info((Object)conversionException);
                }
                catch (NoSuchElementException noSuchElementException) {
                    this.logger.trace((Object)noSuchElementException);
                }
                uPSSetup.getVMSettings().setMigrationTargetHosts(this.utils.readMigrationTargetHostsFromConfig(string));
                try {
                    object = this.configurationManager.getBoolean(string, "enable_guest_vm_vapp_shutdown");
                    uPSSetup.getVMSettings().setGuestVMVAppShutdownEnabled((Boolean)object);
                }
                catch (ConversionException conversionException) {
                    this.logger.info((Object)conversionException);
                }
                catch (NoSuchElementException noSuchElementException) {
                    this.logger.trace((Object)noSuchElementException);
                }
                try {
                    object = this.configurationManager.getInt(string, "guest_vm_vapp_shutdown_duration");
                    uPSSetup.getVMSettings().setGuestVMVappShutdownDuration((Integer)object);
                }
                catch (ConversionException conversionException) {
                    this.logger.info((Object)conversionException);
                }
                catch (NoSuchElementException noSuchElementException) {
                    this.logger.trace((Object)noSuchElementException);
                }
                try {
                    object = this.configurationManager.getBoolean(string, "enable_guest_vm_vapp_startup");
                    uPSSetup.getVMSettings().setGuestVMVappStartupEnabled((Boolean)object);
                }
                catch (ConversionException conversionException) {
                    this.logger.info((Object)conversionException);
                }
                catch (NoSuchElementException noSuchElementException) {
                    this.logger.trace((Object)noSuchElementException);
                }
                try {
                    object = this.configurationManager.getInt(string, "guest_vm_vapp_startup_duration");
                    uPSSetup.getVMSettings().setGuestVMVappStartupDuration((Integer)object);
                }
                catch (ConversionException conversionException) {
                    this.logger.info((Object)conversionException);
                }
                catch (NoSuchElementException noSuchElementException) {
                    this.logger.trace((Object)noSuchElementException);
                }
                try {
                    object = this.configurationManager.getBoolean(string, "enable_host_maintenance");
                    uPSSetup.getVMSettings().setHostMaintenanceEnabled((Boolean)object);
                }
                catch (ConversionException conversionException) {
                    this.logger.info((Object)conversionException);
                }
                catch (NoSuchElementException noSuchElementException) {
                    this.logger.trace((Object)noSuchElementException);
                }
                try {
                    object = this.configurationManager.getInt(string, "host_maintenance_duration");
                    uPSSetup.getVMSettings().setHostMaintenanceDuration((Integer)object);
                }
                catch (ConversionException conversionException) {
                    this.logger.info((Object)conversionException);
                }
                catch (NoSuchElementException noSuchElementException) {
                    this.logger.trace((Object)noSuchElementException);
                }
                try {
                    object = this.configurationManager.getBoolean(string, "enable_host_shutdown");
                    uPSSetup.getVMSettings().setHostShutdownEnabled((Boolean)object);
                }
                catch (ConversionException conversionException) {
                    this.logger.info((Object)conversionException);
                }
                catch (NoSuchElementException noSuchElementException) {
                    this.logger.trace((Object)noSuchElementException);
                }
                try {
                    object = this.configurationManager.getInt(string, "host_shutdown_duration");
                    uPSSetup.getVMSettings().setHostShutdownDuration((Integer)object);
                }
                catch (ConversionException conversionException) {
                    this.logger.info((Object)conversionException);
                }
                catch (NoSuchElementException noSuchElementException) {
                    this.logger.trace((Object)noSuchElementException);
                }
                try {
                    object = this.configurationManager.getInt(string, "vm_startup_delay_duration");
                    uPSSetup.getVMSettings().setBetweenVmStartupDelay((Integer)object);
                }
                catch (ConversionException conversionException) {
                    this.logger.info((Object)conversionException);
                }
                catch (NoSuchElementException noSuchElementException) {
                    this.logger.trace((Object)noSuchElementException);
                }
                this.readVSanUPSSetupFromConfig(this.configurationManager, uPSSetup, string);
                this.readNutanixUPSSetupFromConfig(this.configurationManager, uPSSetup, string);
                this.readAdvancedSSHActionsFromConfig(this.configurationManager, uPSSetup, string);
                try {
                    object = this.configurationManager.getString(string, "hostlist");
                    if (object == null) break block83;
                    stringTokenizer = new StringTokenizer((String)object, "|");
                    while (stringTokenizer.hasMoreTokens()) {
                        string2 = stringTokenizer.nextToken();
                        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "&");
                        String string3 = null;
                        Integer n2 = null;
                        string3 = stringTokenizer2.nextToken();
                        try {
                            String string4 = stringTokenizer2.nextToken();
                            n2 = Integer.valueOf(string4);
                        }
                        catch (NumberFormatException | NoSuchElementException runtimeException) {
                            this.logger.trace((Object)runtimeException);
                        }
                        uPSSetup.addHost(string3, n2);
                    }
                }
                catch (ConversionException conversionException) {
                    this.logger.info((Object)conversionException);
                }
            }
        }
        this.logger.trace("readUPSSetupFromConfig() - end");
        return uPSSetup;
    }

    private void readAdvancedSSHActionsFromConfig(ConfigurationManager configurationManager, UPSSetup uPSSetup, String string3) {
        List list = configurationManager.getSections().stream().filter(string -> string.startsWith("SSHAction")).collect(Collectors.toList());
        list.stream().forEach(string2 -> this.setSSHSettingToUPSSetup((String)string2, string3, uPSSetup, configurationManager));
    }

    private void saveAdvancedSSHActionsToConfig(String string3, Map<String, Boolean> map, ConfigurationManager configurationManager) {
        if (map != null) {
            List list = configurationManager.getSections().stream().filter(string -> StringUtils.startsWith((CharSequence)string, (CharSequence)"SSHAction")).collect(Collectors.toList());
            list.stream().filter(string -> !map.containsKey(string)).forEach(string2 -> configurationManager.clearProperty(string3, (String)string2));
            map.entrySet().stream().forEach(entry -> configurationManager.setProperty(string3, (String)entry.getKey(), entry.getValue()));
        }
    }

    private void setSSHSettingToUPSSetup(String string, String string2, UPSSetup uPSSetup, ConfigurationManager configurationManager) {
        boolean bl = false;
        uPSSetup.setSSHSetting(string, configurationManager.getBoolean(string2, string, bl));
    }

    public String readGroupNameFromConfig(int n) {
        String string = null;
        String string2 = ConfigurationKeys.getAdvancedSetupKey(n);
        if (this.configurationManager.containsKey(string2, "setup_name")) {
            try {
                string = this.configurationManager.getString(string2, "setup_name");
            }
            catch (ConversionException conversionException) {
                this.logger.info((Object)conversionException);
            }
        }
        return string;
    }

    public void saveUPSSetupsToConfig(List<UPSSetup> list) {
        if (list != null && list.size() > 0) {
            int n;
            this.logger.debug("saveUPSSetupsToConfig() - start");
            int n2 = this.readUPSSetupCountFromConfig();
            boolean bl = false;
            bl = this.configurationManager.isAutoSave();
            this.configurationManager.setAutoSave(false);
            for (n = 0; n < list.size(); ++n) {
                this.saveUPSSetupToConfig(list.get(n), n);
            }
            for (n = list.size(); n < n2; ++n) {
                this.configurationManager.clearSection(ConfigurationKeys.getAdvancedSetupKey(n));
            }
            if (bl) {
                this.configurationManager.setAutoSave(true);
                this.configurationManager.save();
            }
        }
    }

    public void saveUPSSetupToConfig(UPSSetup uPSSetup, int n) {
        String string = null;
        this.logger.debug("saveUPSSetupToConfig() - start, ups_setup_idx: {}", (Object)n);
        boolean bl = this.virtualConfigurationManager.isESXi();
        boolean bl2 = this.virtualConfigurationManager.isHyperV();
        boolean bl3 = this.virtualConfigurationManager.isNutanixAHV();
        boolean bl4 = this.virtualConfigurationManager.isNutanixESXi();
        boolean bl5 = false;
        bl5 = this.configurationManager.isAutoSave();
        this.configurationManager.setAutoSave(false);
        string = ConfigurationKeys.getAdvancedSetupKey(n);
        if (uPSSetup.getName() != null) {
            this.configurationManager.setProperty(string, "setup_name", uPSSetup.getName());
        }
        if (uPSSetup.getNMCList() != null && uPSSetup.getNMCList().size() > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String charSequence : uPSSetup.getNMCList()) {
                stringBuilder.append(charSequence);
                stringBuilder.append("|");
            }
            Object object = stringBuilder.toString();
            if (((String)object).endsWith("|")) {
                object = ((String)object).substring(0, ((String)object).length() - 1);
            }
            this.configurationManager.setProperty(string, "ip_addresses", object);
        }
        if (uPSSetup.getUpsRequiredForLoad() >= 0) {
            this.configurationManager.setProperty(string, "ups_required_for_load", uPSSetup.getUpsRequiredForLoad());
        }
        this.configurationManager.setProperty(string, "shutdownCommandFileEnabled", uPSSetup.getCmdFileEnabled());
        if (uPSSetup.getCmdFilePath() != null) {
            this.configurationManager.setProperty(string, "shutdownCommandFile", uPSSetup.getCmdFilePath());
        }
        if (uPSSetup.getCmdFileDuration() >= 0) {
            this.configurationManager.setProperty(string, "shutdownCommandFileDuration", uPSSetup.getCmdFileDuration());
        }
        if (!(bl || bl2 || bl3)) {
            this.configurationManager.setProperty(string, "shutdownPowerchuteServer", uPSSetup.getLocalMachineShutdownEnabled());
        }
        this.configurationManager.setProperty(string, "shutdownOnLostRedundancy", uPSSetup.getRedundancyLostShutdownEnabled());
        this.configurationManager.setProperty(string, "turnOffUps", uPSSetup.getTurnOffUps());
        this.configurationManager.setProperty(string, "turnOffSOG", uPSSetup.getTurnOffSOG());
        this.configurationManager.setProperty("Shutdown", "shutdownCommandFileEnabled", false);
        this.configurationManager.setProperty("Shutdown", "shutdownCommandFileDelay", 0);
        this.configurationManager.setProperty("Shutdown", "shutdownCommandFile", "");
        this.configurationManager.setProperty("Shutdown", "shutdownCommandFileDuration", 30);
        if (this.virtualConfigurationManager.isManagedHostOrNutanixAHV()) {
            boolean bl6 = false;
            int n2 = 0;
            if ((!bl || !this.virtualConfigurationManager.isPCNSInstalledOnVMA()) && uPSSetup.getCmdFileEnabled() && (bl6 = uPSSetup.isExecuteCommandFileAfterHostShutdown())) {
                n2 = uPSSetup.getCmdFileDelay();
            }
            this.configurationManager.setProperty(string, "executeCommandFileAfterHostShutdown", bl6);
            this.configurationManager.setProperty(string, "shutdownCommandFileDelay", n2);
            if (uPSSetup.getHostsMap() != null && uPSSetup.getHostsMap().size() > 0) {
                StringBuilder bl7 = new StringBuilder();
                for (Map.Entry<String, Integer> entry : uPSSetup.getHostsMap().entrySet()) {
                    bl7.append(entry.getKey());
                    if (entry.getValue() != null) {
                        bl7.append("&");
                        bl7.append(entry.getValue());
                    }
                    bl7.append("|");
                }
                Object object = bl7.toString();
                if (((String)object).endsWith("|")) {
                    object = ((String)object).substring(0, ((String)object).length() - 1);
                }
                this.configurationManager.setProperty(string, "hostlist", object);
                if (bl2) {
                    this.configurationManager.setProperty(string, "enable_host_maintenance", uPSSetup.getVMSettings().getHostMaintenanceEnabled());
                    this.configurationManager.setProperty(string, "host_maintenance_duration", uPSSetup.getVMSettings().getHostMaintenanceDuration());
                    this.configurationManager.setProperty(string, "enable_host_shutdown", uPSSetup.getVMSettings().getHostShutdownEnabled());
                    this.configurationManager.setProperty(string, "host_shutdown_duration", uPSSetup.getVMSettings().getHostShutdownDuration());
                    this.configurationManager.setProperty(string, "ShutdownVirtualHosts", uPSSetup.isVirtualHostsShutdownEnabled());
                    this.configurationManager.setProperty(string, "shutdownPowerchuteServer", uPSSetup.getLocalMachineShutdownEnabled());
                } else if (bl3) {
                    this.saveNutanixUPSSetupToConfig(this.configurationManager, uPSSetup, string);
                    this.configurationManager.setProperty(string, "ShutdownVirtualHosts", uPSSetup.isVirtualHostsShutdownEnabled());
                    this.configurationManager.setProperty(string, "shutdownPowerchuteServer", uPSSetup.getLocalMachineShutdownEnabled());
                    this.clearESXiSettings(string);
                    this.clearNutanixESXiSettings(string, this.configurationManager);
                } else {
                    this.configurationManager.setProperty(string, "force_VApp_shutdown", uPSSetup.getVMSettings().isForcevAppShutdownEnabled());
                    this.configurationManager.setProperty(string, "enable_guest_vm_migration", uPSSetup.getVMSettings().isGuestVMMigrationEnabled());
                    this.configurationManager.setProperty(string, "guest_vm_migration_duration", uPSSetup.getVMSettings().getGuestVMMigrationDuration());
                    this.configurationManager.setProperty(string, "enable_custom_target_vm_migration", uPSSetup.getVMSettings().isGuestVMMigrationTargetEnabled());
                    this.utils.saveTargetHostSelectionToConfig(uPSSetup.getVMSettings().getMigrationTargetHosts(), string, "custom_target_hosts");
                    this.configurationManager.setProperty(string, "enable_guest_vm_vapp_shutdown", uPSSetup.getVMSettings().isGuestVMVAppShutdownEnabled());
                    this.configurationManager.setProperty(string, "guest_vm_vapp_shutdown_duration", uPSSetup.getVMSettings().getGuestVMVappShutdownDuration());
                    this.configurationManager.setProperty(string, "enable_guest_vm_vapp_startup", uPSSetup.getVMSettings().isGuestVMVappStartupEnabled());
                    this.configurationManager.setProperty(string, "guest_vm_vapp_startup_duration", uPSSetup.getVMSettings().getGuestVMVappStartupDuration());
                    this.configurationManager.setProperty(string, "vm_startup_delay_duration", uPSSetup.getVMSettings().getBetweenVmStartupDelay());
                    this.configurationManager.setProperty(string, "ShutdownVirtualHosts", uPSSetup.isVirtualHostsShutdownEnabled());
                    this.configurationManager.setProperty(string, "shutdownPowerchuteServer", uPSSetup.getLocalMachineShutdownEnabled());
                    if (this.vsanUtils.isVsanCluster()) {
                        this.utils.savevSanSettingsToConfig(uPSSetup.getVMSettings(), string);
                        if (!this.isAdvancedShutdownMode()) {
                            this.utils.removeAdvancedvSanSettingsFromConfig(string);
                        }
                    } else {
                        this.utils.removeAllvSanSettingsFromConfig(string);
                    }
                    if (bl4) {
                        this.saveNutanixUPSSetupToConfig(this.configurationManager, uPSSetup, string);
                        this.clearNutanixAHVSettings(string, this.configurationManager);
                    } else {
                        this.clearNutanixAHVSettings(string, this.configurationManager);
                        this.clearNutanixESXiSettings(string, this.configurationManager);
                        this.clearNutanixAHVSettings(string, this.configurationManager);
                    }
                }
            } else {
                if (!this.configurationManager.containsKey(string, "ShutdownVirtualHosts")) {
                    boolean bl7;
                    boolean bl8 = true;
                    if (bl) {
                        bl7 = !this.virtualConfigurationManager.isPCNSInstalledOnVMA();
                    }
                    this.configurationManager.setProperty(string, "ShutdownVirtualHosts", bl7);
                    this.configurationManager.setProperty(string, "shutdownPowerchuteServer", bl7);
                } else {
                    this.configurationManager.setProperty(string, "ShutdownVirtualHosts", uPSSetup.isVirtualHostsShutdownEnabled());
                    this.configurationManager.setProperty(string, "shutdownPowerchuteServer", uPSSetup.getLocalMachineShutdownEnabled());
                }
                this.clearESXiSettings(string);
                this.clearHyperVSettings(string);
                this.clearNutanixAHVSettings(string, this.configurationManager);
                this.clearNutanixESXiSettings(string, this.configurationManager);
                this.clearCommonNutanixSettings(string, this.configurationManager);
            }
        }
        this.saveAdvancedSSHActionsToConfig(string, uPSSetup.getSSHSettings(), this.configurationManager);
        if (bl5) {
            this.configurationManager.setAutoSave(true);
            this.configurationManager.save();
        }
    }

    public void clearESXiSettings(String string) {
        this.configurationManager.clearProperty(string, "force_VApp_shutdown");
        this.configurationManager.clearProperty(string, "enable_guest_vm_migration");
        this.configurationManager.clearProperty(string, "guest_vm_migration_duration");
        this.configurationManager.clearProperty(string, "enable_custom_target_vm_migration");
        this.configurationManager.clearProperty(string, "custom_target_hosts");
        this.configurationManager.clearProperty(string, "enable_guest_vm_vapp_shutdown");
        this.configurationManager.clearProperty(string, "guest_vm_vapp_shutdown_duration");
        this.configurationManager.clearProperty(string, "enable_guest_vm_vapp_startup");
        this.configurationManager.clearProperty(string, "guest_vm_vapp_startup_duration");
        this.configurationManager.clearProperty(string, "vm_startup_delay_duration");
    }

    public void clearNutanixAHVSettings(String string, ConfigurationManager configurationManager) {
        configurationManager.clearProperty(string, "uvm_shutdown_duration");
        configurationManager.clearProperty(string, "uvm_startup_enable");
        configurationManager.clearProperty(string, "uvm_startup_duration");
        configurationManager.clearProperty(string, "uvm_poweroff_duration");
        configurationManager.clearProperty(string, "uvm_forceoff_duration");
    }

    public void clearNutanixESXiSettings(String string, ConfigurationManager configurationManager) {
        configurationManager.clearProperty(string, "metro_availability_disable");
    }

    public void clearCommonNutanixSettings(String string, ConfigurationManager configurationManager) {
        configurationManager.clearProperty(string, "cvm_shutdown_duration");
        configurationManager.clearProperty(string, "cvm_startup_enable");
        configurationManager.clearProperty(string, "cvm_startup_duration");
        configurationManager.clearProperty(string, "cvm_connect_timeout");
        configurationManager.clearProperty(string, "afs_shutdown_enable");
        configurationManager.clearProperty(string, "afs_shutdown_duration");
        configurationManager.clearProperty(string, "afs_startup_enable");
        configurationManager.clearProperty(string, "afs_startup_duration");
        configurationManager.clearProperty(string, "ongoing_replication_abort_delay_enable");
        configurationManager.clearProperty(string, "ongoing_replication_abort_delay_duration");
        configurationManager.clearProperty(string, "ongoing_replication_abort_command_duration");
        configurationManager.clearProperty(string, "cluster_shutdown_duration");
        configurationManager.clearProperty(string, "cluster_startup_duration");
    }

    public void clearHyperVSettings(String string) {
        this.configurationManager.clearProperty(string, "enable_host_maintenance");
        this.configurationManager.clearProperty(string, "host_maintenance_duration");
        this.configurationManager.clearProperty(string, "enable_host_shutdown");
        this.configurationManager.clearProperty(string, "host_shutdown_duration");
    }

    public void removeAllAdvancedUPSSetups() {
        boolean bl = false;
        bl = this.configurationManager.isAutoSave();
        this.configurationManager.setAutoSave(false);
        for (String string : this.configurationManager.getSections()) {
            if (!string.startsWith("advanced_ups_setup_")) continue;
            this.configurationManager.clearSection(string);
        }
        if (bl) {
            this.configurationManager.setAutoSave(true);
            this.configurationManager.save();
        }
    }

    public void storeUPSSetupRequestValues(List<UPSSetup> list, PageContext pageContext) {
        HTTPServletParameterMap hTTPServletParameterMap = new HTTPServletParameterMap();
        hTTPServletParameterMap.putAll(pageContext.getPostQueryValues());
        this.storeUPSSetupRequestValues(list, hTTPServletParameterMap);
    }

    public void storeUPSSetupRequestValues(List<UPSSetup> list, HTTPServletParameterMap hTTPServletParameterMap) {
        String string = null;
        String string2 = null;
        String[] stringArray = (String[])hTTPServletParameterMap.get("upsRequired");
        int n = 0;
        for (UPSSetup uPSSetup : list) {
            String string3;
            if (stringArray != null && stringArray.length > n) {
                uPSSetup.setUpsRequiredForLoad(Integer.valueOf(stringArray[n]));
            }
            if (hTTPServletParameterMap.getString("cmdFileEnabled_" + n) != null) {
                uPSSetup.setCmdFileEnabled(true);
                string = hTTPServletParameterMap.getString("cmdFilePath_" + n);
                string = string != null ? string.trim() : "";
                uPSSetup.setCmdFilePath(string);
                string2 = hTTPServletParameterMap.getString("cmdFileDuration_" + n);
                try {
                    uPSSetup.setCmdFileDuration(Integer.valueOf(string2));
                }
                catch (NumberFormatException numberFormatException) {
                    this.logger.error("Command File Duration is not a valid number: " + string2);
                    uPSSetup.setCmdFileDuration(0);
                }
                uPSSetup.setExecuteCommandFileAfterHostShutdown(hTTPServletParameterMap.getString("executeCommandFileAfterHostShutdown_" + n) != null);
                if (uPSSetup.isExecuteCommandFileAfterHostShutdown()) {
                    String string4 = hTTPServletParameterMap.getString("cmdFileDelay_" + n);
                    try {
                        uPSSetup.setCmdFileDelay(Integer.valueOf(string4));
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.logger.error("Command File Delay is not a valid number: " + string4);
                        uPSSetup.setCmdFileDelay(0);
                    }
                } else {
                    uPSSetup.setCmdFileDelay(0);
                }
            } else {
                uPSSetup.setCmdFileEnabled(false);
            }
            boolean bl = this.virtualConfigurationManager.isManagedHostOrNutanixAHV();
            if (bl || !this.virtualConfigurationManager.isESXi() && !this.virtualConfigurationManager.isHyperV()) {
                string3 = hTTPServletParameterMap.getString("shutdownLocalMachine_" + n);
                uPSSetup.setLocalMachineShutdownEnabled(string3 != null);
                string3 = hTTPServletParameterMap.getString("shutdownVirtualHosts_" + n);
                uPSSetup.setVirtualHostsShutdownEnabled(string3 != null);
            }
            if (uPSSetup.getNumberOfRedundantUPS() > 0) {
                uPSSetup.setRedundancyLostShutdownEnabled(hTTPServletParameterMap.getString("shutdownRedundancyLost_" + n) != null);
            } else {
                uPSSetup.setRedundancyLostShutdownEnabled(false);
            }
            string3 = hTTPServletParameterMap.getString("TurnOff_" + n);
            if (string3 != null) {
                if (string3.equals("TurnOffNone")) {
                    uPSSetup.setTurnOffSOG(false);
                    uPSSetup.setTurnOffUps(false);
                } else if (string3.equals("TurnOffUPS")) {
                    uPSSetup.setTurnOffSOG(false);
                    uPSSetup.setTurnOffUps(true);
                } else if (string3.equals("TurnOffSOG")) {
                    uPSSetup.setTurnOffSOG(true);
                    uPSSetup.setTurnOffUps(false);
                }
            }
            ++n;
        }
    }

    private boolean isSingleUPSSetup() {
        boolean bl = true;
        for (UPSSetup uPSSetup : this.readUPSSetupsFromConfig()) {
            if (uPSSetup.getTotalNumberOfUPS() <= 1) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public void initializeSingleUPSSetupSetting(PageContext pageContext) {
        boolean bl = false;
        boolean bl2 = this.isSingleUPSSetup();
        if (this.virtualConfigurationManager.isManagedHostOrNutanixAHV() && this.isAdvancedShutdownMode()) {
            if (this.configurationManager.containsKey("HostConfigSettings", "single_ups_groups_only")) {
                try {
                    bl = this.configurationManager.getBoolean("HostConfigSettings", "single_ups_groups_only");
                }
                catch (NoSuchElementException | ConversionException throwable) {
                    this.logger.debug((Object)throwable);
                }
                if (bl != bl2) {
                    this.cleanUPSSetupsMappedHosts(pageContext);
                }
            }
            this.configurationManager.setProperty("HostConfigSettings", "single_ups_groups_only", this.isSingleUPSSetup());
        } else {
            this.configurationManager.clearProperty("HostConfigSettings", "single_ups_groups_only");
        }
    }

    private void cleanUPSSetupsMappedHosts(PageContext pageContext) {
        for (String string : this.configurationManager.getSections()) {
            if (!string.startsWith("advanced_ups_setup_")) continue;
            this.configurationManager.setProperty(string, "hostlist", "");
        }
        pageContext.getSession().removeAttribute("mappedHosts");
    }

    public boolean getSingleUPSSetupSetting() {
        boolean bl = false;
        if (this.virtualConfigurationManager.isManagedHostOrNutanixAHV() && this.isAdvancedShutdownMode()) {
            boolean bl2 = false;
            if (this.configurationManager.containsKey("HostConfigSettings", "single_ups_groups_only")) {
                try {
                    bl = this.configurationManager.getBoolean("HostConfigSettings", "single_ups_groups_only");
                    bl2 = true;
                }
                catch (NoSuchElementException | ConversionException throwable) {
                    this.logger.trace((Object)throwable);
                }
            }
            if (!bl2) {
                bl = this.isSingleUPSSetup();
                this.configurationManager.setProperty("HostConfigSettings", "single_ups_groups_only", bl);
            }
        }
        return bl;
    }

    public boolean isUPSSetupOutletGroupTurnOffSupported(List<NMC> list, UPSSetup uPSSetup) {
        boolean bl = true;
        boolean bl2 = bl = !this.isUPSSetupWithMixedUPSEnvironment(list, uPSSetup);
        if (bl) {
            bl = !this.isUPSSetupWithHostsMappedToMultipleOutletGroups(uPSSetup);
        }
        return bl;
    }

    public boolean isUPSSetupWithMixedUPSEnvironment(List<NMC> list, UPSSetup uPSSetup) {
        boolean bl = false;
        for (String string : uPSSetup.getNMCList()) {
            for (NMC nMC : list) {
                if (!string.equalsIgnoreCase(nMC.getIPAddress())) continue;
                if (nMC.hasOutletGroups()) break;
                bl = true;
                break;
            }
            if (!bl) continue;
            break;
        }
        return bl;
    }

    public boolean isUPSSetupWithHostsMappedToMultipleOutletGroups(UPSSetup uPSSetup) {
        boolean bl = false;
        if (this.getSingleUPSSetupSetting()) {
            Integer n = null;
            Integer n2 = null;
            for (String string : uPSSetup.getHosts()) {
                n2 = uPSSetup.getHostsMap().get(string);
                if (n == null) {
                    n = n2;
                    continue;
                }
                if (n2 == null || n.equals(n2)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public boolean hasUPSSetupWithHostsMappedToMultipleOutletGroups() {
        UPSSetup uPSSetup;
        boolean bl = false;
        Iterator<UPSSetup> iterator = this.readUPSSetupsFromConfig().iterator();
        while (iterator.hasNext() && !(bl = this.isUPSSetupWithHostsMappedToMultipleOutletGroups(uPSSetup = iterator.next()))) {
        }
        return bl;
    }

    public void updateUPSSetupsTurnOffOutletGroups(PageContext pageContext) {
        int n = 0;
        List<NMC> list = Utils.getNMCList(pageContext, false, true);
        for (UPSSetup uPSSetup : this.readUPSSetupsFromConfig()) {
            if (!this.isUPSSetupOutletGroupTurnOffSupported(list, uPSSetup) && uPSSetup.getTurnOffSOG().booleanValue()) {
                uPSSetup.setTurnOffSOG(false);
                this.saveUPSSetupTurnOffValues(uPSSetup, n);
            }
            ++n;
        }
    }

    public List<OutletGroup> getMappedOutletGroups(PageContext pageContext) {
        return this.getMappedOutletGroups(pageContext.getDataSourceAccessor());
    }

    public List<OutletGroup> getMappedOutletGroups(M11DataSourceAccessor m11DataSourceAccessor) {
        if (!this.getSingleUPSSetupSetting()) {
            return null;
        }
        ArrayList<OutletGroup> arrayList = new ArrayList<OutletGroup>();
        List<NMC> list = Utils.getNMCList(m11DataSourceAccessor, false, true);
        List<UPSSetup> list2 = this.readUPSSetupsFromConfig();
        block0: for (UPSSetup uPSSetup : list2) {
            if (uPSSetup.getNMCList().size() == 0) {
                this.logger.debug("Empty UPS list for group " + uPSSetup.getName());
                continue;
            }
            if (this.isUPSSetupOutletGroupTurnOffSupported(list, uPSSetup)) {
                Object object = null;
                for (String string : uPSSetup.getHosts()) {
                    object = uPSSetup.getHostsMap().get(string);
                    if (object == null) continue;
                    break;
                }
                if (object == null) {
                    this.logger.debug("registering with first outlet group; no hosts mapped for group " + uPSSetup.getName());
                }
                for (NMC nMC : list) {
                    if (!nMC.getIPAddress().equalsIgnoreCase(uPSSetup.getNMCList().get(0))) continue;
                    if (!nMC.hasOutletGroups()) continue block0;
                    boolean bl = false;
                    if (object != null) {
                        for (OutletGroup outletGroup : nMC.getOutletGroups()) {
                            if (!outletGroup.getGroupNumber().equals(object)) continue;
                            arrayList.add(outletGroup);
                            bl = true;
                            break;
                        }
                    }
                    if (bl) continue block0;
                    arrayList.add(nMC.getDefaultOutletGroup());
                    continue block0;
                }
                continue;
            }
            for (NMC nMC : list) {
                if (!nMC.getIPAddress().equalsIgnoreCase(uPSSetup.getNMCList().get(0))) continue;
                if (!nMC.hasOutletGroups()) continue block0;
                arrayList.add(nMC.getDefaultOutletGroup());
                continue block0;
            }
        }
        return arrayList;
    }

    public boolean isAdvancedShutdownMode() {
        String string = null;
        try {
            string = this.configurationManager.getString("NetworkManagementCard", "mode");
        }
        catch (ConversionException conversionException) {
            this.logger.info((Object)conversionException);
        }
        boolean bl = "advanced".equalsIgnoreCase(string);
        this.logger.trace("isAdvancedShutdownMode() - result: {}", (Object)bl);
        return bl;
    }

    public boolean isShutdownOnRedundancyLostEnabled(int n) {
        boolean bl = false;
        String string = ConfigurationKeys.getAdvancedSetupKey(n);
        try {
            if (this.configurationManager.getBoolean(string, "shutdownOnLostRedundancy").booleanValue()) {
                bl = true;
            }
        }
        catch (NoSuchElementException | ConversionException throwable) {
            // empty catch block
        }
        return bl;
    }

    public void saveUPSSetupTurnOffValues(UPSSetup uPSSetup, int n) {
        boolean bl = false;
        bl = this.configurationManager.isAutoSave();
        this.configurationManager.setAutoSave(false);
        String string = ConfigurationKeys.getAdvancedSetupKey(n);
        this.configurationManager.setProperty(string, "turnOffUps", uPSSetup.getTurnOffUps());
        this.configurationManager.setProperty(string, "turnOffSOG", uPSSetup.getTurnOffSOG());
        if (bl) {
            this.configurationManager.setAutoSave(true);
            this.configurationManager.save();
        }
    }

    public String getNMCGroup(String string, List<UPSSetup> list) {
        String string2 = "";
        if (list != null) {
            for (UPSSetup uPSSetup : list) {
                if (!uPSSetup.getNMCList().contains(string)) continue;
                return uPSSetup.getName();
            }
        }
        return string2;
    }

    public boolean isSingleUPSGroup(int n) {
        boolean bl = false;
        List<String> list = this.getNMCListForUPSSetup(n);
        if (list != null && list.size() == 1) {
            bl = true;
        }
        return bl;
    }

    public String getUPSSetupGroupNameFromConfig(int n) {
        String string = "";
        String string2 = ConfigurationKeys.getAdvancedSetupKey(n);
        if (this.configurationManager.containsSection(string2)) {
            try {
                string = this.configurationManager.getString(string2, "setup_name");
            }
            catch (ConversionException conversionException) {
                this.logger.error((Object)conversionException);
            }
        }
        return string;
    }

    public UPSSetup getHostUPSSetup(String string) {
        List<UPSSetup> list = this.readUPSSetupsFromConfig();
        if (list != null) {
            for (UPSSetup uPSSetup : list) {
                LinkedHashSet<String> linkedHashSet = this.vsanUtils.removeVsanTagsFromSet(uPSSetup.getHosts(), this.virtualConfigurationManager.isESXi());
                for (String string2 : linkedHashSet) {
                    String string3 = this.virtualConfigurationManager.getFQDNFromIP(string2);
                    String string4 = this.virtualConfigurationManager.getIPFromHostName(string2);
                    this.logger.debug("getHostUPSSetup() - checking host: {}, config: {}, IP: {}, FQDN: {}", (Object)string, (Object)string2, (Object)string4, (Object)string3);
                    if (string2 == null || !string2.equalsIgnoreCase(string) && !string.equalsIgnoreCase(string3) && !string.equalsIgnoreCase(string4)) continue;
                    this.logger.debug("getHostUPSSetup() - host found in setup: {}", (Object)uPSSetup.getGroup());
                    return uPSSetup;
                }
            }
            this.logger.warn("getHostUPSSetup() - host: {} not found in setup", (Object)string);
        }
        return null;
    }

    public void saveMappedHostsToConfig(PageContext pageContext) {
        LinkedHashMap<String, MappedHost> linkedHashMap = this.utils.readMappedHostsFromRequest(pageContext.getPostQueryValues());
        if (linkedHashMap != null) {
            linkedHashMap = this.vsanUtils.checkVsanConfigurationOfMappedHosts(linkedHashMap);
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.addAll(linkedHashMap.keySet());
            this.hostSystemUtils.saveDefaultVCSAShutdownDuration(arrayList);
        }
        this.saveMappedHostsToConfig(linkedHashMap);
    }

    /*
     * WARNING - void declaration
     */
    public void saveMappedHostsToConfig(LinkedHashMap<String, MappedHost> linkedHashMap) {
        if (linkedHashMap == null) {
            return;
        }
        this.logger.debug("saveMappedHostsToConfig() - start");
        boolean bl = this.getSingleUPSSetupSetting();
        List<UPSSetup> list = this.readUPSSetupsFromConfig();
        VMSettings vMSettings = this.utils.readVMSettingsFromConfigAndCluster();
        int n = 0;
        boolean bl2 = false;
        bl2 = this.configurationManager.isAutoSave();
        this.configurationManager.setAutoSave(false);
        for (UPSSetup uPSSetup : list) {
            StringBuffer stringBuffer = new StringBuffer();
            String string = null;
            if (bl) {
                if (uPSSetup.getNMCList().size() > 0) {
                    string = uPSSetup.getNMCList().get(0);
                }
            } else {
                string = uPSSetup.getName();
            }
            if (string != null) {
                for (MappedHost object : linkedHashMap.values()) {
                    if ((!bl || !string.equalsIgnoreCase(object.getNMCIPAddress())) && (bl || !string.equalsIgnoreCase(object.getSetupName()))) continue;
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append("|");
                    }
                    stringBuffer.append(this.checkVsanConfiguration(object));
                    if (!bl || object.getOutletGroupNumber() == null) continue;
                    stringBuffer.append("&");
                    stringBuffer.append(object.getOutletGroupNumber());
                }
            }
            String string2 = ConfigurationKeys.getAdvancedSetupKey(n);
            if (stringBuffer.length() > 0) {
                void var12_16;
                Object bl3 = null;
                try {
                    String string3 = this.configurationManager.getString(string2, "hostlist");
                }
                catch (ConversionException conversionException) {
                    this.logger.debug((Object)conversionException);
                    Object var12_15 = null;
                }
                if (var12_16 == null || var12_16.trim().isEmpty()) {
                    this.utils.saveVMSettingsToConfig(vMSettings, uPSSetup.getName());
                    this.configurationManager.setProperty(string2, "ShutdownVirtualHosts", false);
                    this.configurationManager.setProperty(string2, "shutdownPowerchuteServer", false);
                }
                this.configurationManager.setProperty(string2, "hostlist", stringBuffer.toString());
            } else {
                this.configurationManager.clearProperty(string2, "hostlist");
                this.configurationManager.clearProperty(string2, "enable_guest_vm_migration");
                this.configurationManager.clearProperty(string2, "guest_vm_migration_duration");
                this.configurationManager.clearProperty(string2, "enable_custom_target_vm_migration");
                this.configurationManager.clearProperty(string2, "custom_target_hosts");
                this.configurationManager.clearProperty(string2, "enable_guest_vm_vapp_shutdown");
                this.configurationManager.clearProperty(string2, "guest_vm_vapp_shutdown_duration");
                this.configurationManager.clearProperty(string2, "guest_vm_vapp_startup_duration");
                this.configurationManager.clearProperty(string2, "enable_guest_vm_vapp_startup");
                this.configurationManager.clearProperty(string2, "force_VApp_shutdown");
                this.configurationManager.clearProperty(string2, "enable_host_maintenance");
                this.configurationManager.clearProperty(string2, "host_maintenance_duration");
                this.configurationManager.clearProperty(string2, "enable_host_shutdown");
                this.configurationManager.clearProperty(string2, "host_shutdown_duration");
                if (!this.configurationManager.containsKey(string2, "ShutdownVirtualHosts")) {
                    boolean bl3 = !this.virtualConfigurationManager.isPCNSInstalledOnVMA();
                    this.configurationManager.setProperty(string2, "ShutdownVirtualHosts", bl3);
                    this.configurationManager.setProperty(string2, "shutdownPowerchuteServer", bl3);
                }
            }
            ++n;
        }
        if (bl2) {
            this.configurationManager.setAutoSave(true);
            this.configurationManager.save();
        }
        if (this.virtualConfigurationManager.isESXi()) {
            this.utils.hasVCLSBeenDetectedOnTheCluster();
        }
    }

    private String checkVsanConfiguration(MappedHost mappedHost) {
        String string = null;
        string = mappedHost.isVsanHost() ? VsanUtils.addVsanTagToHostname(mappedHost.getHostIPAddress()) : (mappedHost.isVsanWitnessHost() ? VsanUtils.addVsanWitnessTagToHostname(mappedHost.getHostIPAddress()) : mappedHost.getHostIPAddress());
        return string;
    }

    public Map<String, MappedHost> readMappedHostsFromConfig() {
        HashMap<String, MappedHost> hashMap = new HashMap<String, MappedHost>();
        for (String string : this.configurationManager.getSections()) {
            String[] stringArray;
            if (!string.startsWith("advanced_ups_setup_")) continue;
            String string2 = null;
            try {
                string2 = this.configurationManager.getString(string, "ip_addresses");
            }
            catch (ConversionException conversionException) {
                this.logger.debug((Object)conversionException);
                continue;
            }
            if (string2.contains("|")) {
                string2 = null;
            }
            String string3 = null;
            try {
                string3 = this.configurationManager.getString(string, "setup_name");
            }
            catch (ConversionException conversionException) {
                this.logger.debug((Object)conversionException);
                continue;
            }
            String string4 = null;
            try {
                string4 = this.configurationManager.getString(string, "hostlist");
            }
            catch (ConversionException conversionException) {
                this.logger.debug((Object)conversionException);
                string4 = null;
            }
            if (string4 == null || (string4 = string4.trim()).isEmpty()) continue;
            for (String string5 : stringArray = string4.split("\\|")) {
                String[] stringArray2 = string5.split("&");
                MappedHost mappedHost = new MappedHost(stringArray2[0], string3, string2);
                if (stringArray2.length > 1) {
                    try {
                        mappedHost.setOutletGroupNumber(Integer.valueOf(stringArray2[1]));
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.logger.debug((Object)numberFormatException);
                    }
                }
                hashMap.put(stringArray2[0], mappedHost);
            }
        }
        return this.vsanUtils.removeVsanTagsFromMappedHosts(hashMap);
    }

    private void readVSanUPSSetupFromConfig(ConfigurationManager configurationManager, UPSSetup uPSSetup, String string) {
        Comparable<Boolean> comparable;
        try {
            comparable = configurationManager.getBoolean(string, "enable_vsan_ftt");
            uPSSetup.getVMSettings().setFttEnabled((Boolean)comparable);
        }
        catch (ConversionException conversionException) {
            this.logger.debug((Object)conversionException);
        }
        catch (NoSuchElementException noSuchElementException) {
            this.logger.trace((Object)noSuchElementException);
        }
        try {
            comparable = configurationManager.getInt(string, "vsan_ftt_level");
            uPSSetup.getVMSettings().setFttLevel((Integer)comparable);
        }
        catch (ConversionException conversionException) {
            this.logger.debug((Object)conversionException);
        }
        catch (NoSuchElementException noSuchElementException) {
            this.logger.trace((Object)noSuchElementException);
        }
        try {
            comparable = configurationManager.getBoolean(string, "shutdown_all_vsan_vms");
            uPSSetup.getVMSettings().setShutdownAllClusterVMsEnabled((Boolean)comparable);
        }
        catch (ConversionException conversionException) {
            this.logger.debug((Object)conversionException);
        }
        catch (NoSuchElementException noSuchElementException) {
            this.logger.trace((Object)noSuchElementException);
        }
        try {
            comparable = configurationManager.getInt(string, "vsan_sync_timeout");
            uPSSetup.getVMSettings().setVsanSyncTimeout((Integer)comparable);
        }
        catch (ConversionException conversionException) {
            this.logger.debug((Object)conversionException);
        }
        catch (NoSuchElementException noSuchElementException) {
            this.logger.trace((Object)noSuchElementException);
        }
        try {
            comparable = configurationManager.getBoolean(string, "delay_maintenance_mode");
            uPSSetup.getVMSettings().setHostMaintenanceModeDelayed((Boolean)comparable);
        }
        catch (ConversionException conversionException) {
            this.logger.debug("readVSanUPSSetupFromConfig() - ConversionException with: {}", (Object)"delay_maintenance_mode");
        }
        catch (NoSuchElementException noSuchElementException) {
            this.logger.trace((Object)noSuchElementException);
        }
        try {
            comparable = configurationManager.getInt(string, "delay_maintenance_mode_timeout");
            uPSSetup.getVMSettings().setHostMaintenanceModeTimeout((Integer)comparable);
        }
        catch (ConversionException conversionException) {
            this.logger.debug("readVSanUPSSetupFromConfig() - ConversionException with: {}", (Object)"delay_maintenance_mode_timeout");
        }
        catch (NoSuchElementException noSuchElementException) {
            this.logger.trace((Object)noSuchElementException);
        }
        try {
            comparable = configurationManager.getInt(string, "vsan_prepare");
            uPSSetup.getVMSettings().setVsanPrepareDuration((Integer)comparable);
        }
        catch (ConversionException conversionException) {
            this.logger.debug("readVSanUPSSetupFromConfig() - ConversionException with: {}", (Object)"vsan_prepare");
        }
        catch (NoSuchElementException noSuchElementException) {
            this.logger.trace((Object)noSuchElementException);
        }
    }

    private void readNutanixUPSSetupFromConfig(ConfigurationManager configurationManager, UPSSetup uPSSetup, String string) {
        Constable constable;
        if (this.virtualConfigurationManager.isNutanixAHV()) {
            try {
                constable = configurationManager.getInt(string, "uvm_shutdown_duration");
                uPSSetup.getVMSettings().setGuestVMVappShutdownDuration((Integer)constable);
            }
            catch (ConversionException conversionException) {
                this.logger.debug((Object)conversionException);
            }
            catch (NoSuchElementException noSuchElementException) {
                this.logger.trace((Object)noSuchElementException);
            }
            try {
                constable = configurationManager.getBoolean(string, "uvm_startup_enable");
                uPSSetup.getVMSettings().setGuestVMVappStartupEnabled((Boolean)constable);
            }
            catch (ConversionException conversionException) {
                this.logger.debug((Object)conversionException);
            }
            catch (NoSuchElementException noSuchElementException) {
                this.logger.trace((Object)noSuchElementException);
            }
            try {
                constable = configurationManager.getInt(string, "uvm_startup_duration");
                uPSSetup.getVMSettings().setGuestVMVappStartupDuration((Integer)constable);
            }
            catch (ConversionException conversionException) {
                this.logger.debug((Object)conversionException);
            }
            catch (NoSuchElementException noSuchElementException) {
                this.logger.trace((Object)noSuchElementException);
            }
            try {
                constable = configurationManager.getInt(string, "uvm_poweroff_duration");
                uPSSetup.getVMSettings().setUvmPoweroffDuration((Integer)constable);
            }
            catch (ConversionException conversionException) {
                this.logger.debug((Object)conversionException);
            }
            catch (NoSuchElementException noSuchElementException) {
                this.logger.trace((Object)noSuchElementException);
            }
            try {
                constable = configurationManager.getInt(string, "uvm_forceoff_duration");
                uPSSetup.getVMSettings().setUvmForceoffDuration((Integer)constable);
            }
            catch (ConversionException conversionException) {
                this.logger.debug((Object)conversionException);
            }
            catch (NoSuchElementException noSuchElementException) {
                this.logger.trace((Object)noSuchElementException);
            }
        }
        try {
            constable = configurationManager.getInt(string, "cvm_shutdown_duration");
            uPSSetup.getVMSettings().setCvmShutdownDuration((Integer)constable);
        }
        catch (ConversionException conversionException) {
            this.logger.debug((Object)conversionException);
        }
        catch (NoSuchElementException noSuchElementException) {
            this.logger.trace((Object)noSuchElementException);
        }
        try {
            constable = configurationManager.getBoolean(string, "cvm_startup_enable");
            uPSSetup.getVMSettings().setCvmStartupEnable((Boolean)constable);
        }
        catch (ConversionException conversionException) {
            this.logger.debug((Object)conversionException);
        }
        catch (NoSuchElementException noSuchElementException) {
            this.logger.trace((Object)noSuchElementException);
        }
        try {
            constable = configurationManager.getInt(string, "cvm_startup_duration");
            uPSSetup.getVMSettings().setCvmStartupDuration((Integer)constable);
        }
        catch (ConversionException conversionException) {
            this.logger.debug((Object)conversionException);
        }
        catch (NoSuchElementException noSuchElementException) {
            this.logger.trace((Object)noSuchElementException);
        }
        try {
            constable = configurationManager.getInt(string, "cvm_connect_timeout");
            uPSSetup.getVMSettings().setCvmConnectTimeout((Integer)constable);
        }
        catch (ConversionException conversionException) {
            this.logger.debug((Object)conversionException);
        }
        catch (NoSuchElementException noSuchElementException) {
            this.logger.trace((Object)noSuchElementException);
        }
        try {
            constable = configurationManager.getBoolean(string, "afs_shutdown_enable");
            uPSSetup.getVMSettings().setAfsShutdownEnable((Boolean)constable);
        }
        catch (ConversionException conversionException) {
            this.logger.debug((Object)conversionException);
        }
        catch (NoSuchElementException noSuchElementException) {
            this.logger.trace((Object)noSuchElementException);
        }
        try {
            constable = configurationManager.getInt(string, "afs_shutdown_duration");
            uPSSetup.getVMSettings().setAfsShutdownDuration((Integer)constable);
        }
        catch (ConversionException conversionException) {
            this.logger.debug((Object)conversionException);
        }
        catch (NoSuchElementException noSuchElementException) {
            this.logger.trace((Object)noSuchElementException);
        }
        try {
            constable = configurationManager.getBoolean(string, "afs_startup_enable");
            uPSSetup.getVMSettings().setAfsStartupEnable((Boolean)constable);
        }
        catch (ConversionException conversionException) {
            this.logger.debug((Object)conversionException);
        }
        catch (NoSuchElementException noSuchElementException) {
            this.logger.trace((Object)noSuchElementException);
        }
        try {
            constable = configurationManager.getInt(string, "afs_startup_duration");
            uPSSetup.getVMSettings().setAfsStartupDuration((Integer)constable);
        }
        catch (ConversionException conversionException) {
            this.logger.debug((Object)conversionException);
        }
        catch (NoSuchElementException noSuchElementException) {
            this.logger.trace((Object)noSuchElementException);
        }
        try {
            constable = configurationManager.getBoolean(string, "ongoing_replication_abort_delay_enable");
            uPSSetup.getVMSettings().setOngoingReplicationAbortDelayEnable((Boolean)constable);
        }
        catch (ConversionException conversionException) {
            this.logger.debug((Object)conversionException);
        }
        catch (NoSuchElementException noSuchElementException) {
            this.logger.trace((Object)noSuchElementException);
        }
        try {
            constable = configurationManager.getInt(string, "ongoing_replication_abort_delay_duration");
            uPSSetup.getVMSettings().setOngoingReplicationAbortDelayDuration((Integer)constable);
        }
        catch (ConversionException conversionException) {
            this.logger.debug((Object)conversionException);
        }
        catch (NoSuchElementException noSuchElementException) {
            this.logger.trace((Object)noSuchElementException);
        }
        try {
            constable = configurationManager.getInt(string, "ongoing_replication_abort_command_duration");
            uPSSetup.getVMSettings().setOngoingReplicationAbortCommandDuration((Integer)constable);
        }
        catch (ConversionException conversionException) {
            this.logger.debug((Object)conversionException);
        }
        catch (NoSuchElementException noSuchElementException) {
            this.logger.trace((Object)noSuchElementException);
        }
        if (this.virtualConfigurationManager.isNutanixESXi()) {
            try {
                constable = configurationManager.getBoolean(string, "metro_availability_disable");
                uPSSetup.getVMSettings().setMetroAvailDisabled((Boolean)constable);
            }
            catch (ConversionException conversionException) {
                this.logger.debug((Object)conversionException);
            }
            catch (NoSuchElementException noSuchElementException) {
                this.logger.trace((Object)noSuchElementException);
            }
            try {
                constable = configurationManager.getBoolean(string, "metro_availability_re-enable");
                uPSSetup.getVMSettings().setMetroAvailReEnabled((Boolean)constable);
            }
            catch (ConversionException conversionException) {
                this.logger.debug((Object)conversionException);
            }
            catch (NoSuchElementException noSuchElementException) {
                this.logger.trace((Object)noSuchElementException);
            }
        }
        try {
            constable = configurationManager.getInt(string, "cluster_shutdown_duration");
            uPSSetup.getVMSettings().setClusterShutdownDuration((Integer)constable);
        }
        catch (ConversionException conversionException) {
            this.logger.debug((Object)conversionException);
        }
        catch (NoSuchElementException noSuchElementException) {
            this.logger.trace((Object)noSuchElementException);
        }
        try {
            constable = configurationManager.getInt(string, "cluster_startup_duration");
            uPSSetup.getVMSettings().setClusterStartupDuration((Integer)constable);
        }
        catch (ConversionException conversionException) {
            this.logger.debug((Object)conversionException);
        }
        catch (NoSuchElementException noSuchElementException) {
            this.logger.trace((Object)noSuchElementException);
        }
    }

    private void saveNutanixUPSSetupToConfig(ConfigurationManager configurationManager, UPSSetup uPSSetup, String string) {
        if (this.virtualConfigurationManager.isNutanixAHV()) {
            configurationManager.setProperty(string, "uvm_shutdown_duration", uPSSetup.getVMSettings().getGuestVMVappShutdownDuration());
            configurationManager.setProperty(string, "uvm_startup_enable", uPSSetup.getVMSettings().isGuestVMVappStartupEnabled());
            configurationManager.setProperty(string, "uvm_startup_duration", uPSSetup.getVMSettings().getGuestVMVappShutdownDuration());
            if (!configurationManager.containsKey(string, "uvm_poweroff_duration")) {
                configurationManager.setProperty(string, "uvm_poweroff_duration", uPSSetup.getVMSettings().getUvmPoweroffDuration());
            }
            if (!configurationManager.containsKey(string, "uvm_forceoff_duration")) {
                configurationManager.setProperty(string, "uvm_forceoff_duration", uPSSetup.getVMSettings().getUvmForceoffDuration());
            }
        }
        configurationManager.setProperty(string, "cvm_shutdown_duration", uPSSetup.getVMSettings().getCvmShutdownDuration());
        configurationManager.setProperty(string, "cvm_startup_enable", uPSSetup.getVMSettings().isCvmStartupEnable());
        configurationManager.setProperty(string, "cvm_startup_duration", uPSSetup.getVMSettings().getCvmStartupDuration());
        if (!configurationManager.containsKey(string, "cvm_connect_timeout")) {
            configurationManager.setProperty(string, "cvm_connect_timeout", uPSSetup.getVMSettings().getCvmConnectTimeout());
        }
        configurationManager.setProperty(string, "afs_shutdown_enable", uPSSetup.getVMSettings().isAfsShutdownEnable());
        configurationManager.setProperty(string, "afs_shutdown_duration", uPSSetup.getVMSettings().getAfsShutdownDuration());
        configurationManager.setProperty(string, "afs_startup_enable", uPSSetup.getVMSettings().isAfsStartupEnable());
        configurationManager.setProperty(string, "afs_startup_duration", uPSSetup.getVMSettings().getAfsStartupDuration());
        configurationManager.setProperty(string, "ongoing_replication_abort_delay_enable", uPSSetup.getVMSettings().isOngoingReplicationAbortDelayEnable());
        configurationManager.setProperty(string, "ongoing_replication_abort_delay_duration", uPSSetup.getVMSettings().getOngoingReplicationAbortDelayDuration());
        configurationManager.setProperty(string, "ongoing_replication_abort_command_duration", uPSSetup.getVMSettings().getOngoingReplicationAbortCommandDuration());
        if (this.virtualConfigurationManager.isNutanixESXi()) {
            configurationManager.setProperty(string, "metro_availability_disable", uPSSetup.getVMSettings().isMetroAvailDisabled());
            configurationManager.setProperty(string, "metro_availability_re-enable", uPSSetup.getVMSettings().isMetroAvailReEnabled());
            if (!configurationManager.containsKey(string, "metro_availability_re-enable")) {
                configurationManager.setProperty(string, "metro_availability_re-enable", uPSSetup.getVMSettings().isMetroAvailReEnabled());
            }
        }
        configurationManager.setProperty(string, "cluster_shutdown_duration", uPSSetup.getVMSettings().getClusterShutdownDuration());
        configurationManager.setProperty(string, "cluster_startup_duration", uPSSetup.getVMSettings().getClusterStartupDuration());
    }

    public boolean isShutdownVirtualHostsEnabled(int n) {
        boolean bl = false;
        String string = "advanced_ups_setup_" + n;
        try {
            if (this.configurationManager.containsKey(string, "ShutdownVirtualHosts")) {
                bl = this.configurationManager.getBoolean(string, "ShutdownVirtualHosts", bl);
            }
        }
        catch (Exception exception) {
            this.logger.error((Object)exception);
        }
        this.logger.debug("isShutdownVirtualHostsEnabled() - ShutdownVirtualHosts: {}, ups_setup_idx: {}", (Object)bl, (Object)n);
        return bl;
    }

    public boolean isAdvancedNonPhysical(int n) {
        return this.isAdvancedShutdownMode() && !this.isPhysicalUPS(n);
    }

    public boolean isPhysicalUPS(int n) {
        String string;
        boolean bl = false;
        String string2 = "advanced_ups_setup_" + n;
        if (this.configurationManager.containsKey(string2, "hostlist") && StringUtils.isBlank((CharSequence)(string = this.configurationManager.getString(string2, "hostlist")))) {
            bl = true;
        }
        this.logger.debug("isPhysicalUPS() - isPhysicalUPS: {}, ups_setup_idx: {}", (Object)bl, (Object)n);
        return bl;
    }

    public void removeHostsFromAdvancedConfig(List<String> list) {
        this.logger.debug("removeHostsFromAdvancedConfig() - start, hosts: {}", list);
        List<UPSSetup> list2 = this.readUPSSetupsFromConfig();
        for (String string : list) {
            for (UPSSetup uPSSetup : list2) {
                boolean bl = false;
                String string2 = null;
                Iterator<String> iterator = uPSSetup.getHostsMap().keySet().iterator();
                while (iterator.hasNext()) {
                    String string3 = string2 = iterator.next();
                    if (VsanUtils.isHostnameWithVsanTags(string2)) {
                        string3 = VsanUtils.removeVsanTagsFromHostname(string2);
                    }
                    if (!string3.equals(string)) continue;
                    bl = true;
                    break;
                }
                if (!bl || string2 == null) continue;
                uPSSetup.getHostsMap().remove(string2);
            }
        }
        this.saveUPSSetupsToConfig(list2);
    }

    public Set<Integer> getGroupsOutOfMaintenanceMode(LinkedHashSet<String> linkedHashSet, List<String> list) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        this.logger.debug("getGroupsOutOfMaintenanceMode() - start, unlockedHosts: {}, recoveredHosts: {}", linkedHashSet, list);
        if (!linkedHashSet.isEmpty()) {
            this.logger.debug("getGroupsOutOfMaintenanceMode() - hosts: {} still unlocked / in maintenance mode", linkedHashSet);
        }
        for (String string : list) {
            UPSSetup uPSSetup = this.getHostUPSSetup(string);
            if (uPSSetup == null || uPSSetup.getHosts() == null) continue;
            LinkedHashSet<String> linkedHashSet2 = this.vsanUtils.removeVsanTagsFromSet(uPSSetup.getHosts());
            this.logger.debug("getGroupsOutOfMaintenanceMode() - checking setup hosts: {}", linkedHashSet2);
            if (!CollectionUtils.containsAny(linkedHashSet, linkedHashSet2)) {
                this.logger.debug("getGroupsOutOfMaintenanceMode() - adding group: {}", (Object)uPSSetup.getGroup());
                hashSet.add(uPSSetup.getGroup());
                continue;
            }
            this.logger.debug("getGroupsOutOfMaintenanceMode() - not adding group: {}, host(s) still unlocked / in maintenance mode", (Object)uPSSetup.getGroup());
        }
        this.logger.debug("getGroupsOutOfMaintenanceMode() - end, result: {}", hashSet);
        return hashSet;
    }

    public List<String> readVsanHostsFromConfig() {
        this.logger.debug("readVsanHostsFromConfig() - start");
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (this.configurationManager.containsKey("advanced_ups_setup_" + n, "hostlist")) {
            String string = this.configurationManager.getString("advanced_ups_setup_" + n, "hostlist");
            if (StringUtils.isNotBlank((CharSequence)string)) {
                String[] stringArray;
                for (String string2 : stringArray = string.split("\\|")) {
                    String[] stringArray2 = string2.split("&");
                    arrayList.add(stringArray2[0]);
                }
            }
            ++n;
        }
        return arrayList;
    }

    @Generated
    public void setHostSystemUtils(@NonNull HostSystemUtils hostSystemUtils) {
        if (hostSystemUtils == null) {
            throw new IllegalArgumentException("hostSystemUtils is marked non-null but is null");
        }
        this.hostSystemUtils = hostSystemUtils;
    }

    @Generated
    public void setVirtualConfigurationManager(@NonNull VirtualConfigurationManager virtualConfigurationManager) {
        if (virtualConfigurationManager == null) {
            throw new IllegalArgumentException("virtualConfigurationManager is marked non-null but is null");
        }
        this.virtualConfigurationManager = virtualConfigurationManager;
    }

    @Generated
    public void setConfigurationManager(@NonNull ConfigurationManager configurationManager) {
        if (configurationManager == null) {
            throw new IllegalArgumentException("configurationManager is marked non-null but is null");
        }
        this.configurationManager = configurationManager;
    }

    @Generated
    public void setUtils(Utils utils) {
        this.utils = utils;
    }

    @Generated
    public void setVsanUtils(VsanUtils vsanUtils) {
        this.vsanUtils = vsanUtils;
    }
}

