/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.util;

import com.apcc.m11.components.webserver.cfgwizard.Setting;
import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.configservice.ConfigurationKeys;
import com.apcc.pcns.configservice.VirtualConfigurationManager;
import com.apcc.pcns.configservice.configurationmanagers.ConfigurationManager;
import javax.servlet.http.HttpSession;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CfgWizardHelper {
    private static final Logger logger = LogManager.getLogger(CfgWizardHelper.class);

    public static Integer getUPSConfiguration(PageContext pageContext) {
        Integer n = null;
        Object object = pageContext.getSession().getAttribute(Setting.UpsConfig.toString());
        if (object != null) {
            try {
                n = Integer.valueOf(object.toString());
            }
            catch (NumberFormatException numberFormatException) {
                logger.error((Object)numberFormatException);
            }
        }
        return n;
    }

    public static String getNetworkConfiguration(HttpSession httpSession) {
        String string = null;
        Object object = httpSession.getAttribute(Setting.UpsNetworkConfig.toString());
        if (object != null) {
            string = object.toString();
        }
        return string;
    }

    public static String getIPv6Configuration(PageContext pageContext) {
        String string = null;
        Object object = pageContext.getSession().getAttribute(Setting.IPv6NetworkConfiguration.toString());
        if (object != null) {
            string = object.toString();
        }
        return string;
    }

    public static void removeGlobalVMSettingsFromConfig(ConfigurationManager configurationManager) {
        boolean bl = false;
        bl = configurationManager.isAutoSave();
        configurationManager.setAutoSave(false);
        String string = "HostConfigSettings";
        configurationManager.clearProperty(string, "enable_guest_vm_migration");
        configurationManager.clearProperty(string, "guest_vm_migration_duration");
        configurationManager.clearProperty(string, "enable_guest_vm_vapp_shutdown");
        configurationManager.clearProperty(string, "guest_vm_vapp_shutdown_duration");
        configurationManager.clearProperty(string, "guest_vm_vapp_startup_duration");
        configurationManager.clearProperty(string, "enable_guest_vm_vapp_startup");
        configurationManager.clearProperty(string, "force_VApp_shutdown");
        configurationManager.clearProperty(string, "ShutdownVirtualHosts");
        configurationManager.clearProperty(string, "VCSA_shutdown_duration");
        configurationManager.clearProperty(string, "apply_vm_settings_to_all_nmcs");
        configurationManager.clearProperty(string, "startup_waits_for_all_hosts_online");
        configurationManager.clearProperty(string, ConfigurationKeys.ENABLE_PLUGIN);
        configurationManager.clearProperty(string, ConfigurationKeys.PLUGIN_EXTENSION_KEY);
        configurationManager.clearProperty(string, ConfigurationKeys.PLUGIN_TYPE);
        configurationManager.clearProperty(string, "hostlist");
        configurationManager.clearProperty(string, "single_ups_groups_only");
        configurationManager.clearProperty(string, "enable_host_maintenance");
        configurationManager.clearProperty(string, "host_maintenance_duration");
        configurationManager.clearProperty(string, "enable_host_shutdown");
        configurationManager.clearProperty(string, "host_shutdown_duration");
        configurationManager.clearProperty(string, "vm_startup_delay_duration");
        configurationManager.clearProperty(string, "delay_maintenance_mode");
        configurationManager.clearProperty(string, "delay_maintenance_mode_timeout");
        configurationManager.clearProperty(string, "vsan_sync_retry_limit");
        configurationManager.clearProperty(string, "vsan_sync_timeout");
        configurationManager.clearProperty(string, "vm_startup_rescan_hba_duration");
        configurationManager.clearProperty(string, "witness_vm_startup_duration");
        configurationManager.save();
        if (bl) {
            configurationManager.setAutoSave(true);
        }
    }

    public static void addExitMaintenanceModeAndVCSAConnectionDelaystoConfig(ConfigurationManager configurationManager) {
        if (!configurationManager.containsKey("HostConfigSettings", "delay_after_exit_maintenance_mode")) {
            configurationManager.setProperty("HostConfigSettings", "delay_after_exit_maintenance_mode", 30);
        }
        if (!configurationManager.containsKey("HostConfigSettings", "delay_after_vcsa_powered_on_and_connected")) {
            configurationManager.setProperty("HostConfigSettings", "delay_after_vcsa_powered_on_and_connected", 30);
        }
    }

    public static void removeExitMaintenanceModeAndVCSAConnetionDelaysFromConfig() {
        ConfigurationManager configurationManager = ServiceManager.getInstance().getConfigurationManager();
        configurationManager.clearProperty("HostConfigSettings", "delay_after_exit_maintenance_mode");
        configurationManager.clearProperty("HostConfigSettings", "delay_after_vcsa_powered_on_and_connected");
    }

    public static void addVMPrioritizationKeysToConfig(ConfigurationManager configurationManager, boolean bl) {
        boolean bl2 = false;
        bl2 = configurationManager.isAutoSave();
        configurationManager.setAutoSave(false);
        VirtualConfigurationManager virtualConfigurationManager = new VirtualConfigurationManager(configurationManager);
        if (!configurationManager.containsKey("HostConfigSettings", "vm_prioritization_enabled")) {
            configurationManager.setProperty("HostConfigSettings", "vm_prioritization_enabled", bl);
        }
        if (!configurationManager.containsKey("VMPrioritization", "vm_list_high")) {
            configurationManager.setProperty("VMPrioritization", "vm_list_high", "");
        }
        if (!configurationManager.containsKey("VMPrioritization", "vm_list_medium")) {
            configurationManager.setProperty("VMPrioritization", "vm_list_medium", "");
        }
        if (!configurationManager.containsKey("VMPrioritization", "vm_list_low")) {
            configurationManager.setProperty("VMPrioritization", "vm_list_low", "");
        }
        if (!configurationManager.containsKey("VMPrioritization", "vm_list_group_1")) {
            configurationManager.setProperty("VMPrioritization", "vm_list_group_1", "");
        }
        if (!configurationManager.containsKey("VMPrioritization", "vm_list_group_2")) {
            configurationManager.setProperty("VMPrioritization", "vm_list_group_2", "");
        }
        if (!configurationManager.containsKey("VMPrioritization", "vm_shutdown_duration_high")) {
            configurationManager.setProperty("VMPrioritization", "vm_shutdown_duration_high", 0);
        }
        if (!configurationManager.containsKey("VMPrioritization", "vm_shutdown_duration_medium")) {
            configurationManager.setProperty("VMPrioritization", "vm_shutdown_duration_medium", 0);
        }
        if (!configurationManager.containsKey("VMPrioritization", "vm_shutdown_duration_low")) {
            configurationManager.setProperty("VMPrioritization", "vm_shutdown_duration_low", 0);
        }
        if (!configurationManager.containsKey("VMPrioritization", "vm_shutdown_duration_group_1")) {
            configurationManager.setProperty("VMPrioritization", "vm_shutdown_duration_group_1", 0);
        }
        if (!configurationManager.containsKey("VMPrioritization", "vm_shutdown_duration_group_2")) {
            configurationManager.setProperty("VMPrioritization", "vm_shutdown_duration_group_2", 0);
        }
        if (!configurationManager.containsKey("VMPrioritization", "vm_shutdown_duration_none")) {
            configurationManager.setProperty("VMPrioritization", "vm_shutdown_duration_none", 0);
        }
        if (!virtualConfigurationManager.isNutanixAHV()) {
            if (!configurationManager.containsKey("VMPrioritization", "vm_migration_duration_high")) {
                configurationManager.setProperty("VMPrioritization", "vm_migration_duration_high", 0);
            }
            if (!configurationManager.containsKey("VMPrioritization", "vm_migration_duration_medium")) {
                configurationManager.setProperty("VMPrioritization", "vm_migration_duration_medium", 0);
            }
            if (!configurationManager.containsKey("VMPrioritization", "vm_migration_duration_low")) {
                configurationManager.setProperty("VMPrioritization", "vm_migration_duration_low", 0);
            }
            if (!configurationManager.containsKey("VMPrioritization", "vm_migration_duration_group_1")) {
                configurationManager.setProperty("VMPrioritization", "vm_migration_duration_group_1", 0);
            }
            if (!configurationManager.containsKey("VMPrioritization", "vm_migration_duration_group_2")) {
                configurationManager.setProperty("VMPrioritization", "vm_migration_duration_group_2", 0);
            }
            if (!configurationManager.containsKey("VMPrioritization", "vm_migration_duration_none")) {
                configurationManager.setProperty("VMPrioritization", "vm_migration_duration_none", 0);
            }
        }
        if (!configurationManager.containsKey("VMPrioritization", "vm_startup_duration_high")) {
            configurationManager.setProperty("VMPrioritization", "vm_startup_duration_high", 0);
        }
        if (!configurationManager.containsKey("VMPrioritization", "vm_startup_duration_medium")) {
            configurationManager.setProperty("VMPrioritization", "vm_startup_duration_medium", 0);
        }
        if (!configurationManager.containsKey("VMPrioritization", "vm_startup_duration_low")) {
            configurationManager.setProperty("VMPrioritization", "vm_startup_duration_low", 0);
        }
        if (!configurationManager.containsKey("VMPrioritization", "vm_startup_duration_group_1")) {
            configurationManager.setProperty("VMPrioritization", "vm_startup_duration_group_1", 0);
        }
        if (!configurationManager.containsKey("VMPrioritization", "vm_startup_duration_group_2")) {
            configurationManager.setProperty("VMPrioritization", "vm_startup_duration_group_2", 0);
        }
        if (!configurationManager.containsKey("VMPrioritization", "vm_startup_duration_none")) {
            configurationManager.setProperty("VMPrioritization", "vm_startup_duration_none", 0);
        }
        configurationManager.save();
        if (bl2) {
            configurationManager.setAutoSave(true);
        }
    }

    public static void addVMPrioritizationKeysToConfig(boolean bl) {
        ConfigurationManager configurationManager = ServiceManager.getInstance().getConfigurationManager();
        CfgWizardHelper.addVMPrioritizationKeysToConfig(configurationManager, bl);
    }

    public static void removeExecuteCommandFileAfterHostShutdownFromConfig() {
        ConfigurationManager configurationManager = ServiceManager.getInstance().getConfigurationManager();
        CfgWizardHelper.removeExecuteCommandFileAfterHostShutdownFromConfig(configurationManager);
    }

    public static void removeExecuteCommandFileAfterHostShutdownFromConfig(ConfigurationManager configurationManager) {
        configurationManager.clearProperty("Shutdown", "executeCommandFileAfterHostShutdown");
        configurationManager.setProperty("Shutdown", "shutdownCommandFileDelay", 0);
    }

    public static void addExecuteCommandFileAfterHostShutdownToConfig() {
        ConfigurationManager configurationManager = ServiceManager.getInstance().getConfigurationManager();
        CfgWizardHelper.addExecuteCommandFileAfterHostShutdownToConfig(configurationManager);
    }

    public static void addExecuteCommandFileAfterHostShutdownToConfig(ConfigurationManager configurationManager) {
        if (!configurationManager.containsKey("Shutdown", "executeCommandFileAfterHostShutdown")) {
            configurationManager.setProperty("Shutdown", "executeCommandFileAfterHostShutdown", false);
            configurationManager.setProperty("Shutdown", "shutdownCommandFileDelay", 0);
        }
    }
}

