/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.util;

import com.apcc.m11.components.stdpowersource.OutletGroup;
import com.apcc.m11.components.webserver.html.Container;
import com.apcc.m11.components.webserver.html.HTML;
import com.apcc.m11.components.webserver.html.HTMLTagWithAlignClassStyle;
import com.apcc.m11.components.webserver.html.Text;
import com.apcc.m11.components.webserver.html.document.Division;
import com.apcc.m11.components.webserver.html.list.ListItem;
import com.apcc.m11.components.webserver.html.list.UnOrderedList;
import com.apcc.m11.components.webserver.html.util.Anchor;
import com.apcc.m11.components.webserver.model.MappedHost;
import com.apcc.m11.components.webserver.model.NMC;
import com.apcc.m11.components.webserver.model.UPSSetup;
import com.apcc.m11.components.webserver.util.InventoryTreeHelper;
import com.apcc.pcns.ServiceManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HostNMCMappingHelper
extends InventoryTreeHelper {
    private static final Logger logger = LogManager.getLogger(HostNMCMappingHelper.class);
    public static final String PARAM_MAPPED_HOST = "mappedHost";
    public static final String ATTR_MAPPED_HOSTS = "mappedHosts";
    public static final String HOST_NMC_MAPPING = "HostNMCMappingPage";
    private static final String REF_UPS = "ups";
    private static final String REF_UPS_NO_OUTLET = "ups_no_outlet";
    private static final String REF_OUTLET = "outlet";
    private static final String REF_UPS_GROUP = "upsgroup";
    private static final String REF_SINGLE_UPS = "singleups";
    private List<UPSSetup> UPSSetupList = new ArrayList<UPSSetup>();
    private List<NMC> NMCList = new ArrayList<NMC>();
    private Map<String, MappedHost> mappedHosts = new HashMap<String, MappedHost>();

    public HostNMCMappingHelper(List<UPSSetup> list, List<NMC> list2, Map<String, MappedHost> map, ServiceManager serviceManager) {
        super(serviceManager);
        this.UPSSetupList = list;
        this.NMCList = list2;
        this.mappedHosts = map;
        this.setMappedHostList(new ArrayList<String>(map.keySet()));
        this.refreshMappedHosts();
    }

    @Override
    public synchronized void refreshMappedHosts() {
        logger.debug("refreshMappedHosts:" + this.mappedHosts.toString());
        if (this.getHostList() != null) {
            Collection<MappedHost> collection = this.mappedHosts.values();
            Iterator<MappedHost> iterator = collection.iterator();
            while (iterator.hasNext()) {
                MappedHost mappedHost = iterator.next();
                if (mappedHost.getNMCIPAddress() == null) {
                    if (this.isExistingHost(mappedHost.getHostIPAddress())) continue;
                    this.hostsRemoved.add(mappedHost.getHostIPAddress());
                    iterator.remove();
                    continue;
                }
                if (this.isExistingNMC(mappedHost.getNMCIPAddress()) && this.isExistingHost(mappedHost.getHostIPAddress())) continue;
                this.hostsRemoved.add(mappedHost.getHostIPAddress());
                iterator.remove();
            }
        }
        logger.debug("refreshMappedHosts:" + this.mappedHosts.toString());
    }

    private NMC findNMC(String string) {
        NMC nMC = null;
        if (this.NMCList != null) {
            for (NMC nMC2 : this.NMCList) {
                if (!nMC2.getIPAddress().equalsIgnoreCase(string)) continue;
                nMC = nMC2;
                break;
            }
        }
        return nMC;
    }

    private boolean isExistingNMC(String string) {
        if (this.NMCList == null) {
            return false;
        }
        for (NMC nMC : this.NMCList) {
            if (!nMC.getIPAddress().equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public void displayUPSTree(Container container) {
        HTMLTagWithAlignClassStyle hTMLTagWithAlignClassStyle;
        Division division;
        logger.debug("displayUPSTree:" + String.valueOf(this.UPSSetupList));
        if (this.isHyperV()) {
            division = new Division();
            division.setId("hyperVFlag");
            division.setCssClass("hidden");
            container.add(division);
        } else if (this.isNutanixAHV() || this.isNutanixESXi()) {
            division = new Division();
            division.setId("nutanixFlag");
            division.setCssClass("hidden");
            container.add(division);
            hTMLTagWithAlignClassStyle = new Division();
            hTMLTagWithAlignClassStyle.setId("advancedFlag");
            hTMLTagWithAlignClassStyle.setCssClass("hidden");
            container.add(hTMLTagWithAlignClassStyle);
        }
        division = new Division();
        division.setId("mappedlist");
        division.setCssClass("treelist ui-corner-all");
        container.add(division);
        hTMLTagWithAlignClassStyle = new UnOrderedList();
        division.add(hTMLTagWithAlignClassStyle);
        boolean bl = this.services.getAdvancedSetupHelper().getSingleUPSSetupSetting();
        String string = "";
        for (UPSSetup uPSSetup : this.UPSSetupList) {
            ListItem listItem = new ListItem();
            hTMLTagWithAlignClassStyle.add(listItem);
            Anchor anchor = new Anchor();
            listItem.add(anchor);
            anchor.setHypertextReference("#");
            anchor.setCssClass("upslnk");
            anchor.add(new Text(uPSSetup.getNameEsc()));
            if (!bl) {
                listItem.setId(uPSSetup.getName());
                if (uPSSetup.getNMCList().size() > 1) {
                    listItem.setAttribute("rel", REF_UPS_GROUP);
                    listItem.setCssClass(REF_UPS_GROUP);
                    string = REF_UPS_GROUP;
                } else {
                    listItem.setAttribute("rel", REF_SINGLE_UPS);
                    listItem.setCssClass(REF_SINGLE_UPS);
                    string = REF_SINGLE_UPS;
                }
                var10_10 = null;
                var11_11 = new StringBuffer();
                var12_12 = uPSSetup.getNMCList().iterator();
                while (var12_12.hasNext()) {
                    var13_13 = (String)var12_12.next();
                    var10_10 = this.findNMC((String)var13_13);
                    if (var10_10 != null) {
                        if (((StringBuffer)var11_11).length() > 0) {
                            ((StringBuffer)var11_11).append("<br/>");
                        }
                        ((StringBuffer)var11_11).append(((NMC)var10_10).getIPAddress());
                        if (((NMC)var10_10).getFqdn() == null) continue;
                        ((StringBuffer)var11_11).append(" - ");
                        ((StringBuffer)var11_11).append(((NMC)var10_10).getFqdn());
                        continue;
                    }
                    logger.debug("Cant find nmc:" + (String)var13_13);
                }
                if (((StringBuffer)var11_11).length() > 0) {
                    anchor.setAttribute("title", ((StringBuffer)var11_11).toString());
                }
                if ((var12_12 = this.getUPSGroupMappedHosts(uPSSetup.getName())).size() > 0) {
                    var13_13 = new UnOrderedList();
                    listItem.add((HTML)var13_13);
                    this.displayMappedHosts((UnOrderedList)var13_13, var12_12);
                }
            } else {
                var10_10 = uPSSetup.getNMCList().get(0);
                listItem.setId((String)var10_10);
                var11_11 = this.findNMC((String)var10_10);
                if (var11_11 != null) {
                    var12_12 = new StringBuffer();
                    ((StringBuffer)((Object)var12_12)).append(((NMC)var11_11).getIPAddress());
                    if (((NMC)var11_11).getFqdn() != null) {
                        ((StringBuffer)((Object)var12_12)).append(" - ");
                        ((StringBuffer)((Object)var12_12)).append(((NMC)var11_11).getFqdn());
                    }
                    anchor.setAttribute("title", ((StringBuffer)((Object)var12_12)).toString());
                    var13_13 = ((NMC)var11_11).getOutletGroups();
                    if (var13_13 != null && !this.isNutanixAHV() && !this.isNutanixESXi()) {
                        listItem.setAttribute("rel", REF_UPS);
                        listItem.setCssClass(REF_UPS);
                        string = REF_UPS;
                        var14_14 = new UnOrderedList();
                        listItem.add((HTML)var14_14);
                        var15_15 = "";
                        Iterator iterator = ((Vector)var13_13).iterator();
                        while (iterator.hasNext()) {
                            OutletGroup outletGroup = (OutletGroup)iterator.next();
                            ListItem listItem2 = new ListItem();
                            listItem2.setAttribute("rel", REF_OUTLET);
                            listItem2.setCssClass(REF_OUTLET);
                            var15_15 = REF_OUTLET;
                            listItem2.setAttribute("outletgroupnumber", outletGroup.getGroupNumber().toString());
                            Anchor anchor2 = new Anchor();
                            anchor2.setHypertextReference("#");
                            anchor2.add(new Text(outletGroup.getName()));
                            listItem2.add(anchor2);
                            ((Container)var14_14).add(listItem2);
                            List<MappedHost> list = this.getUPSMappedHosts(((NMC)var11_11).getIPAddress(), outletGroup.getGroupNumber());
                            if (list.size() > 0) {
                                UnOrderedList unOrderedList = new UnOrderedList();
                                listItem2.add(unOrderedList);
                                this.displayMappedHosts(unOrderedList, list);
                            }
                            listItem2.setDataJstree((String)var15_15);
                        }
                    } else {
                        var14_14 = this.getUPSMappedHosts(((NMC)var11_11).getIPAddress(), null);
                        listItem.setAttribute("rel", REF_UPS_NO_OUTLET);
                        listItem.setCssClass(REF_UPS_NO_OUTLET);
                        string = REF_UPS_NO_OUTLET;
                        if (var14_14.size() > 0) {
                            var15_15 = new UnOrderedList();
                            listItem.add((HTML)var15_15);
                            this.displayMappedHosts((UnOrderedList)var15_15, (List<MappedHost>)var14_14);
                        }
                    }
                }
            }
            listItem.setDataJstree(string);
        }
    }

    private void displayMappedHosts(UnOrderedList unOrderedList, List<MappedHost> list) {
        String string = "";
        for (MappedHost mappedHost : list) {
            ListItem listItem = new ListItem();
            listItem.setAttribute("lnk", mappedHost.getHostIPAddress());
            boolean bl = this.isPCNSHost(mappedHost.getHostIPAddress());
            boolean bl2 = this.isVCSAHost(mappedHost.getHostIPAddress());
            if (bl2 && bl) {
                listItem.setAttribute("rel", "vcsapcnshost");
                listItem.setCssClass("host pcns vcsa");
                string = "vcsapcnshost";
            } else if (bl2) {
                listItem.setAttribute("rel", "vcsahost");
                listItem.setCssClass("host vcsa");
                string = "vcsahost";
            } else if (bl) {
                listItem.setAttribute("rel", "pcnshost");
                listItem.setCssClass("host pcns");
                string = "pcnshost";
            } else {
                listItem.setAttribute("rel", "host");
                listItem.setCssClass("host");
                string = "host";
            }
            Anchor anchor = new Anchor();
            anchor.setHypertextReference("#");
            Text text = new Text(mappedHost.getHostIPAddress());
            anchor.add(text);
            if (bl2 && bl) {
                anchor.setCssClass("vcsapcnshost");
            }
            listItem.setDataJstree(string);
            listItem.add(anchor);
            unOrderedList.add(listItem);
        }
    }

    private List<MappedHost> getUPSGroupMappedHosts(String string) {
        ArrayList<MappedHost> arrayList = new ArrayList<MappedHost>();
        for (MappedHost mappedHost : this.mappedHosts.values()) {
            if (!mappedHost.getSetupName().equalsIgnoreCase(string)) continue;
            arrayList.add(mappedHost);
        }
        return arrayList;
    }

    private List<MappedHost> getUPSMappedHosts(String string, Integer n) {
        ArrayList<MappedHost> arrayList = new ArrayList<MappedHost>();
        for (MappedHost mappedHost : this.mappedHosts.values()) {
            if (!mappedHost.getNMCIPAddress().equalsIgnoreCase(string) || n != null && !n.equals(mappedHost.getOutletGroupNumber())) continue;
            arrayList.add(mappedHost);
        }
        return arrayList;
    }
}

