/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.util;

import com.apcc.m11.components.stdpowersource.OutletGroup;
import com.apcc.m11.components.webserver.html.Container;
import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.html.Text;
import com.apcc.m11.components.webserver.html.apc.ApcHelp;
import com.apcc.m11.components.webserver.html.document.Division;
import com.apcc.m11.components.webserver.html.util.Image;
import com.apcc.m11.components.webserver.model.VMSettings;
import com.apcc.m11.components.webserver.util.HostNMCMappingHelper;
import com.apcc.m11.components.webserver.util.InventoryTreeHelper;
import com.apcc.m11.components.webserver.util.TargetHostSelectionHelper;
import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.m11.components.webserver.util.virtualization.vmware.VMWareConnection;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.util.ResourceBundleWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HostSelectionHTMLHelper {
    private static final Logger logger = LogManager.getLogger(HostSelectionHTMLHelper.class);
    private String theSCVMMNoHostsAvailableErrorText;
    private String theNoHostsAvailableErrorText;
    private String theNutanixNoHostsAvailableErrorText;
    private String thePCNSNotAvailableError;
    private String theVCSANotAvailableError;
    private String theVCSAHostOrVMNotFound;
    private String theVCSAVMPoweredOff;
    private String theHostsRemovedError;
    private String theNoHostsSelectedErrorText;
    private String theFoundPCNSOnVsanHostText;
    private String thePCNSHostWarningText;
    private String theRemoveButtonText;
    private String theResetButtonText;
    private String theApplyButtonText;
    private String theMultipleSelectionText;
    private String theWaitTitle;
    private String theWaitText;
    private String theVCenterAttemptToConnect;
    private String theConfirmCancelDialogTitleText;
    private String theConfirmCancelDialogText;
    private String theSCVMMAttemptToConnect;
    private String theNutanixAttemptToConnect;
    private String theAllHostsNotMappedWarning;
    private String theAllHostsNotMappedSameGroupWarning;
    private String thePcnsRunningOnVmOrHostWarning;
    private String theOutletPendingOffWarningText;
    private String theOutletPoweredOffWarningText;
    private String theOutletRegResultErrorText;
    private String theOutletRegResultText;
    private String theRegisterWithMultipleOGWarningText;
    private String theRegisterWithNoHostMappedWarningText;
    private String theOutletStateUnknownText;
    private String theOutletStateOffText;
    private String theOutletStateFixedText;
    private String theOutletStatePendingOffText;
    private String theOutletStateOnText;
    private String theYesButtonText;
    private String theNoButtonText;
    private String simplivityClusterConnectionError;
    private String collectvCenterRootCertError;
    private static final String kRemoveButton = "InventoryHostMapping.RemoveButton";
    private static final String kResetButton = "InventoryHostMapping.ResetButton";
    private static final String kApplyButton = "InventoryHostMapping.ApplyButton";
    private static final String kMultipleSelection = "InventoryHostMapping.MultipleSelection";
    private static final String kNoHostsSelectedError = "TargetHostSelection.NoHostsSelectedError";
    private static final String kPCNSFoundOnVsanHostError = "TargetHostSelection.PCNSRunningOnVsanHostWarning";
    private static final String kNoHostsAvailableError = "InventoryHostMapping.NoHostsAvailableError";
    private static final String kSCVMMNoHostsAvailableError = "Configure.SCVMMIPError";
    private static final String kNutanixNoHostsAvailableError = "Configure.NutanixClusterError";
    private static final String kPCNSHostWarning = "TargetHostSelection.PCNSHostNotSelectedWarning";
    private static final String COLLECT_VCENTER_ROOT_CERT_WARNING = "TargetHostSelection.CollectvCenterRootCertWarning";
    private static final String kWaitTitle = "PCNS.WaitTitle";
    private static final String kWaitText = "PCNS.WaitText";
    private static final String kHostsRemovedError = "InventoryHostMapping.hostsRemoved";
    private static final String kVCSANotAvailableError = "InventoryHostMapping.VCSANotAvailable";
    private static final String kPCNSNotAvailableError = "InventoryHostMapping.PCNSNotAvailable";
    private static final String kVCSAHostOrVMNotFound = "VCSANotFound.Log";
    private static final String kVCSAPoweredOff = "VCSAVMPoweredOff.Log";
    private static final String kOutletRegResult = "HostNMCMapping.OutletRegResult";
    private static final String kOutletRegResultError = "HostNMCMapping.OutletRegResultError";
    private static final String kOutletPoweredOffWarning = "HostNMCMapping.OutletPoweredOffWarning";
    private static final String kOutletPendingOffWarning = "HostNMCMapping.OutletPendingOffWarning";
    private static final String kOutletStateUnknown = "OutletState.Unknown";
    private static final String kOutletStateOn = "OutletState.On";
    private static final String kOutletStateOff = "OutletState.Off";
    private static final String kOutletStateFixed = "OutletState.Fixed";
    private static final String kOutletStatePendingOff = "OutletState.PendingOff";
    private static final String kVCenterAttemptToConnect = "CfgWizard.VCenterServerDetails.AttemptVCenterServerConnection";
    private static final String kSCVMMAttemptToConnect = "CfgWizard.HyperVServerDetails.AttemptHyperVConnection";
    private static final String kNutanixAttemptToConnect = "CfgWizard.NutanixClusterDetails.AttemptNutanixClusterConnection";
    private static final String kRegisterWithMixedUPSEnvWarning = "HostNMCMapping.RegisterWithMixedUPSEnvWarning";
    private static final String kRegisterWithMultipleOGWarning = "HostNMCMapping.RegisterWithMultipleOGWarning";
    private static final String kRegisterWithNoHostMappedWarning = "HostNMCMapping.RegisterWithNoHostMappedWarning";
    private static final String kConfirmCancelDialogTitle = "HostNMCMappig.ConfirmCancelDialogTitle";
    private static final String kConfirmCancelDialog = "HostNMCMappig.ConfirmCancelDialog";
    private static final String kAllHostsNotMappedWarning = "InventoryHostMapping.AllHostsNotMapped";
    private static final String kAllHostsNotMappedToSameGroup = "InventoryHostMapping.AllHostsNotMappedToSameGroup";
    private static final String kPcnsRunningOnVmOrHost = "InventoryHostMapping.PcnsRunningOnVmOrHost";
    private static final String kYesButton = "PCNS.YesButton";
    private static final String kNoButton = "PCNS.NoButton";
    public static final String IS_TARGET_HOST_PAGE = "isTargetHostPage";
    public static final String IS_MAIN_UI = "ismainui";
    public static final String IS_VM_SETTINGS_PAGE = "isvmsettings";
    public static final String IS_EMPTY_HOST_LIST = "emptyhostlist";
    public static final String IS_EMPTY_MAPPED_LIST = "emptymappedlist";
    private boolean isMainUi;
    private boolean isVMSettingsPage;
    private ServiceManager services;
    private VMWareConnection vmwareConnection;

    public HostSelectionHTMLHelper(Locale locale, boolean bl, boolean bl2, @NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        this.services = serviceManager;
        this.vmwareConnection = serviceManager.getVmWareConnection();
        this.isMainUi = bl;
        this.isVMSettingsPage = bl2;
        this.setupLanguage(locale);
    }

    public void createVCSAWarning(PageContext pageContext, Container container) {
        logger.debug("createVCSAWarning() - start");
        Integer n = this.vmwareConnection.getVCSAStatus();
        if (n == null || n < 0) {
            String string = this.theVCSANotAvailableError;
            if (VMWareConnection.VM_HOST_NOT_FOUND.equals(n) || VMWareConnection.VM_NOT_FOUND.equals(n)) {
                string = this.theVCSAHostOrVMNotFound;
            } else if (VMWareConnection.VM_POWERED_OFF.equals(n)) {
                string = this.theVCSAVMPoweredOff;
            }
            logger.debug("createVCSAWarning() - error: {}", (Object)string);
            string = string.replace("{0}", ApcHelp.getHelpAnchor(ApcHelp.VMWARE_TROUBLESHOOTING).toHTML(pageContext));
            Division division = new Division();
            division.setId("errorText");
            division.add(new Text(string));
            division.setCssClass("treemsg ui-state-error ui-corner-all");
            container.add(division);
        }
    }

    private void createEmptyHostListWarning(PageContext pageContext, Container container, InventoryTreeHelper inventoryTreeHelper) {
        logger.debug("createEmptyHostListWarning() - start");
        if (inventoryTreeHelper.getHostList() == null || inventoryTreeHelper.getHostList().isEmpty()) {
            String string;
            String string2 = "errorText";
            if (inventoryTreeHelper.isHyperV()) {
                string = this.theSCVMMNoHostsAvailableErrorText;
            } else if (inventoryTreeHelper.isNutanixAHV()) {
                string = this.theNutanixNoHostsAvailableErrorText;
            } else {
                string = this.theNoHostsAvailableErrorText;
                if (!this.vmwareConnection.isvCenterServerConnectionSuccessful()) {
                    logger.debug("createEmptyHostListWarning() - vCenter connection not available");
                    string2 = "vCenterErrorText";
                }
            }
            logger.debug("createEmptyHostListWarning() - error: {}", (Object)string);
            Division division = new Division();
            division.setId(string2);
            division.add(new Text(string));
            division.setCssClass("treemsg ui-state-error ui-corner-all");
            container.add(division);
        }
    }

    private void createVCenterVMWarning(PageContext pageContext, Container container, String string) {
        logger.debug("createVCenterVMWarning() - start");
        Integer n = this.vmwareConnection.getVMAStatus();
        if (n == null || n < 0) {
            String string2 = this.thePCNSNotAvailableError;
            if (VMWareConnection.VM_HOST_NOT_FOUND.equals(n) || VMWareConnection.VM_NOT_FOUND.equals(n) || VMWareConnection.VM_POWERED_OFF.equals(n)) {
                logger.debug("createVCenterVMWarning() - error: {}", (Object)string2);
                string2 = string2.replace("{0}", ApcHelp.getHelpAnchor(ApcHelp.VMWARE_TROUBLESHOOTING).toHTML(pageContext));
                Division division = new Division();
                division.setId("errorText");
                division.add(new Text(string2));
                division.setCssClass("treemsg ui-state-error ui-corner-all");
                container.add(division);
            }
        }
    }

    private void createHostsRemovedWarning(PageContext pageContext, Container container, InventoryTreeHelper inventoryTreeHelper) {
        List<String> list = inventoryTreeHelper.getHostsRemoved();
        if (list != null && list.size() > 0) {
            this.services.getVirtualConfigurationManager().removeHostsFromConfig(list);
            Division division = new Division();
            division.setId("errorText");
            this.theHostsRemovedError = this.theHostsRemovedError.replace("{0}", inventoryTreeHelper.getHostsRemovedAsString());
            division.add(new Text(this.theHostsRemovedError));
            division.setCssClass("treemsg ui-state-error ui-corner-all");
            container.add(division);
        }
    }

    public void createNoHostSelectedWarning(PageContext pageContext, Container container) {
        Division division = new Division();
        division.setId("validationText");
        Image image = new Image("/images/exclamation.gif");
        image.setCssClass("warningImg");
        division.add(image);
        division.add(new Text(this.theNoHostsSelectedErrorText));
        division.setCssClass("treemsg ui-state-default ui-corner-all");
        container.add(division);
    }

    private void createPCNSHostWarning(PageContext pageContext, Container container) {
        Image image = new Image("/images/exclamation.gif");
        image.setCssClass("warningImg");
        Division division = new Division();
        division.setId("PCNSHostWarning");
        division.add(image);
        division.add(new Text(this.thePCNSHostWarningText));
        division.setCssClass("treemsg ui-state-default ui-corner-all");
        container.add(division);
    }

    private void createvCenterCertWarning(PageContext pageContext, Container container) {
        Image image = new Image("/images/exclamation.gif");
        image.setCssClass("warningImg");
        Division division = new Division();
        division.setId("vCenterCertWarning");
        division.add(image);
        division.add(new Text(this.collectvCenterRootCertError));
        division.setCssClass("treemsg ui-state-default ui-corner-all");
        container.add(division);
    }

    public void createWaitMessage(PageContext pageContext, Container container) {
        Division division = new Division();
        division.setCssClass("waitDialog");
        division.setId("waitDialog");
        division.setTitle(this.theWaitTitle);
        division.add(new Text(this.theWaitText));
        container.add(division);
    }

    public void displayButtons(Container container, InventoryTreeHelper inventoryTreeHelper) {
        inventoryTreeHelper.displayButton(container, "deletebtn", this.theRemoveButtonText);
        if (!this.isVMSettingsPage) {
            inventoryTreeHelper.displayButton(container, "resetbtn", this.theResetButtonText);
            if (this.isMainUi) {
                inventoryTreeHelper.displayButton(container, "applybtn", this.theApplyButtonText);
            }
        }
    }

    public String getResource(String string) {
        return null;
    }

    private void setupLanguage(Locale locale) {
        ResourceBundleWrapper resourceBundleWrapper = Utils.getWebServerResourceBundle(locale);
        this.theRemoveButtonText = Utils.getResourceString(resourceBundleWrapper, kRemoveButton);
        this.theResetButtonText = Utils.getResourceString(resourceBundleWrapper, kResetButton);
        this.theApplyButtonText = Utils.getResourceString(resourceBundleWrapper, kApplyButton);
        this.theMultipleSelectionText = Utils.getResourceString(resourceBundleWrapper, kMultipleSelection);
        this.theNoHostsSelectedErrorText = Utils.getResourceString(resourceBundleWrapper, kNoHostsSelectedError);
        this.theFoundPCNSOnVsanHostText = Utils.getResourceString(resourceBundleWrapper, kPCNSFoundOnVsanHostError);
        this.theNoHostsAvailableErrorText = Utils.getResourceString(resourceBundleWrapper, kNoHostsAvailableError);
        this.theSCVMMNoHostsAvailableErrorText = Utils.getResourceString(resourceBundleWrapper, kSCVMMNoHostsAvailableError);
        this.theNutanixNoHostsAvailableErrorText = Utils.getResourceString(resourceBundleWrapper, kNutanixNoHostsAvailableError);
        this.thePCNSHostWarningText = Utils.getResourceString(resourceBundleWrapper, kPCNSHostWarning);
        this.theWaitTitle = Utils.getResourceString(resourceBundleWrapper, kWaitTitle);
        this.theWaitText = Utils.getResourceString(resourceBundleWrapper, kWaitText);
        this.theHostsRemovedError = Utils.getResourceString(resourceBundleWrapper, kHostsRemovedError);
        this.theVCSANotAvailableError = Utils.getResourceString(resourceBundleWrapper, kVCSANotAvailableError);
        this.thePCNSNotAvailableError = Utils.getResourceString(resourceBundleWrapper, kPCNSNotAvailableError);
        this.theVCSAHostOrVMNotFound = Utils.getResourceString(resourceBundleWrapper, kVCSAHostOrVMNotFound);
        this.theVCSAVMPoweredOff = Utils.getResourceString(resourceBundleWrapper, kVCSAPoweredOff);
        this.theVCenterAttemptToConnect = Utils.getResourceString(resourceBundleWrapper, kVCenterAttemptToConnect);
        this.theSCVMMAttemptToConnect = Utils.getResourceString(resourceBundleWrapper, kSCVMMAttemptToConnect);
        this.theNutanixAttemptToConnect = Utils.getResourceString(resourceBundleWrapper, kNutanixAttemptToConnect);
        this.theOutletRegResultText = Utils.getResourceString(resourceBundleWrapper, kOutletRegResult);
        this.theOutletRegResultErrorText = Utils.getResourceString(resourceBundleWrapper, kOutletRegResultError);
        this.theOutletPoweredOffWarningText = Utils.getResourceString(resourceBundleWrapper, kOutletPoweredOffWarning);
        this.theOutletPendingOffWarningText = Utils.getResourceString(resourceBundleWrapper, kOutletPendingOffWarning);
        this.theOutletStateUnknownText = Utils.getResourceString(resourceBundleWrapper, kOutletStateUnknown);
        this.theOutletStatePendingOffText = Utils.getResourceString(resourceBundleWrapper, kOutletStatePendingOff);
        this.theOutletStateFixedText = Utils.getResourceString(resourceBundleWrapper, kOutletStateFixed);
        this.theOutletStateOffText = Utils.getResourceString(resourceBundleWrapper, kOutletStateOff);
        this.theOutletStateOnText = Utils.getResourceString(resourceBundleWrapper, kOutletStateOn);
        Utils.getResourceString(resourceBundleWrapper, kRegisterWithMixedUPSEnvWarning);
        this.theRegisterWithMultipleOGWarningText = Utils.getResourceString(resourceBundleWrapper, kRegisterWithMultipleOGWarning);
        this.theRegisterWithNoHostMappedWarningText = Utils.getResourceString(resourceBundleWrapper, kRegisterWithNoHostMappedWarning);
        this.theConfirmCancelDialogTitleText = Utils.getResourceString(resourceBundleWrapper, kConfirmCancelDialogTitle);
        this.theConfirmCancelDialogText = Utils.getResourceString(resourceBundleWrapper, kConfirmCancelDialog);
        this.theAllHostsNotMappedWarning = Utils.getResourceString(resourceBundleWrapper, kAllHostsNotMappedWarning);
        this.theAllHostsNotMappedSameGroupWarning = Utils.getResourceString(resourceBundleWrapper, kAllHostsNotMappedToSameGroup);
        this.thePcnsRunningOnVmOrHostWarning = Utils.getResourceString(resourceBundleWrapper, kPcnsRunningOnVmOrHost);
        this.theYesButtonText = Utils.getResourceString(resourceBundleWrapper, kYesButton);
        this.theNoButtonText = Utils.getResourceString(resourceBundleWrapper, kNoButton);
        this.simplivityClusterConnectionError = Utils.getResourceString(resourceBundleWrapper, "CfgWizard.NutanixClusterDetails.NutanixClusterNetworkError");
        this.collectvCenterRootCertError = Utils.getResourceString(resourceBundleWrapper, COLLECT_VCENTER_ROOT_CERT_WARNING);
    }

    private void createPCNSRunningOnVsanHostWarning(Container container) {
        Image image = new Image("/images/exclamation.gif");
        image.setCssClass("warningImg");
        Division division = new Division();
        division.setId("PCNSInVsanClusterText");
        division.add(image);
        division.add(new Text(this.theFoundPCNSOnVsanHostText));
        division.setCssClass("treemsg ui-state-default ui-corner-all");
        container.add(division);
    }

    private void createPCNSRunningOnVmOrHostWarning(Container container) {
        Division division = new Division();
        division.setId("pcnsRunningOnVmOrHost");
        division.add(new Text(this.thePcnsRunningOnVmOrHostWarning));
        division.setCssClass("treemsg ui-state-error ui-corner-all");
        container.add(division);
    }

    public void createVMWareMessages(PageContext pageContext, Container container, InventoryTreeHelper inventoryTreeHelper) {
        this.createEmptyHostListWarning(pageContext, container, inventoryTreeHelper);
        this.createVCenterVMWarning(pageContext, container, inventoryTreeHelper.getPCNSHost());
        this.createPCNSHostWarning(pageContext, container);
        this.createvCenterCertWarning(pageContext, container);
        boolean bl = this.services.getVirtualConfigurationManager().isVxRail();
        if (this.services.getVirtualConfigurationManager().isESXi() && !bl && this.services.getVsanUtils().isPCNSInstalledOnVsanHost() && !this.services.getVirtualConfigurationManager().isSkipMaintenanceModeEnabled()) {
            this.createPCNSRunningOnVsanHostWarning(container);
        }
        if (this.services.getVirtualConfigurationManager().isNutanixESXi() && !this.isVMSettingsPage) {
            this.addAllHostsNotMappedWarning(container);
            if (inventoryTreeHelper.getPCNSHost() != null) {
                this.createPCNSRunningOnVmOrHostWarning(container);
            }
        }
        if (bl) {
            this.addAllHostsNotMappedWarning(container);
        }
        if (!this.isVMSettingsPage) {
            if (this.services.getVirtualConfigurationManager().isVCSA()) {
                this.createVCSAWarning(pageContext, container);
            }
            this.createHostsRemovedWarning(pageContext, container, inventoryTreeHelper);
        }
    }

    public void createSimplivityMessages(PageContext pageContext, Container container, InventoryTreeHelper inventoryTreeHelper) {
        this.addEmptyHostListWarning(pageContext, container, inventoryTreeHelper);
        this.addSimplivityValidationErrorDiv(container);
    }

    public void createNutanixMessages(PageContext pageContext, Container container, InventoryTreeHelper inventoryTreeHelper) {
        this.createEmptyHostListWarning(pageContext, container, inventoryTreeHelper);
        this.addAllHostsNotMappedWarning(container);
        this.addPcnsRunningOnVMOrHostWarning(container, inventoryTreeHelper);
    }

    private void addPcnsRunningOnVMOrHostWarning(Container container, InventoryTreeHelper inventoryTreeHelper) {
        if (this.services.getVirtualConfigurationManager().isPCNSInstalledOnAVM() || this.services.getVirtualConfigurationManager().isPCNSIntalledOnHostInList(inventoryTreeHelper.getHostList())) {
            Division division = new Division();
            division.setId("pcnsRunningOnVmOrHost");
            division.add(new Text(this.thePcnsRunningOnVmOrHostWarning));
            division.setCssClass("treemsg ui-state-error ui-corner-all");
            container.add(division);
        }
    }

    private void addSimplivityValidationErrorDiv(Container container) {
        Division division = new Division();
        division.setId("connectionError");
        division.setCssClass("treemsg ui-state-error ui-corner-all");
        division.add(new Text(this.simplivityClusterConnectionError));
        container.add(division);
    }

    private void addAllHostsNotMappedWarning(Container container) {
        Division division = new Division();
        division.setId("allHostsNotMappedWarning");
        if (this.services.getAdvancedSetupHelper().isAdvancedShutdownMode()) {
            division.add(new Text(this.theAllHostsNotMappedSameGroupWarning));
        } else {
            division.add(new Text(this.theAllHostsNotMappedWarning));
        }
        division.setCssClass("treemsg ui-state-error ui-corner-all");
        container.add(division);
    }

    private void addEmptyHostListWarning(PageContext pageContext, Container container, InventoryTreeHelper inventoryTreeHelper) {
        if (inventoryTreeHelper.getHostList() == null || inventoryTreeHelper.getHostList().isEmpty()) {
            this.createEmptyHostListWarning(pageContext, container, inventoryTreeHelper);
        }
    }

    public void createTargetHostSelectionLists(PageContext pageContext, Container container, Boolean bl) {
        TargetHostSelectionHelper targetHostSelectionHelper = null;
        if (this.services.getVirtualConfigurationManager().isNutanixAHV()) {
            if (bl.booleanValue()) {
                targetHostSelectionHelper = new TargetHostSelectionHelper(this.services.getVirtualConfigurationManager().parseHostListParameter("HostConfigSettings"), true, true, this.services);
            } else {
                targetHostSelectionHelper = new TargetHostSelectionHelper(new ArrayList<String>(), true, true, this.services);
                targetHostSelectionHelper.setMappedHostList(targetHostSelectionHelper.getHostList().stream().map(host -> host.getIPAddress()).collect(Collectors.toList()));
            }
        } else {
            targetHostSelectionHelper = new TargetHostSelectionHelper(this.services.getVirtualConfigurationManager().parseHostListParameter("HostConfigSettings"), true, true, this.services);
        }
        if (this.services.getVirtualConfigurationManager().isESXi()) {
            if (this.services.getVirtualConfigurationManager().isSimplivity()) {
                this.createSimplivityMessages(pageContext, container, targetHostSelectionHelper);
                this.createvCenterCertWarning(pageContext, container);
            } else {
                this.createVMWareMessages(pageContext, container, targetHostSelectionHelper);
            }
        } else if (this.services.getVirtualConfigurationManager().isNutanixAHV()) {
            this.createNutanixMessages(pageContext, container, targetHostSelectionHelper);
        }
        if (!this.isVMSettingsPage) {
            this.createNoHostSelectedWarning(pageContext, container);
        }
        this.createWaitMessage(pageContext, container);
        Division division = new Division();
        division.setId("multitree");
        container.add(division);
        Division division2 = new Division();
        division2.setId("res");
        division2.setCssClass("hidden");
        division2.setAttribute("data-ismainui", String.valueOf(bl));
        division2.setAttribute("data-emptyhostlist", String.valueOf(this.isEmptyHostList(targetHostSelectionHelper)));
        division2.setAttribute("data-emptymappedlist", String.valueOf(this.isEmptyMappedHostList(targetHostSelectionHelper)));
        targetHostSelectionHelper.addResourceString(division2, "res_multiple_selection", this.theMultipleSelectionText);
        targetHostSelectionHelper.addResourceString(division2, "res_yes_button", this.theYesButtonText);
        targetHostSelectionHelper.addResourceString(division2, "res_no_button", this.theNoButtonText);
        targetHostSelectionHelper.displayHostTree(division);
        targetHostSelectionHelper.displayTargetHostTree(division, false);
        this.displayButtons((Container)division, targetHostSelectionHelper);
        container.add(division2);
    }

    public void createCustomTargetHostLists(PageContext pageContext, Container container) {
        Division division = new Division();
        division.setId("multitree");
        VMSettings vMSettings = (VMSettings)pageContext.getSession().getAttribute("vm_settings");
        pageContext.getSession().setAttribute("vm_settings", null);
        if (vMSettings == null) {
            vMSettings = new VMSettings();
        }
        TargetHostSelectionHelper targetHostSelectionHelper = new TargetHostSelectionHelper(vMSettings.getMigrationTargetHosts(), true, false, this.services);
        this.createVMWareMessages(pageContext, container, targetHostSelectionHelper);
        this.createHostsRemovedWarning(pageContext, container, targetHostSelectionHelper);
        container.add(division);
        targetHostSelectionHelper.displayHostTree(division);
        targetHostSelectionHelper.displayTargetHostTree(division, false);
        this.displayButtons((Container)division, targetHostSelectionHelper);
    }

    public void createHostNMCMappingLists(PageContext pageContext, Container container, InventoryTreeHelper inventoryTreeHelper) {
        this.displayCancelButtonConfirmDialog(container);
        Division division = new Division();
        division.setId("multitree");
        container.add(division);
        ((HostNMCMappingHelper)inventoryTreeHelper).displayHostTree(division);
        ((HostNMCMappingHelper)inventoryTreeHelper).displayUPSTree(division);
        this.displayButtons((Container)division, inventoryTreeHelper);
        Division division2 = new Division();
        division2.setId("res");
        division2.setCssClass("hidden");
        inventoryTreeHelper.addResourceString(division2, "res_multiple_selection", this.theMultipleSelectionText);
        inventoryTreeHelper.addResourceString(division2, "res_yes_button", this.theYesButtonText);
        inventoryTreeHelper.addResourceString(division2, "res_no_button", this.theNoButtonText);
        division2.setAttribute("data-ismainui", String.valueOf(this.isMainUi));
        division2.setAttribute("data-emptyhostlist", String.valueOf(this.isEmptyHostList(inventoryTreeHelper)));
        division2.setAttribute("data-emptymappedlist", String.valueOf(this.isEmptyMappedHostList(inventoryTreeHelper)));
        container.add(division2);
    }

    private boolean isEmptyHostList(InventoryTreeHelper inventoryTreeHelper) {
        return inventoryTreeHelper == null || inventoryTreeHelper.getHostList() == null || inventoryTreeHelper.getHostList().isEmpty();
    }

    private boolean isEmptyMappedHostList(InventoryTreeHelper inventoryTreeHelper) {
        return inventoryTreeHelper == null || inventoryTreeHelper.getMappedHostList() == null || inventoryTreeHelper.getMappedHostList().isEmpty();
    }

    public void createConnectionWaitHTML(Container container) {
        Division division = new Division();
        division.setCssClass("checkConnectionDialog");
        division.setId("checkConnectionDialog");
        Division division2 = new Division();
        division2.setId("checkingConnection");
        division2.setCssClass("warningMsg ConnectionStatusWait");
        String string = "";
        string = this.services.getVirtualConfigurationManager().isNutanixAHV() ? this.theNutanixAttemptToConnect : (this.services.getVirtualConfigurationManager().isHyperV() ? this.theSCVMMAttemptToConnect : this.theVCenterAttemptToConnect);
        division2.add(new Text(string));
        division.add(division2);
        container.add(division);
    }

    public void displayOutletOffWarningDiv(Container container, PageContext pageContext) {
        List list = (List)pageContext.getSession().getAttribute("outlet_off");
        if (list != null) {
            Division division = new Division();
            container.add(division);
            division.setId("errorText");
            division.setCssClass("treemsg ui-state-error ui-corner-all");
            Division division2 = new Division();
            division.add(division2);
            division2.setCssClass("regresult");
            division2.add(new Text(this.theOutletPoweredOffWarningText));
            for (OutletGroup outletGroup : list) {
                Division division3 = new Division();
                division.add(division3);
                division3.setCssClass("regresult regresulterror");
                division3.add(new Text(this.getOutletGroupInfoStr(outletGroup)));
            }
        }
    }

    public void displayOutletPendingOffWarningDiv(Container container, PageContext pageContext) {
        List list = (List)pageContext.getSession().getAttribute("outlet_pending_off");
        if (list != null) {
            Division division = new Division();
            container.add(division);
            division.setId("waringText");
            division.setCssClass("treemsg ui-state-default ui-corner-all");
            Division division2 = new Division();
            division.add(division2);
            division2.setCssClass("regresult");
            division2.add(new Text(this.theOutletPendingOffWarningText));
            for (OutletGroup outletGroup : list) {
                Division division3 = new Division();
                division.add(division3);
                division3.setCssClass("regresult regresulterror");
                division3.add(new Text(this.getOutletGroupInfoStr(outletGroup)));
            }
        }
    }

    public void displayRegistrationResultDiv(Container container, PageContext pageContext) {
        List list = (List)pageContext.getSession().getAttribute("reg_error");
        List list2 = (List)pageContext.getSession().getAttribute("reg_success");
        pageContext.getSession().setAttribute("reg_error", null);
        pageContext.getSession().setAttribute("reg_success", null);
        if (list != null || list2 != null) {
            Division division;
            this.displayRegistrationWarnings(container, pageContext);
            Division division2 = new Division();
            division2.setId("regresultsdiv");
            container.add(division2);
            Division division3 = new Division();
            division2.add(division3);
            division3.setCssClass("regresult");
            if (list != null) {
                division2.setCssClass("treemsg ui-state-error ui-corner-all");
                division3.add(new Text(this.theOutletRegResultErrorText));
                for (OutletGroup outletGroup : list) {
                    division = new Division();
                    division2.add(division);
                    division.setCssClass("regresult regresulterror");
                    division.add(new Text(this.getOutletGroupInfoStr(outletGroup)));
                }
            }
            if (list2 != null) {
                if (list == null) {
                    division3.add(new Text(this.theOutletRegResultText));
                    division2.setCssClass("treemsg success ui-corner-all");
                }
                for (OutletGroup outletGroup : list2) {
                    division = new Division();
                    division2.add(division);
                    if (outletGroup.isSelected() && outletGroup.getState() == 3) {
                        division.setCssClass("regresult regresulterror");
                    } else {
                        division.setCssClass("regresult regresultsuccess");
                    }
                    division.add(new Text(this.getOutletGroupInfoStr(outletGroup)));
                }
            }
        }
    }

    public void displayRegistrationWarnings(Container container, PageContext pageContext) {
        Image image;
        Division division;
        Text text = null;
        Text text2 = null;
        if (Utils.hasOutletGroups(pageContext)) {
            if (this.services.getAdvancedSetupHelper().hasUPSSetupWithHostsMappedToMultipleOutletGroups()) {
                text = new Text(this.theRegisterWithMultipleOGWarningText);
            }
            if (this.services.getWebServerUtils().hasUPSWithNoHostsMapped(pageContext)) {
                text2 = new Text(this.theRegisterWithNoHostMappedWarningText);
            }
        }
        if (text != null) {
            division = new Division();
            image = new Image("/images/exclamation.gif");
            image.setCssClass("warningImg");
            division.add(image);
            division.add(text);
            division.setCssClass("treemsg ui-state-default ui-corner-all");
            container.add(division);
        }
        if (text2 != null) {
            division = new Division();
            image = new Image("/images/exclamation.gif");
            image.setCssClass("warningImg");
            division.add(image);
            division.add(text2);
            division.setCssClass("treemsg ui-state-default ui-corner-all");
            container.add(division);
        }
    }

    public void displayButtons(Container container, HostNMCMappingHelper hostNMCMappingHelper) {
        hostNMCMappingHelper.displayButton(container, "deletebtn", this.theRemoveButtonText);
        hostNMCMappingHelper.displayButton(container, "resetbtn", this.theResetButtonText);
        hostNMCMappingHelper.displayButton(container, "applybtn", this.theApplyButtonText);
    }

    public String getOutletGroupInfoStr(OutletGroup outletGroup) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(outletGroup.getIpAddress());
        stringBuffer.append(" - ");
        stringBuffer.append(outletGroup.getName());
        stringBuffer.append(" - ");
        stringBuffer.append(this.getOutletState(outletGroup.getState()));
        return stringBuffer.toString();
    }

    public String getOutletState(int n) {
        String string = this.theOutletStateUnknownText;
        switch (n) {
            case 1: {
                string = this.theOutletStateOnText;
                break;
            }
            case 0: {
                string = this.theOutletStateOffText;
                break;
            }
            case 2: {
                string = this.theOutletStateFixedText;
                break;
            }
            case 3: {
                string = this.theOutletStatePendingOffText;
                break;
            }
            case 4: {
                string = this.theOutletStateUnknownText;
                break;
            }
            default: {
                string = this.theOutletStateUnknownText;
            }
        }
        return string;
    }

    public void displayCancelButtonConfirmDialog(Container container) {
        Division division = new Division();
        container.add(division);
        division.setId("confirmdialog");
        division.setTitle(this.theConfirmCancelDialogTitleText);
        Division division2 = new Division();
        division.add(division2);
        division2.setId("dlgContentDiv");
        division2.add(new Text(this.theConfirmCancelDialogText));
    }
}

