/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.util;

import com.apcc.m11.components.webserver.html.Container;
import com.apcc.m11.components.webserver.html.HTML;
import com.apcc.m11.components.webserver.html.HTMLTagWithClassStyle;
import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.html.Text;
import com.apcc.m11.components.webserver.html.document.Division;
import com.apcc.m11.components.webserver.html.document.Span;
import com.apcc.m11.components.webserver.util.FormHelper;
import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.util.ResourceBundleWrapper;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import lombok.NonNull;

public class HyperVHTMLHelper {
    public static final String kVCenterHeaderId = "Configure.SCVMMHeader";
    public static final String kSCVMMIp = "Configure.SCVMMIp";
    public static final String kSCVMMIpName = "SCVMMIpName";
    public static final String kSCVMMIpError = "Configure.SCVMMIPError";
    public static final String kAttemptHyperVConnection = "CfgWizard.HyperVServerDetails.AttemptHyperVConnection";
    private String kInvalidIpId = "PCNS.VcenterServerValidation";
    private String kSCVMMNetworkError = "CfgWizard.HyperVServerDetails.SCVMMNetworkError";
    private String kSCVMMError = "Configure.SCVMMError";
    private String kSCVMMPermissionsError = "CfgWizard.HyperVServerDetails.SCVMMPermissionError";
    private String kRequiredId = "PCNS.RequiredField";
    private String theSCVMMServerIpText;
    private String theSCVMMErrorText;
    private Map<String, String> resMap = new HashMap<String, String>();
    private ServiceManager services;

    public HyperVHTMLHelper(Locale locale, @NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        this.services = serviceManager;
        this.getVMSettingsResourceStrings(locale);
    }

    private void getVMSettingsResourceStrings(Locale locale) {
        ResourceBundleWrapper resourceBundleWrapper = Utils.getWebServerResourceBundle(locale);
        this.resMap.put(kVCenterHeaderId, Utils.getResourceString(resourceBundleWrapper, kVCenterHeaderId));
        this.resMap.put(kSCVMMIp, Utils.getResourceString(resourceBundleWrapper, kSCVMMIp));
        this.resMap.put(kSCVMMIpError, Utils.getResourceString(resourceBundleWrapper, kSCVMMIpError));
        this.resMap.put(kAttemptHyperVConnection, Utils.getResourceString(resourceBundleWrapper, kAttemptHyperVConnection));
        this.resMap.put(this.kRequiredId, Utils.getResourceString(resourceBundleWrapper, this.kRequiredId));
        this.resMap.put(this.kInvalidIpId, Utils.getResourceString(resourceBundleWrapper, this.kInvalidIpId));
        this.resMap.put(this.kSCVMMNetworkError, Utils.getResourceString(resourceBundleWrapper, this.kSCVMMNetworkError));
        this.resMap.put(this.kSCVMMError, Utils.getResourceString(resourceBundleWrapper, this.kSCVMMError));
        this.resMap.put(this.kSCVMMPermissionsError, Utils.getResourceString(resourceBundleWrapper, this.kSCVMMPermissionsError));
    }

    private void addResources(Container container) {
        Span span = new Span();
        span.add(new Text(this.resMap.get(this.kRequiredId)));
        span.setId("requiredSpan");
        span.setCssClass("hidden");
        container.add(span);
        Span span2 = new Span();
        span2.add(new Text(this.resMap.get(this.kInvalidIpId)));
        span2.setId("invalidIpSpan");
        span2.setCssClass("hidden");
        container.add(span2);
        Span span3 = new Span();
        span3.add(new Text(this.resMap.get(kAttemptHyperVConnection)));
        span3.setId("attemptConnectionSpan");
        span3.setCssClass("hidden");
        container.add(span3);
        Span span4 = new Span();
        span4.add(new Text(this.resMap.get(this.kSCVMMNetworkError)));
        span4.setId("networkErrorSpan");
        span4.setCssClass("hidden");
        container.add(span4);
        Span span5 = new Span();
        span5.add(new Text(this.resMap.get(this.kSCVMMError)));
        span5.setId("invalidConnectionSpan");
        span5.setCssClass("hidden");
        container.add(span5);
        Span span6 = new Span();
        span6.add(new Text(this.resMap.get(this.kSCVMMPermissionsError)));
        span6.setId("permissionsErrorSpan");
        span6.setCssClass("hidden");
        container.add(span6);
    }

    public HTML createSCVMMHTML(PageContext pageContext, boolean bl) {
        Division division;
        Object object;
        Division division2 = new Division();
        division2.setId("server");
        if (!bl) {
            division2.setCssClass("formdiv");
            object = new Division();
            ((HTMLTagWithClassStyle)object).setCssClass("warningMsg ConnectionStatusWait");
            ((HTMLTagWithClassStyle)object).setId("warningDiv");
            ((Container)object).add(new Text(this.resMap.get(kAttemptHyperVConnection)));
            division2.add((HTML)object);
        }
        object = "";
        if (bl) {
            object = (String)pageContext.getSession().getAttribute(kSCVMMIpName);
        }
        if (object == null || ((String)object).isEmpty()) {
            object = this.services.getVirtualConfigurationManager().getServerIP();
        }
        if (!bl && pageContext.hasValue("scvmm_ip_invalid")) {
            this.theSCVMMErrorText = this.resMap.get(kSCVMMIpError);
            division = new Division();
            division.setCssClass("warningMsg ui-state-error ui-corner-all");
            division.add(new Text(this.theSCVMMErrorText));
            division2.add(division);
        }
        this.theSCVMMServerIpText = this.resMap.get(kSCVMMIp);
        if (bl) {
            division2.add(FormHelper.createLabelTextInputValueDiv(null, this.theSCVMMServerIpText, (String)object, null, kSCVMMIpName, null, 255, 34, null));
            division = new Division();
            division.setId("validateConnection");
            division.add(new Text(this.resMap.get(kAttemptHyperVConnection)));
            division.setCssClass("checkingConnection ConnectionStatusWait");
            Division division3 = new Division();
            division3.setCssClass("connectionDialog");
            division3.setId("connectionDialog");
            division3.add(division);
            division2.add(division3);
            Division division4 = new Division();
            division4.setId("connectionError");
            division4.add(new Text(this.resMap.get(this.kSCVMMNetworkError)));
            division4.setCssClass("scvmmError");
            division2.add(division4);
        } else {
            division2.add(FormHelper.createLabelAndReadOnlyValueDiv(kSCVMMIpName, this.theSCVMMServerIpText, (String)object, null));
        }
        this.addResources(division2);
        return division2;
    }
}

