/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.util;

import com.apcc.m11.components.webserver.html.Container;
import com.apcc.m11.components.webserver.html.HTML;
import com.apcc.m11.components.webserver.html.HTMLTagWithClassStyle;
import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.html.Text;
import com.apcc.m11.components.webserver.html.apc.ApcHelp;
import com.apcc.m11.components.webserver.html.apc.ApcSectionHeader;
import com.apcc.m11.components.webserver.html.document.Division;
import com.apcc.m11.components.webserver.html.document.Span;
import com.apcc.m11.components.webserver.util.FormHelper;
import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.hyperflex.HyperflexDetails;
import com.apcc.pcns.util.ResourceBundleWrapper;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import lombok.NonNull;

public class HyperflexHTMLHelper {
    private static final String CSS_HIDDEN = "hidden";
    public static final String HYPERFLEX_CVM_IP = "hyperflex_cvm";
    public static final String HYPERFLEX_CLUSTER_USER = "hyperflex_user";
    public static final String HYPERFLEX_PASSWORD_CHANGE = "hyperflex_password_change";
    public static final String HYPERFLEX_CLUSTER_PASSWORD = "hyperflex_password";
    private static final String ATTEMPT_CLUSTER_CONNECTION = "CfgWizard.HyperflexClusterDetails.AttemptClusterConnection";
    private static final String CLUSTER_IP_LABEL = "CfgWizard.HyperflexClusterDetails.ClusterIpLabel";
    private static final String CLUSTER_PASSWORD_LABEL = "CfgWizard.HyperflexClusterDetails.ClusterPassword";
    private static final String CLUSTER_USER_LABEL = "CfgWizard.HyperflexClusterDetails.ClusterUser";
    private static final String HEADER_TEXT = "CfgWizard.HyperflexClusterDetails.PageTitle";
    private static final String SUBHEADER_TEXT = "CfgWizard.HyperflexClusterDetails.PageDescription";
    private static final String REQUIRED_VALIDATOR = "PCNS.RequiredField";
    private static final String IP_VALIDATOR = "PCNS.NutanixClusterValidation";
    private static final String CLUSTER_CONNECTION_ERROR = "Configure.HyperflexClusterError";
    private static final String CLUSTER_NETWORK_ERROR = "CfgWizard.NutanixClusterDetails.NutanixClusterNetworkError";
    private static final String INVALID_CREDENTIALS_ERROR = "CfgWizard.NutanixClusterDetails.NutanixClusterInvalidCredentials";
    private static final String RANGE_VALIDATOR = "PCNS.RangeValidation";
    private static final String CHANGE_PASSWORD_TEXT = "PCNS.ChangePasswordText";
    private static final String HIDDEN_PASSWORD_ID = "PCNS.HiddenPassword";
    private static final String CHANGE_PASSWORD_LABEL = "Configure.HyperflexPassword";
    private static final String INVALID_CHARACTERS = "PCNS.InvalidCharacters";
    private static final String HYPERFLEX_PASSWORD_DIALOG_TITLE_ID = "Configure.HyperflexPasswordDialogTitle";
    private Map<String, String> resMap;
    private ServiceManager services;
    private String clusterIPLabel;
    private String clusterUserLabel;
    private String clusterPasswordLabel;

    public HyperflexHTMLHelper(Locale locale, @NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("services is marked non-null but is null");
        }
        this.services = serviceManager;
        this.resMap = new HashMap<String, String>();
        this.getVMSettingsResourceStrings(locale);
    }

    private void getVMSettingsResourceStrings(Locale locale) {
        ResourceBundleWrapper resourceBundleWrapper = Utils.getWebServerResourceBundle(locale);
        this.resMap.put(ATTEMPT_CLUSTER_CONNECTION, Utils.getResourceString(resourceBundleWrapper, ATTEMPT_CLUSTER_CONNECTION));
        this.resMap.put(CLUSTER_PASSWORD_LABEL, Utils.getResourceString(resourceBundleWrapper, CLUSTER_PASSWORD_LABEL));
        this.resMap.put(CLUSTER_USER_LABEL, Utils.getResourceString(resourceBundleWrapper, CLUSTER_USER_LABEL));
        this.resMap.put(HEADER_TEXT, Utils.getResourceString(resourceBundleWrapper, HEADER_TEXT));
        this.resMap.put(SUBHEADER_TEXT, Utils.getResourceString(resourceBundleWrapper, SUBHEADER_TEXT));
        this.resMap.put(REQUIRED_VALIDATOR, Utils.getResourceString(resourceBundleWrapper, REQUIRED_VALIDATOR));
        this.resMap.put(IP_VALIDATOR, Utils.getResourceString(resourceBundleWrapper, IP_VALIDATOR));
        this.resMap.put(CLUSTER_CONNECTION_ERROR, Utils.getResourceString(resourceBundleWrapper, CLUSTER_CONNECTION_ERROR));
        this.resMap.put(CLUSTER_NETWORK_ERROR, Utils.getResourceString(resourceBundleWrapper, CLUSTER_NETWORK_ERROR));
        this.resMap.put(INVALID_CREDENTIALS_ERROR, Utils.getResourceString(resourceBundleWrapper, INVALID_CREDENTIALS_ERROR));
        this.resMap.put(RANGE_VALIDATOR, Utils.getResourceString(resourceBundleWrapper, RANGE_VALIDATOR));
        this.resMap.put(CHANGE_PASSWORD_TEXT, Utils.getResourceString(resourceBundleWrapper, CHANGE_PASSWORD_TEXT));
        this.resMap.put(HIDDEN_PASSWORD_ID, Utils.getResourceString(resourceBundleWrapper, HIDDEN_PASSWORD_ID));
        this.resMap.put(CHANGE_PASSWORD_LABEL, Utils.getResourceString(resourceBundleWrapper, CHANGE_PASSWORD_LABEL));
        this.resMap.put(HYPERFLEX_PASSWORD_DIALOG_TITLE_ID, Utils.getResourceString(resourceBundleWrapper, HYPERFLEX_PASSWORD_DIALOG_TITLE_ID));
        this.resMap.put(INVALID_CHARACTERS, Utils.getResourceString(resourceBundleWrapper, INVALID_CHARACTERS));
        this.clusterIPLabel = Utils.getResourceString(resourceBundleWrapper, CLUSTER_IP_LABEL);
        this.clusterPasswordLabel = this.resMap.get(CLUSTER_PASSWORD_LABEL);
        this.clusterUserLabel = this.resMap.get(CLUSTER_USER_LABEL);
    }

    public HTML createConnectionSectionHeader() {
        ApcSectionHeader apcSectionHeader = new ApcSectionHeader(this.resMap.get(HEADER_TEXT), this.resMap.get(SUBHEADER_TEXT));
        apcSectionHeader.setHelpId(ApcHelp.CLUSTER_DETAILS_HYPERFLEX);
        return apcSectionHeader;
    }

    public HTML createConnectionHTML(PageContext pageContext, boolean bl) {
        Object object;
        Division division = new Division();
        division.setId("hyperflex");
        if (!bl) {
            division.setCssClass("formdiv");
            object = new Division();
            ((HTMLTagWithClassStyle)object).setCssClass("warningMsg ConnectionStatusWait");
            ((HTMLTagWithClassStyle)object).setId("hyperflexCheckInProgress");
            ((Container)object).add(new Text(this.resMap.get(ATTEMPT_CLUSTER_CONNECTION)));
            division.add((HTML)object);
        }
        object = this.getHyperflexDetails(pageContext, bl);
        if (bl) {
            division.add(FormHelper.createServerIPDiv(((HyperflexDetails)object).getHost(), this.clusterIPLabel, HYPERFLEX_CVM_IP));
            division.add(FormHelper.createInputDiv(((HyperflexDetails)object).getUsername(), this.clusterUserLabel, HYPERFLEX_CLUSTER_USER));
            division.add(FormHelper.createPasswordDiv(this.clusterPasswordLabel, HYPERFLEX_CLUSTER_PASSWORD));
            String string = this.resMap.get(ATTEMPT_CLUSTER_CONNECTION);
            Division division2 = new Division();
            division2.setId("validateConnection");
            division2.add(new Text(string));
            division2.setCssClass("checkingConnection ConnectionStatusWait");
            Division division3 = new Division();
            division3.setCssClass("waitDialog");
            division3.setId("waitDialog");
            division3.add(division2);
            division.add(division3);
            String string2 = this.resMap.get(CLUSTER_NETWORK_ERROR);
            division.add(FormHelper.createErrorDivision("connectionError", string2, "error-alert"));
        } else {
            division.add(FormHelper.createLabelAndReadOnlyValueDiv(HYPERFLEX_CVM_IP, this.clusterIPLabel, ((HyperflexDetails)object).getHost(), null));
            division.add(FormHelper.createInputDiv(((HyperflexDetails)object).getUsername(), this.clusterUserLabel, HYPERFLEX_CLUSTER_USER));
            division.add(FormHelper.createPasswordDiv(this.clusterPasswordLabel, HYPERFLEX_CLUSTER_PASSWORD));
        }
        this.addResources(division);
        return division;
    }

    private HyperflexDetails getHyperflexDetails(PageContext pageContext, boolean bl) {
        HyperflexDetails hyperflexDetails = null;
        if (bl) {
            hyperflexDetails = (HyperflexDetails)pageContext.getSession().getAttribute("hyperflex_details");
        }
        if (hyperflexDetails == null) {
            hyperflexDetails = this.services.getHyperflexUtils().loadHyperflexDetails();
        }
        return hyperflexDetails;
    }

    public void addResources(Container container) {
        String string = this.resMap.get(REQUIRED_VALIDATOR);
        Span span = new Span();
        span.add(new Text(string));
        span.setId("requiredSpan");
        span.setCssClass(CSS_HIDDEN);
        container.add(span);
        String string2 = this.resMap.get(IP_VALIDATOR);
        Span span2 = new Span();
        span2.add(new Text(string2));
        span2.setId("invalidIpSpan");
        span2.setCssClass(CSS_HIDDEN);
        container.add(span2);
        Span span3 = new Span();
        span3.setId("attemptConnectionSpan");
        span3.setCssClass(CSS_HIDDEN);
        container.add(span3);
        Span span4 = new Span();
        Span span5 = new Span();
        span3.add(new Text(this.resMap.get(ATTEMPT_CLUSTER_CONNECTION)));
        span5.add(new Text(this.resMap.get(CLUSTER_CONNECTION_ERROR)));
        span4.add(new Text(this.resMap.get(CLUSTER_NETWORK_ERROR)));
        span5.setId("invalidConnectionSpan");
        span5.setCssClass(CSS_HIDDEN);
        container.add(span5);
        span4.setId("networkErrorSpan");
        span4.setCssClass(CSS_HIDDEN);
        container.add(span4);
        String string3 = this.resMap.get(INVALID_CREDENTIALS_ERROR);
        Span span6 = new Span();
        span6.add(new Text(string3));
        span6.setId("invalidCredentialsSpan");
        span6.setCssClass(CSS_HIDDEN);
        container.add(span6);
        Span span7 = new Span();
        span7.add(new Text(this.resMap.get(RANGE_VALIDATOR)));
        span7.setId("rangeSpan");
        span7.setCssClass(CSS_HIDDEN);
        container.add(span7);
        Span span8 = new Span(HYPERFLEX_CLUSTER_PASSWORD);
        span8.setId("resHyperflexPasswordName");
        span8.setCssClass(CSS_HIDDEN);
        container.add(span8);
        span8 = new Span(this.resMap.get(INVALID_CHARACTERS));
        span8.setId("resInvalidCharacters");
        span8.setCssClass(CSS_HIDDEN);
        container.add(span8);
    }
}

