/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.util;

import com.apcc.m11.components.webserver.html.Container;
import com.apcc.m11.components.webserver.html.HTMLButton;
import com.apcc.m11.components.webserver.html.Text;
import com.apcc.m11.components.webserver.html.document.Division;
import com.apcc.m11.components.webserver.html.document.Span;
import com.apcc.m11.components.webserver.html.list.ListItem;
import com.apcc.m11.components.webserver.html.list.UnOrderedList;
import com.apcc.m11.components.webserver.html.util.Anchor;
import com.apcc.m11.components.webserver.model.Cluster;
import com.apcc.m11.components.webserver.model.Datacenter;
import com.apcc.m11.components.webserver.model.Host;
import com.apcc.pcns.ServiceManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class InventoryTreeHelper {
    private static final Logger logger = LogManager.getLogger(InventoryTreeHelper.class);
    public static final String CLASS_HIDDEN = "hidden";
    public static final String PARAM_RESET = "reset";
    protected static final String ATTR_REL = "rel";
    protected static final String ATTR_LNK = "lnk";
    protected static final String ATTR_GRPNMR = "outletgroupnumber";
    protected static final String REF_PCNSHOST = "pcnshost";
    protected static final String REF_VCSAHOST = "vcsahost";
    protected static final String REF_VCSAPCNSHOST = "vcsapcnshost";
    protected static final String REF_HOST = "host";
    protected static final String REF_HOST_PCNS = "host pcns";
    protected static final String REF_HOST_VCSA = "host vcsa";
    protected static final String REF_HOST_PCNS_VCSA = "host pcns vcsa";
    private static final String REF_CLUSTER = "cluster";
    private static final String REF_DATACENTER = "datacenter";
    private static final String REF_HOST_DISABLED = "host-disabled";
    private static final String REF_PCNSHOST_DISABLED = "pcnshost-disabled";
    private static final String REF_VCSAHOST_DISABLED = "vcsahost-disabled";
    private static final String REF_VCSAPCNSHOST_DISABLED = "vcsapcnshost-disabled";
    private static final String REF_CLUSTER_DISABLED = "cluster-disabled";
    private static final String REF_DATACENTER_DISABLED = "datacenter-disabled";
    private static final String REF_HOST_MAPPED = "host mapped";
    private static final String REF_DATACENTER_MAPPED = "datacenter mapped";
    private static final String REF_CLUSTER_MAPPED = "cluster mapped";
    private static final String REF_HOST_PCNS_MAPPED = "host pcns mapped";
    private static final String REF_HOST_VCSA_MAPPED = "host vcsa mapped";
    private static final String REF_HOST_PCNS_VCSA_MAPPED = "host pcns vcsa mapped";
    private boolean isHyperV;
    private boolean isNutanixAHV;
    private boolean isESXi;
    private boolean isNutanixESXi;
    private boolean vxRail;
    private String PCNSHost = null;
    private String VCSAHost = null;
    private List<Host> hostList = null;
    private List<String> mappedHostList = new ArrayList<String>();
    protected List<String> hostsRemoved = new ArrayList<String>();
    protected ServiceManager services;

    public InventoryTreeHelper(@NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        this.services = serviceManager;
        this.isHyperV = this.services.getVirtualConfigurationManager().isHyperV();
        this.isNutanixAHV = this.services.getVirtualConfigurationManager().isNutanixAHV();
        this.isESXi = this.services.getVirtualConfigurationManager().isESXi();
        this.isNutanixESXi = this.services.getVirtualConfigurationManager().isNutanixESXi();
        this.vxRail = this.services.getVirtualConfigurationManager().isVxRail();
    }

    public void initialize() {
        this.hostList = this.isHyperV ? this.services.getHyperVUtils().getHosts() : (this.isNutanixAHV ? this.services.getHostSystemUtils().getAhvHosts() : this.services.getHostSystemUtils().getHosts());
        if (this.hostList != null && this.isESXi) {
            this.PCNSHost = this.services.getHostSystemUtils().getPCNSHost();
            this.VCSAHost = this.services.getHostSystemUtils().getVCSAHost();
        }
    }

    public boolean isHyperV() {
        return this.isHyperV;
    }

    public boolean isNutanixAHV() {
        return this.isNutanixAHV;
    }

    public boolean isNutanixESXi() {
        return this.isNutanixESXi;
    }

    public String getPCNSHost() {
        return this.PCNSHost;
    }

    public String getVCSAHost() {
        return this.VCSAHost;
    }

    public List<Host> getHostList() {
        return this.hostList;
    }

    public List<String> getMappedHostList() {
        return this.mappedHostList;
    }

    protected void setMappedHostList(List<String> list) {
        this.mappedHostList = list;
        logger.debug("setMappedHostList:" + list.toString());
    }

    public abstract void refreshMappedHosts();

    protected boolean isExistingHost(String string) {
        boolean bl = false;
        for (Host host : this.hostList) {
            if (!host.getIPAddress().equalsIgnoreCase(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    protected boolean isPCNSHost(String string) {
        return string.equalsIgnoreCase(this.PCNSHost);
    }

    protected boolean isVCSAHost(String string) {
        return string.equalsIgnoreCase(this.VCSAHost);
    }

    public void addResourceString(Division division, String string, String string2) {
        Span span = new Span(string2);
        span.setId(string);
        division.add(span);
    }

    public void displayButton(Container container, String string, String string2) {
        HTMLButton hTMLButton = new HTMLButton();
        container.add(hTMLButton);
        hTMLButton.setId(string);
        hTMLButton.add(new Text(string2));
    }

    public void displayHostTree(Container container) {
        String string = "";
        Division division = new Division();
        division.setId("inventory");
        division.setCssClass("treelist ui-corner-all");
        container.add(division);
        UnOrderedList unOrderedList = new UnOrderedList();
        division.add(unOrderedList);
        if (this.getHostList() != null) {
            List<Datacenter> list = this.createDatacenterList();
            if (list.isEmpty()) {
                if (this.isHyperV) {
                    this.displayHosts(unOrderedList, this.createNonClusterHostList());
                    this.displayClusters(unOrderedList, this.createClusterList());
                } else if (this.isNutanixAHV) {
                    this.displayClusters(unOrderedList, this.createClusterList());
                } else {
                    this.displayHosts(unOrderedList, this.hostList);
                }
            } else {
                for (Datacenter datacenter : list) {
                    boolean bl = true;
                    if (datacenter.isEmpty()) continue;
                    ListItem listItem = new ListItem();
                    Anchor anchor = new Anchor();
                    anchor.setHypertextReference("#");
                    anchor.add(new Text(datacenter.getName()));
                    listItem.add(anchor);
                    UnOrderedList unOrderedList2 = new UnOrderedList();
                    listItem.add(unOrderedList2);
                    unOrderedList.add(listItem);
                    bl = this.displayHosts(unOrderedList2, datacenter.getHostList());
                    if (bl &= this.displayClusters(unOrderedList2, datacenter.getClusterList())) {
                        listItem.setAttribute(ATTR_REL, REF_DATACENTER_DISABLED);
                        listItem.setCssClass(REF_DATACENTER_MAPPED);
                        string = REF_DATACENTER_DISABLED;
                    } else {
                        listItem.setAttribute(ATTR_REL, REF_DATACENTER);
                        listItem.setCssClass(REF_DATACENTER);
                        string = REF_DATACENTER;
                    }
                    listItem.setDataJstree(string);
                }
            }
        }
    }

    private boolean displayClusters(UnOrderedList unOrderedList, List<Cluster> list) {
        boolean bl = true;
        String string = "";
        for (Cluster cluster : list) {
            if (cluster.isEmpty()) continue;
            ListItem listItem = new ListItem();
            Anchor anchor = new Anchor();
            anchor.setHypertextReference("#");
            anchor.add(new Text(cluster.getName()));
            listItem.add(anchor);
            UnOrderedList unOrderedList2 = new UnOrderedList();
            listItem.add(unOrderedList2);
            unOrderedList.add(listItem);
            if (this.displayHosts(unOrderedList2, cluster.getHostList())) {
                listItem.setAttribute(ATTR_REL, REF_CLUSTER_DISABLED);
                listItem.setCssClass(REF_CLUSTER_MAPPED);
                string = REF_CLUSTER_DISABLED;
            } else {
                bl = false;
                listItem.setAttribute(ATTR_REL, REF_CLUSTER);
                listItem.setCssClass(REF_CLUSTER);
                string = REF_CLUSTER;
            }
            listItem.setDataJstree(string);
        }
        return bl;
    }

    private boolean displayHosts(UnOrderedList unOrderedList, List<Host> list) {
        boolean bl = true;
        String string = "";
        for (Host host : list) {
            ListItem listItem = new ListItem();
            listItem.setAttribute(ATTR_LNK, host.getIPAddress());
            boolean bl2 = this.isPCNSHost(host.getIPAddress());
            boolean bl3 = this.isVCSAHost(host.getIPAddress());
            boolean bl4 = this.isHostMapped(host.getIPAddress());
            if (!bl4) {
                bl = false;
            }
            if (bl2 && bl3) {
                if (bl4) {
                    listItem.setAttribute(ATTR_REL, REF_VCSAPCNSHOST_DISABLED);
                    listItem.setCssClass(REF_HOST_PCNS_VCSA_MAPPED);
                    string = REF_VCSAPCNSHOST_DISABLED;
                } else {
                    listItem.setAttribute(ATTR_REL, REF_VCSAPCNSHOST);
                    listItem.setCssClass(REF_HOST_PCNS_VCSA);
                    string = REF_VCSAPCNSHOST;
                }
            } else if (bl3) {
                if (bl4) {
                    listItem.setAttribute(ATTR_REL, REF_VCSAHOST_DISABLED);
                    listItem.setCssClass(REF_HOST_VCSA_MAPPED);
                    string = REF_VCSAHOST_DISABLED;
                } else {
                    listItem.setAttribute(ATTR_REL, REF_VCSAHOST);
                    listItem.setCssClass(REF_HOST_VCSA);
                    string = REF_VCSAHOST;
                }
            } else if (bl2) {
                if (bl4) {
                    listItem.setAttribute(ATTR_REL, REF_PCNSHOST_DISABLED);
                    listItem.setCssClass(REF_HOST_PCNS_MAPPED);
                    string = REF_PCNSHOST_DISABLED;
                } else {
                    listItem.setAttribute(ATTR_REL, REF_PCNSHOST);
                    listItem.setCssClass(REF_HOST_PCNS);
                    string = REF_PCNSHOST;
                }
            } else if (bl4) {
                listItem.setAttribute(ATTR_REL, REF_HOST_DISABLED);
                listItem.setCssClass(REF_HOST_MAPPED);
                string = REF_HOST_DISABLED;
            } else {
                listItem.setAttribute(ATTR_REL, REF_HOST);
                listItem.setCssClass(REF_HOST);
                string = REF_HOST;
            }
            Anchor anchor = new Anchor();
            anchor.setHypertextReference("#");
            anchor.add(new Text(host.getIPAddress()));
            if (bl3 && bl2) {
                anchor.setCssClass(REF_VCSAPCNSHOST);
            }
            listItem.setDataJstree(string);
            listItem.add(anchor);
            unOrderedList.add(listItem);
        }
        return bl;
    }

    private boolean isHostMapped(String string) {
        for (String string2 : this.mappedHostList) {
            if (!string2.equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    private List<Datacenter> createDatacenterList() {
        ArrayList<Datacenter> arrayList = new ArrayList<Datacenter>();
        for (Host host : this.hostList) {
            if (host.getDataCenter() == null) continue;
            Datacenter datacenter = this.findDatacenter(arrayList, host.getDataCenter());
            if (datacenter == null) {
                datacenter = new Datacenter(host.getDataCenter());
                arrayList.add(datacenter);
            }
            datacenter.addHost(host);
        }
        return arrayList;
    }

    private Datacenter findDatacenter(List<Datacenter> list, String string) {
        for (Datacenter datacenter : list) {
            if (!datacenter.getName().equals(string)) continue;
            return datacenter;
        }
        return null;
    }

    private List<Cluster> createClusterList() {
        ArrayList<Cluster> arrayList = new ArrayList<Cluster>();
        for (Host host : this.hostList) {
            if (host.getCluster() == null) continue;
            Cluster cluster = this.findCluster(arrayList, host.getCluster());
            if (cluster == null) {
                cluster = new Cluster(host.getCluster());
                arrayList.add(cluster);
            }
            cluster.addHost(host);
        }
        return arrayList;
    }

    private Cluster findCluster(List<Cluster> list, String string) {
        for (Cluster cluster : list) {
            if (!cluster.getName().equals(string)) continue;
            return cluster;
        }
        return null;
    }

    private List<Host> createNonClusterHostList() {
        ArrayList<Host> arrayList = new ArrayList<Host>();
        for (Host host : this.hostList) {
            if (host.getCluster() != null) continue;
            arrayList.add(host);
        }
        return arrayList;
    }

    public List<String> getHostsRemoved() {
        return this.hostsRemoved;
    }

    public String getHostsRemovedAsString() {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<String> iterator = this.hostsRemoved.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next() + ",");
        }
        if (stringBuilder != null && stringBuilder.length() > 0) {
            return stringBuilder.substring(0, stringBuilder.length() - 1);
        }
        return null;
    }

    public boolean isBMCEnabledForAnyMappedHosts() {
        this.refreshMappedHosts();
        block0: for (String string : this.getMappedHostList()) {
            if (this.getHostList() == null) continue;
            for (Host host : this.getHostList()) {
                if (host == null || !host.getIPAddress().equalsIgnoreCase(string)) continue;
                if (!host.getBMCEnabled()) continue block0;
                return true;
            }
        }
        return false;
    }

    @Generated
    public boolean isVxRail() {
        return this.vxRail;
    }

    @Generated
    public void setVxRail(boolean bl) {
        this.vxRail = bl;
    }
}

