/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.util;

import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.util.ResourceBundleWrapper;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.configuration2.ex.ConversionException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JREUtils {
    private static final Logger logger = LogManager.getLogger(JREUtils.class);
    private static final int EXECUTE_MASK = 64;
    private static final int WRITE_MASK = 128;
    private static final int READ_MASK = 256;

    public static List<File> getAvailableJREUpdates() {
        logger.debug("getAvailableJREUpdates");
        ArrayList<File> arrayList = new ArrayList<File>();
        File file = new File("../Updates");
        logger.debug("Update Dir: {}  exists: {} dir: {}", (Object)file.getAbsolutePath(), (Object)file.exists(), (Object)file.isDirectory());
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            Pattern pattern = Pattern.compile(".*.tar.gz$|.*.zip$");
            for (File file2 : fileArray) {
                logger.debug("check file: {}", (Object)file2.getName());
                if (!file2.isFile() || !pattern.matcher(file2.getName()).matches()) continue;
                arrayList.add(file2);
                logger.debug("found update file: {}", (Object)file2.getName());
            }
        } else {
            logger.debug("No files in Updates");
        }
        logger.debug("getAvailableJREUpdates: {}", (Object)((Object)arrayList).toString());
        return arrayList;
    }

    private static File getSelectedJreUpdate(String string) {
        List<File> list = JREUtils.getAvailableJREUpdates();
        Optional<File> optional = list.stream().filter(file -> StringUtils.equals((CharSequence)file.getName(), (CharSequence)string)).findFirst();
        File file2 = optional.orElse(null);
        logger.debug("isValidUpdate() - Selection resolves to file: {}", (Object)file2);
        return file2;
    }

    public static void applyJREUpdates(String string) {
        File file = JREUtils.getSelectedJreUpdate(string);
        ResourceBundleWrapper resourceBundleWrapper = Utils.getWebServerResourceBundle(Locale.getDefault());
        boolean bl = false;
        if (file == null) {
            String string2 = Utils.getResourceString(resourceBundleWrapper, "JREUpdate.FAILED");
            ServiceManager.getInstance().getApplicationErrorHandler().put(string2);
            return;
        }
        logger.error("Updating the JRE to: {}", (Object)string);
        String string3 = "";
        MessageFormat messageFormat = new MessageFormat("");
        messageFormat.setLocale(Locale.getDefault());
        String string4 = Utils.getResourceString(resourceBundleWrapper, "JREUpdate.Start");
        messageFormat.applyPattern(string4);
        Object[] objectArray = new Object[]{string};
        string3 = messageFormat.format(objectArray);
        ServiceManager.getInstance().getApplicationErrorHandler().put(string3);
        logger.info("Is Windows: {}", (Object)SystemUtils.IS_OS_WINDOWS);
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            String[] stringArray;
            Object object5;
            Object object6;
            Object object7;
            File file2;
            block56: {
                File file3;
                Object object8;
                String string5 = "../Updates";
                String string6 = "..";
                file2 = new File(string6);
                if (!file2.exists()) {
                    file2.mkdir();
                }
                object7 = null;
                if (file.getPath().endsWith(".zip")) {
                    object7 = JREUtils.unzipJRE(file, file2);
                } else {
                    object8 = JREUtils.getFileName(file, string5);
                    object6 = new File((String)object8);
                    object6 = JREUtils.decompressGZipFile(file, (File)object6);
                    object7 = JREUtils.unTarJRE((File)object6, file2);
                    boolean bl2 = ((File)object6).delete();
                    if (!bl2) {
                        logger.debug("Failed to delete file: {}", object8);
                    }
                }
                object8 = new File((String)object7);
                if (((File)object8).isDirectory()) {
                    logger.error("Update file does not contain the java executable");
                    JREUtils.deleteDir((File)object8);
                    string3 = Utils.getResourceString(resourceBundleWrapper, "JREUpdate.FAILED");
                    ServiceManager.getInstance().getApplicationErrorHandler().put(string3);
                    bl = true;
                    return;
                }
                logger.info("jvm Runtime location: {}", object7);
                object6 = "";
                if (SystemUtils.IS_OS_WINDOWS) {
                    var15_18 = ((String)object7).indexOf("\\bin\\");
                    if (var15_18 > 0) {
                        object6 = ((String)object7).substring(0, var15_18);
                    }
                    file3 = new File((String)object6 + "/bin/jlink.exe");
                } else {
                    var15_18 = ((String)object7).indexOf("/bin/");
                    if (var15_18 > 0) {
                        object6 = ((String)object7).substring(0, var15_18);
                    }
                    file3 = new File((String)object6 + "/bin/jlink");
                }
                if (file3.exists() && file3.canExecute()) {
                    logger.error("Using jlink to create a smaller JRE: {}", (Object)file3.getAbsolutePath());
                    try {
                        String string7 = "java.base,java.compiler,java.desktop,java.naming,java.rmi,java.management,java.scripting,java.instrument,java.security.jgss,java.sql,java.xml,java.logging,jdk.crypto.cryptoki,jdk.zipfs,jdk.jdwp.agent";
                        object5 = ServiceManager.getInstance().getConfigurationManager();
                        try {
                            if (object5.containsKey("Networking", "javaModules")) {
                                string7 = object5.getString("Networking", "javaModules");
                                logger.error("Using java module list from ini file: {}", (Object)string7);
                            }
                        }
                        catch (ConversionException conversionException) {
                            logger.error("Error using java modules from ini file, using default: {}", (Throwable)conversionException);
                        }
                        stringArray = new ProcessBuilder(file3.getAbsolutePath(), "--module-path", (String)object6 + "/jmods", "--output", (String)object6 + "/jre", "--add-modules", string7);
                        logger.info("Build JRE Requested: {}", stringArray.command());
                        object4 = stringArray.start();
                        ((Process)object4).waitFor();
                        object3 = new BufferedReader(new InputStreamReader(((Process)object4).getInputStream()));
                        object2 = ((BufferedReader)object3).readLine();
                        while (object2 != null) {
                            logger.info("jlink Cmd output: {}", object2);
                            object2 = ((BufferedReader)object3).readLine();
                        }
                        logger.info("Build JRE Complete");
                        object = null;
                        object = SystemUtils.IS_OS_WINDOWS ? (Object)((String)object7).replace("\\bin\\", "\\jre\\bin\\") : (Object)((String)object7).replace("/bin/", "/jre/bin/");
                        File file4 = new File((String)object);
                        if (file4.exists() && file4.canExecute()) {
                            File[] fileArray;
                            logger.info("delete jdk directories except jre");
                            for (File file5 : fileArray = new File((String)object6).listFiles()) {
                                logger.debug("Checking: {}", (Object)file5.getName());
                                if (file5.getName().equals("jre")) continue;
                                logger.debug("deleting: {}", (Object)file5.getName());
                                JREUtils.deleteDir(file5);
                            }
                            logger.info("delete jdk directories done");
                            object7 = object;
                            int n = 0;
                            n = SystemUtils.IS_OS_WINDOWS ? ((String)object7).indexOf("\\bin") : ((String)object7).indexOf("/bin");
                            if (n > 0) {
                                object6 = ((String)object7).substring(0, n);
                            }
                            logger.warn("Modified JRE: {}", object6);
                            break block56;
                        }
                        logger.error("Modified JRE not found.  Using full JDK.");
                    }
                    catch (IOException iOException) {
                        logger.error("Error building JRE: {}", (Throwable)iOException);
                    }
                    catch (InterruptedException interruptedException) {
                        logger.error("Interuption Error building JRE: {}", (Throwable)interruptedException);
                    }
                } else {
                    logger.error("Java tool jlink not found at {}", (Object)file3.getAbsolutePath());
                }
            }
            String string8 = null;
            object5 = new File((String)object7);
            if (((File)object5).exists() && ((File)object5).canExecute()) {
                logger.debug("JRE is ready");
                if (SystemUtils.IS_OS_WINDOWS) {
                    logger.debug("Update windows Registry");
                    stringArray = new File((String)object6);
                    if (stringArray.exists() && stringArray.isDirectory()) {
                        object4 = "HKLM\\SYSTEM\\CurrentControlSet\\Services\\PCNS1\\Parameters";
                        string8 = JREUtils.readRegistry((String)object4, "Application");
                        if (string8 == null || string8.isEmpty()) {
                            logger.error("Current JRE not found in registry {}", object4);
                            string3 = Utils.getResourceString(resourceBundleWrapper, "JREUpdate.FAILED");
                            ServiceManager.getInstance().getApplicationErrorHandler().put(string3);
                            bl = true;
                            return;
                        }
                        int n = string8.indexOf(File.separator + "jre" + File.separator + "bin");
                        if (n > 0) {
                            string8 = string8.substring(0, n);
                        } else {
                            n = string8.indexOf(File.separator + "bin" + File.separator);
                            if (n > 0) {
                                string8 = string8.substring(0, n);
                            }
                        }
                        logger.error("Changing java.exe from: {}  to: {}", (Object)string8, object7);
                        JREUtils.writeRegistry((String)object4, "Application", (String)object7);
                    } else {
                        logger.error("New JRE directory not found: {}", (Object)stringArray.getAbsolutePath());
                        bl = true;
                    }
                } else {
                    logger.error("Updating java.cfg");
                    stringArray = new File("java.cfg");
                    try {
                        object4 = new BufferedReader(new FileReader((File)stringArray));
                        try {
                            object3 = ((BufferedReader)object4).readLine();
                            if (object3 != null) {
                                string8 = ((String)object3).trim();
                            }
                            logger.debug("oldJRE: {}", (Object)string8);
                        }
                        finally {
                            ((BufferedReader)object4).close();
                        }
                    }
                    catch (IOException iOException) {
                        logger.error("Unable to update java.cfg: {}", (Throwable)iOException);
                        bl = true;
                    }
                    try {
                        object4 = new FileWriter((File)stringArray);
                        try {
                            object3 = object7;
                            int n = ((String)object7).indexOf("/bin/") + 5;
                            if (n > 0) {
                                object3 = ((String)object7).substring(0, n);
                            }
                            logger.debug("newJavaBin: {}", object3);
                            ((Writer)object4).write((String)object3);
                        }
                        finally {
                            ((OutputStreamWriter)object4).close();
                        }
                    }
                    catch (IOException iOException) {
                        logger.error("Unable to update java.cfg: {}", (Throwable)iOException);
                        bl = true;
                    }
                }
            } else {
                logger.error("Java not found at: {}", (Object)((File)object5).getAbsolutePath());
                bl = true;
            }
            if (bl) {
                string3 = Utils.getResourceString(resourceBundleWrapper, "JREUpdate.FAILED");
                ServiceManager.getInstance().getApplicationErrorHandler().put(string3);
                return;
            }
            try {
                stringArray = null;
                if (SystemUtils.IS_OS_WINDOWS) {
                    logger.error("Restarting the service");
                    object4 = new String[]{"cmd", "/c", "net stop PCNS1 & net start PCNS1 & rmdir /S /Q \"" + string8 + "\" & rmdir /Q \"" + string8 + "\\..\" "};
                    stringArray = object4;
                } else {
                    logger.error("Restarting the deamon");
                    logger.debug("Finding Java root dir: {}", string8);
                    object4 = string8.replaceFirst("/jre/bin/$", "");
                    logger.debug("Finding Java root dir: {}", object4);
                    object4 = ((String)object4).replaceFirst("/bin/$", "");
                    logger.debug("Finding Java root dir: {}", object4);
                    String[] stringArray2 = new String[]{"sh", "-c", "cd \"" + file2.getCanonicalPath() + "/group1\"; which systemctl && systemctl restart PowerChute;  [ $? -ne 0 ] && kill -9 `cat pcns.pid` && rm pcns.pid && ./powerchute.sh;  rm -fr \"" + (String)object4 + "\" "};
                    stringArray = stringArray2;
                }
                logger.error("request Service Restart");
                object4 = new ProcessBuilder(stringArray);
                logger.info("Service Restart cmd: {}", ((ProcessBuilder)object4).command());
                bl = false;
                string3 = Utils.getResourceString(resourceBundleWrapper, "JREUpdate.Success");
                ServiceManager.getInstance().getApplicationErrorHandler().put(string3);
                Process process = ((ProcessBuilder)object4).start();
                object2 = process.getInputStream();
                object = new byte[16];
                ((InputStream)object2).read((byte[])object, 0, ((byte[])object).length);
                logger.info("Output: {}", object);
                logger.info("service Restart requested.");
            }
            catch (IOException iOException) {
                logger.error("Error restarting service: {}", (Throwable)iOException);
                bl = true;
            }
        }
        catch (Exception exception) {
            logger.error("Error applying jre patch {}", (Throwable)exception);
            bl = true;
        }
        if (bl) {
            string3 = Utils.getResourceString(resourceBundleWrapper, "JREUpdate.FAILED");
            ServiceManager.getInstance().getApplicationErrorHandler().put(string3);
        }
        logger.debug("done");
    }

    private static final String readRegistry(String string, String string2) {
        try {
            char c;
            String string3;
            int n;
            Process process = Runtime.getRuntime().exec("reg query \"" + string + "\" /v " + string2);
            InputStream inputStream = process.getInputStream();
            StringBuilder stringBuilder = new StringBuilder();
            try {
                int n2;
                while ((n2 = inputStream.read()) != -1) {
                    stringBuilder.append((char)n2);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if ((n = (string3 = stringBuilder.toString()).indexOf("REG_SZ")) == -1) {
                return null;
            }
            stringBuilder = new StringBuilder();
            n += 6;
            while (n <= string3.length() && ((c = string3.charAt(n)) == ' ' || c == '\t')) {
                ++n;
            }
            while (n <= string3.length() && (c = string3.charAt(n)) != '\r' && c != '\n') {
                stringBuilder.append(c);
                ++n;
            }
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static final boolean writeRegistry(String string, String string2, String string3) {
        try {
            Process process = Runtime.getRuntime().exec("reg add \"" + string + "\" /f /v " + string2 + " /t REG_SZ /d \"" + string3 + "\"");
            InputStream inputStream = process.getInputStream();
            StringBuilder stringBuilder = new StringBuilder();
            try {
                int n;
                while ((n = inputStream.read()) != -1) {
                    stringBuilder.append((char)n);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            logger.debug("writeRegistry:" + stringBuilder.toString());
            return process.exitValue() == 0;
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String unzipJRE(File file, File file2) throws IOException {
        logger.debug("unzipJRE");
        Object object = "";
        try (ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(file));){
            String string;
            ZipEntry zipEntry = null;
            Pattern pattern = SystemUtils.IS_OS_WINDOWS ? Pattern.compile(".*java.exe$") : Pattern.compile(".*bin/java$");
            String string2 = file2.getCanonicalPath();
            object = string2 + File.separator;
            zipEntry = zipInputStream.getNextEntry();
            if (zipEntry == null) {
                zipInputStream.close();
                throw new IOException("Invalid Zip File: " + file.getName());
            }
            String string3 = string = zipEntry.getName();
            if (!zipEntry.isDirectory()) {
                zipInputStream.close();
                throw new IOException("File doesnt contain a zipped directory:" + file.getName());
            }
            Object object2 = Paths.get(string2, string).normalize();
            int n = 1;
            while (Files.exists((Path)object2, LinkOption.NOFOLLOW_LINKS)) {
                logger.debug("JRE directory already exists: {}", object2);
                string3 = string.replace("/", "-" + ++n + "/");
                object2 = Paths.get(string2, string3).normalize();
            }
            if (!object2.normalize().startsWith(string2)) {
                logger.warn("unzipJRE() - Preventing an attempt to create a file/ folder outside the install directory: {}", object2);
                throw new IOException("Entry outside of the target dir. See ZipSlip");
            }
            logger.debug("JRE directory: {}", object2);
            Files.createDirectories((Path)object2, new FileAttribute[0]);
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                object2 = zipEntry.getName();
                Path path = Paths.get(string2, string, ((String)object2).substring(string.length())).normalize();
                if (!path.startsWith(string2)) {
                    logger.warn("unzipJRE() - Preventing an attempt to create a file/ folder outside the install directory: {}", (Object)path);
                    throw new IOException("Entry outside of the target dir. See ZipSlip");
                }
                File file3 = path.toFile();
                if (zipEntry.isDirectory()) {
                    if (Files.exists(path, LinkOption.NOFOLLOW_LINKS)) continue;
                    Files.createDirectories(path, new FileAttribute[0]);
                    continue;
                }
                try (FileOutputStream fileOutputStream = new FileOutputStream(file3);){
                    IOUtils.copy((InputStream)zipInputStream, (OutputStream)fileOutputStream);
                }
                catch (IOException iOException) {
                    logger.error("An error occurred while copying input stream to output file: ", (Throwable)iOException);
                }
                if (!pattern.matcher(zipEntry.getName()).matches()) continue;
                object = file3.getAbsolutePath();
                logger.debug("Found the jvm: {}", object);
            }
            zipInputStream.closeEntry();
            zipInputStream.close();
        }
        logger.debug("unzipJRE returns: {}", object);
        return object;
    }

    private static String unTarJRE(File file, File file2) throws IOException {
        logger.debug("unTarJRE");
        TarArchiveEntry tarArchiveEntry = null;
        Object object = "";
        try (TarArchiveInputStream tarArchiveInputStream = new TarArchiveInputStream((InputStream)new FileInputStream(file));){
            Pattern pattern = SystemUtils.IS_OS_WINDOWS ? Pattern.compile(".*java.exe$") : Pattern.compile(".*bin/java$");
            String string = file2.getCanonicalPath();
            tarArchiveEntry = tarArchiveInputStream.getNextEntry();
            String string2 = tarArchiveEntry.getName();
            String string3 = string2.split("\\/|\\\\", 2)[0] + File.separator;
            Object object2 = string3;
            Path path = Paths.get(string, string3).normalize();
            int n = 1;
            while (Files.exists(path, LinkOption.NOFOLLOW_LINKS)) {
                logger.debug("JRE directory already exists: {}", (Object)path);
                object2 = string3.replace(File.separator, "-" + ++n + File.separator);
                path = Paths.get(string, new String[]{object2}).normalize();
            }
            if (path.startsWith(string)) {
                logger.debug("JRE directory: {}", (Object)path);
                Files.createDirectories(path, new FileAttribute[0]);
            } else {
                logger.warn("unTarJRE() - Preventing an attempt to create a file/ folder outside the install directory: {}", (Object)path);
                throw new IOException("Entry outside of the target dir. See ZipSlip");
            }
            while ((tarArchiveEntry = tarArchiveInputStream.getNextEntry()) != null) {
                String string4 = tarArchiveEntry.getName();
                Path path2 = Paths.get(string, new String[]{object2, string4.substring(string3.length())}).normalize();
                if (!path2.startsWith(string)) {
                    logger.warn("unTarJRE() - Preventing an attempt to create a file/ folder outside the install directory: {}", (Object)path2);
                    throw new IOException("Entry outside of the target dir. See ZipSlip");
                }
                File file3 = path2.toFile();
                if (tarArchiveEntry.isDirectory()) {
                    if (Files.exists(path2, LinkOption.NOFOLLOW_LINKS)) continue;
                    Files.createDirectories(path2, new FileAttribute[0]);
                    continue;
                }
                if (path2.getParent() != null && !Files.exists(path2.getParent(), LinkOption.NOFOLLOW_LINKS)) {
                    Files.createDirectories(path2.getParent(), new FileAttribute[0]);
                }
                try (FileOutputStream fileOutputStream = new FileOutputStream(file3);){
                    IOUtils.copy((InputStream)tarArchiveInputStream, (OutputStream)fileOutputStream);
                }
                catch (IOException iOException) {
                    logger.error("An error occurred while copying input stream to output file: ", (Throwable)iOException);
                }
                if (!file3.setReadable((tarArchiveEntry.getMode() & 0x100) != 0)) {
                    logger.debug("Failed to set file as readable: {}", (Object)file3.getAbsolutePath());
                }
                if (!file3.setWritable((tarArchiveEntry.getMode() & 0x80) != 0)) {
                    logger.debug("Failed to set file as writable: {}", (Object)file3.getAbsolutePath());
                }
                if (!file3.setExecutable((tarArchiveEntry.getMode() & 0x40) != 0)) {
                    logger.debug("Failed to set file as executable: {}", (Object)file3.getAbsolutePath());
                }
                if (!pattern.matcher(tarArchiveEntry.getName()).matches()) continue;
                object = file3.getAbsolutePath();
                logger.debug("Found the jvm: {}", object);
            }
            tarArchiveInputStream.close();
            if (((String)object).isEmpty()) {
                object = path.toFile().getCanonicalPath() + File.separator;
            }
        }
        logger.debug("unTarJRE returns: {}", object);
        return object;
    }

    static boolean isExecutable(int n) {
        int n2 = 73;
        return (n & n2) != 0;
    }

    private static File decompressGZipFile(File file, File file2) throws IOException {
        logger.debug("decompressGZipFile(): Unzip {} to {}", (Object)file, (Object)file2);
        try (GzipCompressorInputStream gzipCompressorInputStream = new GzipCompressorInputStream((InputStream)new BufferedInputStream(Files.newInputStream(file.toPath(), new OpenOption[0])));
             OutputStream outputStream = Files.newOutputStream(file2.toPath(), new OpenOption[0]);){
            gzipCompressorInputStream.transferTo(outputStream);
            logger.debug("decompressGZipFile(): Unzip complete.");
        }
        return file2;
    }

    private static String getFileName(File file, String string) {
        return string + File.separator + file.getName().substring(0, file.getName().lastIndexOf(46));
    }

    private static void deleteDir(File file) {
        try {
            if (file.isDirectory()) {
                FileUtils.deleteDirectory((File)file);
            } else {
                FileUtils.delete((File)file);
            }
        }
        catch (IOException iOException) {
            logger.debug("Failed to delete file: {}", (Object)file.getAbsolutePath());
        }
    }
}

