/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.util;

import com.apcc.m11.components.webserver.html.Container;
import com.apcc.m11.components.webserver.html.HTML;
import com.apcc.m11.components.webserver.html.HTMLTagWithClassStyle;
import com.apcc.m11.components.webserver.html.Text;
import com.apcc.m11.components.webserver.html.apc.ApcHelp;
import com.apcc.m11.components.webserver.html.apc.ApcSectionHeader;
import com.apcc.m11.components.webserver.html.document.Division;
import com.apcc.m11.components.webserver.html.document.Label;
import com.apcc.m11.components.webserver.html.document.Span;
import com.apcc.m11.components.webserver.html.form.Button;
import com.apcc.m11.components.webserver.html.form.Input;
import com.apcc.m11.components.webserver.html.form.RadioButton;
import com.apcc.m11.components.webserver.html.util.Image;
import com.apcc.m11.components.webserver.util.FormHelper;
import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.configservice.AuthHelper;
import com.apcc.pcns.licensing.ActivationMethod;
import com.apcc.pcns.licensing.ILicensingConfigManager;
import com.apcc.pcns.licensing.ILicensingManager;
import com.apcc.pcns.licensing.ILicensingUtils;
import com.apcc.pcns.util.ResourceBundleWrapper;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import lombok.NonNull;

public class LicensingHTMLHelper {
    private ILicensingConfigManager licensingConfigManager;
    private ILicensingManager licensingManager;
    private ILicensingUtils licensingUtils;
    private AuthHelper authHelper;
    private static final Integer QUANTITY_MAX_LENGTH = 6;
    public static final String ACTIVATION_ID = "activationId";
    public static final String PROXY_FORM = "proxyForm";
    public static final String PROXY_SECTION = "proxySection";
    public static final String PROXY_ADDRESS = "proxyAddress";
    public static final String PROXY_PORT = "proxyPort";
    public static final String PROXY_USERNAME_ID = "proxyUserName";
    public static final String PROXY_PASSWORD_ID = "proxyPassword";
    public static final String ACTIVATION_BUTTON = "activationButton";
    public static final String UPDATE_BUTTON = "updateButton";
    public static final String PORTAL_BUTTON_ID = "portalButton";
    public static final String PORTAL_URL_ID = "portalUrl";
    public static final String GENERATION_BUTTON = "generationButton";
    public static final String UPLOAD_BUTTON = "uploadButton";
    public static final String UPLOAD_INPUT = "uploadInput";
    public static final String QUANTITY = "quantity";
    public static final String RANGE_VALIDATION_ID = "rangeValidation";
    public static final String OFFLINE_STEPS_ID = "offlineSteps";
    public static final String GENERATE_SPAN = "generateSpan";
    public static final String PORTAL_SPAN = "portalSpan";
    public static final String UPLOAD_SPAN = "uploadSpan";
    public static final String OFFLINE_ACTIVATION_DIV = "offlineActivationDiv";
    private static final String REQUIRED_FIELD = "PCNS.RequiredField";
    private static final String REQUIRED_FIELD_ID = "requiredField";
    private static final String RANGE_VALIDATION = "PCNS.RangeValidation";
    private static final String DIGITS_VALIDATION = "PCNS.DigitsValidation";
    private static final String DIGITS_VALIDATION_ID = "digitsOnly";
    private static final String LENGTH_VALIDATION = "PCNS.RangeLength";
    private static final String ACTIVATION_ID_LABEL = "CfgWizard.LicensingPage.ActivationIdLabel";
    private static final String ACTIVATION_ID_TOOLTIP = "CfgWizard.LicensingPage.ActivationIdToolTip";
    private static final String QUANTITY_LABEL = "CfgWizard.LicensingPage.QuantityLabel";
    private static final String QUANTITY_TOOLTIP = "CfgWizard.LicensingPage.QuantityToolTip";
    private static final String ONLINE_ACTIVATION_TOOLTIP = "CfgWizard.LicensingPage.OnlineActivationToolTip";
    private static final String OFFLINE_ACTIVATION_TOOLTIP = "CfgWizard.LicensingPage.OfflineActivationToolTip";
    private static final String TRIAL_ACTIVATION_TOOLTIP = "CfgWizard.LicensingPage.TrialActivationToolTip";
    private static final String PROXY_LABEL = "CfgWizard.LicensingPage.ProxyLabel";
    private static final String PROXY_PORT_LABEL_KEY = "CfgWizard.LicensingPage.ProxyPortLabel";
    private static final String PROXY_TOOLTIP = "CfgWizard.LicensingPage.ProxyToolTip";
    private static final String PROXY_PORT_TOOLTIP = "CfgWizard.LicensingPage.ProxyPortToolTip";
    private static final String PROXY_USERNAME = "CfgWizard.LicensingPage.ProxyUserName";
    private static final String PROXY_PASSWORD = "CfgWizard.LicensingPage.ProxyPassword";
    private static final String PROXY_USERNAME_TOOLTIP = "CfgWizard.LicensingPage.ProxyUserNameTooltip";
    private static final String PROXY_PASSWORD_TOOLTIP = "CfgWizard.LicensingPage.ProxyPasswordTooltip";
    private static final String INVALID_PROXY_ADDRESS = "Licensing.InvalidProxyAddress";
    private static final String ACTIVATE_ONLINE_RADIO = "Licensing.ActivateOnline";
    private static final String ACTIVATE_OFFLINE_RADIO = "Licensing.ActivateOffline";
    private static final String ACTIVATE_TRIAL_RADIO = "Licensing.Type.Trial";
    private static final String TRIAL_NOTICE_1 = "Licensing.Trial.Notice1";
    private static final String TRIAL_NOTICE_2 = "Licensing.Trial.Notice2";
    private static final String TRIAL_NOTICE_3 = "Licensing.Trial.Notice3";
    private static final String TRIAL_RENEWAL_NOTICE = "Licensing.ExpiredTrialLicenseWarning";
    private static final String ACTIVATE_BUTTON = "CfgWizard.LicensingPage.ActivateButton";
    private static final String PORTAL_BUTTON = "CfgWizard.LicensingPage.PortalButton";
    private static final String PORTAL_INSTRUCTIONS = "CfgWizard.LicensingPage.PortalInstruction";
    private static final String PORTAL_TOOLTIP = "CfgWizard.LicensingPage.PortalTooltip";
    private static final String ACTIVATION_DIALOG_TITLE = "CfgWizard.LicensingPage.ActivationWaitTitle";
    private static final String ACTIVATION_DIALOG_BODY = "CfgWizard.LicensingPage.ActivationWaitBody";
    private static final String INVALID_ACTIVATION_ID = "Licensing.Exceptions.InvalidActivationID";
    private static final String INVALID_RESPONSE = "Licensing.Exceptions.InvalidResponse";
    private static final String INVALID_FILE_SIZE = "Licensing.Exceptions.IncorrectFileSize";
    private static final String INVALID_FILE_TYPE = "Licensing.Exceptions.IncorrectFileType";
    private static final String GENERATE_BUTTON = "CfgWizard.LicensingPage.GenerateButton";
    private static final String GENERATE_INSTRUCTIONS = "CfgWizard.LicensingPage.GenerateInstruction";
    private static final String GENERATE_TOOLTIP = "CfgWizard.LicensingPage.GenerateTooltip";
    private static final String UPLOAD_RESPONSE_BUTTON = "CfgWizard.LicensingPage.UploadResponseButton";
    private static final String UPLOAD_INSTRUCTIONS = "CfgWizard.LicensingPage.UploadInstruction";
    private static final String UPLOAD_TOOLTIP = "CfgWizard.LicensingPage.UploadTooltip";
    private static final String DOWNLOAD_FAILED_MESSAGE = "CfgWizard.LicensingPage.DownloadFailedText";
    private static final String WAIT_DIALOG_TITLE = "PCNS.WaitTitle";
    private static final String WAIT_DIALOG_BODY = "PCNS.WaitText";
    private static final String PORT_RANGE_VALIDATION_MESSAGE = "portRangeValidation";
    private static final String QUANTITY_RANGE_VALIDATION_MESSAGE = "quantityRangeValidation";
    private static final String MAX_LENGTH_256 = "maxLength256";
    private static final String MAX_LENGTH_5 = "maxLength5";
    private static final String GENERATION_DIALOG_TITLE = "CfgWizard.LicensingPage.GenerationWaitTitle";
    private static final String GENERATION_DIALOG_BODY = "CfgWizard.LicensingPage.GenerationWaitBody";
    private static final String UPDATE_LICENSE = "Licensing.UpdateLicense";
    private static final String UPDATE = "Licensing.Update";
    private static final String PROXY_ADDRESS_ID = "proxyAddress";
    private static final String PROXY_PORT_ID = "proxyPort";
    private static final String QUANTITY_FIELD_ID = "quantity";
    private Map<String, String> resMap;
    private static final String ACTIVATION_METHOD_SECTION_ID = "activationMethodSelection";

    public LicensingHTMLHelper(Locale locale, @NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("services is marked non-null but is null");
        }
        this.licensingConfigManager = serviceManager.getLicensingConfigManager();
        this.licensingManager = serviceManager.getLicensingManager();
        this.licensingUtils = serviceManager.getLicensingUtils();
        this.authHelper = serviceManager.getAuthHelper();
        this.resMap = new HashMap<String, String>();
        this.getResourceStrings(locale);
    }

    private void getResourceStrings(Locale locale) {
        ResourceBundleWrapper resourceBundleWrapper = Utils.getWebServerResourceBundle(locale);
        this.resMap.put(REQUIRED_FIELD, Utils.getResourceString(resourceBundleWrapper, REQUIRED_FIELD));
        this.resMap.put(PORT_RANGE_VALIDATION_MESSAGE, MessageFormat.format(Utils.getResourceString(resourceBundleWrapper, RANGE_VALIDATION), 0, 65535));
        this.resMap.put(QUANTITY_RANGE_VALIDATION_MESSAGE, MessageFormat.format(Utils.getResourceString(resourceBundleWrapper, RANGE_VALIDATION), 1, 500000));
        this.resMap.put(DIGITS_VALIDATION, Utils.getResourceString(resourceBundleWrapper, DIGITS_VALIDATION));
        this.resMap.put(MAX_LENGTH_256, MessageFormat.format(Utils.getResourceString(resourceBundleWrapper, LENGTH_VALIDATION), 0, 256));
        this.resMap.put(MAX_LENGTH_5, MessageFormat.format(Utils.getResourceString(resourceBundleWrapper, LENGTH_VALIDATION), 0, 5));
        this.resMap.put(ACTIVATION_ID_LABEL, Utils.getResourceString(resourceBundleWrapper, ACTIVATION_ID_LABEL));
        this.resMap.put(ACTIVATION_ID_TOOLTIP, Utils.getResourceString(resourceBundleWrapper, ACTIVATION_ID_TOOLTIP));
        this.resMap.put(ACTIVATE_BUTTON, Utils.getResourceString(resourceBundleWrapper, ACTIVATE_BUTTON));
        this.resMap.put(PORTAL_BUTTON, Utils.getResourceString(resourceBundleWrapper, PORTAL_BUTTON));
        this.resMap.put(ACTIVATION_DIALOG_TITLE, Utils.getResourceString(resourceBundleWrapper, ACTIVATION_DIALOG_TITLE));
        this.resMap.put(ACTIVATION_DIALOG_BODY, Utils.getResourceString(resourceBundleWrapper, ACTIVATION_DIALOG_BODY));
        this.resMap.put(GENERATION_DIALOG_TITLE, Utils.getResourceString(resourceBundleWrapper, GENERATION_DIALOG_TITLE));
        this.resMap.put(GENERATION_DIALOG_BODY, Utils.getResourceString(resourceBundleWrapper, GENERATION_DIALOG_BODY));
        this.resMap.put(WAIT_DIALOG_TITLE, Utils.getResourceString(resourceBundleWrapper, WAIT_DIALOG_TITLE));
        this.resMap.put(WAIT_DIALOG_BODY, Utils.getResourceString(resourceBundleWrapper, WAIT_DIALOG_BODY));
        this.resMap.put(PROXY_LABEL, Utils.getResourceString(resourceBundleWrapper, PROXY_LABEL));
        this.resMap.put(PROXY_TOOLTIP, Utils.getResourceString(resourceBundleWrapper, PROXY_TOOLTIP));
        this.resMap.put(PROXY_USERNAME, Utils.getResourceString(resourceBundleWrapper, PROXY_USERNAME));
        this.resMap.put(PROXY_PASSWORD, Utils.getResourceString(resourceBundleWrapper, PROXY_PASSWORD));
        this.resMap.put(PROXY_USERNAME_TOOLTIP, Utils.getResourceString(resourceBundleWrapper, PROXY_USERNAME_TOOLTIP));
        this.resMap.put(PROXY_PASSWORD_TOOLTIP, Utils.getResourceString(resourceBundleWrapper, PROXY_PASSWORD_TOOLTIP));
        this.resMap.put(INVALID_PROXY_ADDRESS, Utils.getResourceString(resourceBundleWrapper, INVALID_PROXY_ADDRESS));
        this.resMap.put(ACTIVATE_ONLINE_RADIO, Utils.getResourceString(resourceBundleWrapper, ACTIVATE_ONLINE_RADIO));
        this.resMap.put(ACTIVATE_OFFLINE_RADIO, Utils.getResourceString(resourceBundleWrapper, ACTIVATE_OFFLINE_RADIO));
        this.resMap.put(ACTIVATE_TRIAL_RADIO, Utils.getResourceString(resourceBundleWrapper, ACTIVATE_TRIAL_RADIO));
        this.resMap.put(TRIAL_NOTICE_1, Utils.getResourceString(resourceBundleWrapper, TRIAL_NOTICE_1));
        this.resMap.put(TRIAL_NOTICE_2, Utils.getResourceString(resourceBundleWrapper, TRIAL_NOTICE_2));
        this.resMap.put(TRIAL_NOTICE_3, Utils.getResourceString(resourceBundleWrapper, TRIAL_NOTICE_3));
        this.resMap.put(TRIAL_RENEWAL_NOTICE, Utils.getResourceString(resourceBundleWrapper, TRIAL_RENEWAL_NOTICE));
        this.resMap.put(GENERATE_BUTTON, Utils.getResourceString(resourceBundleWrapper, GENERATE_BUTTON));
        this.resMap.put(ONLINE_ACTIVATION_TOOLTIP, Utils.getResourceString(resourceBundleWrapper, ONLINE_ACTIVATION_TOOLTIP));
        this.resMap.put(OFFLINE_ACTIVATION_TOOLTIP, Utils.getResourceString(resourceBundleWrapper, OFFLINE_ACTIVATION_TOOLTIP));
        this.resMap.put(TRIAL_ACTIVATION_TOOLTIP, Utils.getResourceString(resourceBundleWrapper, TRIAL_ACTIVATION_TOOLTIP));
        this.resMap.put(UPLOAD_RESPONSE_BUTTON, Utils.getResourceString(resourceBundleWrapper, UPLOAD_RESPONSE_BUTTON));
        this.resMap.put(DOWNLOAD_FAILED_MESSAGE, Utils.getResourceString(resourceBundleWrapper, DOWNLOAD_FAILED_MESSAGE));
        this.resMap.put(QUANTITY_LABEL, Utils.getResourceString(resourceBundleWrapper, QUANTITY_LABEL));
        this.resMap.put(QUANTITY_TOOLTIP, Utils.getResourceString(resourceBundleWrapper, QUANTITY_TOOLTIP));
        this.resMap.put(UPDATE_LICENSE, Utils.getResourceString(resourceBundleWrapper, UPDATE_LICENSE));
        this.resMap.put(UPDATE, Utils.getResourceString(resourceBundleWrapper, UPDATE));
        this.resMap.put(GENERATE_INSTRUCTIONS, Utils.getResourceString(resourceBundleWrapper, GENERATE_INSTRUCTIONS));
        this.resMap.put(GENERATE_TOOLTIP, Utils.getResourceString(resourceBundleWrapper, GENERATE_TOOLTIP));
        this.resMap.put(PORTAL_INSTRUCTIONS, Utils.getResourceString(resourceBundleWrapper, PORTAL_INSTRUCTIONS));
        this.resMap.put(PORTAL_TOOLTIP, Utils.getResourceString(resourceBundleWrapper, PORTAL_TOOLTIP));
        this.resMap.put(UPLOAD_INSTRUCTIONS, Utils.getResourceString(resourceBundleWrapper, UPLOAD_INSTRUCTIONS));
        this.resMap.put(UPLOAD_TOOLTIP, Utils.getResourceString(resourceBundleWrapper, UPLOAD_TOOLTIP));
        this.resMap.put(INVALID_ACTIVATION_ID, Utils.getResourceString(resourceBundleWrapper, INVALID_ACTIVATION_ID));
        this.resMap.put(PROXY_PORT_LABEL_KEY, Utils.getResourceString(resourceBundleWrapper, PROXY_PORT_LABEL_KEY));
        this.resMap.put(PROXY_PORT_TOOLTIP, Utils.getResourceString(resourceBundleWrapper, PROXY_PORT_TOOLTIP));
        this.resMap.put(INVALID_RESPONSE, Utils.getResourceString(resourceBundleWrapper, INVALID_RESPONSE));
        this.resMap.put(INVALID_FILE_SIZE, Utils.getResourceString(resourceBundleWrapper, INVALID_FILE_SIZE));
        this.resMap.put(INVALID_FILE_TYPE, Utils.getResourceString(resourceBundleWrapper, INVALID_FILE_TYPE));
    }

    public HTML addUpdateLicenseSection() {
        return this.createLicensingPageHTML(true);
    }

    public HTML addActivateNewLicenseSection() {
        return this.createLicensingPageHTML(false);
    }

    private void addPageResourceStrings(Container container) {
        Division division = new Division();
        division.setCssClass("hidden");
        container.add(division);
        Span span = new Span(REQUIRED_FIELD_ID, this.resMap.get(REQUIRED_FIELD));
        division.add(span);
        span = new Span(DIGITS_VALIDATION_ID, this.resMap.get(DIGITS_VALIDATION));
        division.add(span);
        span = new Span(QUANTITY_RANGE_VALIDATION_MESSAGE, this.resMap.get(QUANTITY_RANGE_VALIDATION_MESSAGE));
        division.add(span);
        span = new Span(PORT_RANGE_VALIDATION_MESSAGE, this.resMap.get(PORT_RANGE_VALIDATION_MESSAGE));
        division.add(span);
        span = new Span(MAX_LENGTH_256, this.resMap.get(MAX_LENGTH_256));
        division.add(span);
        span = new Span(MAX_LENGTH_5, this.resMap.get(MAX_LENGTH_5));
        division.add(span);
    }

    private HTML createLicensingPageHTML(boolean bl) {
        HTML hTML;
        Division division = new Division();
        division.setId("licensing");
        this.addPageResourceStrings(division);
        if (bl) {
            hTML = new ApcSectionHeader(this.resMap.get(UPDATE_LICENSE));
            ((ApcSectionHeader)hTML).setHelpId(ApcHelp.UPDATE_LICENSE);
            division.add(hTML);
        }
        this.addActivationMethodSelectorSection(division, bl);
        hTML = new Division();
        ((HTMLTagWithClassStyle)hTML).setId("activationMethodFields");
        this.addActivationIdSection((Container)hTML, bl);
        this.addQuantitySection((Container)hTML);
        this.addProxySection((Container)hTML);
        this.addErrorSection((Container)hTML);
        this.addOfflineActivationSection((Container)hTML);
        this.addTrialActivationSection((Container)hTML);
        division.add(hTML);
        this.addOnlineActivationSection(division, bl);
        Input input = new Input();
        input.setType("hidden");
        input.setId("cloudLicensingActivationMethod");
        input.setValue(ActivationMethod.CLS.getValue());
        division.add(input);
        Input input2 = new Input();
        input2.setType("hidden");
        input2.setId("offlineLicensingActivationMethod");
        input2.setValue(ActivationMethod.OFFLINE.getValue());
        division.add(input2);
        Input input3 = new Input();
        input3.setType("hidden");
        input3.setId("trialLicensingActivationMethod");
        input3.setValue(ActivationMethod.TRIAL.getValue());
        division.add(input3);
        division.add(this.createActivationDialog());
        division.add(this.createGenerationDialog());
        division.add(this.createWaitDialog());
        return division;
    }

    private void addActivationMethodSelectorSection(Container container, boolean bl) {
        Division division = new Division();
        division.setId(ACTIVATION_METHOD_SECTION_ID);
        division.setCssClass("labelvaluediv");
        if (bl) {
            division.setOption("hidden", "true");
        }
        Span span = new Span();
        span.setCssClass("activationRadioSpan");
        RadioButton radioButton = new RadioButton("activationMethodRadio");
        span.add(radioButton);
        radioButton.setId("onlineActivationRadio");
        radioButton.setDisable(bl);
        radioButton.setValue(ActivationMethod.CLS.getValue());
        radioButton.setCheck(this.licensingManager.isOnlineActivationSelected());
        radioButton.setOnClick("changeActivationMethod(event)");
        Label label = new Label(this.resMap.get(ACTIVATE_ONLINE_RADIO));
        span.add(label);
        label.setFor("onlineActivationRadio");
        this.addToolTip(span, ONLINE_ACTIVATION_TOOLTIP);
        division.add(span);
        Span span2 = new Span();
        span2.setCssClass("activationRadioSpan");
        radioButton = new RadioButton("activationMethodRadio");
        span2.add(radioButton);
        radioButton.setId("offlineActivationRadio");
        radioButton.setDisable(bl);
        radioButton.setValue(ActivationMethod.OFFLINE.getValue());
        radioButton.setCheck(this.licensingManager.isOfflineActivationSelected());
        radioButton.setOnClick("changeActivationMethod(event)");
        label = new Label(this.resMap.get(ACTIVATE_OFFLINE_RADIO));
        span2.add(label);
        label.setFor("offlineActivationRadio");
        this.addToolTip(span2, OFFLINE_ACTIVATION_TOOLTIP);
        division.add(span2);
        Span span3 = new Span();
        span3.setCssClass("activationRadioSpan");
        radioButton = new RadioButton("activationMethodRadio");
        span3.add(radioButton);
        radioButton.setId("trialActivationRadio");
        radioButton.setDisable(bl);
        radioButton.setValue(ActivationMethod.TRIAL.getValue());
        radioButton.setCheck(this.licensingManager.isTrialActivationSelected());
        radioButton.setOnClick("changeActivationMethod(event)");
        label = new Label(this.resMap.get(ACTIVATE_TRIAL_RADIO));
        span3.add(label);
        label.setFor("trialActivationRadio");
        this.addToolTip(span3, TRIAL_ACTIVATION_TOOLTIP);
        division.add(span3);
        container.add(division);
    }

    private void addActivationIdSection(Container container, boolean bl) {
        String string = this.authHelper.getLicensingActivationId();
        Division division = new Division();
        division.setId("activationIdDiv");
        if (bl) {
            division.setCssClass("hidden");
        }
        Division division2 = FormHelper.createLabelTextInputValueDiv(null, this.resMap.get(ACTIVATION_ID_LABEL), string, null, ACTIVATION_ID, null, 255, 30, null);
        this.addToolTip(division2, ACTIVATION_ID_TOOLTIP);
        division.add(division2);
        Span span = new Span(this.licensingUtils.getActivationIdRegex());
        span.setId("activationIdRegex");
        span.setCssClass("hidden");
        division.add(span);
        Span span2 = new Span(this.resMap.get(INVALID_ACTIVATION_ID));
        span2.setId("invalidActivationId");
        span2.setCssClass("hidden");
        division.add(span2);
        container.add(division);
    }

    private void addErrorSection(Container container) {
        Division division = FormHelper.createErrorDivision("licenseValidationMessage", "", null);
        container.add(division);
    }

    private void addQuantitySection(Container container) {
        int n = this.licensingManager.getLicenseQuantity();
        String string = n > 0 ? Integer.toString(n) : Integer.toString(this.licensingUtils.getQuantityFromIni());
        Division division = FormHelper.createLabelTextInputValueDiv(null, this.resMap.get(QUANTITY_LABEL), string, null, "quantity", null, QUANTITY_MAX_LENGTH, null, null, null);
        this.addToolTip(division, QUANTITY_TOOLTIP);
        division.setId("licenseQuantitySection");
        container.add(division);
    }

    private void addTrialActivationSection(Container container) {
        Division division;
        String string = "trialActivationSection";
        if (this.licensingManager.hasExpiredTrialLicense()) {
            division = FormHelper.createErrorDivision(string, this.resMap.get(TRIAL_RENEWAL_NOTICE), null);
        } else {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(this.resMap.get(TRIAL_NOTICE_1));
            arrayList.add(this.resMap.get(TRIAL_NOTICE_2));
            arrayList.add(this.resMap.get(TRIAL_NOTICE_3));
            division = FormHelper.createWarningDivision(string, arrayList, null);
        }
        container.add(division);
    }

    private void addProxySection(Container container) {
        String string = this.licensingConfigManager.getProxyAddress();
        String string2 = Integer.toString(this.licensingConfigManager.getProxyPort());
        String string3 = this.authHelper.getLicensingProxyUsername();
        Division division = new Division();
        division.setId(PROXY_SECTION);
        container.add(division);
        if (this.licensingManager.isOfflineActivationSelected()) {
            division.setCssClass("hidden");
        }
        Division division2 = FormHelper.createLabelTextInputValueDiv(null, this.resMap.get(PROXY_LABEL), string, null, "proxyAddress", null, 255, 30, null);
        this.addToolTip(division2, PROXY_TOOLTIP);
        division.add(division2);
        Division division3 = FormHelper.createLabelTextInputValueDiv(null, this.resMap.get(PROXY_PORT_LABEL_KEY), string2, null, "proxyPort", null, QUANTITY_MAX_LENGTH, null, null, null);
        this.addToolTip(division3, PROXY_PORT_TOOLTIP);
        division.add(division3);
        Division division4 = FormHelper.createLabelTextInputValueDiv(null, this.resMap.get(PROXY_USERNAME), string3, null, PROXY_USERNAME_ID, null, 255, 30, null);
        this.addToolTip(division4, PROXY_USERNAME_TOOLTIP);
        division.add(division4);
        Division division5 = FormHelper.createLabelTextInputValueDiv(null, this.resMap.get(PROXY_PASSWORD), null, null, PROXY_PASSWORD_ID, null, (Integer)255, (Integer)30, null, true);
        this.addToolTip(division5, PROXY_PASSWORD_TOOLTIP);
        division.add(division5);
        Span span = new Span(this.resMap.get(INVALID_PROXY_ADDRESS));
        span.setId("invalidProxyAddress");
        span.setCssClass("hidden");
        division.add(span);
        Span span2 = new Span(this.licensingUtils.getPlaceholderPasswordRegex());
        span2.setId("passwordRegex");
        span2.setCssClass("hidden");
        division.add(span2);
    }

    private void addToolTip(Container container, String string) {
        Image image = new Image();
        image.setSource("/images/Info32.png");
        image.setCssClass("cfgEventIcon");
        image.setId("licensingToolTip");
        image.setTitle(this.resMap.get(string));
        container.add(image);
    }

    private void addActivateButton(Container container, String string, String string2) {
        Button button = new Button();
        button.setId(string2);
        button.setValue(string);
        button.addClass("ui-button-disabled ui-state-disabled");
        button.setDisable(true);
        container.add(button);
    }

    private void addGenerateSection(Container container) {
        Division division = new Division();
        division.setId(OFFLINE_STEPS_ID);
        Span span = new Span(GENERATE_SPAN, this.resMap.get(GENERATE_INSTRUCTIONS));
        division.add(span);
        Button button = new Button();
        button.setId(GENERATION_BUTTON);
        button.setValue(this.resMap.get(GENERATE_BUTTON));
        button.setOnClick("generateLicenseRequest()");
        button.addClass("ui-button-disabled ui-state-disabled");
        button.setDisable(true);
        division.add(button);
        this.addToolTip(division, GENERATE_TOOLTIP);
        container.add(division);
    }

    private void addButtonToFlexnetPortal(Container container) {
        Division division = new Division();
        division.setId(OFFLINE_STEPS_ID);
        Span span = new Span(PORTAL_SPAN, this.resMap.get(PORTAL_INSTRUCTIONS));
        Button button = new Button();
        button.setId(PORTAL_BUTTON_ID);
        button.setValue(this.resMap.get(PORTAL_BUTTON));
        Input input = new Input();
        input.setType("hidden");
        input.setId(PORTAL_URL_ID);
        input.setValue(this.licensingConfigManager.getLicensingPortalAddress());
        division.add(span);
        division.add(button);
        division.add(input);
        this.addToolTip(division, PORTAL_TOOLTIP);
        container.add(division);
    }

    private void addUploadButton(Container container) {
        Division division = new Division();
        division.setId(OFFLINE_STEPS_ID);
        Span span = new Span(UPLOAD_SPAN, this.resMap.get(UPLOAD_INSTRUCTIONS));
        Input input = new Input();
        input.setId(UPLOAD_INPUT);
        input.setType("file");
        input.setAcceptFileType(".bin");
        input.setClassName("hidden");
        Button button = new Button();
        button.setValue(this.resMap.get(UPLOAD_RESPONSE_BUTTON));
        button.setId(UPLOAD_BUTTON);
        division.add(span);
        division.add(button);
        division.add(input);
        this.addToolTip(division, UPLOAD_TOOLTIP);
        container.add(division);
    }

    private HTML createActivationDialog() {
        Division division = new Division();
        division.setId("activationDialog");
        division.setCssClass("activationDialog");
        division.setTitle(this.resMap.get(ACTIVATION_DIALOG_TITLE));
        division.add(new Text(this.resMap.get(ACTIVATION_DIALOG_BODY)));
        return division;
    }

    private HTML createWaitDialog() {
        Division division = new Division();
        division.setId("waitDialog");
        division.setCssClass("waitDialog");
        division.setTitle(this.resMap.get(WAIT_DIALOG_TITLE));
        division.add(new Text(this.resMap.get(WAIT_DIALOG_BODY)));
        return division;
    }

    private HTML createGenerationDialog() {
        Division division = new Division();
        division.setId("generationDialog");
        division.setCssClass("activationDialog");
        division.setTitle(this.resMap.get(GENERATION_DIALOG_TITLE));
        division.add(new Text(this.resMap.get(GENERATION_DIALOG_BODY)));
        return division;
    }

    private void addOnlineActivationSection(Container container, boolean bl) {
        Division division = new Division();
        division.setId("onlineActivationDiv");
        if (this.licensingManager.isOfflineActivationSelected()) {
            division.setCssClass("hidden");
        }
        if (bl) {
            this.addActivateButton(division, this.resMap.get(UPDATE), ACTIVATION_BUTTON);
        } else {
            this.addActivateButton(division, this.resMap.get(ACTIVATE_BUTTON), ACTIVATION_BUTTON);
        }
        container.add(division);
    }

    private void addOfflineActivationSection(Container container) {
        Division division = new Division();
        Division division2 = new Division();
        division.setId(OFFLINE_ACTIVATION_DIV);
        if (!this.licensingManager.isOfflineActivationSelected()) {
            division.setCssClass("hidden");
        }
        division.add(FormHelper.createWarningDivision("generationErrorMessage", this.resMap.get(DOWNLOAD_FAILED_MESSAGE), null));
        this.addGenerateSection(division2);
        this.addButtonToFlexnetPortal(division2);
        this.addUploadButton(division2);
        Division division3 = new Division();
        division3.setCssClass("hidden");
        division.add(division3);
        Span span = new Span();
        span.setId("invalidResponseMsg");
        span.setText(this.resMap.get(INVALID_RESPONSE));
        division3.add(span);
        span = new Span();
        span.setId("invalidFileSizeMsg");
        span.setText(this.resMap.get(INVALID_FILE_SIZE));
        division3.add(span);
        span = new Span();
        span.setId("invalidFileTypeMsg");
        span.setText(this.resMap.get(INVALID_FILE_TYPE));
        division3.add(span);
        division.add(division2);
        container.add(division);
    }
}

