/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.util;

import com.apcc.m11.components.webserver.html.Container;
import com.apcc.m11.components.webserver.html.HTML;
import com.apcc.m11.components.webserver.html.HTMLTagWithClassStyle;
import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.html.apc.ApcHelp;
import com.apcc.m11.components.webserver.html.apc.ApcSectionHeader;
import com.apcc.m11.components.webserver.html.document.Division;
import com.apcc.m11.components.webserver.html.document.Span;
import com.apcc.m11.components.webserver.util.FormHelper;
import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.configservice.AuthHelper;
import com.apcc.pcns.licensing.ILicensingManager;
import com.apcc.pcns.licensing.ILicensingUtils;
import com.apcc.pcns.licensing.LicenseDetails;
import com.apcc.pcns.licensing.provider.LicenseProvider;
import com.apcc.pcns.util.ResourceBundleWrapper;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Optional;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LicensingPanelHelper {
    private static final String LICENSE_ERROR = "License Error";
    private static final String VALUE = "value";
    private static final String LABEL = "label";
    private static final String LABEL_VALUE_DIV = "labelvaluediv";
    private AuthHelper authHelper;
    private ILicensingManager licensingManager;
    private Optional<LicenseDetails> licenseDetails;
    private ILicensingUtils licensingUtils;
    private static final Logger logger = LogManager.getLogger(LicensingPanelHelper.class);
    private Boolean hidePanel = false;
    public static final String LICENSE_SECTION_NAME_LABEL = "CfgWizard.LicensingDetailsPage.PageTitle";
    public static final String LICENSE_SUBHEADING_LABEL = "CfgWizard.LicensingDetailsPage.PageDescription";
    public static final String LICENSE_FEATURE_NAME_LABEL = "Licensing.FeatureName";
    public static final String LICENSE_ACTIVATION_DATE_LABEL = "Licensing.ActivationDate";
    public static final String LICENSE_RENEWAL_DATE_LABEL = "Licensing.RenewalDate";
    public static final String LICENSE_ACTIVATION_ID_LABEL = "Licensing.ActivationID";
    public static final String LOCAL_LICENSING_SERVER_ADDRESS_LABEL = "Licensing.LocalLicensingServerAddress";
    public static final String LICENSING_SECTION_DETAILS = "Licensing.SectionDetails";
    public static final String LICENSE_QUANTITY_LABEL = "Licensing.Quantity";
    public static final String LICENSING_PURCHASE_LINK_LABEL = "Licensing.LinkText";
    public static final String LICENSING_PURCHASE_LINK = "Licensing.LinkAddress";
    private static final String LICENSE_EXPIRED_WARNING = "Licensing.ExpiredLicenseWarning";
    public static final String LICENSING_DEVICE_ID = "Licensing.DeviceID";
    private static final String LICENSE_DURATION_LABEL = "Licensing.Details.Label.DaysRemaining";
    private static final String LICENSE_DURATION_VALUE = "Licensing.Details.Value.DaysRemaining";
    private static final String LICENSE_TYPE_SUBSCRIPTION = "Licensing.Type.Subscription";
    private static final String LICENSE_TYPE_TRIAL = "Licensing.Type.Trial";
    private String licenseDurationLabel;
    private String licenseDurationValue;
    private String licenseTypeSubscription;
    private String licenseTypeTrial;
    private String theFeatureNameValue;
    private String theActivationDateValue;
    private String theRenewalDateValue;
    private String theQuantityValue;
    private String theLicenseLinkText;
    private String thePurchaseLink;
    private String deviceIDValue;
    private String theSectionName;
    private String theSectionSubheading;
    private String theFeatureNameText;
    private String theActivationDateText;
    private String theRenewalDateText;
    private String theActivationIDText;
    private String theLocalLicensingServerText;
    private String theQuantityText;
    private String licenseExpiredWarning;
    private String deviceIDText;

    public LicensingPanelHelper(Locale locale, @NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("services is marked non-null but is null");
        }
        this.licensingManager = serviceManager.getLicensingManager();
        this.licensingManager.init();
        this.licenseDetails = this.licensingManager.getLicense();
        this.authHelper = serviceManager.getAuthHelper();
        this.licensingUtils = serviceManager.getLicensingUtils();
        this.hidePanel = !this.licensingManager.hasLicense();
        this.setupLanguage(locale);
    }

    public Division createLicensingPanelHTML(PageContext pageContext, boolean bl) {
        String string;
        HTML hTML;
        this.processLicenseDetails(this.licenseDetails);
        Division division = new Division();
        division.setId("licenseContainer");
        if (!bl) {
            hTML = new ApcSectionHeader(this.theSectionName, this.theSectionSubheading);
            ((ApcSectionHeader)hTML).setHelpId(ApcHelp.LICENSING);
            division.add(hTML);
        }
        if (this.licensingManager.isInGracePeriod()) {
            division.add(FormHelper.createErrorDivision("errorcontainer", this.licenseExpiredWarning, "error-alert"));
        }
        hTML = new Division();
        ((HTMLTagWithClassStyle)hTML).setId("licenseInfo");
        ((HTMLTagWithClassStyle)hTML).setCssClass("formdiv");
        Division division2 = new Division();
        division2.setCssClass(LABEL_VALUE_DIV);
        Span span = new Span(this.theFeatureNameText);
        span.setCssClass(LABEL);
        division2.add(span);
        span = new Span(this.theFeatureNameValue);
        span.setCssClass(VALUE);
        span.setId("infoFeatureName");
        division2.add(span);
        ((Container)hTML).add(division2);
        Division division3 = new Division();
        division3.setCssClass(LABEL_VALUE_DIV);
        Span span2 = new Span(this.theQuantityText);
        span2.setCssClass(LABEL);
        division3.add(span2);
        span2 = new Span(this.theQuantityValue);
        span2.setCssClass(VALUE);
        span2.setId("infoQuantity");
        division3.add(span2);
        ((Container)hTML).add(division3);
        Division division4 = this.createLicenseTypeDiv();
        ((Container)hTML).add(division4);
        Division division5 = new Division();
        division5.setCssClass(LABEL_VALUE_DIV);
        Span span3 = new Span(this.theActivationDateText);
        span3.setCssClass(LABEL);
        division5.add(span3);
        span3 = new Span(this.theActivationDateValue);
        span3.setCssClass(VALUE);
        span3.setId("infoActivationDate");
        division5.add(span3);
        ((Container)hTML).add(division5);
        Division division6 = new Division();
        division6.setCssClass(LABEL_VALUE_DIV);
        Span span4 = new Span(this.theRenewalDateText);
        span4.setCssClass(LABEL);
        division6.add(span4);
        span4 = new Span(this.theRenewalDateValue);
        span4.setCssClass(VALUE);
        span4.setId("infoRenewalDate");
        division6.add(span4);
        ((Container)hTML).add(division6);
        Division division7 = new Division();
        division7.setCssClass(LABEL_VALUE_DIV);
        Span span5 = new Span(this.deviceIDText);
        span5.setCssClass(LABEL);
        division7.add(span5);
        span5 = new Span(this.deviceIDValue);
        span5.setCssClass(VALUE);
        span5.setId("deviceID");
        division7.add(span5);
        ((Container)hTML).add(division7);
        if (!this.licensingManager.isLLSActivationSelected()) {
            ((Container)hTML).add(this.createActivationInformation());
        }
        if ((string = this.licensingUtils.getLLSURL(false)) != null) {
            ((Container)hTML).add(this.createLocalLicensingInformation(string));
        }
        division.add(hTML);
        if (this.hidePanel.booleanValue() && bl) {
            division.setCssClass("hidden");
        }
        return division;
    }

    public Division createLicenseTypeDiv() {
        Division division = new Division();
        division.setCssClass(LABEL_VALUE_DIV);
        Span span = new Span(this.licenseDurationLabel);
        span.setCssClass(LABEL);
        division.add(span);
        long l = 0L;
        if (this.licensingManager.getLicense().isPresent()) {
            l = this.licensingManager.getLicense().get().getNumberOfDaysTillLicenseExpires();
        } else {
            logger.error("createLicenseTypeDiv() - unable to retrieve LicenseDetails");
        }
        LicenseProvider licenseProvider = this.licensingManager.getLicenseProvider();
        String string = licenseProvider.hasSubscriptionLicense() ? this.licenseTypeSubscription : this.licenseTypeTrial;
        String string2 = MessageFormat.format(this.licenseDurationValue, string, l);
        span = new Span(string2);
        span.setCssClass(VALUE);
        span.setId("id-license-duration");
        division.add(span);
        return division;
    }

    public Container addPurchaseLink() {
        Division division = new Division();
        Span span = new Span(this.theLicenseLinkText);
        span.setCssClass("purchaseHeader");
        division.add(span);
        span = new Span(this.thePurchaseLink);
        span.setCssClass("purchaseLink");
        division.add(span);
        return division;
    }

    private void setupLanguage(Locale locale) {
        ResourceBundleWrapper resourceBundleWrapper = Utils.getWebServerResourceBundle(locale);
        this.theSectionName = Utils.getResourceString(resourceBundleWrapper, LICENSE_SECTION_NAME_LABEL);
        this.theSectionSubheading = Utils.getResourceString(resourceBundleWrapper, LICENSE_SUBHEADING_LABEL);
        this.theFeatureNameText = Utils.getResourceString(resourceBundleWrapper, LICENSE_FEATURE_NAME_LABEL);
        this.theActivationDateText = Utils.getResourceString(resourceBundleWrapper, LICENSE_ACTIVATION_DATE_LABEL);
        this.theRenewalDateText = Utils.getResourceString(resourceBundleWrapper, LICENSE_RENEWAL_DATE_LABEL);
        this.theActivationDateText = Utils.getResourceString(resourceBundleWrapper, LICENSE_ACTIVATION_DATE_LABEL);
        this.theActivationIDText = Utils.getResourceString(resourceBundleWrapper, LICENSE_ACTIVATION_ID_LABEL);
        this.theLocalLicensingServerText = Utils.getResourceString(resourceBundleWrapper, LOCAL_LICENSING_SERVER_ADDRESS_LABEL);
        this.theQuantityText = Utils.getResourceString(resourceBundleWrapper, LICENSE_QUANTITY_LABEL);
        this.theLicenseLinkText = Utils.getResourceString(resourceBundleWrapper, LICENSING_PURCHASE_LINK_LABEL);
        this.thePurchaseLink = Utils.getResourceString(resourceBundleWrapper, LICENSING_PURCHASE_LINK);
        this.licenseExpiredWarning = Utils.getResourceString(resourceBundleWrapper, LICENSE_EXPIRED_WARNING);
        this.deviceIDText = Utils.getResourceString(resourceBundleWrapper, LICENSING_DEVICE_ID);
        this.licenseDurationLabel = Utils.getResourceString(resourceBundleWrapper, LICENSE_DURATION_LABEL);
        this.licenseDurationValue = Utils.getResourceString(resourceBundleWrapper, LICENSE_DURATION_VALUE);
        this.licenseTypeSubscription = Utils.getResourceString(resourceBundleWrapper, LICENSE_TYPE_SUBSCRIPTION);
        this.licenseTypeTrial = Utils.getResourceString(resourceBundleWrapper, LICENSE_TYPE_TRIAL);
    }

    private void processLicenseDetails(Optional<LicenseDetails> optional) {
        this.theFeatureNameValue = LICENSE_ERROR;
        this.theActivationDateValue = LICENSE_ERROR;
        this.theRenewalDateValue = LICENSE_ERROR;
        this.deviceIDValue = LICENSE_ERROR;
        if (optional.isPresent()) {
            this.theFeatureNameValue = optional.get().getFeatureName();
            this.theActivationDateValue = optional.get().getActivationDate().toString();
            this.theRenewalDateValue = optional.get().getExpiryDate().toString();
            this.theQuantityValue = Integer.toString(optional.get().getQuantity());
            this.deviceIDValue = this.licensingUtils.getDeviceId();
        }
        logger.debug("processLicenseDetails() - Feature Name: {}, Activation Date: {}, Renewal Date: {}, Quantity: {}", (Object)this.theFeatureNameValue, (Object)this.theActivationDateValue, (Object)this.theRenewalDateValue, (Object)this.theQuantityValue);
    }

    private HTML createActivationInformation() {
        Division division = new Division();
        division.setCssClass(LABEL_VALUE_DIV);
        Span span = new Span(this.theActivationIDText);
        span.setCssClass(LABEL);
        division.add(span);
        String string = this.authHelper.getLicensingActivationId();
        if (StringUtils.isBlank((CharSequence)string)) {
            string = "Not Set";
        }
        span = new Span(string);
        span.setCssClass(VALUE);
        span.setId("infoActivationId");
        division.add(span);
        return division;
    }

    private HTML createLocalLicensingInformation(String string) {
        Division division = new Division();
        division.setCssClass(LABEL_VALUE_DIV);
        Span span = new Span(this.theLocalLicensingServerText);
        span.setCssClass(LABEL);
        division.add(span);
        span = new Span(string);
        span.setCssClass(VALUE);
        division.add(span);
        return division;
    }
}

