/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.util;

import com.apcc.m11.components.webserver.html.HTML;
import com.apcc.m11.components.webserver.html.apc.ApcHelp;
import com.apcc.m11.components.webserver.html.apc.ApcSectionHeader;
import com.apcc.m11.components.webserver.html.document.Division;
import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.util.ResourceBundleWrapper;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import lombok.NonNull;

public class LogBundleHTMLHelper {
    private static final String LOG_BUNDLE_PAGE_TITLE = "LogBundle.Main.Title";
    private static final String LOG_BUNDLE_PAGE_DESCRIPTION = "LogBundle.Main.Description";
    private static final String WAIT_DIALOG_TITLE = "PCNS.WaitTitle";
    private static final String WAIT_DIALOG_TEXT = "PCNS.WaitText";
    private String waitDialogTitle;
    private String waitDialogText;
    private Map<String, String> resMap;

    public LogBundleHTMLHelper(Locale locale, @NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("services is marked non-null but is null");
        }
        this.resMap = new HashMap<String, String>();
        this.getResourceStrings(locale);
    }

    private void getResourceStrings(Locale locale) {
        ResourceBundleWrapper resourceBundleWrapper = Utils.getWebServerResourceBundle(locale);
        this.resMap.put(LOG_BUNDLE_PAGE_TITLE, Utils.getResourceString(resourceBundleWrapper, LOG_BUNDLE_PAGE_TITLE));
        this.resMap.put(LOG_BUNDLE_PAGE_DESCRIPTION, Utils.getResourceString(resourceBundleWrapper, LOG_BUNDLE_PAGE_DESCRIPTION));
    }

    public HTML createErrorPanel() {
        Division division = new Division();
        division.setId("errorcontainer");
        division.setCssClass("ui-state-error ui-corner-all");
        return division;
    }

    public HTML createLogBundlePageHTML() {
        Division division = new Division();
        division.setId("logBundle");
        ApcSectionHeader apcSectionHeader = new ApcSectionHeader(this.resMap.get(LOG_BUNDLE_PAGE_TITLE), this.resMap.get(LOG_BUNDLE_PAGE_DESCRIPTION));
        apcSectionHeader.setHelpId(ApcHelp.LOG_BUNDLE);
        division.add(apcSectionHeader);
        return division;
    }
}

