/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.util;

import com.apcc.m11.components.webserver.html.HTML;
import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.html.apc.ApcHelp;
import com.apcc.m11.components.webserver.html.apc.ApcMenu;
import com.apcc.m11.components.webserver.html.document.Division;
import com.apcc.m11.components.webserver.html.document.Span;
import com.apcc.m11.components.webserver.model.MenuItem;
import com.apcc.m11.components.webserver.model.NMC;
import com.apcc.m11.components.webserver.model.UPSSetup;
import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.util.ResourceBundleWrapper;
import java.util.List;
import java.util.Locale;
import lombok.NonNull;

public class MenuHelper {
    private static final String SYSTEM_LOG_ID = "Menu.System.EventLog";
    private static final String SYSTEM_CONFIGURE_ID = "Menu.System.Configure";
    private static final String SYSTEM_UPDATES_ID = "Menu.System.Updates";
    private static final String CEIP_ID = "Menu.System.CEIP";
    private static final String SYSTEM_EVENTS_ID = "Menu.System.EventActions";
    private static final String SYSTEM_CONFIGURE_SHUTDOWN_ID = "Menu.System.ConfigShutdown";
    private static final String SNMP_ID = "SNMP.SNMPHeader";
    private static final String SYSTEM_VM_SETTINGS_ID = "Menu.System.VMSettings";
    private static final String SYSTEM_CONFIG_WIZARD_ID = "Menu.System.CfgWizard";
    private static final String HOME_MENU_TITLE = "Menu.Home";
    private static final String CONFIGURATION_ID = "Menu.Configuration";
    private static final String UPS_ID = "Menu.UPS";
    private static final String UPS_POWERED_ID = "Menu.UPS.Powered";
    private static final String UPS_VM_SETTINGS_ID = "Menu.UPS.VMSettings";
    private static final String SYSTEM_HOST_NMC_MAPPING = "Menu.System.HostNMCMapping";
    private static final String SYSTEM_TARGET_HOST_SELECTION = "Menu.System.TargetHostSelection";
    private static final String SYSTEM_VM_PRIORITIZATION = "Menu.System.VMPrioritization";
    private static final String HELP_ID = "Menu.Help";
    private static final String ABOUT_ID = "Menu.Help.Omaha";
    private static final String ABOUT_HELP_CONTENTS = "Menu.Help.HelpContents";
    private static final String ONLINE_HELP_ID = "Menu.Help.OnlineHelp";
    private static final String ONLINE_SUPPORT_URL = "www.apc.com/support/";
    private static final String CLOSE_ID = "PCNS.CloseButton";
    private static final String ABOUT_TITLE = "Menu.Help.OmahaTitle";
    private static final String SYSTEM_NUTANIX_SETTING = "Menu.System.NutanixSettings";
    private static final String SSH_TITLE = "Menu.System.SSH";
    private static final String LICENSE_TITLE = "CfgWizard.LicensingPage.PageTitle";
    private static final String VIRTUALIZATION_ID = "Menu.Virtualization";
    private static final String LOG_BUNDLE_TITLE = "Menu.Help.LogBundle";
    private String theCloseText;
    private String theAboutTitle;
    private String theSystemLogText;
    private String theSystemConfigureText;
    private String theSystemVMSettingsText;
    private String theSystemUpdatesText;
    private String theCEIPText;
    private String theSystemEventsText;
    private String theSystemConfigShutdownText;
    private String theSNMPText;
    private String theSystemCfgWizardText;
    private String theUPSText;
    private String theVMSettingsText;
    private String theUPSPoweredText;
    private String theSystemHostNMCMappingText;
    private String theSystemTargetHostSelectionText;
    private String theSystemVMPrioritizationText;
    private String theHelpText;
    private String theAboutOmahaText;
    private String theHelpContentsText;
    private String theOnlineHelpText;
    private String theNutanixSettingsText;
    private String theLicensingText;
    private String theVirtualizationMenuText;
    private String theSSHText;
    private String theConfigurationText;
    private String theHomeMenuTitle;
    private String theLogBundleText;
    private ServiceManager services;

    public MenuHelper(@NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        this.services = serviceManager;
    }

    public void createMenu(ApcMenu apcMenu, PageContext pageContext) {
        boolean bl = this.services.getVirtualConfigurationManager().isManagedHost();
        boolean bl2 = this.services.getVirtualConfigurationManager().isHyperV();
        boolean bl3 = this.services.getVirtualConfigurationManager().isESXi();
        boolean bl4 = bl3 && bl;
        boolean bl5 = this.services.getVirtualConfigurationManager().isNutanixAHV();
        apcMenu.clearMenuList();
        this.setupLanguage(pageContext.getLocale());
        apcMenu.addMenu(this.createServerMenu());
        apcMenu.addMenu(this.createConfigurationMenu());
        if (bl2 || bl4 || bl5) {
            apcMenu.addMenu(this.createVirtualizationMenu());
        }
        if (this.services.getAdvancedSetupHelper().isAdvancedShutdownMode()) {
            this.createAdvancedUPSMenu(apcMenu);
        } else {
            apcMenu.addMenu(this.createUPSMenu(pageContext));
        }
        apcMenu.addMenu(this.createHelpMenu());
    }

    public HTML getAboutPageResourceStrings(@NonNull PageContext pageContext) {
        if (pageContext == null) {
            throw new IllegalArgumentException("aCtx is marked non-null but is null");
        }
        this.setupLanguage(pageContext.getLocale());
        Division division = new Division();
        division.setId("resources");
        Span span = new Span(this.theCloseText);
        span.setId("resCloseButton");
        span.setCssClass("hidden");
        division.add(span);
        Span span2 = new Span(this.theAboutTitle);
        span2.setId("resAboutTitle");
        span2.setCssClass("hidden");
        division.add(span2);
        return division;
    }

    private MenuItem createServerMenu() {
        MenuItem menuItem = new MenuItem(this.theHomeMenuTitle);
        menuItem.addMenuItem(new MenuItem(this.theSystemLogText, "/eventlog"));
        return menuItem;
    }

    private MenuItem createConfigurationMenu() {
        MenuItem menuItem = new MenuItem(this.theConfigurationText);
        MenuItem menuItem2 = new MenuItem(this.theSystemEventsText, "/selectevents");
        menuItem.addMenuItem(menuItem2);
        menuItem2 = new MenuItem(this.theSystemConfigureText, "/configure");
        menuItem.addMenuItem(menuItem2);
        if (this.services.getVirtualConfigurationManager().isNutanixESXi()) {
            menuItem2 = new MenuItem(this.theNutanixSettingsText, "/NutanixSettings");
            menuItem.addMenuItem(menuItem2);
        }
        menuItem2 = this.services.getAdvancedSetupHelper().isAdvancedShutdownMode() ? new MenuItem(this.theSystemConfigShutdownText, "/advancedshutdown") : new MenuItem(this.theSystemConfigShutdownText, "/configureshutdownsettings");
        menuItem.addMenuItem(menuItem2);
        menuItem2 = new MenuItem(this.theSSHText, "/sshsettings");
        menuItem.addMenuItem(menuItem2);
        menuItem2 = new MenuItem(this.theSNMPText, "/configuresnmpsettings");
        menuItem.addMenuItem(menuItem2);
        menuItem2 = new MenuItem(this.theSystemCfgWizardText, "/cfgwizard");
        menuItem.addMenuItem(menuItem2);
        return menuItem;
    }

    private MenuItem createUPSMenu(PageContext pageContext) {
        MenuItem menuItem = new MenuItem(this.theUPSText);
        for (NMC nMC : Utils.getNMCList(pageContext, false, false)) {
            menuItem.addMenuItem(new MenuItem(nMC.getIPAddress(), "/upsconfig?nmcip=" + nMC.getIPAddress()));
        }
        menuItem.addMenuItem(new MenuItem(this.theUPSPoweredText, "/ConnectedServers"));
        return menuItem;
    }

    private void createAdvancedUPSMenu(ApcMenu apcMenu) {
        MenuItem menuItem = new MenuItem(this.theUPSText);
        int n = 0;
        List<UPSSetup> list = this.services.getAdvancedSetupHelper().readUPSSetupsFromConfig();
        if (list != null) {
            for (UPSSetup uPSSetup : list) {
                menuItem.addMenuItem(this.createUPSSetupMenu(n, uPSSetup));
                ++n;
            }
        }
        apcMenu.addMenu(menuItem);
    }

    private MenuItem createUPSSetupMenu(int n, UPSSetup uPSSetup) {
        MenuItem menuItem = new MenuItem(uPSSetup.getNameEsc());
        for (String string : uPSSetup.getNMCList()) {
            menuItem.addMenuItem(new MenuItem(string, "/upsconfig?nmcip=" + string));
        }
        if ((this.services.getVirtualConfigurationManager().isManagedHost() || this.services.getVirtualConfigurationManager().isNutanixAHV()) && !uPSSetup.getHosts().isEmpty()) {
            menuItem.addMenuItem(new MenuItem(this.theVMSettingsText, "/individualvmsettings?setup=" + n));
        }
        menuItem.addMenuItem(new MenuItem(this.theSSHText, "/advancedsshsettings?setup=" + n));
        menuItem.addMenuItem(new MenuItem(this.theUPSPoweredText, "/ConnectedServers?setup=" + n));
        return menuItem;
    }

    private MenuItem createVirtualizationMenu() {
        boolean bl = this.services.getVirtualConfigurationManager().isManagedHost();
        boolean bl2 = this.services.getVirtualConfigurationManager().isESXi();
        boolean bl3 = this.services.getVirtualConfigurationManager().isNutanixAHV();
        boolean bl4 = this.services.getVirtualConfigurationManager().isUnmanagedHyperV();
        MenuItem menuItem = new MenuItem(this.theVirtualizationMenuText);
        MenuItem menuItem2 = new MenuItem(this.theSystemVMSettingsText, "/vmsettings");
        menuItem.addMenuItem(menuItem2);
        if (bl || bl3) {
            if (this.services.getAdvancedSetupHelper().isAdvancedShutdownMode()) {
                menuItem.addMenuItem(new MenuItem(this.theSystemHostNMCMappingText, "/hostnmcmapping"));
            } else {
                menuItem.addMenuItem(new MenuItem(this.theSystemTargetHostSelectionText, "/targethostselection"));
            }
            if (bl2 || bl3) {
                menuItem.addMenuItem(new MenuItem(this.theSystemVMPrioritizationText, "/vmprioritization"));
            }
        }
        if (bl4) {
            menuItem.addMenuItem(new MenuItem(this.theSystemVMPrioritizationText, "/vmprioritization"));
        }
        return menuItem;
    }

    private MenuItem createHelpMenu() {
        MenuItem menuItem;
        MenuItem menuItem2 = new MenuItem(this.theHelpText);
        if (!this.services.getWebServerUtils().isJapanese()) {
            menuItem = new MenuItem(this.theSystemUpdatesText, "/updates");
            menuItem.setId("updates");
            menuItem2.addMenuItem(menuItem);
        }
        menuItem = new MenuItem(this.theHelpContentsText, "javascript:" + ApcHelp.getOnClick(ApcHelp.INTRODUCTION1));
        menuItem.setScriptLink(true);
        menuItem2.addMenuItem(menuItem);
        if (this.services.getLicensingUtils().isLicensedTier()) {
            menuItem = new MenuItem(this.theLicensingText, "/licensing");
            menuItem2.addMenuItem(menuItem);
        }
        menuItem = new MenuItem(this.theCEIPText, "/ceip");
        menuItem.setId("menuItemCEIP");
        menuItem2.addMenuItem(menuItem);
        menuItem = new MenuItem(this.theOnlineHelpText, "http://www.apc.com/support/");
        menuItem.setOpenInNewPage(true);
        menuItem2.addMenuItem(menuItem);
        menuItem = new MenuItem(this.theLogBundleText, "/logBundle");
        menuItem2.addMenuItem(menuItem);
        menuItem = new MenuItem(this.theAboutOmahaText, "#");
        menuItem.setId("about");
        menuItem2.addMenuItem(menuItem);
        return menuItem2;
    }

    private void setupLanguage(Locale locale) {
        ResourceBundleWrapper resourceBundleWrapper = Utils.getWebServerResourceBundle(locale);
        this.theSystemLogText = Utils.getResourceString(resourceBundleWrapper, SYSTEM_LOG_ID);
        this.theSystemConfigureText = Utils.getResourceString(resourceBundleWrapper, SYSTEM_CONFIGURE_ID);
        this.theSystemUpdatesText = Utils.getResourceString(resourceBundleWrapper, SYSTEM_UPDATES_ID);
        this.theCEIPText = Utils.getResourceString(resourceBundleWrapper, CEIP_ID);
        this.theSystemEventsText = Utils.getResourceString(resourceBundleWrapper, SYSTEM_EVENTS_ID);
        this.theSystemConfigShutdownText = Utils.getResourceString(resourceBundleWrapper, SYSTEM_CONFIGURE_SHUTDOWN_ID);
        this.theSNMPText = Utils.getResourceString(resourceBundleWrapper, SNMP_ID);
        this.theSystemVMSettingsText = Utils.getResourceString(resourceBundleWrapper, SYSTEM_VM_SETTINGS_ID);
        this.theSystemCfgWizardText = Utils.getResourceString(resourceBundleWrapper, SYSTEM_CONFIG_WIZARD_ID);
        this.theUPSText = Utils.getResourceString(resourceBundleWrapper, UPS_ID);
        this.theUPSPoweredText = Utils.getResourceString(resourceBundleWrapper, UPS_POWERED_ID);
        this.theSystemHostNMCMappingText = Utils.getResourceString(resourceBundleWrapper, SYSTEM_HOST_NMC_MAPPING);
        this.theSystemTargetHostSelectionText = Utils.getResourceString(resourceBundleWrapper, SYSTEM_TARGET_HOST_SELECTION);
        this.theSystemVMPrioritizationText = Utils.getResourceString(resourceBundleWrapper, SYSTEM_VM_PRIORITIZATION);
        this.theHelpText = Utils.getResourceString(resourceBundleWrapper, HELP_ID);
        this.theHelpContentsText = Utils.getResourceString(resourceBundleWrapper, ABOUT_HELP_CONTENTS);
        this.theAboutOmahaText = Utils.getResourceString(resourceBundleWrapper, ABOUT_ID);
        this.theOnlineHelpText = Utils.getResourceString(resourceBundleWrapper, ONLINE_HELP_ID);
        this.theVirtualizationMenuText = Utils.getResourceString(resourceBundleWrapper, VIRTUALIZATION_ID);
        this.theVMSettingsText = Utils.getResourceString(resourceBundleWrapper, UPS_VM_SETTINGS_ID);
        this.theSSHText = Utils.getResourceString(resourceBundleWrapper, SSH_TITLE);
        this.theCloseText = Utils.getResourceString(resourceBundleWrapper, CLOSE_ID);
        this.theAboutTitle = Utils.getResourceString(resourceBundleWrapper, ABOUT_TITLE);
        this.theNutanixSettingsText = Utils.getResourceString(resourceBundleWrapper, SYSTEM_NUTANIX_SETTING);
        this.theLicensingText = Utils.getResourceString(resourceBundleWrapper, LICENSE_TITLE);
        this.theConfigurationText = Utils.getResourceString(resourceBundleWrapper, CONFIGURATION_ID);
        this.theHomeMenuTitle = Utils.getResourceString(resourceBundleWrapper, HOME_MENU_TITLE);
        this.theLogBundleText = Utils.getResourceString(resourceBundleWrapper, LOG_BUNDLE_TITLE);
    }
}

