/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.util;

import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.m11.ds.events.flexevents.ShutdownEvents;
import com.apcc.m11.ds.services.messageBroadcastGroup.AllRecipients;
import com.apcc.m11.ds.services.messageBroadcastGroup.ListOfNotificationRecipients;
import com.apcc.m11.ds.services.messageBroadcastGroup.Recipient;
import com.apcc.m11.ds.services.messageBroadcastGroup.RegisterRecipientForNotification;
import com.apcc.m11.ds.services.messageBroadcastGroup.UnRegisterAllRecipientsForNotification;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NotificationHelper {
    private static final Logger logger = LogManager.getLogger(NotificationHelper.class);

    public static void setShutdownNotification(PageContext pageContext) {
        if (Utils.isBroadcastSupported()) {
            ObjectId objectId = ShutdownEvents.ShutdownStarting.getObjectId();
            Recipient recipient = null;
            int n = 0;
            if (objectId != null) {
                String string = pageContext.getPostQueryValue("notifyEnabled");
                String string2 = pageContext.getPostQueryValue("notifyUser");
                String string3 = pageContext.getPostQueryValue("singleUserName");
                if (pageContext.getPostQueryValue("notifyInterval") != null) {
                    String string4 = pageContext.getPostQueryValue("notifyInterval");
                    try {
                        n = Integer.valueOf(string4);
                    }
                    catch (NumberFormatException numberFormatException) {
                        logger.error((Object)numberFormatException);
                        n = 0;
                    }
                }
                pageContext.set(UnRegisterAllRecipientsForNotification.kOid, objectId);
                if (string != null) {
                    String string5 = AllRecipients.kOid.toString();
                    recipient = string2 != null && string2.equals("notifyAllUsers") ? new Recipient(string5, objectId, 0, n) : new Recipient(string3, objectId, 0, n);
                    pageContext.set(RegisterRecipientForNotification.kOid, recipient);
                }
            }
        } else {
            logger.debug("setNotification: Notification is not enabled");
        }
    }

    public static Recipient getShutdownNotificationRecipient(PageContext pageContext) {
        Recipient recipient = null;
        Hashtable hashtable = null;
        try {
            hashtable = (Hashtable)pageContext.get(ListOfNotificationRecipients.kOid);
        }
        catch (Exception exception) {
            logger.error("Unable to get notifications", (Throwable)exception);
        }
        Boolean bl = false;
        if (hashtable != null) {
            logger.trace("notifications != null");
            String string = new ObjectId(ShutdownEvents.ShutdownStarting.getObjectId()).toString();
            if (hashtable.containsKey(string)) {
                bl = true;
                Vector vector = (Vector)hashtable.get(string);
                if (vector != null && vector.size() > 0) {
                    recipient = (Recipient)vector.firstElement();
                }
            }
        }
        pageContext.setValue("notifyEnabled", bl);
        return recipient;
    }
}

