/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.util;

import com.apcc.m11.components.webserver.html.Container;
import com.apcc.m11.components.webserver.html.HTML;
import com.apcc.m11.components.webserver.html.HTMLTagWithClassStyle;
import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.html.Text;
import com.apcc.m11.components.webserver.html.apc.ApcForm;
import com.apcc.m11.components.webserver.html.apc.ApcHelp;
import com.apcc.m11.components.webserver.html.apc.ApcPage;
import com.apcc.m11.components.webserver.html.apc.ApcSectionHeader;
import com.apcc.m11.components.webserver.html.document.Division;
import com.apcc.m11.components.webserver.html.document.Span;
import com.apcc.m11.components.webserver.html.form.Form;
import com.apcc.m11.components.webserver.html.form.Password;
import com.apcc.m11.components.webserver.util.FormHelper;
import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.m11.components.webserver.util.virtualization.nutanix.NutanixDetails;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.util.ResourceBundleWrapper;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public class NutanixHTMLHelper {
    public static final String kNutanixHeaderId = "Configure.NutanixHeader";
    private String theNutanixIPLabel;
    private String theNutanixClusterPasswordLabel;
    private String theNutanixHostPasswordLabel;
    private String theNutanixSshKeyPathLabel;
    private String theNutanixSshKeyPassphraseLabel;
    private String theNutanixAHVHeaderText;
    private String theNutanixAHVSubHeaderText;
    private String thePasswordCheckFailedText;
    private String theSshPassphraseCheckFailedText;
    private String theCurrentSshPassphraseText;
    private String theNewSshPassphraseText;
    private String theRepeatSshPassphraseText;
    private String thePasswordWillBeDeletedWarningText;
    private String theSshKeyPathAndPassphraseWillBeDeletedWarningText;
    private String theClusterPasswordRequiredErrorText;
    private String theHostPasswordRequiredErrorText;
    private String theCheckNutanixAHVHostDetailsButtonText;
    private String theCheckNutanixAHVHostDetailsErrorText;
    private String theCheckNutanixAHVHostDetailsSuccessText;
    private String theCurrentPasswordText;
    private String theNewPasswordText;
    private String theRepeatNewPasswordText;
    private String sshKeyFailedValidation;
    public static final String NUTANIX_CLUSTER_IP = "nutanix_cluster_ip";
    public static final String NUTANIX_USERNAME = "nutanix_cluster_username";
    public static final String NUTANIX_CLUSTER_PASSWORD = "nutanix_cluster_password";
    public static final String NUTANIX_HOST_PASSWORD = "nutanix_host_password";
    public static final String NUTANIX_SSH_KEY_PATH = "nutanix_ssh_key_path";
    public static final String NUTANIX_SSH_KEY_PASSPHRASE = "nutanix_ssh_key_passphrase";
    private static final String kConfigureNutanixClusterIpLabel = "Configure.NutanixClusterIP";
    private static final String kConfigureNutanixClusterPasswordLabel = "Configure.NutanixClusterPassword";
    private static final String kConfigureNutanixHostPasswordLabel = "Configure.NutanixHostPassword";
    private static final String kConfigureNutanixSshKeyPathLabel = "Configure.NutanixClusterSshKeyPathLabel";
    private static final String kConfigureNutanixSshKeyPassphraseLabel = "Configure.NutanixClusterSshKeyPassphraseLabel";
    private static final String kNutanixClusterIpLabel = "CfgWizard.NutanixClusterDetails.NutanixClusterIpLabel";
    private static final String kNutanixClusterPasswordLabel = "CfgWizard.NutanixClusterDetails.NutanixClusterPasswordLabel";
    private static final String kNutanixHostPasswordLabel = "CfgWizard.NutanixClusterDetails.NutanixHostPasswordLabel";
    private static final String kNutanixSshKeyPathLabel = "CfgWizard.NutanixClusterDetails.NutanixClusterSshKeyPathLabel";
    private static final String kNutanixSshKeyPassphraseLabel = "CfgWizard.NutanixClusterDetails.NutanixClusterSshKeyPassphraseLabel";
    private static final String kInvalidNutanixCredentials = "CfgWizard.NutanixClusterDetails.NutanixClusterInvalidCredentials";
    private static final String kNutanixPasswordAndKeyWarning = "CfgWizard.NutanixClusterDetails.NutanixPasswordAndKeyWarning";
    private static final String kNutanixClusterError = "Configure.NutanixClusterError";
    private static final String kNutanixClusterNetworkError = "CfgWizard.NutanixClusterDetails.NutanixClusterNetworkError";
    private static final String kCouldNotLoadKeyWarning = "CfgWizard.NutanixClusterDetails.NutanixClusterCouldNotLoadKey";
    private static final String INVALID_SSH_KEYFILE = "SSHSettings.Action.InvalidSSHKeyFile";
    public static final String kRequiredId = "PCNS.RequiredField";
    public static final String kPasswordOrKeyRequired = "CfgWizard.NutanixClusterDetails.PasswordOrKeyRequiredField";
    public static final String kInvalidIpId = "PCNS.NutanixClusterValidation";
    private static final String kRangeValidation = "PCNS.RangeValidation";
    private static final String kAttemptNutanixClusterConnection = "CfgWizard.NutanixClusterDetails.AttemptNutanixClusterConnection";
    private static final String kHiddenPasswordId = "PCNS.HiddenPassword";
    private static final String kChangePasswordText = "PCNS.ChangePasswordText";
    private static final String kSshPassphraseCheckFailedId = "Configure.SshPassphraseCheckFailed";
    private static final String kCurrentSshPassphraseLabelId = "Configure.CurrentSshPassphraseLabel";
    private static final String kNewSshPassphraseLabelId = "Configure.NewSshPassphraseLabel";
    private static final String kRepeatSshPassphraseLabelId = "Configure.RepeatNewSshPassphraseLabel";
    private static final String kPasswordCheckFailedId = "Configure.PasswordCheckFailed";
    private static final String kCurrentPasswordLabelId = "Configure.CurrentPasswordLabel";
    private static final String kNewPasswordLabelId = "Configure.NewPasswordLabel";
    private static final String kRepeatNewPasswordLabelId = "Configure.RepeatNewPasswordLabel";
    private Map<String, String> resMap = new HashMap<String, String>();
    private ServiceManager services;

    public NutanixHTMLHelper(Locale locale, @NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        this.services = serviceManager;
        this.getVMSettingsResourceStrings(locale);
    }

    private void getVMSettingsResourceStrings(Locale locale) {
        ResourceBundleWrapper resourceBundleWrapper = Utils.getWebServerResourceBundle(locale);
        boolean bl = this.services.getVirtualConfigurationManager().isNutanixAHV();
        this.resMap.put(kNutanixHeaderId, Utils.getResourceString(resourceBundleWrapper, kNutanixHeaderId));
        this.resMap.put(kInvalidNutanixCredentials, Utils.getResourceString(resourceBundleWrapper, kInvalidNutanixCredentials));
        this.resMap.put(kNutanixPasswordAndKeyWarning, Utils.getResourceString(resourceBundleWrapper, kNutanixPasswordAndKeyWarning));
        this.resMap.put(kCouldNotLoadKeyWarning, Utils.getResourceString(resourceBundleWrapper, kCouldNotLoadKeyWarning));
        this.resMap.put(kNutanixClusterError, Utils.getResourceString(resourceBundleWrapper, kNutanixClusterError));
        this.resMap.put(kNutanixClusterNetworkError, Utils.getResourceString(resourceBundleWrapper, kNutanixClusterNetworkError));
        this.resMap.put(kAttemptNutanixClusterConnection, Utils.getResourceString(resourceBundleWrapper, kAttemptNutanixClusterConnection));
        this.resMap.put(kHiddenPasswordId, Utils.getResourceString(resourceBundleWrapper, kHiddenPasswordId));
        this.resMap.put(kChangePasswordText, Utils.getResourceString(resourceBundleWrapper, kChangePasswordText));
        this.resMap.put(kRequiredId, Utils.getResourceString(resourceBundleWrapper, kRequiredId));
        this.resMap.put(kInvalidIpId, Utils.getResourceString(resourceBundleWrapper, kInvalidIpId));
        this.resMap.put(kPasswordOrKeyRequired, Utils.getResourceString(resourceBundleWrapper, kPasswordOrKeyRequired));
        this.resMap.put(kConfigureNutanixClusterIpLabel, Utils.getResourceString(resourceBundleWrapper, kConfigureNutanixClusterIpLabel));
        this.resMap.put(kConfigureNutanixClusterPasswordLabel, Utils.getResourceString(resourceBundleWrapper, kConfigureNutanixClusterPasswordLabel));
        this.resMap.put(kConfigureNutanixHostPasswordLabel, Utils.getResourceString(resourceBundleWrapper, kConfigureNutanixHostPasswordLabel));
        this.resMap.put(kConfigureNutanixSshKeyPathLabel, Utils.getResourceString(resourceBundleWrapper, kConfigureNutanixSshKeyPathLabel));
        this.resMap.put(kConfigureNutanixSshKeyPassphraseLabel, Utils.getResourceString(resourceBundleWrapper, kConfigureNutanixSshKeyPassphraseLabel));
        this.resMap.put(kNutanixClusterIpLabel, Utils.getResourceString(resourceBundleWrapper, kNutanixClusterIpLabel));
        this.resMap.put(kNutanixClusterPasswordLabel, Utils.getResourceString(resourceBundleWrapper, kNutanixClusterPasswordLabel));
        this.resMap.put(kNutanixHostPasswordLabel, Utils.getResourceString(resourceBundleWrapper, kNutanixHostPasswordLabel));
        this.resMap.put(kNutanixSshKeyPathLabel, Utils.getResourceString(resourceBundleWrapper, kNutanixSshKeyPathLabel));
        this.resMap.put(kNutanixSshKeyPassphraseLabel, Utils.getResourceString(resourceBundleWrapper, kNutanixSshKeyPassphraseLabel));
        this.theNutanixAHVHeaderText = Utils.getResourceString(resourceBundleWrapper, "Configure.NutanixAHVHeader");
        this.theNutanixAHVSubHeaderText = Utils.getResourceString(resourceBundleWrapper, "Configure.NutanixAHVSubHeader");
        this.thePasswordCheckFailedText = Utils.getResourceString(resourceBundleWrapper, kPasswordCheckFailedId);
        this.theSshPassphraseCheckFailedText = Utils.getResourceString(resourceBundleWrapper, kSshPassphraseCheckFailedId);
        this.theCurrentSshPassphraseText = Utils.getResourceString(resourceBundleWrapper, kCurrentSshPassphraseLabelId);
        this.theNewSshPassphraseText = Utils.getResourceString(resourceBundleWrapper, kNewSshPassphraseLabelId);
        this.theRepeatSshPassphraseText = Utils.getResourceString(resourceBundleWrapper, kRepeatSshPassphraseLabelId);
        this.thePasswordWillBeDeletedWarningText = Utils.getResourceString(resourceBundleWrapper, bl ? "Configure.ClusterAndHostPasswordsWillBeDeletedWarning" : "NutanixSettings.ClusterPasswordWillBeDeletedWarning");
        this.theSshKeyPathAndPassphraseWillBeDeletedWarningText = Utils.getResourceString(resourceBundleWrapper, bl ? "Configure.SshKeyPathAndPassphraseWillBeDeletedWarning" : "NutanixSettings.SshKeyPathAndPassphraseWillBeDeletedWarning");
        this.theClusterPasswordRequiredErrorText = Utils.getResourceString(resourceBundleWrapper, "Configure.NutanixClusterPasswordRequired");
        this.theHostPasswordRequiredErrorText = Utils.getResourceString(resourceBundleWrapper, "Configure.NutanixHostPasswordRequired");
        this.theCheckNutanixAHVHostDetailsButtonText = Utils.getResourceString(resourceBundleWrapper, "Configure.CheckNutanixAHVHostDetails");
        this.theCheckNutanixAHVHostDetailsErrorText = Utils.getResourceString(resourceBundleWrapper, "Configure.CheckNutanixAHVHostDetailsError");
        this.theCheckNutanixAHVHostDetailsSuccessText = Utils.getResourceString(resourceBundleWrapper, "Configure.CheckNutanixAHVHostDetailsSuccess");
        this.theCurrentPasswordText = Utils.getResourceString(resourceBundleWrapper, kCurrentPasswordLabelId);
        this.theNewPasswordText = Utils.getResourceString(resourceBundleWrapper, kNewPasswordLabelId);
        this.theRepeatNewPasswordText = Utils.getResourceString(resourceBundleWrapper, kRepeatNewPasswordLabelId);
        this.sshKeyFailedValidation = Utils.getResourceString(resourceBundleWrapper, INVALID_SSH_KEYFILE);
    }

    public void addResources(Container container) {
        String string = this.resMap.get(kRequiredId);
        Span span = new Span();
        span.add(new Text(string));
        span.setId("requiredSpan");
        span.setCssClass("hidden");
        container.add(span);
        String string2 = this.resMap.get(kPasswordOrKeyRequired);
        Span span2 = new Span();
        span2.add(new Text(string2));
        span2.setId("passwordOrKeyRequiredSpan");
        span2.setCssClass("hidden");
        container.add(span2);
        String string3 = this.resMap.get(kInvalidIpId);
        Span span3 = new Span();
        span3.add(new Text(string3));
        span3.setId("invalidIpSpan");
        span3.setCssClass("hidden");
        container.add(span3);
        Span span4 = new Span();
        span4.setId("attemptConnectionSpan");
        span4.setCssClass("hidden");
        container.add(span4);
        Span span5 = new Span();
        Span span6 = new Span();
        span4.add(new Text(this.resMap.get(kAttemptNutanixClusterConnection)));
        span6.add(new Text(this.resMap.get(kNutanixClusterError)));
        span5.add(new Text(this.resMap.get(kNutanixClusterNetworkError)));
        span6.setId("invalidConnectionSpan");
        span6.setCssClass("hidden");
        container.add(span6);
        span5.setId("networkErrorSpan");
        span5.setCssClass("hidden");
        container.add(span5);
        String string4 = this.resMap.get(kInvalidNutanixCredentials);
        Span span7 = new Span();
        span7.add(new Text(string4));
        span7.setId("invalidCredentialsSpan");
        span7.setCssClass("hidden");
        container.add(span7);
        String string5 = this.resMap.get(kCouldNotLoadKeyWarning);
        Span span8 = new Span();
        span8.add(new Text(string5));
        span8.setId("couldNotLoadKeySpan");
        span8.setCssClass("hidden");
        container.add(span8);
        Span span9 = new Span();
        span9.add(new Text(this.resMap.get(kRangeValidation)));
        span9.setId("rangeSpan");
        span9.setCssClass("hidden");
        container.add(span9);
        Span span10 = new Span();
        span10.add(new Text(this.sshKeyFailedValidation));
        span10.setId("resSSHKeyNotFound");
        span10.setCssClass("hidden");
        container.add(span10);
    }

    public HTML createNutanixConnectionHTML(PageContext pageContext, boolean bl) {
        Object object;
        boolean bl2 = this.services.getVirtualConfigurationManager().isNutanixAHV();
        Division division = new Division();
        division.setId("server");
        if (!bl) {
            division.setCssClass("formdiv");
            object = new Division();
            ((HTMLTagWithClassStyle)object).setCssClass("warningMsg ConnectionStatusWait");
            ((HTMLTagWithClassStyle)object).setId("warningDiv");
            ((Container)object).add(new Text(this.resMap.get(kAttemptNutanixClusterConnection)));
            division.add((HTML)object);
            this.theNutanixIPLabel = this.resMap.get(kConfigureNutanixClusterIpLabel);
            this.theNutanixClusterPasswordLabel = this.resMap.get(kConfigureNutanixClusterPasswordLabel);
            this.theNutanixHostPasswordLabel = this.resMap.get(kConfigureNutanixHostPasswordLabel);
            this.theNutanixSshKeyPathLabel = this.resMap.get(kConfigureNutanixSshKeyPathLabel);
            this.theNutanixSshKeyPassphraseLabel = this.resMap.get(kConfigureNutanixSshKeyPassphraseLabel);
        } else {
            this.theNutanixIPLabel = this.resMap.get(kNutanixClusterIpLabel);
            this.theNutanixClusterPasswordLabel = this.resMap.get(kNutanixClusterPasswordLabel);
            this.theNutanixHostPasswordLabel = this.resMap.get(kNutanixHostPasswordLabel);
            this.theNutanixSshKeyPathLabel = this.resMap.get(kNutanixSshKeyPathLabel);
            this.theNutanixSshKeyPassphraseLabel = this.resMap.get(kNutanixSshKeyPassphraseLabel);
        }
        object = new NutanixDetails();
        if (bl) {
            object = (NutanixDetails)pageContext.getSession().getAttribute("nutanix_details");
            if (object == null) {
                object = this.services.getNutanixUtils().loadNutanixDetails();
            }
        } else {
            object = this.services.getNutanixUtils().loadNutanixDetails();
        }
        if (bl) {
            division.add(FormHelper.createServerIPDiv(((NutanixDetails)object).getClusterIp(), this.theNutanixIPLabel, NUTANIX_CLUSTER_IP));
            division.add(FormHelper.createPasswordDiv(this.theNutanixClusterPasswordLabel, NUTANIX_CLUSTER_PASSWORD));
            String string = this.resMap.get(kAttemptNutanixClusterConnection);
            Division division2 = new Division();
            division2.setId("validateConnection");
            division2.add(new Text(string));
            division2.setCssClass("checkingConnection ConnectionStatusWait");
            Division division3 = new Division();
            division3.setCssClass("waitDialog");
            division3.setId("waitDialog");
            division3.add(division2);
            division.add(division3);
            division.add(this.createSshKeyPathDiv(((NutanixDetails)object).getSshKeyPath(), this.theNutanixSshKeyPathLabel, NUTANIX_SSH_KEY_PATH));
            division.add(this.createSshKeyPassphraseDiv(this.theNutanixSshKeyPassphraseLabel, NUTANIX_SSH_KEY_PASSPHRASE));
            if (bl2) {
                division.add(FormHelper.createPasswordDiv(this.theNutanixHostPasswordLabel, NUTANIX_HOST_PASSWORD));
            }
            String string2 = this.resMap.get(kNutanixClusterNetworkError);
            division.add(FormHelper.createErrorDivision("connectionError", string2, "error-alert"));
            String string3 = this.resMap.get(kNutanixPasswordAndKeyWarning);
            division.add(FormHelper.createWarningDivision("passwordAndKeyWarning", string3, "nutanixError"));
        } else {
            division.add(FormHelper.createLabelAndReadOnlyValueDiv(NUTANIX_CLUSTER_IP, this.theNutanixIPLabel, ((NutanixDetails)object).getClusterIp(), null));
            division.add(FormHelper.createPasswordDiv(this.theNutanixClusterPasswordLabel, NUTANIX_CLUSTER_PASSWORD));
            division.add(this.createSshKeyPathDiv(((NutanixDetails)object).getSshKeyPath(), this.theNutanixSshKeyPathLabel, NUTANIX_SSH_KEY_PATH));
            division.add(this.createSshKeyPassphraseDiv(this.theNutanixSshKeyPassphraseLabel, NUTANIX_SSH_KEY_PASSPHRASE));
            if (bl2) {
                division.add(FormHelper.createPasswordDiv(this.theNutanixHostPasswordLabel, NUTANIX_HOST_PASSWORD));
                division.add(FormHelper.createButtonDivision("checkAHVHostDetails", this.theCheckNutanixAHVHostDetailsButtonText));
                division.add(FormHelper.createErrorDivision("checkAHVHostDetailsError", this.theCheckNutanixAHVHostDetailsErrorText, null));
                division.add(FormHelper.createInfoDivision("checkAHVHostDetailsSuccess", this.theCheckNutanixAHVHostDetailsSuccessText, null));
            }
        }
        this.addResources(division);
        return division;
    }

    private HTML createSshKeyPathDiv(String string, String string2, String string3) {
        return FormHelper.createLabelTextInputValueDiv(null, string2, string, null, string3, null, 255, 34, null);
    }

    private HTML createSshKeyPassphraseDiv(String string, String string2) {
        return FormHelper.createLabelTextInputValueDiv(null, string, null, null, string2, null, (Integer)255, (Integer)34, null, true);
    }

    public HTML createNutanixConnectionSectionHeader() {
        ApcSectionHeader apcSectionHeader = new ApcSectionHeader(this.theNutanixAHVHeaderText, this.theNutanixAHVSubHeaderText);
        apcSectionHeader.setHelpId(this.services.getVirtualConfigurationManager().isNutanixAHV() ? ApcHelp.CVM_CLUSTER_DETAILS_AHV : ApcHelp.CVM_CLUSTER_DETAILS_ESXI);
        return apcSectionHeader;
    }

    public void createNutanixMessages(ApcForm apcForm) {
        apcForm.add(FormHelper.createWarningDivision("passwordWillBeDeletedWarning", this.thePasswordWillBeDeletedWarningText, null));
        apcForm.add(FormHelper.createWarningDivision("SshKeyPathWillBeDeletedWarning", this.theSshKeyPathAndPassphraseWillBeDeletedWarningText, null));
        apcForm.add(FormHelper.createErrorDivision("nutanixClusterPasswordRequired", this.theClusterPasswordRequiredErrorText, null));
        apcForm.add(FormHelper.createErrorDivision("nutanixHostPasswordRequired", this.theHostPasswordRequiredErrorText, null));
    }

    public HTML createVMChangeClusterPasswordDialog() {
        Division division = new Division();
        division.setId("vmpasswordDiv");
        division.setCssClass("passwordDiv");
        division.setStyle("display: none;");
        Division division2 = new Division();
        division2.setId("vmpwerror");
        division2.setCssClass("pwerror ui-state-error ui-corner-all");
        division2.add(new Text(this.thePasswordCheckFailedText));
        division.add(division2);
        Form form = new Form();
        form.setId("vmpasswordForm");
        division.add(form);
        form.add(FormHelper.createLabelTextInputValueDiv(null, this.theCurrentPasswordText, "", null, "vmcurrentPassword", null, (Integer)34, null, null, true));
        Password password = new Password("vmnewPassword1");
        password.setId("vmnewPassword1");
        password.setMaxLength("34");
        password.setSize("36");
        password.setValue("");
        form.add(FormHelper.createLabelTextInputValueDiv(null, this.theNewPasswordText, password, null));
        form.add(FormHelper.createLabelTextInputValueDiv(null, this.theRepeatNewPasswordText, "", null, "vmnewPassword2", null, (Integer)34, null, null, true));
        return division;
    }

    public HTML createVMChangeHostPasswordDialog() {
        Division division = new Division();
        division.setId("vmHostPasswordDiv");
        division.setCssClass("passwordDiv");
        division.setStyle("display: none;");
        Division division2 = new Division();
        division2.setId("vmhostpwerror");
        division2.setCssClass("pwerror ui-state-error ui-corner-all");
        division2.add(new Text(this.thePasswordCheckFailedText));
        division.add(division2);
        Form form = new Form();
        form.setId("vmHostPasswordForm");
        division.add(form);
        form.add(FormHelper.createLabelTextInputValueDiv(null, this.theCurrentPasswordText, "", null, "vmCurrentHostPassword", null, (Integer)34, null, null, true));
        Password password = new Password("vmNewHostPassword1");
        password.setId("vmNewHostPassword1");
        password.setMaxLength("34");
        password.setSize("36");
        password.setValue("");
        form.add(FormHelper.createLabelTextInputValueDiv(null, this.theNewPasswordText, password, null));
        form.add(FormHelper.createLabelTextInputValueDiv(null, this.theRepeatNewPasswordText, "", null, "vmNewHostPassword2", null, (Integer)34, null, null, true));
        return division;
    }

    public HTML createVMChangeSshPassphraseDialog() {
        Division division = new Division();
        division.setId("vmpassphraseDiv");
        division.setCssClass("passwordDiv");
        division.setStyle("display: none;");
        Division division2 = new Division();
        division2.setId("vmpassphraseerror");
        division2.setCssClass("pwerror ui-state-error ui-corner-all");
        division2.add(new Text(this.theSshPassphraseCheckFailedText));
        division.add(division2);
        Form form = new Form();
        form.setId("vmpassphraseForm");
        division.add(form);
        form.add(FormHelper.createLabelTextInputValueDiv(null, this.theCurrentSshPassphraseText, "", null, "vmcurrentPassphrase", null, (Integer)34, null, null, true));
        Password password = new Password("vmnewPassphrase1");
        password.setId("vmnewPassphrase1");
        password.setMaxLength("34");
        password.setSize("36");
        password.setValue("");
        form.add(FormHelper.createLabelTextInputValueDiv(null, this.theNewSshPassphraseText, password, null));
        form.add(FormHelper.createLabelTextInputValueDiv(null, this.theRepeatSshPassphraseText, "", null, "vmnewPassphrase2", null, (Integer)34, null, null, true));
        return division;
    }

    public Division createBooleanDiv(String string) {
        Division division = new Division();
        division.setId(string);
        division.setCssClass("hidden");
        return division;
    }

    public void addHiddenNutanixAuthDivsToPage(ApcPage apcPage) {
        NutanixDetails nutanixDetails = this.services.getNutanixUtils().loadNutanixDetails();
        String string = nutanixDetails.getClusterPassword();
        String string2 = nutanixDetails.getHostPassword();
        String string3 = nutanixDetails.getSshKeyPath();
        if (StringUtils.isNotBlank((CharSequence)string)) {
            apcPage.add(this.createBooleanDiv("isClusterPasswordSet"));
        }
        if (StringUtils.isNotBlank((CharSequence)string2)) {
            apcPage.add(this.createBooleanDiv("isHostPasswordSet"));
        }
        if (StringUtils.isNotBlank((CharSequence)string3)) {
            apcPage.add(this.createBooleanDiv("isSSHKeyPathSet"));
        }
    }
}

