/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.util;

import com.apcc.m11.components.webserver.html.HTML;
import com.apcc.m11.components.webserver.html.HTMLTagWithClassStyle;
import com.apcc.m11.components.webserver.html.Text;
import com.apcc.m11.components.webserver.html.document.Division;
import com.apcc.m11.components.webserver.html.document.Span;
import com.apcc.m11.components.webserver.html.form.Checkbox;
import com.apcc.m11.components.webserver.html.form.Form;
import com.apcc.m11.components.webserver.html.form.Input;
import com.apcc.m11.components.webserver.html.form.Option;
import com.apcc.m11.components.webserver.html.list.ListItem;
import com.apcc.m11.components.webserver.html.list.UnOrderedList;
import com.apcc.m11.components.webserver.html.table.Table;
import com.apcc.m11.components.webserver.html.table.TableData;
import com.apcc.m11.components.webserver.html.table.TableRow;
import com.apcc.m11.components.webserver.html.util.Anchor;
import com.apcc.m11.components.webserver.html.util.Image;
import com.apcc.m11.components.webserver.model.SSHActionTrigger;
import com.apcc.m11.components.webserver.model.SSHSettings;
import com.apcc.m11.components.webserver.util.FormHelper;
import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.util.ResourceBundleWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SSHSettingsHTMLHelper {
    private static final Logger logger = LogManager.getLogger(SSHSettingsHTMLHelper.class);
    private static final String INDEX_ATTR = "index";
    private static final String DEFAULT_SSH_ACTION_DURATION = "120";
    private static final String DEFAULT_SSH_ACTION_DELAY = "0";
    private static final String DEFAULT_SSH_PORT = "22";
    private static final int MAX_FQDN_LENGTH = 255;
    private static final int MAX_PASSWORD_LENGTH = 265;
    private static final int MAX_USERNAME_LENGTH = 255;
    private static final int MAX_PATH_LENGTH = 260;
    private static final String LIST_HEADER_TEXT = "SSHSettings.ActionListHeader";
    private static final String ADD_BTN_TEXT = "SSHSettings.AddBtnText";
    private static final String NO_ITEMS_TEXT = "SSHSettings.NoItemsText";
    private static final String ACTION_NAME = "SSHSettings.Action.Name";
    private static final String ACTION_NAME_TOOLTIP = "SSHSettings.Action.NameTooltip";
    private static final String ACTION_USER_NAME = "SSHSettings.Action.Username";
    private static final String ACTION_USER_NAME_TOOLTIP = "SSHSettings.Action.UsernameTooltip";
    private static final String ACTION_PASSWORD = "SSHSettings.Action.Password";
    private static final String ACTION_PASSWORD_TOOLTIP = "SSHSettings.Action.PasswordTooltip";
    private static final String ACTION_SSH_KEY_PATH = "SSHSettings.Action.SshKeyPath";
    private static final String ACTION_SSH_KEY_PATH_TOOLTIP = "SSHSettings.Action.SshKeyPathTooltip";
    private static final String ACTION_SSH_KEY_PASSWORD = "SSHSettings.Action.SshKeyPassword";
    private static final String ACTION_SSH_KEY_PASSWORD_TOOLTIP = "SSHSettings.Action.SshKeyPasswordTooltip";
    private static final String ACTION_HOST_ADDRESS = "SSHSettigns.Action.HostAddress";
    private static final String ACTION_HOST_ADDRESS_TOOLTIP = "SSHSettigns.Action.HostAddressTooltip";
    private static final String ACTION_HOST_PORT = "SSHSettings.Action.Port";
    private static final String ACTION_HOST_PORT_TOOLTIP = "SSHSettings.Action.PortTooltip";
    private static final String ACTION_CMD_PATH = "SSHSettings.Action.CmdPath";
    private static final String ACTION_CMD_PATH_TOOLTIP = "SSHSettings.Action.CmdPathTooltip";
    private static final String ACTION_DURATION = "SSHSettings.Action.Duration";
    private static final String ACTION_DURATION_TOOLTIP = "SSHSettings.Action.DurationTooltip";
    private static final String ACTION_DELAY = "SSHSettings.Action.Delay";
    private static final String ACTION_DELAY_TOOLTIP = "SSHSettings.Action.DelayTooltip";
    private static final String ACTION_TRIGGER = "SSHSettings.Action.Trigger";
    private static final String ACTION_TRIGGER_TOOLTIP = "SSHSettings.Action.TriggerTooltip";
    private static final String ACTION_TRIGGER_ON_STARTUP = "SSHSettings.Action.Trigger.OnStartup";
    private static final String ACTION_TRIGGER_AFTER_SHUTDOWN = "SSHSettings.Action.Trigger.AfterShutdown";
    private static final String ACTION_TRIGGER_BEFORE_SHUTDOWN = "SSHSettings.Action.Trigger.BeforeShutdown";
    private static final String ACTION_TRIGGER_BEFORE_VM_SHUTDOWN = "SSHSettings.Action.Trigger.BeforeVMShutdown";
    private static final String ACTION_TRIGGER_AFTER_SHUTDOWN_CMD = "SSHSettings.Action.Trigger.AfterShutdownCmd";
    private static final String ACTION_TRIGGER_BEFORE_SHUTDOWN_CMD = "SSHSettings.Action.Trigger.BeforeShutdownCmd";
    private static final String ACTION_ENABLE = "SSHSettings.Action.Enable";
    private static final String SECONDS_LABEL = "SSHSettings.Action.Seconds";
    private static final String WAIT_DIALOG_TITLE = "PCNS.WaitTitle";
    private static final String WAIT_DIALOG_TEXT = "PCNS.WaitText";
    private static final String kApplyButton = "PCNS.ApplyButton";
    private static final String kResetButton = "PCNS.UndoButton";
    private static final String kNoActionsToSelect = "SSHSettings.NoActionsToSelect";
    private static final String kSelectedActionNotEnabledWarningText = "SSHSettings.SelectedActionNotEnabled";
    private static final String kHypertextReferenceOption = "href";
    private String theListHeaderText;
    private String theAddBtnText;
    private String theNoItemsText;
    private String nameLabel;
    private String nameTooltip;
    private String userNameLabel;
    private String usernameTooltip;
    private String passwordLabel;
    private String passwordTooltip;
    private String sshKeyPathLabel;
    private String sshKeyPathTooltip;
    private String sshKeyPasswordLabel;
    private String sshKeyPasswordTooltip;
    private String hostAddressLabel;
    private String hostAddressTooltip;
    private String portLabel;
    private String portTooltip;
    private String cmdFilePathLabel;
    private String cmdFilePathTooltip;
    private String durationLabel;
    private String durationTooltip;
    private String delayLabel;
    private String delayTooltip;
    private String triggerLabel;
    private String triggerTooltip;
    private String onStartupOption;
    private String afterShutdownOption;
    private String beforeShutdownOption;
    private String beforeVMShutdownOption;
    private String enableLabel;
    private String secondsLabel;
    private String waitDialogTitle;
    private String waitDialogText;
    private String theApplyButtonText;
    private String theResetButtonText;
    private String theNoActionsToSelectText;
    private String theSelectedActionNotEnabledWarningText;
    private List<SSHSettings> settings;
    private Map<String, Boolean> sshActions;
    private ServiceManager services;

    public SSHSettingsHTMLHelper(Locale locale, List<SSHSettings> list, @NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        this.settings = new ArrayList<SSHSettings>();
        this.services = serviceManager;
        if (list != null) {
            this.settings.addAll(list);
        }
        this.getSSHSettingsResourceStrings(locale);
    }

    private void getSSHSettingsResourceStrings(Locale locale) {
        ResourceBundleWrapper resourceBundleWrapper = Utils.getWebServerResourceBundle(locale);
        this.theAddBtnText = Utils.getResourceString(resourceBundleWrapper, ADD_BTN_TEXT);
        this.theListHeaderText = Utils.getResourceString(resourceBundleWrapper, LIST_HEADER_TEXT);
        this.theNoItemsText = Utils.getResourceString(resourceBundleWrapper, NO_ITEMS_TEXT);
        this.nameLabel = Utils.getResourceString(resourceBundleWrapper, ACTION_NAME);
        this.nameTooltip = Utils.getResourceString(resourceBundleWrapper, ACTION_NAME_TOOLTIP);
        this.userNameLabel = Utils.getResourceString(resourceBundleWrapper, ACTION_USER_NAME);
        this.usernameTooltip = Utils.getResourceString(resourceBundleWrapper, ACTION_USER_NAME_TOOLTIP);
        this.passwordLabel = Utils.getResourceString(resourceBundleWrapper, ACTION_PASSWORD);
        this.passwordTooltip = Utils.getResourceString(resourceBundleWrapper, ACTION_PASSWORD_TOOLTIP);
        this.sshKeyPathLabel = Utils.getResourceString(resourceBundleWrapper, ACTION_SSH_KEY_PATH);
        this.sshKeyPathTooltip = Utils.getResourceString(resourceBundleWrapper, ACTION_SSH_KEY_PATH_TOOLTIP);
        this.sshKeyPasswordLabel = Utils.getResourceString(resourceBundleWrapper, ACTION_SSH_KEY_PASSWORD);
        this.sshKeyPasswordTooltip = Utils.getResourceString(resourceBundleWrapper, ACTION_SSH_KEY_PASSWORD_TOOLTIP);
        this.hostAddressLabel = Utils.getResourceString(resourceBundleWrapper, ACTION_HOST_ADDRESS);
        this.hostAddressTooltip = Utils.getResourceString(resourceBundleWrapper, ACTION_HOST_ADDRESS_TOOLTIP);
        this.portLabel = Utils.getResourceString(resourceBundleWrapper, ACTION_HOST_PORT);
        this.portTooltip = Utils.getResourceString(resourceBundleWrapper, ACTION_HOST_PORT_TOOLTIP);
        this.cmdFilePathLabel = Utils.getResourceString(resourceBundleWrapper, ACTION_CMD_PATH);
        this.cmdFilePathTooltip = Utils.getResourceString(resourceBundleWrapper, ACTION_CMD_PATH_TOOLTIP);
        this.durationLabel = Utils.getResourceString(resourceBundleWrapper, ACTION_DURATION);
        this.durationTooltip = Utils.getResourceString(resourceBundleWrapper, ACTION_DURATION_TOOLTIP);
        this.delayLabel = Utils.getResourceString(resourceBundleWrapper, ACTION_DELAY);
        this.delayTooltip = Utils.getResourceString(resourceBundleWrapper, ACTION_DELAY_TOOLTIP);
        this.triggerLabel = Utils.getResourceString(resourceBundleWrapper, ACTION_TRIGGER);
        this.triggerTooltip = Utils.getResourceString(resourceBundleWrapper, ACTION_TRIGGER_TOOLTIP);
        this.onStartupOption = Utils.getResourceString(resourceBundleWrapper, ACTION_TRIGGER_ON_STARTUP);
        if (StringUtils.isBlank((CharSequence)this.services.getVirtualConfigurationManager().getVirtualInstallValue())) {
            this.afterShutdownOption = Utils.getResourceString(resourceBundleWrapper, ACTION_TRIGGER_AFTER_SHUTDOWN_CMD);
            this.beforeShutdownOption = Utils.getResourceString(resourceBundleWrapper, ACTION_TRIGGER_BEFORE_SHUTDOWN_CMD);
        } else {
            this.afterShutdownOption = Utils.getResourceString(resourceBundleWrapper, ACTION_TRIGGER_AFTER_SHUTDOWN);
            this.beforeShutdownOption = Utils.getResourceString(resourceBundleWrapper, ACTION_TRIGGER_BEFORE_SHUTDOWN);
            this.beforeVMShutdownOption = Utils.getResourceString(resourceBundleWrapper, ACTION_TRIGGER_BEFORE_VM_SHUTDOWN);
        }
        this.enableLabel = Utils.getResourceString(resourceBundleWrapper, ACTION_ENABLE);
        this.secondsLabel = Utils.getResourceString(resourceBundleWrapper, SECONDS_LABEL);
        this.waitDialogText = Utils.getResourceString(resourceBundleWrapper, WAIT_DIALOG_TEXT);
        this.waitDialogTitle = Utils.getResourceString(resourceBundleWrapper, WAIT_DIALOG_TITLE);
        this.theApplyButtonText = Utils.getResourceString(resourceBundleWrapper, kApplyButton);
        this.theResetButtonText = Utils.getResourceString(resourceBundleWrapper, kResetButton);
        this.theNoActionsToSelectText = Utils.getResourceString(resourceBundleWrapper, kNoActionsToSelect);
        this.theSelectedActionNotEnabledWarningText = Utils.getResourceString(resourceBundleWrapper, kSelectedActionNotEnabledWarningText);
    }

    public HTML createSSHActionsListPanel(boolean bl) {
        HTMLTagWithClassStyle hTMLTagWithClassStyle;
        Division division = new Division();
        division.setId("actionListDiv");
        division.setCssClass("ui-widget");
        Division division2 = new Division();
        division.add(division2);
        division2.setId("actionListHeader");
        division2.setCssClass("ui-widget-header ui-corner-top");
        division2.add(new Text(this.theListHeaderText));
        if (!bl) {
            hTMLTagWithClassStyle = new Anchor();
            division2.add(hTMLTagWithClassStyle);
            hTMLTagWithClassStyle.setId("addActionBtn");
            ((Anchor)hTMLTagWithClassStyle).setHypertextReference("#");
            hTMLTagWithClassStyle.add(new Text(this.theAddBtnText));
        }
        hTMLTagWithClassStyle = new UnOrderedList();
        division.add(hTMLTagWithClassStyle);
        hTMLTagWithClassStyle.setId("actionsList");
        hTMLTagWithClassStyle.setCssClass("ui-widget-content ui-corner-bottom");
        for (SSHSettings sSHSettings : this.settings) {
            if (bl) {
                hTMLTagWithClassStyle.add(this.createAdvancedSSHActionItem(sSHSettings));
                continue;
            }
            hTMLTagWithClassStyle.add(this.createSSHActionItem(sSHSettings));
        }
        if (!bl) {
            Division division3 = new Division();
            division3.setId("noActionsDiv");
            division3.add(new Text(this.theNoItemsText));
            division.add(division3);
        } else {
            division.add(this.createNoActionsToSelectLink());
        }
        return division;
    }

    private HTML createSSHActionItem(SSHSettings sSHSettings) {
        HTMLTagWithClassStyle hTMLTagWithClassStyle;
        ListItem listItem = new ListItem();
        listItem.setId("sshActionItem");
        listItem.setCssClass("ui-widget-content ui-corner-all");
        Table table = new Table();
        TableRow tableRow = new TableRow();
        listItem.add(table);
        table.add(tableRow);
        TableData tableData = new TableData();
        tableRow.add(tableData);
        Span span = new Span(StringEscapeUtils.escapeHtml4((String)sSHSettings.getName()));
        span.setCssClass("actionName");
        tableData.add(span);
        TableData tableData2 = new TableData();
        tableRow.add(tableData2);
        if (sSHSettings.isEnabled()) {
            hTMLTagWithClassStyle = new Image("/images/checkmark.gif");
            tableData2.add(hTMLTagWithClassStyle);
        }
        hTMLTagWithClassStyle = new TableData();
        tableRow.add(hTMLTagWithClassStyle);
        Anchor anchor = new Anchor();
        anchor.setCssClass("editBtn");
        anchor.setHypertextReference("#");
        anchor.setAttribute(INDEX_ATTR, String.valueOf(sSHSettings.getIndex()));
        hTMLTagWithClassStyle.add(anchor);
        Anchor anchor2 = new Anchor();
        anchor2.setCssClass("deleteBtn");
        anchor2.setHypertextReference("#");
        anchor2.setAttribute(INDEX_ATTR, String.valueOf(sSHSettings.getIndex()));
        hTMLTagWithClassStyle.add(anchor2);
        return listItem;
    }

    public HTML createWaitDialog() {
        Division division = new Division();
        division.setId("waitDialog");
        division.setCssClass("waitDialog");
        division.setTitle(this.waitDialogTitle);
        division.add(new Text(this.waitDialogText));
        return division;
    }

    private HTML createAdvancedSSHActionItem(SSHSettings sSHSettings) {
        HTMLTagWithClassStyle hTMLTagWithClassStyle;
        ListItem listItem = new ListItem();
        listItem.setId("sshActionItem");
        listItem.setCssClass("ui-widget-content ui-corner-all");
        Table table = new Table();
        TableRow tableRow = new TableRow();
        listItem.add(table);
        table.add(tableRow);
        TableData tableData = new TableData();
        tableRow.add(tableData);
        Span span = new Span(StringEscapeUtils.escapeHtml4((String)sSHSettings.getName()));
        tableData.add(span);
        TableData tableData2 = new TableData();
        tableRow.add(tableData2);
        if (sSHSettings.isEnabled()) {
            hTMLTagWithClassStyle = new Image("/images/checkmark.gif");
            tableData2.add(hTMLTagWithClassStyle);
        }
        hTMLTagWithClassStyle = new TableData();
        tableRow.add(hTMLTagWithClassStyle);
        Span span2 = new Span();
        span2.add(this.createCheckbox(sSHSettings.getSection(), sSHSettings.getSection(), this.sshActions.get(sSHSettings.getSection())));
        hTMLTagWithClassStyle.add(span2);
        return listItem;
    }

    public HTML createCheckbox(String string, String string2, boolean bl) {
        Checkbox checkbox = new Checkbox(string);
        checkbox.setCheck(bl);
        checkbox.setValue("on");
        if (StringUtils.isEmpty((CharSequence)string2)) {
            checkbox.setId(string2);
        } else {
            checkbox.setId(string);
        }
        return checkbox;
    }

    public HTML createActionDialogHTML() {
        HTML hTML;
        Option option;
        Division division = new Division();
        division.setId("actionDialog");
        Form form = new Form();
        division.add(form);
        form.setId("actionDialogForm");
        form.add(FormHelper.createLabelTextInputValueDiv(null, this.nameLabel, "", null, "actionName", null, (Integer)50, null, null, this.nameTooltip));
        form.add(FormHelper.createLabelTextInputValueDiv(null, this.userNameLabel, "", null, "username", null, (Integer)255, null, null, this.usernameTooltip));
        form.add(FormHelper.createLabelTextInputValueDiv(null, this.passwordLabel, "", null, "password", null, 265, null, null, true, this.passwordTooltip));
        form.add(FormHelper.createLabelTextInputValueDiv(null, this.sshKeyPathLabel, "", null, "sshKeyPath", null, (Integer)260, null, null, this.sshKeyPathTooltip));
        form.add(FormHelper.createLabelTextInputValueDiv(null, this.sshKeyPasswordLabel, "", null, "sshKeyPassword", null, 265, null, null, true, this.sshKeyPasswordTooltip));
        form.add(FormHelper.createLabelTextInputValueDiv(null, this.hostAddressLabel, "", null, "hostAddress", null, (Integer)255, null, null, this.hostAddressTooltip));
        form.add(FormHelper.createLabelTextInputValueDiv(null, this.portLabel, DEFAULT_SSH_PORT, null, "port", null, (Integer)5, null, null, this.portTooltip));
        form.add(FormHelper.createLabelTextInputValueDiv(null, this.cmdFilePathLabel, "", null, "cmdPath", null, (Integer)260, null, null, this.cmdFilePathTooltip));
        form.add(FormHelper.createLabelTextInputValueDiv(null, this.delayLabel, DEFAULT_SSH_ACTION_DELAY, null, "delay", null, (Integer)6, null, this.secondsLabel, this.delayTooltip));
        form.add(FormHelper.createLabelTextInputValueDiv(null, this.durationLabel, DEFAULT_SSH_ACTION_DURATION, null, "duration", null, (Integer)6, null, this.secondsLabel, this.durationTooltip));
        ArrayList<Option> arrayList = new ArrayList<Option>();
        Option option2 = new Option(this.onStartupOption);
        option2.setValue(SSHActionTrigger.ON_STARTUP.getIniSetting());
        arrayList.add(option2);
        if (this.services.getVirtualConfigurationManager().isHyperV() && !this.services.getVirtualConfigurationManager().isManagedHost() || this.services.getVirtualConfigurationManager().isESXi() && !this.services.getVirtualConfigurationManager().isManagedHost() || !this.services.getVirtualConfigurationManager().isNutanixAHV() && this.services.getVirtualConfigurationManager().isPCNSInstalledOnVMA()) {
            logger.debug("createActionDialogHTML() - disabling After host shutdown option");
        } else {
            option = new Option(this.afterShutdownOption);
            option.setValue(SSHActionTrigger.AFTER_HOST_SHUTDOWN.getIniSetting());
            option.setSelected(true);
            arrayList.add(option);
        }
        option = new Option(this.beforeShutdownOption);
        option.setValue(SSHActionTrigger.BEFORE_HOST_SHUTDOWN.getIniSetting());
        arrayList.add(option);
        if (StringUtils.isNotBlank((CharSequence)this.services.getVirtualConfigurationManager().getVirtualInstallValue())) {
            hTML = new Option(this.beforeVMShutdownOption);
            ((Option)hTML).setValue(SSHActionTrigger.BEFORE_VM_SHUTDOWN.getIniSetting());
            arrayList.add((Option)hTML);
        }
        form.add(FormHelper.createLabelSelectValueDiv(null, this.triggerLabel, "", "", "sshTrigger", arrayList, this.triggerTooltip));
        form.add(FormHelper.createLabelCheckboxValueDiv(null, this.enableLabel, true, "enabled", "actionEnabled"));
        hTML = new Input();
        form.add(hTML);
        ((Input)hTML).setType("hidden");
        ((Input)hTML).setId("actionIndex");
        ((Input)hTML).setName("actionIndex");
        ((Input)hTML).setValue("-1");
        return division;
    }

    public HTML createButtonDiv() {
        Division division = new Division();
        division.setId("buttondiv");
        Input input = new Input();
        input.setName("apply");
        input.setValue(this.theApplyButtonText);
        input.setId("apply");
        input.setType("submit");
        input.setClassName("newbutton");
        division.add(input);
        Input input2 = new Input();
        input2.setName("resetButton");
        input2.setValue(this.theResetButtonText);
        input2.setId("resetButton");
        input2.setType("reset");
        input2.setClassName("newbutton");
        division.add(input2);
        return division;
    }

    public void setSSHActions(Map<String, Boolean> map) {
        this.sshActions = map;
    }

    public HTML createErrorPanel() {
        Division division = new Division();
        division.setId("errorcontainer");
        division.setCssClass("ui-state-error ui-corner-all");
        return division;
    }

    public HTML createNoActionsToSelectLink() {
        Division division = new Division();
        division.setId("noActionsToSelectDiv");
        Anchor anchor = new Anchor();
        anchor.setId("noActionsToSelectLink");
        anchor.add(new Text(this.theNoActionsToSelectText));
        anchor.setAttribute(kHypertextReferenceOption, "/sshsettings");
        division.add(anchor);
        return division;
    }

    public HTML createSelectedActionNotEnabledWarning() {
        return FormHelper.createWarningDivision("selActionNotEnabled", this.theSelectedActionNotEnabledWarningText, null);
    }
}

