/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.util;

import com.apcc.m11.components.webserver.html.PageContext;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import javax.servlet.ServletException;
import javax.servlet.http.HttpSession;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SecurityUtils {
    public static final String NO_SESSION_ERROR = "No valid session found";
    public static final String CONTEXT_PARAM_TOKEN_PER_REQUEST = "FormTokenPerRequest";
    private static final Logger logger = LogManager.getLogger(SecurityUtils.class);

    public static String generateRandomToken() throws NoSuchAlgorithmException {
        SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
        return Long.toHexString(secureRandom.nextLong());
    }

    public static String getRandomToken(HttpSession httpSession, String string) throws ServletException, NoSuchAlgorithmException {
        if (httpSession == null) {
            throw new ServletException(NO_SESSION_ERROR);
        }
        String string2 = (String)httpSession.getAttribute(string);
        if (string2 == null) {
            string2 = SecurityUtils.generateRandomToken();
            httpSession.setAttribute(string, (Object)string2);
        }
        return string2;
    }

    public static boolean verifyRandomToken(PageContext pageContext, String string, String string2, boolean bl) throws NoSuchAlgorithmException {
        boolean bl2 = false;
        HttpSession httpSession = pageContext.getSession();
        if (httpSession == null) {
            logger.warn("verifyRandomToken() - Attempt to verify a token for a non-existant session.");
            return false;
        }
        try {
            String string3 = SecurityUtils.getRandomToken(httpSession, string2);
            String string4 = pageContext.getPostQueryValue(string);
            bl2 = string3.equals(string4);
            if (!bl2) {
                logger.warn("Invalid form token detected.  Possible CSRF attack!");
            }
            if (bl) {
                httpSession.removeAttribute(string2);
            }
        }
        catch (ServletException servletException) {
            logger.debug("verifyRandomToken() - Failed to verify token due to: {}", (Throwable)servletException);
            bl2 = false;
        }
        return bl2;
    }

    public static String getX509CertificateThumbPrint(X509Certificate x509Certificate) {
        String string = null;
        if (x509Certificate != null) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                for (byte by : DigestUtils.sha1((byte[])x509Certificate.getEncoded())) {
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(":");
                    }
                    stringBuffer.append(String.format("%02X", by));
                }
                logger.debug("certificate thumbprint=" + String.valueOf(stringBuffer));
                string = stringBuffer.toString();
            }
            catch (CertificateEncodingException certificateEncodingException) {
                logger.error((Object)certificateEncodingException);
            }
        }
        return string;
    }
}

