/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.util;

import com.apcc.m11.components.webserver.html.Container;
import com.apcc.m11.components.webserver.html.HTML;
import com.apcc.m11.components.webserver.html.HTMLTagWithClassStyle;
import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.html.Text;
import com.apcc.m11.components.webserver.html.apc.ApcHelp;
import com.apcc.m11.components.webserver.html.apc.ApcSectionHeader;
import com.apcc.m11.components.webserver.html.document.Division;
import com.apcc.m11.components.webserver.html.document.Span;
import com.apcc.m11.components.webserver.html.form.Input;
import com.apcc.m11.components.webserver.util.FormHelper;
import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.simplivity.SimplivityDetails;
import com.apcc.pcns.util.ResourceBundleWrapper;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import lombok.NonNull;

public class SimplivityHTMLHelper {
    private static final String CSS_HIDDEN = "hidden";
    public static final String OVC_IPS_ID = "ovcIPs";
    public static final String OVC_NAMES_ID = "ovcNames";
    public static final String OVC_HOSTS_ID = "ovcHosts";
    public static final String SIMPLIVITY_PASSWORD_CHANGE = "simplivity_password_change";
    public static final String SIMPLIVITY_OVC_PASSWORD = "simplivity_ovc_password";
    public static final String SIMPLIVITY_OVC_USER = "simplivity_ovc_user";
    private static final String ATTEMPT_CLUSTER_CONNECTION = "CfgWizard.SimplivityClusterDetails.AttemptClusterConnection";
    private static final String CLUSTER_PASSWORD_LABEL = "CfgWizard.SimplivityClusterDetails.ClusterPassword";
    private static final String CLUSTER_USER_LABEL = "CfgWizard.SimplivityClusterDetails.ClusterUser";
    private static final String HEADER_TEXT = "CfgWizard.SimplivityClusterDetails.PageTitle";
    private static final String SUBHEADER_TEXT = "CfgWizard.SimplivityClusterDetails.PageDescription";
    private static final String REQUIRED_VALIDATOR = "PCNS.RequiredField";
    private static final String IP_VALIDATOR = "PCNS.NutanixClusterValidation";
    private static final String CLUSTER_CONNECTION_ERROR = "Configure.SimplivityClusterError";
    public static final String CLUSTER_NETWORK_ERROR = "CfgWizard.NutanixClusterDetails.NutanixClusterNetworkError";
    private static final String INVALID_CREDENTIALS_ERROR = "CfgWizard.NutanixClusterDetails.NutanixClusterInvalidCredentials";
    private static final String OVC_DOWN_ERROR = "Configure.OVCDownError";
    private static final String OVC_CONNECTION_SUCCESS = "Configure.OVCConnectionSuccess";
    private static final String RANGE_VALIDATOR = "PCNS.RangeValidation";
    private static final String CHANGE_PASSWORD_TEXT = "PCNS.ChangePasswordText";
    private static final String HIDDEN_PASSWORD_ID = "PCNS.HiddenPassword";
    private static final String CHANGE_PASSWORD_LABEL = "Configure.SimplivityPassword";
    private static final String INVALID_CHARACTERS = "PCNS.InvalidCharacters";
    private static final String SIMPLIVITY_PASSWORD_DIALOG_TITLE_ID = "Configure.SimplivityPasswordDialogTitle";
    private Map<String, String> resMap;
    private ServiceManager services;
    private String clusterUserLabel;
    private String clusterPasswordLabel;

    public SimplivityHTMLHelper(Locale locale, @NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("services is marked non-null but is null");
        }
        this.services = serviceManager;
        this.resMap = new HashMap<String, String>();
        this.getVMSettingsResourceStrings(locale);
    }

    private void getVMSettingsResourceStrings(Locale locale) {
        ResourceBundleWrapper resourceBundleWrapper = Utils.getWebServerResourceBundle(locale);
        this.resMap.put(ATTEMPT_CLUSTER_CONNECTION, Utils.getResourceString(resourceBundleWrapper, ATTEMPT_CLUSTER_CONNECTION));
        this.resMap.put(CLUSTER_PASSWORD_LABEL, Utils.getResourceString(resourceBundleWrapper, CLUSTER_PASSWORD_LABEL));
        this.resMap.put(CLUSTER_USER_LABEL, Utils.getResourceString(resourceBundleWrapper, CLUSTER_USER_LABEL));
        this.resMap.put(HEADER_TEXT, Utils.getResourceString(resourceBundleWrapper, HEADER_TEXT));
        this.resMap.put(SUBHEADER_TEXT, Utils.getResourceString(resourceBundleWrapper, SUBHEADER_TEXT));
        this.resMap.put(REQUIRED_VALIDATOR, Utils.getResourceString(resourceBundleWrapper, REQUIRED_VALIDATOR));
        this.resMap.put(IP_VALIDATOR, Utils.getResourceString(resourceBundleWrapper, IP_VALIDATOR));
        this.resMap.put(CLUSTER_CONNECTION_ERROR, Utils.getResourceString(resourceBundleWrapper, CLUSTER_CONNECTION_ERROR));
        this.resMap.put(CLUSTER_NETWORK_ERROR, Utils.getResourceString(resourceBundleWrapper, CLUSTER_NETWORK_ERROR));
        this.resMap.put(INVALID_CREDENTIALS_ERROR, Utils.getResourceString(resourceBundleWrapper, INVALID_CREDENTIALS_ERROR));
        this.resMap.put(RANGE_VALIDATOR, Utils.getResourceString(resourceBundleWrapper, RANGE_VALIDATOR));
        this.resMap.put(CHANGE_PASSWORD_TEXT, Utils.getResourceString(resourceBundleWrapper, CHANGE_PASSWORD_TEXT));
        this.resMap.put(HIDDEN_PASSWORD_ID, Utils.getResourceString(resourceBundleWrapper, HIDDEN_PASSWORD_ID));
        this.resMap.put(CHANGE_PASSWORD_LABEL, Utils.getResourceString(resourceBundleWrapper, CHANGE_PASSWORD_LABEL));
        this.resMap.put(SIMPLIVITY_PASSWORD_DIALOG_TITLE_ID, Utils.getResourceString(resourceBundleWrapper, SIMPLIVITY_PASSWORD_DIALOG_TITLE_ID));
        this.resMap.put(INVALID_CHARACTERS, Utils.getResourceString(resourceBundleWrapper, INVALID_CHARACTERS));
        this.resMap.put(OVC_DOWN_ERROR, Utils.getResourceString(resourceBundleWrapper, OVC_DOWN_ERROR));
        this.resMap.put(OVC_CONNECTION_SUCCESS, Utils.getResourceString(resourceBundleWrapper, OVC_CONNECTION_SUCCESS));
        this.clusterPasswordLabel = this.resMap.get(CLUSTER_PASSWORD_LABEL);
        this.clusterUserLabel = this.resMap.get(CLUSTER_USER_LABEL);
    }

    public HTML createConnectionSectionHeader() {
        ApcSectionHeader apcSectionHeader = new ApcSectionHeader(this.resMap.get(HEADER_TEXT), this.resMap.get(SUBHEADER_TEXT));
        apcSectionHeader.setHelpId(ApcHelp.CLUSTER_DETAILS_SIMPLIVITY);
        return apcSectionHeader;
    }

    public Division createSimplivityErrorDiv() {
        String string = this.resMap.get(CLUSTER_NETWORK_ERROR);
        return FormHelper.createErrorDivision("connectionError", string, "error-alert");
    }

    public HTML createSimplivityConnectionHTML(PageContext pageContext, boolean bl, boolean bl2) {
        Object object;
        Division division = new Division();
        division.setId("simplivity");
        if (!bl && !bl2) {
            division.setCssClass("formdiv");
            object = new Division();
            ((HTMLTagWithClassStyle)object).setCssClass("warningMsg ConnectionStatusWait");
            ((HTMLTagWithClassStyle)object).setId("ovcCheckInProgress");
            ((Container)object).add(new Text(this.resMap.get(ATTEMPT_CLUSTER_CONNECTION)));
            division.add((HTML)object);
        }
        SimplivityDetails simplivityDetails = (object = this.getSimplivityDetails(pageContext, bl)).isEmpty() ? new SimplivityDetails() : object.get(0);
        Input input = new Input();
        input.setId(OVC_NAMES_ID);
        input.setName(OVC_NAMES_ID);
        input.setType(CSS_HIDDEN);
        division.add(input);
        Input input2 = new Input();
        input2.setId(OVC_IPS_ID);
        input2.setName(OVC_IPS_ID);
        input2.setType(CSS_HIDDEN);
        division.add(input2);
        Input input3 = new Input();
        input3.setId(OVC_HOSTS_ID);
        input3.setName(OVC_HOSTS_ID);
        input3.setType(CSS_HIDDEN);
        division.add(input3);
        if (bl2) {
            Input input4 = new Input();
            input4.setId("hostSelection");
            input4.setType(CSS_HIDDEN);
            division.add(input4);
        } else {
            division.add(FormHelper.createInputDiv(simplivityDetails.getOvcUser(), this.clusterUserLabel, SIMPLIVITY_OVC_USER));
            if (bl) {
                division.add(FormHelper.createPasswordDiv(this.clusterPasswordLabel, SIMPLIVITY_OVC_PASSWORD));
                String string = this.resMap.get(ATTEMPT_CLUSTER_CONNECTION);
                Division division2 = new Division();
                division2.setId("validateConnection");
                division2.add(new Text(string));
                division2.setCssClass("checkingConnection ConnectionStatusWait");
                Division division3 = new Division();
                division3.setCssClass("waitDialog");
                division3.setId("waitDialog");
                division3.add(division2);
                division.add(division3);
                division.add(this.createSimplivityErrorDiv());
            } else {
                division.add(FormHelper.createPasswordDiv(this.clusterPasswordLabel, SIMPLIVITY_OVC_PASSWORD));
            }
        }
        this.addResources(division);
        return division;
    }

    private List<SimplivityDetails> getSimplivityDetails(PageContext pageContext, boolean bl) {
        List<SimplivityDetails> list;
        if (bl) {
            list = (List<SimplivityDetails>)pageContext.getSession().getAttribute("simplivity_details");
            if (list == null && (list = this.services.getSimplivityUtils().loadSimplivityDetails()).isEmpty()) {
                list.add(new SimplivityDetails());
            }
        } else {
            list = this.services.getSimplivityUtils().loadSimplivityDetails();
        }
        return list;
    }

    public void addResources(Container container) {
        String string = this.resMap.get(REQUIRED_VALIDATOR);
        Span span = new Span();
        span.add(new Text(string));
        span.setId("requiredSpan");
        span.setCssClass(CSS_HIDDEN);
        container.add(span);
        String string2 = this.resMap.get(IP_VALIDATOR);
        Span span2 = new Span();
        span2.add(new Text(string2));
        span2.setId("invalidIpSpan");
        span2.setCssClass(CSS_HIDDEN);
        container.add(span2);
        Span span3 = new Span();
        span3.setId("attemptConnectionSpan");
        span3.setCssClass(CSS_HIDDEN);
        container.add(span3);
        Span span4 = new Span();
        Span span5 = new Span();
        span3.add(new Text(this.resMap.get(ATTEMPT_CLUSTER_CONNECTION)));
        span5.add(new Text(this.resMap.get(CLUSTER_CONNECTION_ERROR)));
        span4.add(new Text(this.resMap.get(CLUSTER_NETWORK_ERROR)));
        span5.setId("invalidConnectionSpan");
        span5.setCssClass(CSS_HIDDEN);
        container.add(span5);
        span4.setId("networkErrorSpan");
        span4.setCssClass(CSS_HIDDEN);
        container.add(span4);
        String string3 = this.resMap.get(INVALID_CREDENTIALS_ERROR);
        Span span6 = new Span();
        span6.add(new Text(string3));
        span6.setId("invalidCredentialsSpan");
        span6.setCssClass(CSS_HIDDEN);
        container.add(span6);
        Span span7 = new Span();
        span7.add(new Text(this.resMap.get(RANGE_VALIDATOR)));
        span7.setId("rangeSpan");
        span7.setCssClass(CSS_HIDDEN);
        container.add(span7);
        Span span8 = new Span(SIMPLIVITY_OVC_PASSWORD);
        span8.setId("resSimplivityPasswordName");
        span8.setCssClass(CSS_HIDDEN);
        container.add(span8);
        span8 = new Span(this.resMap.get(SIMPLIVITY_PASSWORD_DIALOG_TITLE_ID));
        span8.setId("resSimplivityPasswordDialogTitle");
        span8.setCssClass(CSS_HIDDEN);
        container.add(span8);
        span8 = new Span(this.resMap.get(INVALID_CHARACTERS));
        span8.setId("resInvalidCharacters");
        span8.setCssClass(CSS_HIDDEN);
        container.add(span8);
        span8 = new Span(this.resMap.get(OVC_DOWN_ERROR));
        span8.setId("ovcDownSpan");
        span8.setCssClass(CSS_HIDDEN);
        container.add(span8);
        span8 = new Span(this.resMap.get(OVC_CONNECTION_SUCCESS));
        span8.setId("ovcConnectionSuccessSpan");
        span8.setCssClass(CSS_HIDDEN);
        container.add(span8);
    }
}

