/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.util;

import com.apcc.m11.components.webserver.html.Container;
import com.apcc.m11.components.webserver.html.Text;
import com.apcc.m11.components.webserver.html.document.Division;
import com.apcc.m11.components.webserver.html.list.ListItem;
import com.apcc.m11.components.webserver.html.list.UnOrderedList;
import com.apcc.m11.components.webserver.html.util.Anchor;
import com.apcc.m11.components.webserver.util.InventoryTreeHelper;
import com.apcc.pcns.ServiceManager;
import java.util.Iterator;
import java.util.List;
import lombok.NonNull;

public class TargetHostSelectionHelper
extends InventoryTreeHelper {
    public static final String PARAM_TARGET_HOST = "targetHost";
    public static final String ATTR_TARGET_HOSTS = "targetHosts";
    public static final String TARGET_HOST_SELECTION = "TargetHostSelectionPage";

    public TargetHostSelectionHelper(List<String> list, boolean bl, boolean bl2, @NonNull ServiceManager serviceManager) {
        super(serviceManager);
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        if (bl) {
            this.initialize();
        }
        this.setMappedHostList(list);
        this.refreshMappedHosts();
        if (bl2) {
            this.selectAllHostsInSameClusterAsPCNSHost();
        }
    }

    @Override
    public synchronized void refreshMappedHosts() {
        if (this.getHostList() != null) {
            Iterator<String> iterator = this.getMappedHostList().iterator();
            while (iterator.hasNext()) {
                String string = iterator.next();
                if (this.isExistingHost(string)) continue;
                this.hostsRemoved.add(string);
                iterator.remove();
            }
        }
    }

    protected synchronized void selectAllHostsInSameClusterAsPCNSHost() {
        if (this.getMappedHostList().isEmpty() && this.getPCNSHost() != null) {
            List<String> list = this.services.getHostSystemUtils().getPCNSClusterHosts();
            if (list != null && !list.isEmpty()) {
                this.getMappedHostList().addAll(list);
            } else {
                this.getMappedHostList().add(this.getPCNSHost());
            }
            this.services.getWebServerUtils().saveTargetHostSelectionToConfig(this.getMappedHostList());
        }
    }

    public void displayTargetHostTree(Container container, boolean bl) {
        Division division;
        if (this.isHyperV()) {
            division = new Division();
            division.setId("hyperVFlag");
            division.setCssClass("hidden");
            container.add(division);
        }
        if (this.isNutanixAHV() || this.isNutanixESXi()) {
            division = new Division();
            division.setId("nutanixFlag");
            division.setCssClass("hidden");
            container.add(division);
        }
        if (this.isVxRail()) {
            division = new Division();
            division.setId("vxRailFlag");
            division.setCssClass("hidden");
            container.add(division);
        }
        division = new Division();
        division.setId("mappedlist");
        division.setCssClass("treelist ui-corner-all");
        container.add(division);
        UnOrderedList unOrderedList = new UnOrderedList();
        division.add(unOrderedList);
        if (!bl) {
            this.displayTargetHosts(unOrderedList);
        }
    }

    private void displayTargetHosts(UnOrderedList unOrderedList) {
        String string = "";
        for (String string2 : this.getMappedHostList()) {
            ListItem listItem = new ListItem();
            listItem.setAttribute("lnk", string2);
            boolean bl = this.isPCNSHost(string2);
            boolean bl2 = this.isVCSAHost(string2);
            if (bl2 && bl) {
                listItem.setAttribute("rel", "vcsapcnshost");
                listItem.setCssClass("host pcns vcsa");
                string = "vcsapcnshost";
            } else if (bl2) {
                listItem.setAttribute("rel", "vcsahost");
                listItem.setCssClass("host vcsa");
                string = "vcsahost";
            } else if (bl) {
                listItem.setAttribute("rel", "pcnshost");
                listItem.setCssClass("host pcns");
                string = "pcnshost";
            } else {
                listItem.setAttribute("rel", "host");
                listItem.setCssClass("host");
                string = "host";
            }
            Anchor anchor = new Anchor();
            anchor.setHypertextReference("#");
            anchor.add(new Text(string2));
            if (bl2 && bl) {
                anchor.setCssClass("vcsapcnshost");
            }
            listItem.setDataJstree(string);
            listItem.add(anchor);
            unOrderedList.add(listItem);
        }
    }
}

