/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.util;

import com.apcc.m11.arch.IFormatter;
import com.apcc.m11.arch.ObjectId;
import com.apcc.m11.arch.event.Event;
import com.apcc.m11.components.psaggregator.rules.advanced.AdvancedGroupEvent;
import com.apcc.m11.components.psaggregator.rules.advanced.AdvancedGroupOutletEvent;
import com.apcc.m11.components.shutdowner.formatters.RunCommandFileFormatter;
import com.apcc.m11.components.shutdowner.vmware.vsan.VsanUtils;
import com.apcc.m11.components.stdpowersource.OutletGroup;
import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.model.MappedHost;
import com.apcc.m11.components.webserver.model.NMC;
import com.apcc.m11.components.webserver.model.UPSSetup;
import com.apcc.m11.components.webserver.model.VMOperations;
import com.apcc.m11.components.webserver.model.VMSettings;
import com.apcc.m11.components.webserver.servlets.cfgwizard.HTTPServletParameterMap;
import com.apcc.m11.components.webserver.servlets.cfgwizard.M11DataSourceAccessor;
import com.apcc.m11.components.webserver.util.AdvancedSetupHelper;
import com.apcc.m11.components.webserver.util.virtualization.VMPrioritizationUtils;
import com.apcc.m11.components.webserver.util.virtualization.vmware.ClusterUtils;
import com.apcc.m11.components.webserver.util.virtualization.vmware.HostSystemUtils;
import com.apcc.m11.components.webserver.util.virtualization.vxrail.VxRailUtils;
import com.apcc.m11.ds.powersource.communication.TCPIPCommunication;
import com.apcc.pcns.configservice.ConfigurationKeys;
import com.apcc.pcns.configservice.VirtualConfigurationManager;
import com.apcc.pcns.configservice.configurationmanagers.ConfigurationManager;
import com.apcc.pcns.configservice.validation.IntRangeSetValidator;
import com.apcc.pcns.util.HostNameLookUpTable;
import com.apcc.pcns.util.IPUtils;
import com.apcc.pcns.util.ResourceBundleWrapper;
import com.apcc.pcns.util.UTF8ResourceBundle;
import java.io.File;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.StringTokenizer;
import java.util.Vector;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.configuration2.ex.ConversionException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Utils {
    private static final Logger logger = LogManager.getLogger(Utils.class);
    public static final String MISSING_RESOURCE_STRING = "MISSING RESOURCE STRING!";
    private static final String MISSING_BUNDLE_STRING = "MISSING RESOURCE BUNDLE!";
    public static final String HOST_DELIMITER = "|";
    public static final String OUTLET_GROUP_DELIMITER = "&";
    public static final String HOST_DELIMITER_ESCAPED = "\\|";
    public static final String UNKNOWN = "unknown";
    public static final String DATATABLES_START = "_START_";
    public static final String DATATABLES_END = "_END_";
    public static final String DATATABLES_TOTAL = "_TOTAL_";
    public static final String DATA_ATTR_PREFIX = "data-";
    public static final String WEBSERVER_I18N_RESOURCE = "com.apcc.m11.components.webserver.i18n.WebServer";
    private static final Locale[] supportedLocales = new Locale[]{Locale.JAPANESE};
    private static Boolean logkeys = null;
    private String thePcnsVersion = null;
    private static final String VERSION_KEY = "Pcns.Version";
    private static final String VERSION_FILE = "com.apcc.m11.components.webserver.i18n.Version";
    private Boolean japanese = Boolean.FALSE;
    private VsanUtils vsanUtils;
    private AdvancedSetupHelper advancedSetupHelper;
    private ConfigurationManager config;
    private VirtualConfigurationManager virtualConfigManager;
    private VMPrioritizationUtils vmPrioritizationUtils;
    private HostSystemUtils hostSystemUtils;
    private VxRailUtils vxRailUtils;
    private ClusterUtils clusterUtils;

    public void init() {
        try {
            ResourceBundleWrapper resourceBundleWrapper = Utils.getUTF8ResourceBundle(VERSION_FILE, Locale.getDefault());
            this.thePcnsVersion = Utils.getResourceString(resourceBundleWrapper, VERSION_KEY);
        }
        catch (MissingResourceException missingResourceException) {
            logger.error("init() - cannot load a needed resource: {}, error: {}: ", (Object)VERSION_FILE, (Object)missingResourceException);
        }
        if ("JP".equals(this.thePcnsVersion)) {
            this.japanese = Boolean.TRUE;
        }
    }

    public static List<NMC> getNMCList(PageContext pageContext, boolean bl, boolean bl2) {
        return Utils.getNMCList(pageContext.getDataSourceAccessor(), bl, bl2);
    }

    public static List<NMC> getNMCList(M11DataSourceAccessor m11DataSourceAccessor, boolean bl, boolean bl2) {
        ArrayList<NMC> arrayList = new ArrayList<NMC>();
        Vector<InetAddress> vector = Utils.getIPAddresses(m11DataSourceAccessor);
        if (vector != null) {
            Vector<Object> vector2 = new Vector();
            if (bl2) {
                vector2 = Utils.getOutletGroups(m11DataSourceAccessor);
            }
            for (InetAddress inetAddress : vector) {
                String string = inetAddress.getHostAddress();
                Vector vector3 = null;
                for (Vector vector4 : vector2) {
                    if (vector4.isEmpty() || !((OutletGroup)vector4.firstElement()).getIpAddress().equalsIgnoreCase(string)) continue;
                    vector3 = vector4;
                    break;
                }
                NMC nMC = new NMC(string, vector3);
                if (bl) {
                    Utils.hostNameLookUp(nMC, inetAddress);
                }
                arrayList.add(nMC);
            }
        }
        return arrayList;
    }

    public static NMC getNMC(PageContext pageContext, String string, boolean bl) {
        NMC nMC = null;
        Vector<InetAddress> vector = Utils.getIPAddresses(pageContext);
        if (vector != null) {
            Vector<Vector<OutletGroup>> vector2 = Utils.getOutletGroups(pageContext);
            InetAddress object = null;
            for (InetAddress object2 : vector) {
                if (!object2.getHostAddress().equalsIgnoreCase(string)) continue;
                object = object2;
                break;
            }
            if (object != null) {
                Object object3 = null;
                for (Vector<OutletGroup> vector3 : vector2) {
                    if (vector3.isEmpty() || !vector3.firstElement().getIpAddress().equalsIgnoreCase(string)) continue;
                    object3 = vector3;
                    break;
                }
                nMC = new NMC(string, (Vector<OutletGroup>)object3);
                if (bl) {
                    Utils.hostNameLookUp(nMC, object);
                }
            }
        }
        return nMC;
    }

    public static void hostNameLookUp(NMC nMC, InetAddress inetAddress) {
        String string = HostNameLookUpTable.getInstance().lookUp(inetAddress);
        String string2 = inetAddress.getHostAddress();
        if (!string2.equalsIgnoreCase(string)) {
            int n = string.indexOf(".");
            if (n < 0) {
                nMC.setHostName(string);
            } else {
                nMC.setHostName(string.substring(0, n));
                nMC.setFqdn(string);
            }
        }
    }

    public static Vector<InetAddress> getIPAddresses(PageContext pageContext) {
        return Utils.getIPAddresses(pageContext.getDataSourceAccessor());
    }

    public static Vector<InetAddress> getIPAddresses(M11DataSourceAccessor m11DataSourceAccessor) {
        Vector<InetAddress> vector = null;
        Object object = m11DataSourceAccessor.get(TCPIPCommunication.IpAddress.getObjectId());
        if (object != null) {
            if (object instanceof Vector) {
                vector = (Vector<InetAddress>)object;
            } else {
                vector = new Vector<InetAddress>();
                vector.add((InetAddress)object);
            }
        }
        return vector;
    }

    public static Vector<Vector<OutletGroup>> getOutletGroups(PageContext pageContext) {
        return Utils.getOutletGroups(pageContext.getDataSourceAccessor());
    }

    public static Vector<Vector<OutletGroup>> getOutletGroups(M11DataSourceAccessor m11DataSourceAccessor) {
        Vector vector;
        Vector vector2 = new Vector();
        Object object = m11DataSourceAccessor.get(TCPIPCommunication.OutletGroupList.getObjectId());
        if (object instanceof Vector && !(vector = (Vector)object).isEmpty()) {
            Object e = vector.get(0);
            if (e instanceof Vector) {
                vector2 = (Vector)object;
            } else if (object != null) {
                vector2.add((Vector)object);
            }
        }
        return vector2;
    }

    public static boolean isOutletGroupTurnOffSupported(PageContext pageContext) {
        boolean bl = true;
        List<NMC> list = Utils.getNMCList(pageContext, false, true);
        for (NMC nMC : list) {
            if (nMC.hasOutletGroups()) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public boolean hasUPSWithNoHostsMapped(PageContext pageContext) {
        boolean bl = false;
        if (!this.advancedSetupHelper.getSingleUPSSetupSetting()) {
            return true;
        }
        NMC nMC = null;
        for (UPSSetup uPSSetup : this.advancedSetupHelper.readUPSSetupsFromConfig()) {
            if (uPSSetup.getNMCList().size() == 0 || (nMC = Utils.getNMC(pageContext, uPSSetup.getNMCList().get(0), false)) == null || !nMC.hasOutletGroups()) continue;
            boolean bl2 = false;
            for (Integer n : uPSSetup.getHostsMap().values()) {
                if (n == null) continue;
                bl2 = true;
                break;
            }
            if (!(bl = !bl2)) continue;
            break;
        }
        return bl;
    }

    public static boolean hasOutletGroups(PageContext pageContext) {
        NMC nMC;
        boolean bl = false;
        List<NMC> list = Utils.getNMCList(pageContext, false, true);
        Iterator<NMC> iterator = list.iterator();
        while (iterator.hasNext() && !(bl = (nMC = iterator.next()).hasOutletGroups())) {
        }
        return bl;
    }

    public VMSettings readHypervVMSettingsFromConfig() {
        String string = null;
        return this.readHypervVMSettingsFromConfig(string);
    }

    public VMSettings readHypervVMSettingsFromConfig(Integer n) throws ConversionException {
        String string = null;
        if (n != null) {
            String string2 = ConfigurationKeys.getAdvancedSetupKey(n);
            string = this.config.getString(string2, "setup_name");
        }
        return this.readHypervVMSettingsFromConfig(string);
    }

    public VMSettings readHypervVMSettingsFromConfig(String string) {
        String string2;
        String string3;
        VMSettings vMSettings = new VMSettings();
        String string4 = string3 = "HostConfigSettings";
        if (string != null && (string2 = this.getNMCSection(string)) != null) {
            string4 = string2;
        }
        try {
            string2 = "enable_hvstopcluster";
            if (this.config.containsKey(string4, string2)) {
                vMSettings.setHVStopClusterEnabled(this.config.getBoolean(string4, string2));
            }
            if (this.config.containsKey(string4, string2 = "hvstopcluster_duration")) {
                vMSettings.setHVStopClusterDuration(this.config.getInt(string4, string2));
            }
            if (this.config.containsKey(string4, string2 = "hvstartcluster_duration")) {
                vMSettings.setHVStartClusterDuration(this.config.getInt(string4, string2));
            }
            if (this.config.containsKey(string4, string2 = "enable_guest_vm_migration")) {
                vMSettings.setGuestVMMigrationEnabled(this.config.getBoolean(string4, string2));
            }
            if (this.config.containsKey(string4, string2 = "guest_vm_migration_duration")) {
                vMSettings.setGuestVMMigrationDuration(this.config.getInt(string4, string2));
            }
            if (this.config.containsKey(string4, string2 = "enable_custom_target_vm_migration")) {
                vMSettings.setGuestVMMigrationTargetEnabled(this.config.getBoolean(string4, string2));
            }
            if (this.config.containsKey(string4, string2 = "custom_target_hosts")) {
                vMSettings.setMigrationTargetHosts(this.readMigrationTargetHostsFromConfig(string4));
            }
            if (this.config.containsKey(string4, string2 = "enable_guest_vm_vapp_shutdown")) {
                vMSettings.setGuestVMVAppShutdownEnabled(this.config.getBoolean(string4, string2));
            }
            if (this.config.containsKey(string4, string2 = "guest_vm_vapp_shutdown_duration")) {
                vMSettings.setGuestVMVappShutdownDuration(this.config.getInt(string4, string2));
            }
            if (this.config.containsKey(string4, string2 = "enable_guest_vm_vapp_startup")) {
                vMSettings.setGuestVMVappStartupEnabled(this.config.getBoolean(string4, string2));
            }
            if (this.config.containsKey(string4, string2 = "guest_vm_vapp_startup_duration")) {
                vMSettings.setGuestVMVappStartupDuration(this.config.getInt(string4, string2));
            }
            if (this.config.containsKey(string4, string2 = "enable_host_maintenance")) {
                vMSettings.setHostMaintenanceEnabled(this.config.getBoolean(string4, string2));
            }
            if (this.config.containsKey(string4, string2 = "host_maintenance_duration")) {
                vMSettings.setHostMaintenanceDuration(this.config.getInt(string4, string2));
            }
            if (this.config.containsKey(string4, string2 = "enable_host_shutdown")) {
                vMSettings.setHostShutdownEnabled(this.config.getBoolean(string4, string2));
            }
            if (this.config.containsKey(string4, string2 = "host_shutdown_duration")) {
                vMSettings.setHostShutdownDuration(this.config.getInt(string4, string2));
            }
            if (this.config.containsKey(string4, string2 = "apply_vm_settings_to_all_nmcs")) {
                vMSettings.setApplySettingsToAllGroups(this.config.getBoolean(string4, string2));
            }
            if (this.config.containsKey(string4, string2 = "vm_startup_delay_duration")) {
                vMSettings.setBetweenVmStartupDelay(this.config.getInt(string4, string2));
            }
        }
        catch (ConversionException conversionException) {
            logger.debug((Object)conversionException);
        }
        return vMSettings;
    }

    public VMSettings readVMSettingsFromConfig() {
        return this.readVMSettingsFromConfig(null);
    }

    public VMSettings readVMSettingsFromRequest(PageContext pageContext) {
        HTTPServletParameterMap hTTPServletParameterMap = new HTTPServletParameterMap();
        hTTPServletParameterMap.putAll(pageContext.getPostQueryValues());
        return this.readVMSettingsFromRequest(hTTPServletParameterMap);
    }

    public VMSettings readVMSettingsFromRequest(HTTPServletParameterMap hTTPServletParameterMap) {
        boolean bl;
        String string;
        VMSettings vMSettings;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        boolean bl5;
        boolean bl6;
        boolean bl7;
        boolean bl8;
        boolean bl9;
        block63: {
            bl9 = this.virtualConfigManager.isManagedHost();
            bl8 = this.virtualConfigManager.isHyperV();
            bl7 = this.virtualConfigManager.isESXi();
            bl6 = this.virtualConfigManager.isNutanixAHV();
            bl5 = this.virtualConfigManager.isNutanixESXi();
            bl4 = this.virtualConfigManager.isSimplivity();
            bl3 = this.virtualConfigManager.isHyperflex();
            bl2 = this.virtualConfigManager.isVxRail();
            if (!(bl9 || bl8 || bl6)) {
                return null;
            }
            vMSettings = new VMSettings();
            string = null;
            Integer n = null;
            bl = hTTPServletParameterMap.getString("hvStopClusterEnabled") != null;
            vMSettings.setHVStopClusterEnabled(bl);
            if (bl) {
                string = hTTPServletParameterMap.getString("hvStopClusterDuration");
                if (string != null) {
                    try {
                        vMSettings.setHVStopClusterDuration(Integer.parseInt(string));
                    }
                    catch (NumberFormatException numberFormatException) {
                        logger.error((Object)numberFormatException);
                    }
                }
                if ((string = hTTPServletParameterMap.getString("hvStartClusterDuration")) != null) {
                    try {
                        vMSettings.setHVStartClusterDuration(Integer.parseInt(string));
                    }
                    catch (NumberFormatException numberFormatException) {
                        logger.error((Object)numberFormatException);
                    }
                }
            } else {
                vMSettings.setHVStopClusterEnabled(false);
            }
            bl = hTTPServletParameterMap.getString("vmmigrationEnabled") != null;
            vMSettings.setGuestVMMigrationEnabled(bl);
            if (bl) {
                string = hTTPServletParameterMap.getString("vmmigrationDuration");
                if (string != null) {
                    try {
                        vMSettings.setGuestVMMigrationDuration(Integer.parseInt(string));
                    }
                    catch (NumberFormatException numberFormatException) {
                        logger.error((Object)numberFormatException);
                    }
                }
                bl = hTTPServletParameterMap.getString("vmmigrationtargetEnabled") != null;
                vMSettings.setGuestVMMigrationTargetEnabled(bl);
                if (bl) {
                    vMSettings.setMigrationTargetHosts(this.readTargetHostSelectionFromRequest(hTTPServletParameterMap));
                }
            } else {
                vMSettings.setGuestVMMigrationTargetEnabled(false);
            }
            if (!bl6) {
                bl = hTTPServletParameterMap.getString("vmshutdownEnabled") != null;
                vMSettings.setGuestVMVAppShutdownEnabled(bl);
            }
            if (bl || bl6) {
                string = hTTPServletParameterMap.getString("vmshutdownDuration");
                if (string != null) {
                    try {
                        n = Integer.parseInt(string);
                        if (n < 0 || n > 172800) {
                            vMSettings.setGuestVMVappShutdownDuration(120);
                        } else {
                            vMSettings.setGuestVMVappShutdownDuration(n);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        logger.debug((Object)numberFormatException);
                    }
                }
                bl = hTTPServletParameterMap.getString("vmstartupEnabled") != null;
                vMSettings.setGuestVMVappStartupEnabled(bl);
                if (bl && (string = hTTPServletParameterMap.getString("vmstartupDuration")) != null) {
                    try {
                        n = Integer.parseInt(string);
                        if (n < 0 || n > 172800) {
                            vMSettings.setGuestVMVappStartupDuration(120);
                            break block63;
                        }
                        vMSettings.setGuestVMVappStartupDuration(n);
                    }
                    catch (NumberFormatException numberFormatException) {
                        logger.debug((Object)numberFormatException);
                    }
                }
            } else {
                vMSettings.setGuestVMVappStartupEnabled(false);
            }
        }
        if (bl6 || bl5) {
            Utils.readCvmVMSettingsFromRequest(vMSettings, hTTPServletParameterMap);
            Utils.readNutanixAfsVMSettingsFromRequest(vMSettings, hTTPServletParameterMap);
            this.readNutanixProtectionDomainSettingsFromRequest(vMSettings, hTTPServletParameterMap);
            Utils.readClusterStopSettingsFromRequest(vMSettings, hTTPServletParameterMap);
        }
        if (bl4) {
            Utils.readSimplivityVMSettingsFromRequest(vMSettings, hTTPServletParameterMap);
        }
        if (bl3) {
            Utils.readCvmVMSettingsFromRequest(vMSettings, hTTPServletParameterMap);
            Utils.readClusterStopSettingsFromRequest(vMSettings, hTTPServletParameterMap);
        }
        if (bl2) {
            this.readVxRailVMSettingsFromRequest(vMSettings, hTTPServletParameterMap);
        }
        if (bl9 && bl7) {
            if (vMSettings.isGuestVMVAppShutdownEnabled()) {
                vMSettings.setForcevAppShutdownEnabled(hTTPServletParameterMap.getString("forcevappshutdownEnabled") != null);
            } else {
                vMSettings.setForcevAppShutdownEnabled(false);
            }
            string = hTTPServletParameterMap.getString("vcsashutdownDuration");
            if (string != null) {
                try {
                    vMSettings.setvCSAShutdownDuration(Integer.parseInt(string));
                }
                catch (NumberFormatException numberFormatException) {
                    logger.debug((Object)numberFormatException);
                }
            }
            if (NumberUtils.isParsable((String)hTTPServletParameterMap.getString("disableRetreatModeDuration"))) {
                vMSettings.setEnableVClsDelay(NumberUtils.toInt((String)hTTPServletParameterMap.getString("disableRetreatModeDuration")));
            }
            if (NumberUtils.isParsable((String)hTTPServletParameterMap.getString("enableRetreatModeDuration"))) {
                vMSettings.setDisableVClsDelay(NumberUtils.toInt((String)hTTPServletParameterMap.getString("enableRetreatModeDuration")));
            }
            vMSettings.setDisableHAMode(hTTPServletParameterMap.getString("disableHA") != null);
            if (NumberUtils.isParsable((String)hTTPServletParameterMap.getString("disableHADuration"))) {
                vMSettings.setDisableHADelay(NumberUtils.toInt((String)hTTPServletParameterMap.getString("disableHADuration")));
            }
            if (NumberUtils.isParsable((String)hTTPServletParameterMap.getString("enableHADuration"))) {
                vMSettings.setEnableHADelay(NumberUtils.toInt((String)hTTPServletParameterMap.getString("enableHADuration")));
            }
            this.readAutoStartDelayFromConfig(vMSettings, "HostConfigSettings");
            vMSettings.setStartupWaitForAllHostsOnline(hTTPServletParameterMap.getString("startupWaitsforHosts") != null);
        }
        if (bl9 && bl8) {
            bl = hTTPServletParameterMap.getString("vmskipHostMaintenance") != null;
            vMSettings.setSkipMaintenanceModeEnabled(bl);
            bl = hTTPServletParameterMap.getString("vmenableHostMaintenance") != null;
            vMSettings.setHostMaintenanceEnabled(bl);
            string = hTTPServletParameterMap.getString("vmmaintenanceDuration");
            if (string != null) {
                try {
                    vMSettings.setHostMaintenanceDuration(Integer.parseInt(string));
                }
                catch (NumberFormatException numberFormatException) {
                    logger.debug((Object)numberFormatException);
                }
            }
            bl = hTTPServletParameterMap.getString("vmenableHostShutdown") != null;
            vMSettings.setHostShutdownEnabled(bl);
            string = hTTPServletParameterMap.getString("vmHostShutdownDuration");
            if (string != null) {
                try {
                    vMSettings.setHostShutdownDuration(Integer.parseInt(string));
                }
                catch (NumberFormatException numberFormatException) {
                    logger.debug((Object)numberFormatException);
                }
            }
        }
        vMSettings.setApplySettingsToAllGroups(hTTPServletParameterMap.getString("globalvmsettings") != null);
        if (hTTPServletParameterMap.getString("vspherepluginEnabled") != null) {
            vMSettings.setPluginType(ConfigurationKeys.LEGACY_PLUGIN);
            vMSettings.setPluginEnabled(true);
        } else if (hTTPServletParameterMap.getString("vspherewebpluginEnabled") != null) {
            vMSettings.setPluginType(ConfigurationKeys.WEB_CLIENT_PLUGIN);
            vMSettings.setPluginEnabled(true);
        } else if (hTTPServletParameterMap.getString("vmsettingsHiddenInput") == null && bl7 && bl9) {
            try {
                if (this.config.containsKey("HostConfigSettings", ConfigurationKeys.ENABLE_PLUGIN)) {
                    vMSettings.setPluginEnabled(this.config.getBoolean("HostConfigSettings", ConfigurationKeys.ENABLE_PLUGIN));
                }
            }
            catch (ConversionException conversionException) {
                logger.debug((Object)conversionException);
            }
            try {
                if (this.config.containsKey("HostConfigSettings", ConfigurationKeys.PLUGIN_TYPE)) {
                    vMSettings.setPluginType(this.config.getString("HostConfigSettings", ConfigurationKeys.PLUGIN_TYPE));
                }
            }
            catch (ConversionException conversionException) {
                logger.debug((Object)conversionException);
            }
        }
        int n = this.virtualConfigManager.getDurationGlobal("vm_startup_delay_duration");
        vMSettings.setBetweenVmStartupDelay(n);
        try {
            vMSettings.setHostMaintenanceModeDelayed(hTTPServletParameterMap.getString("vmHostMaintenanceDelayEnabled") != null);
            vMSettings.setHostMaintenanceModeTimeout(Integer.parseInt(hTTPServletParameterMap.getString("vmHostMaintenanceDelayTimeout")));
            vMSettings.setSkipMaintenanceModeEnabled(hTTPServletParameterMap.getString("vmskipHostMaintenance") != null);
        }
        catch (NumberFormatException numberFormatException) {
            logger.debug((Object)numberFormatException);
        }
        try {
            vMSettings.setFttEnabled(hTTPServletParameterMap.getString("enableFTT") != null);
            vMSettings.setVsanSyncTimeout(Integer.parseInt(hTTPServletParameterMap.getString("vSanSyncTimeout")));
            vMSettings.setVsanPrepareDuration(Integer.parseInt(hTTPServletParameterMap.getString("vsanPrepareDuration")));
            vMSettings.setVsanRecoveryDuration(Integer.parseInt(hTTPServletParameterMap.getString("vsanRecoveryDuration")));
            vMSettings.setShutdownAllClusterVMsEnabled(hTTPServletParameterMap.getString("shutdownAllClusterVMs") != null);
            vMSettings.setFttLevel(Integer.parseInt(hTTPServletParameterMap.getString("vSanFTTLevel")));
        }
        catch (NumberFormatException numberFormatException) {
            logger.debug((Object)numberFormatException);
        }
        return vMSettings;
    }

    private static void readCvmVMSettingsFromRequest(VMSettings vMSettings, HTTPServletParameterMap hTTPServletParameterMap) {
        block11: {
            Integer n;
            String string = hTTPServletParameterMap.getString("cvmShutdownDuration");
            if (string != null) {
                try {
                    n = Integer.parseInt(string);
                    if (n < 0 || n > 172800) {
                        vMSettings.setCvmShutdownDuration(120);
                    } else {
                        vMSettings.setCvmShutdownDuration(n);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    logger.debug((Object)numberFormatException);
                }
            }
            Boolean bl = hTTPServletParameterMap.getString("cvmStartupEnable") != null;
            vMSettings.setCvmStartupEnable(bl);
            if (bl.booleanValue()) {
                string = hTTPServletParameterMap.getString("cvmStartupDuration");
                if (string != null) {
                    try {
                        n = Integer.parseInt(string);
                        if (n < 0 || n > 172800) {
                            vMSettings.setCvmStartupDuration(300);
                            break block11;
                        }
                        vMSettings.setCvmStartupDuration(n);
                    }
                    catch (NumberFormatException numberFormatException) {
                        logger.debug((Object)numberFormatException);
                    }
                }
            } else {
                vMSettings.setCvmStartupEnable(false);
            }
        }
    }

    private static void readNutanixAfsVMSettingsFromRequest(VMSettings vMSettings, HTTPServletParameterMap hTTPServletParameterMap) {
        block13: {
            Integer n;
            String string;
            Boolean bl;
            block12: {
                bl = hTTPServletParameterMap.getString("afsShutdownEnable") != null;
                vMSettings.setAfsShutdownEnable(bl);
                if (bl.booleanValue()) {
                    string = hTTPServletParameterMap.getString("afsShutdownDuration");
                    if (string != null) {
                        try {
                            n = Integer.parseInt(string);
                            if (n < 0 || n > 172800) {
                                vMSettings.setAfsShutdownDuration(180);
                                break block12;
                            }
                            vMSettings.setAfsShutdownDuration(n);
                        }
                        catch (NumberFormatException numberFormatException) {
                            logger.debug((Object)numberFormatException);
                        }
                    }
                } else {
                    vMSettings.setAfsShutdownEnable(false);
                }
            }
            bl = hTTPServletParameterMap.getString("afsStartupEnable") != null;
            vMSettings.setAfsStartupEnable(bl);
            if (bl.booleanValue()) {
                string = hTTPServletParameterMap.getString("afsStartupDuration");
                if (string != null) {
                    try {
                        n = Integer.parseInt(string);
                        if (n < 0 || n > 172800) {
                            vMSettings.setAfsStartupDuration(300);
                            break block13;
                        }
                        vMSettings.setAfsStartupDuration(n);
                    }
                    catch (NumberFormatException numberFormatException) {
                        logger.debug((Object)numberFormatException);
                    }
                }
            } else {
                vMSettings.setAfsStartupEnable(false);
            }
        }
    }

    private static void readClusterStopSettingsFromRequest(VMSettings vMSettings, HTTPServletParameterMap hTTPServletParameterMap) {
        Integer n;
        String string = hTTPServletParameterMap.getString("clusterShutdownDuration");
        if (string != null) {
            try {
                n = Integer.parseInt(string);
                if (n < 0 || n > 172800) {
                    vMSettings.setClusterShutdownDuration(180);
                } else {
                    vMSettings.setClusterShutdownDuration(n);
                }
            }
            catch (NumberFormatException numberFormatException) {
                logger.debug((Object)numberFormatException);
            }
        }
        if ((string = hTTPServletParameterMap.getString("clusterStartupDuration")) != null) {
            try {
                n = Integer.parseInt(string);
                if (n < 0 || n > 172800) {
                    vMSettings.setClusterStartupDuration(120);
                } else {
                    vMSettings.setClusterStartupDuration(n);
                }
                vMSettings.setClusterStartupDuration(Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {
                logger.debug((Object)numberFormatException);
            }
        }
    }

    private void readNutanixProtectionDomainSettingsFromRequest(VMSettings vMSettings, HTTPServletParameterMap hTTPServletParameterMap) {
        Boolean bl;
        block8: {
            bl = hTTPServletParameterMap.getString("ongoingReplicationAbortDelayEnable") != null;
            vMSettings.setOngoingReplicationAbortDelayEnable(bl);
            if (bl.booleanValue()) {
                String string = hTTPServletParameterMap.getString("ongoingReplicationAbortDelayDuration");
                if (string != null) {
                    try {
                        Integer n = Integer.parseInt(string);
                        if (n < 0 || n > 172800) {
                            vMSettings.setOngoingReplicationAbortDelayDuration(120);
                            break block8;
                        }
                        vMSettings.setOngoingReplicationAbortDelayDuration(n);
                    }
                    catch (NumberFormatException numberFormatException) {
                        logger.debug((Object)numberFormatException);
                    }
                }
            } else {
                vMSettings.setOngoingReplicationAbortDelayEnable(false);
            }
        }
        if (this.virtualConfigManager.isNutanixESXi()) {
            bl = hTTPServletParameterMap.getString("metroAvailDisable") != null;
            vMSettings.setMetroAvailDisabled(bl);
            vMSettings.setMetroAvailReEnabled(bl);
            if (!bl.booleanValue()) {
                vMSettings.setMetroAvailDisabled(false);
                vMSettings.setMetroAvailReEnabled(false);
            }
        }
    }

    private void readVxRailVMSettingsFromRequest(VMSettings vMSettings, HTTPServletParameterMap hTTPServletParameterMap) {
        this.readVxRailShutdownDelayFromRequest(vMSettings, hTTPServletParameterMap);
        this.readVxRailShutdownDurationFromRequest(vMSettings, hTTPServletParameterMap);
        this.vxRailUtils.getRetryLimit(vMSettings, "VxRailClusterDetails");
        this.vxRailUtils.getNetworkTimeout(vMSettings, "VxRailClusterDetails");
        this.vxRailUtils.getRetryInterval(vMSettings, "VxRailClusterDetails");
    }

    private void readVxRailShutdownDelayFromRequest(VMSettings vMSettings, HTTPServletParameterMap hTTPServletParameterMap) {
        String string = hTTPServletParameterMap.getString("vxRailShutdownDelay");
        if (StringUtils.isNotBlank((CharSequence)string)) {
            vMSettings.setVxRailShutdownDelay(NumberUtils.toInt((String)string));
        }
    }

    private void readVxRailShutdownDurationFromRequest(VMSettings vMSettings, HTTPServletParameterMap hTTPServletParameterMap) {
        String string = hTTPServletParameterMap.getString("vxRailShutdownDuration");
        if (StringUtils.isNotBlank((CharSequence)string)) {
            vMSettings.setVxRailShutdownDuration(NumberUtils.toInt((String)string));
        }
    }

    private static void readSimplivityVMSettingsFromRequest(VMSettings vMSettings, HTTPServletParameterMap hTTPServletParameterMap) {
        Utils.readOvcShutdownDurationFromRequest(vMSettings, hTTPServletParameterMap);
        Utils.readOvcStartupDurationFromRequest(vMSettings, hTTPServletParameterMap);
    }

    private static void readOvcStartupDurationFromRequest(VMSettings vMSettings, HTTPServletParameterMap hTTPServletParameterMap) {
        block6: {
            Boolean bl = hTTPServletParameterMap.getString("ovcStartupEnable") != null;
            vMSettings.setOvcStartupEnable(bl);
            if (bl.booleanValue()) {
                String string = hTTPServletParameterMap.getString("ovcStartupDuration");
                if (string != null) {
                    try {
                        Integer n = Integer.parseInt(string);
                        if (n < 0 || n > 172800) {
                            vMSettings.setOvcStartupDuration(480);
                            break block6;
                        }
                        vMSettings.setOvcStartupDuration(n);
                    }
                    catch (NumberFormatException numberFormatException) {
                        logger.debug((Object)numberFormatException);
                    }
                }
            } else {
                vMSettings.setOvcStartupEnable(false);
            }
        }
    }

    private static void readOvcShutdownDurationFromRequest(VMSettings vMSettings, HTTPServletParameterMap hTTPServletParameterMap) {
        String string = hTTPServletParameterMap.getString("ovcShutdownDuration");
        if (string != null) {
            try {
                Integer n = Integer.parseInt(string);
                if (n < 0 || n > 172800) {
                    vMSettings.setOvcShutdownDuration(300);
                } else {
                    vMSettings.setOvcShutdownDuration(n);
                }
            }
            catch (NumberFormatException numberFormatException) {
                logger.debug((Object)numberFormatException);
            }
        }
    }

    public VMSettings readVMSettingsFromConfigAndCluster() {
        return this.readVMSettingsFromConfigAndCluster(null);
    }

    public VMSettings readVMSettingsFromConfigAndCluster(String string) {
        VMSettings vMSettings = this.readVMSettingsFromConfig(string);
        this.updateVMSettingsFromCluster(vMSettings);
        return vMSettings;
    }

    public void updateVMSettingsFromCluster(@NonNull VMSettings vMSettings) {
        if (vMSettings == null) {
            throw new IllegalArgumentException("settings is marked non-null but is null");
        }
        vMSettings.setVsanCluster(this.vsanUtils.isVsanCluster());
        if (this.virtualConfigManager.isESXi()) {
            vMSettings.setPcnsOnVSAN(this.vsanUtils.isPCNSInstalledOnVsanHost());
            vMSettings.setVCLSvMsPresent(this.hasVCLSBeenDetectedOnTheCluster());
        }
    }

    public VMSettings readVMSettingsFromConfig(String string) {
        String string2;
        String string3;
        VMSettings vMSettings = new VMSettings();
        String string4 = string3 = "HostConfigSettings";
        if (string != null && (string2 = this.getNMCSection(string)) != null) {
            string4 = string2;
        }
        string2 = null;
        if (this.virtualConfigManager.isManagedHost()) {
            string2 = "enable_guest_vm_migration";
            try {
                if (this.config.containsKey(string4, string2)) {
                    vMSettings.setGuestVMMigrationEnabled(this.config.getBoolean(string4, string2));
                } else if (!string4.equals(string3) && this.config.containsKey(string3, string2)) {
                    vMSettings.setGuestVMMigrationEnabled(this.config.getBoolean(string3, string2));
                }
            }
            catch (ConversionException conversionException) {
                logger.debug((Object)conversionException);
            }
            string2 = "guest_vm_migration_duration";
            try {
                if (this.config.containsKey(string4, string2)) {
                    vMSettings.setGuestVMMigrationDuration(this.config.getInt(string4, string2));
                } else if (!string4.equals(string3) && this.config.containsKey(string3, string2)) {
                    vMSettings.setGuestVMMigrationDuration(this.config.getInt(string3, string2));
                }
            }
            catch (ConversionException conversionException) {
                logger.debug((Object)conversionException);
            }
            string2 = "enable_custom_target_vm_migration";
            try {
                if (this.config.containsKey(string4, string2)) {
                    vMSettings.setGuestVMMigrationTargetEnabled(this.config.getBoolean(string4, string2));
                } else if (!string4.equals(string3) && this.config.containsKey(string3, string2)) {
                    vMSettings.setGuestVMMigrationTargetEnabled(this.config.getBoolean(string3, string2));
                }
            }
            catch (ConversionException conversionException) {
                logger.debug((Object)conversionException);
            }
            string2 = "custom_target_hosts";
            if (this.config.containsKey(string4, string2)) {
                vMSettings.setMigrationTargetHosts(this.readMigrationTargetHostsFromConfig(string4));
            }
        }
        if (this.virtualConfigManager.isESXi()) {
            this.readESXiVMSettingsFromConfig(vMSettings, "HostConfigSettings");
        }
        if (this.virtualConfigManager.isNutanixAHV() || this.virtualConfigManager.isNutanixESXi()) {
            this.readNutanixVMSettingsFromConfig(vMSettings, string4, string3);
        }
        if (this.virtualConfigManager.isNutanixAHV() || this.virtualConfigManager.isNutanixESXi() || this.virtualConfigManager.isHyperflex()) {
            this.readClusterSettingsFromConfig(vMSettings, string4, string3);
            this.readCVMSettingsFromConfig(vMSettings, string4, string3);
        }
        if (this.virtualConfigManager.isSimplivity()) {
            this.readSimplivityVMSettingsFromConfig(vMSettings, string4, string3);
        }
        if (this.virtualConfigManager.isVxRail()) {
            this.readVxRailVMSettingsFromConfig(vMSettings, "VxRailClusterDetails");
        }
        string2 = "delay_maintenance_mode";
        try {
            if (this.config.containsKey(string4, string2)) {
                vMSettings.setHostMaintenanceModeDelayed(this.config.getBoolean(string4, string2));
            } else if (!string4.equals(string3) && this.config.containsKey(string3, string2)) {
                vMSettings.setHostMaintenanceModeDelayed(this.config.getBoolean(string3, string2));
            } else if (this.virtualConfigManager.isNutanixESXi() || this.virtualConfigManager.isSimplivity() || this.virtualConfigManager.isHyperflex()) {
                vMSettings.setHostMaintenanceModeDelayed(true);
            }
        }
        catch (ConversionException conversionException) {
            logger.debug((Object)conversionException);
        }
        string2 = "delay_maintenance_mode_timeout";
        try {
            if (this.config.containsKey(string4, string2)) {
                vMSettings.setHostMaintenanceModeTimeout(this.config.getInt(string4, string2));
            } else if (!string4.equals(string3) && this.config.containsKey(string3, string2)) {
                vMSettings.setHostMaintenanceModeTimeout(this.config.getInt(string3, string2));
            }
        }
        catch (ConversionException conversionException) {
            logger.debug((Object)conversionException);
        }
        string2 = "vcls_detected_on_cluster";
        try {
            if (this.config.containsKey(string4, string2)) {
                vMSettings.setVCLSvMsPresent(this.config.getBoolean(string4, string2));
            } else if (!string4.equals(string3) && this.config.containsKey(string3, string2)) {
                vMSettings.setVCLSvMsPresent(this.config.getBoolean(string3, string2));
            }
        }
        catch (ConversionException conversionException) {
            logger.debug((Object)conversionException);
        }
        string2 = "disable_vCLS_duration";
        try {
            if (this.config.containsKey(string4, string2)) {
                vMSettings.setDisableVClsDelay(this.config.getInt(string4, string2));
            } else if (!string4.equals(string3) && this.config.containsKey(string3, string2)) {
                vMSettings.setDisableVClsDelay(this.config.getInt(string3, string2));
            }
        }
        catch (ConversionException conversionException) {
            logger.debug((Object)conversionException);
        }
        string2 = "enable_vCLS_duration";
        try {
            if (this.config.containsKey(string4, string2)) {
                vMSettings.setEnableVClsDelay(this.config.getInt(string4, string2));
            } else if (!string4.equals(string3) && this.config.containsKey(string3, string2)) {
                vMSettings.setEnableVClsDelay(this.config.getInt(string3, string2));
            }
        }
        catch (ConversionException conversionException) {
            logger.debug((Object)conversionException);
        }
        string2 = "disable_ha_on_shutdown";
        try {
            if (this.config.containsKey(string4, string2)) {
                vMSettings.setDisableHAMode(this.config.getBoolean(string4, string2));
            } else if (!string4.equals(string3) && this.config.containsKey(string3, string2)) {
                vMSettings.setDisableHAMode(this.config.getBoolean(string3, string2));
            }
        }
        catch (ConversionException conversionException) {
            logger.debug((Object)conversionException);
        }
        string2 = "disable_ha_delay";
        try {
            if (this.config.containsKey(string4, string2)) {
                vMSettings.setDisableHADelay(this.config.getInt(string4, string2));
            } else if (!string4.equals(string3) && this.config.containsKey(string3, string2)) {
                vMSettings.setDisableHADelay(this.config.getInt(string3, string2));
            }
        }
        catch (ConversionException conversionException) {
            logger.debug((Object)conversionException);
        }
        string2 = "enable_ha_delay";
        try {
            if (this.config.containsKey(string4, string2)) {
                vMSettings.setEnableHADelay(this.config.getInt(string4, string2));
            } else if (!string4.equals(string3) && this.config.containsKey(string3, string2)) {
                vMSettings.setEnableHADelay(this.config.getInt(string3, string2));
            }
        }
        catch (ConversionException conversionException) {
            logger.debug((Object)conversionException);
        }
        string2 = "disable_vCLS_duration";
        try {
            if (this.config.containsKey(string4, string2)) {
                vMSettings.setDisableVClsDelay(this.config.getInt(string4, string2));
            } else if (!string4.equals(string3) && this.config.containsKey(string3, string2)) {
                vMSettings.setDisableVClsDelay(this.config.getInt(string3, string2));
            }
        }
        catch (ConversionException conversionException) {
            logger.debug((Object)conversionException);
        }
        string2 = "enable_guest_vm_vapp_shutdown";
        try {
            if (this.config.containsKey(string4, string2)) {
                vMSettings.setGuestVMVAppShutdownEnabled(this.config.getBoolean(string4, string2));
            } else if (!string4.equals(string3) && this.config.containsKey(string3, string2)) {
                vMSettings.setGuestVMVAppShutdownEnabled(this.config.getBoolean(string4, string2));
            }
        }
        catch (ConversionException conversionException) {
            logger.debug((Object)conversionException);
        }
        string2 = "guest_vm_vapp_shutdown_duration";
        try {
            if (this.config.containsKey(string4, string2)) {
                vMSettings.setGuestVMVappShutdownDuration(this.config.getInt(string4, string2));
            } else if (!string4.equals(string3) && this.config.containsKey(string3, string2)) {
                vMSettings.setGuestVMVappShutdownDuration(this.config.getInt(string4, string2));
            }
        }
        catch (ConversionException conversionException) {
            logger.debug((Object)conversionException);
        }
        string2 = "enable_guest_vm_vapp_startup";
        try {
            if (this.config.containsKey(string4, string2)) {
                vMSettings.setGuestVMVappStartupEnabled(this.config.getBoolean(string4, string2));
            } else if (!string4.equals(string3) && this.config.containsKey(string3, string2)) {
                vMSettings.setGuestVMVappStartupEnabled(this.config.getBoolean(string4, string2));
            }
        }
        catch (ConversionException conversionException) {
            logger.debug((Object)conversionException);
        }
        string2 = "guest_vm_vapp_startup_duration";
        try {
            if (this.config.containsKey(string4, string2)) {
                vMSettings.setGuestVMVappStartupDuration(this.config.getInt(string4, string2));
            } else if (!string4.equals(string3) && this.config.containsKey(string3, string2)) {
                vMSettings.setGuestVMVappStartupDuration(this.config.getInt(string4, string2));
            }
        }
        catch (ConversionException conversionException) {
            logger.debug((Object)conversionException);
        }
        string2 = "force_VApp_shutdown";
        try {
            if (this.config.containsKey(string4, string2)) {
                vMSettings.setForcevAppShutdownEnabled(this.config.getBoolean(string4, string2));
            } else if (!string4.equals(string3) && this.config.containsKey(string3, string2)) {
                vMSettings.setForcevAppShutdownEnabled(this.config.getBoolean(string3, string2));
            }
        }
        catch (ConversionException conversionException) {
            logger.debug((Object)conversionException);
        }
        string2 = "VCSA_shutdown_duration";
        try {
            if (this.config.containsKey(string3, string2)) {
                vMSettings.setvCSAShutdownDuration(this.config.getInt(string3, string2));
            }
        }
        catch (ConversionException conversionException) {
            logger.debug((Object)conversionException);
        }
        string2 = "startup_waits_for_all_hosts_online";
        try {
            if (this.config.containsKey(string3, string2)) {
                vMSettings.setStartupWaitForAllHostsOnline(this.config.getBoolean(string3, string2));
            }
        }
        catch (ConversionException conversionException) {
            logger.debug((Object)conversionException);
        }
        string2 = "apply_vm_settings_to_all_nmcs";
        try {
            if (this.config.containsKey(string3, string2)) {
                vMSettings.setApplySettingsToAllGroups(this.config.getBoolean(string3, string2));
            }
        }
        catch (ConversionException conversionException) {
            logger.debug((Object)conversionException);
        }
        string2 = ConfigurationKeys.ENABLE_PLUGIN;
        try {
            if (this.config.containsKey(string3, string2)) {
                vMSettings.setPluginEnabled(this.config.getBoolean(string3, string2));
            }
        }
        catch (ConversionException conversionException) {
            logger.debug((Object)conversionException);
        }
        string2 = ConfigurationKeys.PLUGIN_TYPE;
        try {
            if (this.config.containsKey(string3, string2)) {
                vMSettings.setPluginType(this.config.getString(string3, string2));
            }
        }
        catch (ConversionException conversionException) {
            logger.debug((Object)conversionException);
        }
        string2 = "Skip_Maintenance_Mode";
        try {
            if (this.config.containsKey(string3, string2)) {
                vMSettings.setSkipMaintenanceModeEnabled(this.config.getBoolean(string3, string2));
            }
        }
        catch (ConversionException conversionException) {
            logger.debug((Object)conversionException);
        }
        string2 = "enable_host_maintenance";
        try {
            if (this.config.containsKey(string4, string2)) {
                vMSettings.setHostMaintenanceEnabled(this.config.getBoolean(string4, string2));
            } else if (!string4.equals(string3) && this.config.containsKey(string3, string2)) {
                vMSettings.setHostMaintenanceEnabled(this.config.getBoolean(string3, string2));
            }
        }
        catch (ConversionException conversionException) {
            logger.debug((Object)conversionException);
        }
        string2 = "host_maintenance_duration";
        try {
            if (this.config.containsKey(string4, string2)) {
                vMSettings.setHostMaintenanceDuration(this.config.getInt(string4, string2));
            } else if (!string4.equals(string3) && this.config.containsKey(string3, string2)) {
                vMSettings.setHostMaintenanceDuration(this.config.getInt(string3, string2));
            }
        }
        catch (ConversionException conversionException) {
            logger.debug((Object)conversionException);
        }
        string2 = "enable_host_shutdown";
        try {
            if (this.config.containsKey(string4, string2)) {
                vMSettings.setHostShutdownEnabled(this.config.getBoolean(string4, string2));
            } else if (!string4.equals(string3) && this.config.containsKey(string3, string2)) {
                vMSettings.setHostShutdownEnabled(this.config.getBoolean(string3, string2));
            }
        }
        catch (ConversionException conversionException) {
            logger.debug((Object)conversionException);
        }
        string2 = "host_shutdown_duration";
        try {
            if (this.config.containsKey(string4, string2)) {
                vMSettings.setHostShutdownDuration(this.config.getInt(string4, string2));
            } else if (!string4.equals(string3) && this.config.containsKey(string3, string2)) {
                vMSettings.setHostShutdownDuration(this.config.getInt(string3, string2));
            }
        }
        catch (ConversionException conversionException) {
            logger.debug((Object)conversionException);
        }
        string2 = "vm_startup_delay_duration";
        try {
            if (this.config.containsKey(string4, string2)) {
                vMSettings.setBetweenVmStartupDelay(this.config.getInt(string4, string2));
            } else if (!string4.equals(string3) && this.config.containsKey(string3, string2)) {
                vMSettings.setBetweenVmStartupDelay(this.config.getInt(string3, string2));
            }
        }
        catch (ConversionException conversionException) {
            logger.debug((Object)conversionException);
        }
        string2 = "delay_before_vmstartup";
        try {
            if (this.config.containsKey(string4, string2)) {
                vMSettings.setBeforeVmStartupDelay(this.config.getInt(string4, string2));
            } else if (!string4.equals(string3) && this.config.containsKey(string3, string2)) {
                vMSettings.setBeforeVmStartupDelay(this.config.getInt(string3, string2));
            }
        }
        catch (ConversionException conversionException) {
            logger.debug((Object)conversionException);
        }
        string2 = "enable_vsan_ftt";
        try {
            if (this.config.containsKey(string4, string2)) {
                vMSettings.setFttEnabled(this.config.getBoolean(string4, string2));
            } else if (!string4.equals(string3) && this.config.containsKey(string3, string2)) {
                vMSettings.setFttEnabled(this.config.getBoolean(string3, string2));
            }
        }
        catch (ConversionException conversionException) {
            logger.debug((Object)conversionException);
        }
        string2 = "vsan_ftt_level";
        try {
            if (this.config.containsKey(string4, string2)) {
                vMSettings.setFttLevel(this.config.getInt(string4, string2));
            } else if (!string4.equals(string3) && this.config.containsKey(string3, string2)) {
                vMSettings.setFttLevel(this.config.getInt(string3, string2));
            }
        }
        catch (ConversionException conversionException) {
            logger.debug((Object)conversionException);
        }
        string2 = "shutdown_all_vsan_vms";
        try {
            if (this.config.containsKey(string4, string2)) {
                vMSettings.setShutdownAllClusterVMsEnabled(this.config.getBoolean(string4, string2));
            } else if (!string4.equals(string3) && this.config.containsKey(string3, string2)) {
                vMSettings.setShutdownAllClusterVMsEnabled(this.config.getBoolean(string3, string2));
            }
        }
        catch (ConversionException conversionException) {
            logger.debug((Object)conversionException);
        }
        string2 = "vsan_sync_timeout";
        try {
            if (this.config.containsKey(string4, string2)) {
                vMSettings.setVsanSyncTimeout(this.config.getInt(string4, string2));
            } else if (!string4.equals(string3) && this.config.containsKey(string3, string2)) {
                vMSettings.setVsanSyncTimeout(this.config.getInt(string3, string2));
            }
        }
        catch (ConversionException conversionException) {
            logger.debug((Object)conversionException);
        }
        string2 = "vsan_prepare";
        try {
            if (this.config.containsKey(string4, string2)) {
                vMSettings.setVsanPrepareDuration(this.config.getInt(string4, string2));
            } else if (!string4.equals(string3) && this.config.containsKey(string3, string2)) {
                vMSettings.setVsanPrepareDuration(this.config.getInt(string3, string2));
            }
        }
        catch (ConversionException conversionException) {
            logger.debug((Object)conversionException);
        }
        string2 = "vsan_recovery";
        try {
            if (this.config.containsKey(string4, string2)) {
                vMSettings.setVsanRecoveryDuration(this.config.getInt(string4, string2));
            } else if (!string4.equals(string3) && this.config.containsKey(string3, string2)) {
                vMSettings.setVsanRecoveryDuration(this.config.getInt(string3, string2));
            }
        }
        catch (ConversionException conversionException) {
            logger.debug((Object)conversionException);
        }
        return vMSettings;
    }

    private void readClusterSettingsFromConfig(VMSettings vMSettings, String string, String string2) {
        String string3 = "cluster_shutdown_duration";
        try {
            if (this.config.containsKey(string, string3)) {
                vMSettings.setClusterShutdownDuration(this.config.getInt(string, string3));
            } else if (!string.equals(string2) && this.config.containsKey(string2, string3)) {
                vMSettings.setClusterShutdownDuration(this.config.getInt(string2, string3));
            }
        }
        catch (ConversionException conversionException) {
            logger.debug((Object)conversionException);
        }
        string3 = "cluster_startup_duration";
        try {
            if (this.config.containsKey(string, string3)) {
                vMSettings.setClusterStartupDuration(this.config.getInt(string, string3));
            } else if (!string.equals(string2) && this.config.containsKey(string2, string3)) {
                vMSettings.setClusterStartupDuration(this.config.getInt(string2, string3));
            }
        }
        catch (ConversionException conversionException) {
            logger.debug((Object)conversionException);
        }
    }

    private void readCVMSettingsFromConfig(VMSettings vMSettings, String string, String string2) {
        String string3 = "cvm_shutdown_duration";
        try {
            if (this.config.containsKey(string, string3)) {
                vMSettings.setCvmShutdownDuration(this.config.getInt(string, string3));
            } else if (!string.equals(string2) && this.config.containsKey(string2, string3)) {
                vMSettings.setCvmShutdownDuration(this.config.getInt(string2, string3));
            }
        }
        catch (ConversionException conversionException) {
            logger.debug((Object)conversionException);
        }
        string3 = "cvm_startup_enable";
        try {
            if (this.config.containsKey(string, string3)) {
                vMSettings.setCvmStartupEnable(this.config.getBoolean(string, string3));
            } else if (!string.equals(string2) && this.config.containsKey(string2, string3)) {
                vMSettings.setCvmStartupEnable(this.config.getBoolean(string2, string3));
            }
        }
        catch (ConversionException conversionException) {
            logger.debug((Object)conversionException);
        }
        string3 = "cvm_startup_duration";
        try {
            if (this.config.containsKey(string, string3)) {
                vMSettings.setCvmStartupDuration(this.config.getInt(string, string3));
            } else if (!string.equals(string2) && this.config.containsKey(string2, string3)) {
                vMSettings.setCvmStartupDuration(this.config.getInt(string2, string3));
            }
        }
        catch (ConversionException conversionException) {
            logger.debug((Object)conversionException);
        }
        string3 = "cvm_connect_timeout";
        try {
            if (this.config.containsKey(string, string3)) {
                vMSettings.setCvmConnectTimeout(this.config.getInt(string, string3));
            } else if (!string.equals(string2) && this.config.containsKey(string2, string3)) {
                vMSettings.setCvmConnectTimeout(this.config.getInt(string2, string3));
            }
        }
        catch (ConversionException conversionException) {
            logger.debug((Object)conversionException);
        }
    }

    private void readNutanixVMSettingsFromConfig(VMSettings vMSettings, String string, String string2) {
        String string3;
        Boolean bl = this.virtualConfigManager.isNutanixAHV();
        Boolean bl2 = this.virtualConfigManager.isNutanixESXi();
        if (bl.booleanValue()) {
            string3 = "uvm_shutdown_duration";
            try {
                if (this.config.containsKey(string, string3)) {
                    vMSettings.setGuestVMVappShutdownDuration(this.config.getInt(string, string3));
                } else if (!string.equals(string2) && this.config.containsKey(string2, string3)) {
                    vMSettings.setGuestVMVappShutdownDuration(this.config.getInt(string2, string3));
                }
            }
            catch (ConversionException conversionException) {
                logger.debug((Object)conversionException);
            }
            string3 = "uvm_startup_enable";
            try {
                if (this.config.containsKey(string, string3)) {
                    vMSettings.setGuestVMVappStartupEnabled(this.config.getBoolean(string, string3));
                } else if (!string.equals(string2) && this.config.containsKey(string2, string3)) {
                    vMSettings.setGuestVMVappStartupEnabled(this.config.getBoolean(string2, string3));
                }
            }
            catch (ConversionException conversionException) {
                logger.debug((Object)conversionException);
            }
            string3 = "uvm_startup_duration";
            try {
                if (this.config.containsKey(string, string3)) {
                    vMSettings.setGuestVMVappStartupDuration(this.config.getInt(string, string3));
                } else if (!string.equals(string2) && this.config.containsKey(string2, string3)) {
                    vMSettings.setGuestVMVappStartupDuration(this.config.getInt(string2, string3));
                }
            }
            catch (ConversionException conversionException) {
                logger.debug((Object)conversionException);
            }
            string3 = "uvm_poweroff_duration";
            try {
                if (this.config.containsKey(string, string3)) {
                    vMSettings.setUvmPoweroffDuration(this.config.getInt(string, string3));
                } else if (!string.equals(string2) && this.config.containsKey(string2, string3)) {
                    vMSettings.setUvmPoweroffDuration(this.config.getInt(string2, string3));
                }
            }
            catch (ConversionException conversionException) {
                logger.debug((Object)conversionException);
            }
            string3 = "uvm_forceoff_duration";
            try {
                if (this.config.containsKey(string, string3)) {
                    vMSettings.setUvmForceoffDuration(this.config.getInt(string, string3));
                } else if (!string.equals(string2) && this.config.containsKey(string2, string3)) {
                    vMSettings.setUvmForceoffDuration(this.config.getInt(string2, string3));
                }
            }
            catch (ConversionException conversionException) {
                logger.debug((Object)conversionException);
            }
        }
        string3 = "afs_shutdown_enable";
        try {
            if (this.config.containsKey(string, string3)) {
                vMSettings.setAfsShutdownEnable(this.config.getBoolean(string, string3));
            } else if (!string.equals(string2) && this.config.containsKey(string2, string3)) {
                vMSettings.setAfsShutdownEnable(this.config.getBoolean(string2, string3));
            }
        }
        catch (ConversionException conversionException) {
            logger.debug((Object)conversionException);
        }
        string3 = "afs_shutdown_duration";
        try {
            if (this.config.containsKey(string, string3)) {
                vMSettings.setAfsShutdownDuration(this.config.getInt(string, string3));
            } else if (!string.equals(string2) && this.config.containsKey(string2, string3)) {
                vMSettings.setAfsShutdownDuration(this.config.getInt(string2, string3));
            }
        }
        catch (ConversionException conversionException) {
            logger.debug((Object)conversionException);
        }
        string3 = "afs_startup_enable";
        try {
            if (this.config.containsKey(string, string3)) {
                vMSettings.setAfsStartupEnable(this.config.getBoolean(string, string3));
            } else if (!string.equals(string2) && this.config.containsKey(string2, string3)) {
                vMSettings.setAfsStartupEnable(this.config.getBoolean(string2, string3));
            }
        }
        catch (ConversionException conversionException) {
            logger.debug((Object)conversionException);
        }
        string3 = "afs_startup_duration";
        try {
            if (this.config.containsKey(string, string3)) {
                vMSettings.setAfsStartupDuration(this.config.getInt(string, string3));
            } else if (!string.equals(string2) && this.config.containsKey(string2, string3)) {
                vMSettings.setAfsStartupDuration(this.config.getInt(string2, string3));
            }
        }
        catch (ConversionException conversionException) {
            logger.debug((Object)conversionException);
        }
        string3 = "ongoing_replication_abort_delay_enable";
        try {
            if (this.config.containsKey(string, string3)) {
                vMSettings.setOngoingReplicationAbortDelayEnable(this.config.getBoolean(string, string3));
            } else if (!string.equals(string2) && this.config.containsKey(string2, string3)) {
                vMSettings.setOngoingReplicationAbortDelayEnable(this.config.getBoolean(string2, string3));
            }
        }
        catch (ConversionException conversionException) {
            logger.debug((Object)conversionException);
        }
        string3 = "ongoing_replication_abort_delay_duration";
        try {
            if (this.config.containsKey(string, string3)) {
                vMSettings.setOngoingReplicationAbortDelayDuration(this.config.getInt(string, string3));
            } else if (!string.equals(string2) && this.config.containsKey(string2, string3)) {
                vMSettings.setOngoingReplicationAbortDelayDuration(this.config.getInt(string2, string3));
            }
        }
        catch (ConversionException conversionException) {
            logger.debug((Object)conversionException);
        }
        string3 = "ongoing_replication_abort_command_duration";
        try {
            if (this.config.containsKey(string, string3)) {
                vMSettings.setOngoingReplicationAbortCommandDuration(this.config.getInt(string, string3));
            } else if (!string.equals(string2) && this.config.containsKey(string2, string3)) {
                vMSettings.setOngoingReplicationAbortCommandDuration(this.config.getInt(string2, string3));
            }
        }
        catch (ConversionException conversionException) {
            logger.debug((Object)conversionException);
        }
        if (bl2.booleanValue()) {
            string3 = "metro_availability_disable";
            try {
                if (this.config.containsKey(string, string3)) {
                    vMSettings.setMetroAvailDisabled(this.config.getBoolean(string, string3));
                } else if (!string.equals(string2) && this.config.containsKey(string2, string3)) {
                    vMSettings.setMetroAvailDisabled(this.config.getBoolean(string2, string3));
                }
            }
            catch (ConversionException conversionException) {
                logger.debug((Object)conversionException);
            }
            string3 = "metro_availability_re-enable";
            try {
                if (this.config.containsKey(string, string3)) {
                    vMSettings.setMetroAvailReEnabled(this.config.getBoolean(string, string3));
                } else if (!string.equals(string2) && this.config.containsKey(string2, string3)) {
                    vMSettings.setMetroAvailReEnabled(this.config.getBoolean(string2, string3));
                }
            }
            catch (ConversionException conversionException) {
                logger.debug((Object)conversionException);
            }
        }
    }

    private void readESXiVMSettingsFromConfig(VMSettings vMSettings, String string) {
        this.readAutoStartDelayFromConfig(vMSettings, string);
    }

    private void readAutoStartDelayFromConfig(VMSettings vMSettings, String string) {
        IntRangeSetValidator intRangeSetValidator = new IntRangeSetValidator(0);
        intRangeSetValidator.add(0, 172800);
        String string2 = "autostart_delay";
        try {
            if (this.config.containsKey(string, string2)) {
                vMSettings.setAutostartDelay(this.config.getInt(string, string2, intRangeSetValidator));
            }
        }
        catch (ConversionException conversionException) {
            logger.debug((Object)conversionException);
        }
    }

    public int getAutostartDelay() {
        IntRangeSetValidator intRangeSetValidator = new IntRangeSetValidator(0);
        intRangeSetValidator.add(0, 172800);
        int n = 0;
        try {
            if (this.config.containsKey("HostConfigSettings", "autostart_delay")) {
                n = this.config.getInt("HostConfigSettings", "autostart_delay", intRangeSetValidator);
            } else {
                this.config.setProperty("HostConfigSettings", "autostart_delay", 0);
            }
        }
        catch (IllegalArgumentException | ConversionException throwable) {
            logger.warn("getAutostartDelay() - Unexpected exception: {}", throwable);
        }
        logger.debug("getAutostartDelay() - VM Auto-start Policy delay read from INI as: {}", (Object)n);
        return n;
    }

    private void readVxRailVMSettingsFromConfig(VMSettings vMSettings, String string) {
        this.vxRailUtils.getShutdownDuration(vMSettings, string);
        this.vxRailUtils.getShutdownDelay(vMSettings, string);
        this.vxRailUtils.getRetryLimit(vMSettings, string);
        this.vxRailUtils.getNetworkTimeout(vMSettings, string);
        this.vxRailUtils.getRetryInterval(vMSettings, string);
    }

    private void readSimplivityVMSettingsFromConfig(VMSettings vMSettings, String string, String string2) {
        this.readOvcShutdownDurationFromConfig(vMSettings, string, string2);
        this.readOvcStartupEnableFromConfig(vMSettings, string, string2);
        this.readOvcStartupDurationFromConfig(vMSettings, string, string2);
        this.readOvcConnectTimeoutFromConfig(vMSettings, string, string2);
    }

    private void readOvcConnectTimeoutFromConfig(VMSettings vMSettings, String string, String string2) {
        String string3 = "ovc_connect_timeout";
        try {
            if (this.config.containsKey(string, string3)) {
                vMSettings.setOvcConnectTimeout(this.config.getInt(string, string3));
            } else if (!string.equals(string2) && this.config.containsKey(string2, string3)) {
                vMSettings.setOvcConnectTimeout(this.config.getInt(string2, string3));
            }
        }
        catch (ConversionException conversionException) {
            logger.debug((Object)conversionException);
        }
    }

    private void readOvcStartupDurationFromConfig(VMSettings vMSettings, String string, String string2) {
        String string3 = "ovc_startup_duration";
        try {
            if (this.config.containsKey(string, string3)) {
                vMSettings.setOvcStartupDuration(this.config.getInt(string, string3));
            } else if (!string.equals(string2) && this.config.containsKey(string2, string3)) {
                vMSettings.setOvcStartupDuration(this.config.getInt(string2, string3));
            }
        }
        catch (ConversionException conversionException) {
            logger.debug((Object)conversionException);
        }
    }

    private void readOvcStartupEnableFromConfig(VMSettings vMSettings, String string, String string2) {
        String string3 = "ovc_startup_enable";
        try {
            if (this.config.containsKey(string, string3)) {
                vMSettings.setOvcStartupEnable(this.config.getBoolean(string, string3));
            } else if (!string.equals(string2) && this.config.containsKey(string2, string3)) {
                vMSettings.setOvcStartupEnable(this.config.getBoolean(string2, string3));
            }
        }
        catch (ConversionException conversionException) {
            logger.debug((Object)conversionException);
        }
    }

    private void readOvcShutdownDurationFromConfig(VMSettings vMSettings, String string, String string2) {
        String string3 = "ovc_shutdown_duration";
        try {
            if (this.config.containsKey(string, string3)) {
                vMSettings.setOvcShutdownDuration(this.config.getInt(string, string3));
            } else if (!string.equals(string2) && this.config.containsKey(string2, string3)) {
                vMSettings.setOvcShutdownDuration(this.config.getInt(string2, string3));
            }
        }
        catch (ConversionException conversionException) {
            logger.debug((Object)conversionException);
        }
    }

    public List<String> readMigrationTargetHostsFromConfig(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = null;
        try {
            string2 = this.config.getString(string, "custom_target_hosts");
        }
        catch (ConversionException conversionException) {
            logger.debug((Object)conversionException);
        }
        if (string2 != null && !(string2 = string2.trim()).isEmpty()) {
            String[] stringArray;
            for (String string3 : stringArray = string2.split(HOST_DELIMITER_ESCAPED)) {
                arrayList.add(string3);
            }
        }
        return arrayList;
    }

    public void saveVMSettingsToConfig(VMSettings vMSettings, boolean bl) {
        logger.debug("saveVMSettingsToConfig() - start");
        this.saveVMSettingsToConfig(vMSettings, null);
        boolean bl2 = this.virtualConfigManager.isNutanixAHV();
        boolean bl3 = this.virtualConfigManager.isManagedHost();
        boolean bl4 = this.advancedSetupHelper.isAdvancedShutdownMode();
        if ((bl3 || bl2) && bl4 && bl) {
            for (String string : this.config.getSections()) {
                if (!string.startsWith("advanced_ups_setup_")) continue;
                String string2 = null;
                try {
                    string2 = this.config.getString(string, "setup_name");
                }
                catch (ConversionException conversionException) {
                    logger.debug((Object)conversionException);
                    continue;
                }
                if (!this.config.containsKey(string, "hostlist") && !this.config.containsKey(string, "enable_guest_vm_vapp_shutdown")) continue;
                try {
                    if (vMSettings.isGuestVMMigrationEnabled()) {
                        vMSettings.setGuestVMMigrationTargetEnabled(this.config.getBoolean(string, "enable_custom_target_vm_migration"));
                    }
                    vMSettings.setMigrationTargetHosts(this.readMigrationTargetHostsFromConfig(string));
                }
                catch (NoSuchElementException | ConversionException throwable) {
                    logger.debug((Object)throwable);
                }
                this.saveVMSettingsToConfig(vMSettings, string2);
            }
        }
        if ((bl3 || bl2) && bl4) {
            this.config.setProperty("HostConfigSettings", "apply_vm_settings_to_all_nmcs", String.valueOf(bl));
            this.config.clearProperty("HostConfigSettings", "hostlist");
        } else {
            this.config.clearProperty("HostConfigSettings", "apply_vm_settings_to_all_nmcs");
        }
    }

    public void saveVMSettingsToConfig(VMSettings vMSettings, String string) {
        boolean bl;
        String string2 = "HostConfigSettings";
        boolean bl2 = false;
        bl2 = this.config.isAutoSave();
        this.config.setAutoSave(false);
        if (string != null && (string2 = this.getNMCSection(string)) == null) {
            logger.error("Could not store VM Settings - Advanced Setup Section is missing in configuration");
            return;
        }
        if (this.vmPrioritizationUtils.isVMPrioritizationEnabled()) {
            vMSettings.setGuestVMMigrationDuration(this.vmPrioritizationUtils.readVMPrioritizationDurationsFromConfig(VMOperations.MIGRATION).getTotalDuration());
            vMSettings.setGuestVMVappShutdownDuration(this.vmPrioritizationUtils.readVMPrioritizationDurationsFromConfig(VMOperations.SHUTDOWN).getTotalDuration());
            vMSettings.setGuestVMVappStartupDuration(this.vmPrioritizationUtils.readVMPrioritizationDurationsFromConfig(VMOperations.STARTUP).getTotalDuration());
        }
        boolean bl3 = this.virtualConfigManager.isManagedHost();
        boolean bl4 = this.advancedSetupHelper.isAdvancedShutdownMode();
        boolean bl5 = this.virtualConfigManager.isHyperV();
        if (!bl3 && bl5) {
            this.config.setProperty(string2, "enable_hvstopcluster", vMSettings.isHVStopClusterEnabled());
            this.config.setProperty(string2, "hvstopcluster_duration", vMSettings.getHVStopClusterDuration());
            this.config.setProperty(string2, "hvstartcluster_duration", vMSettings.getHVStartClusterDuration());
        }
        if (bl3 && !bl5 || !bl3 && bl5) {
            this.config.setProperty(string2, "enable_guest_vm_migration", vMSettings.isGuestVMMigrationEnabled());
            this.config.setProperty(string2, "guest_vm_migration_duration", vMSettings.getGuestVMMigrationDuration());
            if (!(bl3 && bl4 && string2.equals("HostConfigSettings"))) {
                this.config.setProperty(string2, "enable_custom_target_vm_migration", vMSettings.isGuestVMMigrationTargetEnabled());
                this.saveTargetHostSelectionToConfig(vMSettings.getMigrationTargetHosts(), string2, "custom_target_hosts");
            } else {
                this.config.clearProperty(string2, "enable_custom_target_vm_migration");
                this.config.clearProperty(string2, "custom_target_hosts");
            }
        } else {
            this.config.clearProperty(string2, "enable_guest_vm_migration");
            this.config.clearProperty(string2, "guest_vm_migration_duration");
            this.config.clearProperty(string2, "enable_custom_target_vm_migration");
            this.config.clearProperty(string2, "custom_target_hosts");
        }
        boolean bl6 = bl = bl3 && bl5;
        if (!bl && !this.virtualConfigManager.isNutanixAHV()) {
            this.config.setProperty(string2, "enable_guest_vm_vapp_shutdown", vMSettings.isGuestVMVAppShutdownEnabled());
            this.config.setProperty(string2, "guest_vm_vapp_shutdown_duration", vMSettings.getGuestVMVappShutdownDuration());
            this.config.setProperty(string2, "enable_guest_vm_vapp_startup", vMSettings.isGuestVMVappStartupEnabled());
            this.config.setProperty(string2, "guest_vm_vapp_startup_duration", vMSettings.getGuestVMVappStartupDuration());
            this.config.setProperty(string2, "vm_startup_delay_duration", vMSettings.getBetweenVmStartupDelay());
        } else {
            this.config.clearProperty(string2, "enable_guest_vm_vapp_shutdown");
            this.config.clearProperty(string2, "guest_vm_vapp_shutdown_duration");
            this.config.clearProperty(string2, "enable_guest_vm_vapp_startup");
            this.config.clearProperty(string2, "guest_vm_vapp_startup_duration");
            this.config.clearProperty(string2, "vm_startup_delay_duration");
        }
        if (this.virtualConfigManager.isSimplivity()) {
            this.saveSimplivitySettingsToConfig(vMSettings, string2);
        } else {
            this.removeSimplivitySettingsFromConfig(string2);
            this.config.clearSection("SimplivityClusterDetails");
        }
        if (this.virtualConfigManager.isNutanixAHV()) {
            this.saveNutanixAHVVMSettingsToConfig(vMSettings, string2);
        } else {
            this.removeNutanixAHVVMSettingsFromConfig(string2);
        }
        if (this.virtualConfigManager.isVxRail()) {
            this.saveVxRailSettingsToConfig(vMSettings, "VxRailClusterDetails");
        } else {
            this.config.clearSection("VxRailClusterDetails");
        }
        if (this.virtualConfigManager.isESXi() && bl3) {
            this.config.setProperty(string2, "force_VApp_shutdown", vMSettings.isForcevAppShutdownEnabled());
            this.config.setProperty(string2, "vm_startup_delay_duration", vMSettings.getBetweenVmStartupDelay());
            this.config.setProperty("HostConfigSettings", "Skip_Maintenance_Mode", vMSettings.isSkipMaintenanceModeEnabled());
            this.config.setProperty(string2, "delay_maintenance_mode", vMSettings.isHostMaintenanceModeDelayed());
            this.config.setProperty(string2, "delay_maintenance_mode_timeout", vMSettings.getHostMaintenanceModeTimeout());
            this.config.setProperty(string2, "enable_vCLS_duration", vMSettings.getEnableVClsDelay());
            this.config.setProperty(string2, "disable_ha_on_shutdown", vMSettings.isDisableHAMode());
            this.config.setProperty(string2, "disable_ha_delay", vMSettings.getDisableHADelay());
            this.config.setProperty(string2, "enable_ha_delay", vMSettings.getEnableHADelay());
            this.config.setProperty(string2, "vsan_prepare", vMSettings.getVsanPrepareDuration());
            this.config.setProperty(string2, "vsan_recovery", vMSettings.getVsanRecoveryDuration());
            this.config.setProperty(string2, "disable_vCLS_duration", vMSettings.getDisableVClsDelay());
            this.config.setProperty(string2, "autostart_delay", vMSettings.getAutostartDelay());
            this.virtualConfigManager.setDefaultHostRescanAllHbaDuration();
            if (this.vsanUtils.isVsanCluster()) {
                this.savevSanSettingsToConfig(vMSettings, string2);
                if (!this.advancedSetupHelper.isAdvancedShutdownMode()) {
                    this.removeAdvancedvSanSettingsFromConfig(string2);
                }
            } else {
                this.removeAllvSanSettingsFromConfig(string2);
            }
            if (string == null) {
                if (this.hostSystemUtils.isVCenterServerInstalledOnTargetHost()) {
                    this.config.setProperty(string2, "VCSA_shutdown_duration", vMSettings.getvCSAShutdownDuration());
                }
                this.config.setProperty(string2, ConfigurationKeys.ENABLE_PLUGIN, vMSettings.isPluginEnabled());
                this.config.setProperty(string2, ConfigurationKeys.PLUGIN_TYPE, vMSettings.getPluginType());
                this.config.setProperty(string2, "startup_waits_for_all_hosts_online", vMSettings.isStartupWaitForAllHostsOnline());
            }
        } else if (bl) {
            this.config.setProperty(string2, "enable_host_maintenance", vMSettings.getHostMaintenanceEnabled());
            this.config.setProperty(string2, "host_maintenance_duration", vMSettings.getHostMaintenanceDuration());
            this.config.setProperty(string2, "enable_host_shutdown", vMSettings.getHostShutdownEnabled());
            this.config.setProperty(string2, "host_shutdown_duration", vMSettings.getHostShutdownDuration());
        } else if (bl5 && !bl3) {
            this.config.clearProperty(string2, "enable_host_maintenance");
            this.config.clearProperty(string2, "host_maintenance_duration");
            this.config.clearProperty(string2, "enable_host_shutdown");
        } else if (string == null) {
            this.config.clearProperty(string2, "VCSA_shutdown_duration");
            this.config.clearProperty(string2, ConfigurationKeys.ENABLE_PLUGIN);
            this.config.clearProperty(string2, ConfigurationKeys.PLUGIN_EXTENSION_KEY);
            this.config.clearProperty(string2, "startup_waits_for_all_hosts_online");
        }
        if (this.virtualConfigManager.isNutanixESXi()) {
            this.saveNutanixESXiVMSettingsToConfig(vMSettings, string2);
        } else {
            this.removeNutanixESXiVMSettingsFromConfig(string2);
        }
        if (this.virtualConfigManager.isHyperflex() || this.virtualConfigManager.isNutanixESXi() || this.virtualConfigManager.isNutanixAHV()) {
            this.saveClusterSettingsToConfig(vMSettings, string2);
            this.saveCVMSettingsToConfig(vMSettings, string2);
        } else {
            this.removeClusterSettingsFromConfig(string2);
            this.removeCVMSettingsFromConfig(string2);
        }
        if (!this.virtualConfigManager.isHyperflex()) {
            this.config.clearSection("HyperflexClusterDetails");
        }
        if (bl2) {
            this.config.setAutoSave(true);
            this.config.save();
        }
    }

    private void saveNutanixAHVVMSettingsToConfig(VMSettings vMSettings, String string) {
        this.config.setProperty(string, "uvm_shutdown_duration", vMSettings.getGuestVMVappShutdownDuration());
        this.config.setProperty(string, "uvm_startup_enable", vMSettings.isGuestVMVappStartupEnabled());
        this.config.setProperty(string, "uvm_startup_duration", vMSettings.getGuestVMVappStartupDuration());
        if (!this.config.containsKey(string, "uvm_poweroff_duration")) {
            this.config.setProperty(string, "uvm_poweroff_duration", 15);
        }
        if (!this.config.containsKey(string, "uvm_forceoff_duration")) {
            this.config.setProperty(string, "uvm_forceoff_duration", 15);
        }
        this.saveCommonNutanixSettingsToConfig(vMSettings, string);
    }

    private void saveVxRailSettingsToConfig(VMSettings vMSettings, String string) {
        this.config.setProperty(string, "cluster_shutdown_delay", vMSettings.getVxRailShutdownDelay());
        this.config.setProperty(string, "cluster_shutdown_duration", vMSettings.getVxRailShutdownDuration());
        this.config.setProperty(string, "retry_limit", vMSettings.getVxRailRetryLimit());
        this.config.setProperty(string, "network_timeout", vMSettings.getVxRailNetworkTimeout());
        this.config.setProperty(string, "retry_interval", vMSettings.getVxRailRetryInterval());
    }

    private void saveSimplivitySettingsToConfig(VMSettings vMSettings, String string) {
        this.config.setProperty(string, "ovc_shutdown_duration", vMSettings.getOvcShutdownDuration());
        this.config.setProperty(string, "ovc_startup_enable", vMSettings.isOvcStartupEnable());
        this.config.setProperty(string, "ovc_startup_duration", vMSettings.getOvcStartupDuration());
        if (!this.config.containsKey(string, "ovc_connect_timeout")) {
            this.config.setProperty(string, "ovc_connect_timeout", vMSettings.getOvcConnectTimeout());
        }
    }

    private void removeSimplivitySettingsFromConfig(String string) {
        this.config.clearProperty(string, "ovc_shutdown_duration");
        this.config.clearProperty(string, "ovc_startup_enable");
        this.config.clearProperty(string, "ovc_startup_duration");
        this.config.clearProperty(string, "ovc_connect_timeout");
    }

    private void saveNutanixESXiVMSettingsToConfig(VMSettings vMSettings, String string) {
        this.saveCommonNutanixSettingsToConfig(vMSettings, string);
        this.config.setProperty(string, "metro_availability_disable", vMSettings.isMetroAvailDisabled());
        this.config.setProperty(string, "metro_availability_re-enable", vMSettings.isMetroAvailReEnabled());
        if (!this.config.containsKey(string, "metro_availability_re-enable")) {
            this.config.setProperty(string, "metro_availability_re-enable", true);
        }
    }

    private void saveCVMSettingsToConfig(VMSettings vMSettings, String string) {
        this.config.setProperty(string, "cvm_shutdown_duration", vMSettings.getCvmShutdownDuration());
        this.config.setProperty(string, "cvm_startup_enable", vMSettings.isCvmStartupEnable());
        this.config.setProperty(string, "cvm_startup_duration", vMSettings.getCvmStartupDuration());
        if (!this.config.containsKey(string, "cvm_connect_timeout")) {
            this.config.setProperty(string, "cvm_connect_timeout", 10);
        }
    }

    private void saveClusterSettingsToConfig(VMSettings vMSettings, String string) {
        this.config.setProperty(string, "cluster_shutdown_duration", vMSettings.getClusterShutdownDuration());
        this.config.setProperty(string, "cluster_startup_duration", vMSettings.getClusterStartupDuration());
    }

    private void saveCommonNutanixSettingsToConfig(VMSettings vMSettings, String string) {
        this.config.setProperty(string, "afs_shutdown_enable", vMSettings.isAfsShutdownEnable());
        this.config.setProperty(string, "afs_shutdown_duration", vMSettings.getAfsShutdownDuration());
        this.config.setProperty(string, "afs_startup_enable", vMSettings.isAfsStartupEnable());
        this.config.setProperty(string, "afs_startup_duration", vMSettings.getAfsStartupDuration());
        this.config.setProperty(string, "ongoing_replication_abort_delay_enable", vMSettings.isOngoingReplicationAbortDelayEnable());
        this.config.setProperty(string, "ongoing_replication_abort_delay_duration", vMSettings.getOngoingReplicationAbortDelayDuration());
        this.config.setProperty(string, "ongoing_replication_abort_command_duration", vMSettings.getOngoingReplicationAbortCommandDuration());
    }

    private void removeNutanixAHVVMSettingsFromConfig(String string) {
        this.config.clearProperty(string, "uvm_shutdown_duration");
        this.config.clearProperty(string, "uvm_startup_enable");
        this.config.clearProperty(string, "uvm_startup_duration");
        this.config.clearProperty(string, "uvm_poweroff_duration");
        this.config.clearProperty(string, "uvm_forceoff_duration");
        if (!this.virtualConfigManager.isNutanixESXi()) {
            this.removeCommonNutanixVMSettingsFromConfig(string);
        }
    }

    private void removeNutanixESXiVMSettingsFromConfig(String string) {
        if (!this.virtualConfigManager.isNutanixAHV()) {
            this.removeCommonNutanixVMSettingsFromConfig(string);
        }
        this.config.clearProperty(string, "metro_availability_disable");
        this.config.clearProperty(string, "metro_availability_re-enable");
    }

    private void removeCVMSettingsFromConfig(String string) {
        this.config.clearProperty(string, "cvm_shutdown_duration");
        this.config.clearProperty(string, "cvm_startup_enable");
        this.config.clearProperty(string, "cvm_startup_duration");
        this.config.clearProperty(string, "cvm_connect_timeout");
    }

    private void removeClusterSettingsFromConfig(String string) {
        this.config.clearProperty(string, "cluster_shutdown_duration");
        this.config.clearProperty(string, "cluster_startup_duration");
    }

    private void removeCommonNutanixVMSettingsFromConfig(String string) {
        this.config.clearProperty(string, "afs_shutdown_enable");
        this.config.clearProperty(string, "afs_shutdown_duration");
        this.config.clearProperty(string, "afs_startup_enable");
        this.config.clearProperty(string, "afs_startup_duration");
        this.config.clearProperty(string, "ongoing_replication_abort_delay_enable");
        this.config.clearProperty(string, "ongoing_replication_abort_delay_duration");
        this.config.clearProperty(string, "ongoing_replication_abort_command_duration");
        this.config.clearSection("NutanixClusterDetails");
    }

    public void savevSanSettingsToConfig(VMSettings vMSettings, String string) {
        if (this.advancedSetupHelper.isAdvancedShutdownMode() && StringUtils.equalsIgnoreCase((CharSequence)string, (CharSequence)"HostConfigSettings")) {
            this.config.setProperty(string, "enable_vsan_ftt", vMSettings.isFttEnabled());
            this.config.setProperty(string, "shutdown_all_vsan_vms", vMSettings.isShutdownAllClusterVMsEnabled());
            this.config.setProperty(string, "vsan_ftt_level", vMSettings.getFttLevel());
        }
        this.config.setProperty(string, "vsan_sync_timeout", vMSettings.getVsanSyncTimeout());
        this.config.setProperty(string, "vsan_prepare", vMSettings.getVsanPrepareDuration());
        this.config.setProperty(string, "vsan_recovery", vMSettings.getVsanRecoveryDuration());
        this.virtualConfigManager.setDefaultVsanSyncRetryLimit();
        this.virtualConfigManager.setDefaultWitnessVmStartupDuration();
    }

    public void removeAdvancedvSanSettingsFromConfig(String string) {
        this.config.clearProperty(string, "enable_vsan_ftt");
        this.config.clearProperty(string, "shutdown_all_vsan_vms");
        this.config.clearProperty(string, "vsan_ftt_level");
    }

    public void removeAllvSanSettingsFromConfig(String string) {
        this.removeAdvancedvSanSettingsFromConfig(string);
        this.config.clearProperty(string, "vsan_sync_timeout");
        this.config.clearProperty(string, "vsan_sync_retry_limit");
        this.config.clearProperty(string, "witness_vm_startup_duration");
        this.config.clearProperty(string, "vsan_prepare");
        this.config.clearProperty(string, "vsan_recovery");
    }

    public String getNMCSection(String string) {
        String string2 = null;
        if (string != null) {
            for (String string3 : this.config.getSections()) {
                if (!string3.startsWith("advanced_ups_setup_")) continue;
                try {
                    if (!string.equalsIgnoreCase(this.config.getString(string3, "setup_name"))) continue;
                    string2 = string3;
                    break;
                }
                catch (ConversionException conversionException) {
                    logger.debug((Object)conversionException);
                }
            }
        }
        return string2;
    }

    public LinkedHashMap<String, MappedHost> readMappedHostsFromRequest(Map<String, String[]> map) {
        boolean bl = this.advancedSetupHelper.getSingleUPSSetupSetting();
        LinkedHashMap<String, MappedHost> linkedHashMap = new LinkedHashMap<String, MappedHost>();
        String[] stringArray = map.get("mappedHost");
        if (stringArray != null) {
            for (String string : stringArray) {
                String[] stringArray2 = string.split(",");
                if (stringArray2.length < 2) continue;
                MappedHost mappedHost = new MappedHost(stringArray2[0], bl ? null : stringArray2[1], bl ? stringArray2[1] : null);
                if (bl && stringArray2.length == 3) {
                    try {
                        mappedHost.setOutletGroupNumber(Integer.valueOf(stringArray2[2]));
                    }
                    catch (NumberFormatException numberFormatException) {
                        logger.error((Object)numberFormatException);
                        mappedHost.setOutletGroupNumber(null);
                    }
                }
                linkedHashMap.put(mappedHost.getHostIPAddress(), mappedHost);
            }
        }
        return linkedHashMap;
    }

    public List<String> readTargetHostSelectionFromRequest(Map<String, String[]> map) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = map.get("targetHost");
        if (stringArray != null) {
            for (String string : stringArray) {
                arrayList.add(string);
            }
        }
        return arrayList;
    }

    public void saveTargetHostSelectionToConfig(PageContext pageContext) {
        logger.debug("saveTargetHostSelectionToConfig() - start");
        List<String> list = this.readTargetHostSelectionFromRequest(pageContext.getPostQueryValues());
        list = this.vsanUtils.checkVsanConfigurationOfTargetHosts(list);
        this.saveTargetHostSelectionToConfig(list);
    }

    public void saveTargetHostSelectionToConfig(List<String> list) {
        if (this.virtualConfigManager.isManagedESXi()) {
            this.hostSystemUtils.saveDefaultVCSAShutdownDuration(list);
        }
        this.saveTargetHostSelectionToConfig(list, null);
    }

    public void saveTargetHostSelectionToConfig(List<String> list, String string) {
        this.saveTargetHostSelectionToConfig(list, "HostConfigSettings", string);
    }

    public void saveTargetHostSelectionToConfig(List<String> list, String string, String string2) {
        if (list != null) {
            StringBuffer stringBuffer = new StringBuffer();
            for (String string3 : list) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(HOST_DELIMITER);
                }
                stringBuffer.append(string3);
            }
            this.config.setProperty(string, string2 != null ? string2 : "hostlist", stringBuffer.toString());
            if (this.virtualConfigManager.isESXi()) {
                this.hasVCLSBeenDetectedOnTheCluster();
            }
        }
    }

    public static boolean isBroadcastSupported() {
        boolean bl;
        block5: {
            bl = true;
            try {
                String string = System.getProperty("os.name");
                String string2 = System.getProperty("os.version");
                logger.trace("isBroadcastSupported:" + string + " " + string2);
                if (!string.toLowerCase().startsWith("windows")) break block5;
                String[] stringArray = string2.split("\\.");
                logger.trace("isBroadcastSupported:" + stringArray[0]);
                try {
                    int n = Integer.parseInt(stringArray[0]);
                    if (n >= 6) {
                        bl = false;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    logger.debug("Error formatting version:" + stringArray[0]);
                    bl = false;
                }
            }
            catch (Exception exception) {
                logger.error("isBroadcastSupported error:" + exception.getLocalizedMessage());
            }
        }
        logger.trace("isBroadcastSupported:" + bl);
        return bl;
    }

    public static String stripoutHTML(String string) {
        return string.replaceAll(">>", "").replaceAll("<[^>]*>", "");
    }

    public boolean isAdvancedMode() {
        boolean bl = false;
        try {
            bl = this.config.getString("NetworkManagementCard", "mode").equalsIgnoreCase("advanced");
        }
        catch (ConversionException conversionException) {
            logger.debug((Object)conversionException);
        }
        return bl;
    }

    public Integer readUPSConfigurationMode() {
        Integer n = 0;
        try {
            String string = this.config.getString("NetworkManagementCard", "mode");
            if ("single".equalsIgnoreCase(string)) {
                n = 1;
            } else if ("redundant".equalsIgnoreCase(string)) {
                n = 2;
            } else if ("parallel".equalsIgnoreCase(string)) {
                n = 3;
            } else if ("advanced".equalsIgnoreCase(string)) {
                n = 5;
            }
        }
        catch (ConversionException conversionException) {
            logger.debug((Object)conversionException);
        }
        return n;
    }

    public Map<String, List<String>> readUPSGroups() {
        LinkedHashMap<String, List<String>> linkedHashMap = new LinkedHashMap<String, List<String>>();
        int n = 0;
        boolean bl = false;
        do {
            try {
                if (this.config.containsKey("advanced_ups_setup_" + n, "setup_name") && this.config.containsKey("advanced_ups_setup_" + n, "ip_addresses")) {
                    String string = this.config.getString("advanced_ups_setup_" + n, "ip_addresses");
                    String string2 = this.config.getString("advanced_ups_setup_" + n, "setup_name");
                    StringTokenizer stringTokenizer = new StringTokenizer(string, HOST_DELIMITER);
                    ArrayList<String> arrayList = new ArrayList<String>();
                    while (stringTokenizer.hasMoreTokens()) {
                        arrayList.add(stringTokenizer.nextToken());
                    }
                    linkedHashMap.put(string2, arrayList);
                    ++n;
                    continue;
                }
                bl = true;
            }
            catch (ConversionException conversionException) {
                logger.error((Object)conversionException);
            }
        } while (!bl);
        return linkedHashMap;
    }

    public String readNetworkConfig() {
        String string = null;
        if (this.config.containsKey("Networking", "NetworkConfig")) {
            try {
                string = this.config.getString("Networking", "NetworkConfig");
                if (string != null) {
                    if (string.equalsIgnoreCase("IPV4")) {
                        string = Integer.toString(1);
                    } else if (string.equalsIgnoreCase("IPV6")) {
                        string = Integer.toString(2);
                    }
                }
            }
            catch (ConversionException conversionException) {
                logger.error((Object)conversionException);
            }
        }
        return string;
    }

    public void cleanExtraUPSFromConfig(Object object) {
        String[] stringArray;
        boolean bl = false;
        int n = 2;
        if (object instanceof String[] && (stringArray = (String[])object) != null) {
            n = stringArray.length + 1;
        }
        int n2 = n;
        while (!bl) {
            if (this.config.containsKey("NetworkManagementCard", ConfigurationKeys.getNMCAddressKey(n2 - 1))) {
                this.config.clearProperty("NetworkManagementCard", ConfigurationKeys.getNMCAddressKey(n2 - 1));
            } else {
                bl = true;
            }
            if (this.config.containsKey("NetworkManagementCard", ConfigurationKeys.getOutletGroupKey(n2 - 1))) {
                this.config.clearProperty("NetworkManagementCard", ConfigurationKeys.getOutletGroupKey(n2 - 1));
            }
            ++n2;
        }
    }

    public static String getResourceString(ResourceBundleWrapper resourceBundleWrapper, String string) {
        Object object = MISSING_BUNDLE_STRING;
        if (resourceBundleWrapper != null && string != null) {
            try {
                object = resourceBundleWrapper.getResourceBundle().getString(string);
                if (logkeys == null) {
                    File file = new File("logkeys");
                    logkeys = file.exists();
                }
                if (logkeys.booleanValue() && (string.endsWith(".Log") || string.contains("FlexEvent") || string.contains("RegStatus") || resourceBundleWrapper.getName().contains("StdPowerSource") || resourceBundleWrapper.getName().contains("RunTimeVerifier") || resourceBundleWrapper.getName().contains("ShutdownFormatters"))) {
                    object = (String)object + "(" + string + ")";
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                logkeys = false;
            }
            catch (MissingResourceException missingResourceException) {
                logger.error("missing resource " + string + ". " + String.valueOf(missingResourceException));
                object = MISSING_RESOURCE_STRING;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return object;
    }

    public static Event formatRunCommandFile(Event event, String string, ObjectId objectId, int n) {
        Event event2 = null;
        RunCommandFileFormatter runCommandFileFormatter = new RunCommandFileFormatter(string, n);
        event2 = event instanceof AdvancedGroupOutletEvent ? new AdvancedGroupOutletEvent(objectId, true, (IFormatter)runCommandFileFormatter, ((AdvancedGroupEvent)event).getGroup(), ((AdvancedGroupEvent)event).getGroupName(), ((AdvancedGroupOutletEvent)event).getOutletNumber(), ((AdvancedGroupOutletEvent)event).getOutletName()) : (event instanceof AdvancedGroupEvent ? new AdvancedGroupEvent(objectId, (IFormatter)runCommandFileFormatter, ((AdvancedGroupEvent)event).getGroup(), ((AdvancedGroupEvent)event).getGroupName()) : new Event(objectId, (IFormatter)runCommandFileFormatter));
        return event2;
    }

    public static String vectorToString(AbstractCollection<String> abstractCollection) {
        String string = null;
        if (abstractCollection != null && abstractCollection.size() > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String string2 : abstractCollection) {
                stringBuilder.append(string2);
                stringBuilder.append(", ");
            }
            string = stringBuilder.toString();
            if (string.length() > 0) {
                string = string.substring(0, string.length() - 2);
            }
        }
        return string;
    }

    public static String getFQDNForLocalHostAddress(String string) {
        logger.debug("getFQDNForLocalHostAddress - start(), hostIP: {}", (Object)string);
        String string2 = "localhost";
        String string3 = null;
        if (string != null) {
            if (string.contains("%")) {
                string = string.substring(0, string.indexOf("%"));
            }
            try {
                string3 = HostNameLookUpTable.getInstance().lookUp(InetAddress.getByName(string));
                logger.debug("getFQDNForLocalHostAddress() - Found FQDN in lookup table: {}", (Object)string3);
            }
            catch (UnknownHostException unknownHostException) {
                logger.error((Object)unknownHostException);
            }
        } else {
            InetAddress inetAddress = IPUtils.getLocalhostAddress();
            if (inetAddress == null) {
                try {
                    inetAddress = InetAddress.getLocalHost();
                }
                catch (UnknownHostException unknownHostException) {
                    logger.error((Object)unknownHostException);
                }
            }
            if (inetAddress != null) {
                string = inetAddress.getHostAddress();
                string3 = HostNameLookUpTable.getInstance().lookUp(inetAddress);
            }
        }
        if (string3 != null && string != null) {
            if (string3.toLowerCase().startsWith("localhost") || string3.toLowerCase().endsWith(".localdomain")) {
                string3 = string;
            }
            string2 = string3;
        }
        logger.debug("getFQDNForLocalHostAddress() - result: {}", (Object)string2);
        return string2;
    }

    public static int compareVersionNumbers(String string, String string2) {
        int n = 0;
        Scanner scanner = new Scanner(string);
        Scanner scanner2 = new Scanner(string2);
        scanner.useDelimiter("\\.");
        scanner2.useDelimiter("\\.");
        while (scanner.hasNextInt() && scanner2.hasNextInt()) {
            int n2;
            int n3 = scanner.nextInt();
            if (n3 < (n2 = scanner2.nextInt())) {
                n = -1;
                break;
            }
            if (n3 <= n2) continue;
            n = 1;
            break;
        }
        if (n == 0) {
            if (scanner.hasNextInt()) {
                n = 1;
            } else if (scanner2.hasNextInt()) {
                n = -1;
            }
        }
        scanner.close();
        scanner2.close();
        return n;
    }

    public static String getRemoteAddress(PageContext pageContext) {
        String string = UNKNOWN;
        if (pageContext.getRequest() != null) {
            string = pageContext.getRequest().getRemoteAddr();
            try {
                InetAddress inetAddress = InetAddress.getByName(string);
                string = inetAddress instanceof Inet4Address ? inetAddress.getHostAddress() : InetAddress.getByName(inetAddress.getHostName()).getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {
                logger.error((Object)unknownHostException);
            }
        }
        return string;
    }

    public static final boolean isSupportedLocale(Locale locale) {
        boolean bl = false;
        if (locale != null) {
            for (Locale locale2 : supportedLocales) {
                if (!locale.getLanguage().equals(locale2.getLanguage())) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public boolean isTurnOffUPSOrOutlet(Event event) {
        Object object;
        if (event instanceof AdvancedGroupEvent) {
            AdvancedGroupEvent advancedGroupEvent = (AdvancedGroupEvent)event;
            object = "advanced_ups_setup_" + advancedGroupEvent.getGroup();
        } else {
            object = "Shutdown";
        }
        boolean bl = false;
        boolean bl2 = false;
        try {
            bl = this.config.getBoolean((String)object, "turnOffUps");
            bl2 = this.config.getBoolean((String)object, "turnOffSOG");
        }
        catch (NoSuchElementException noSuchElementException) {
            logger.error("NoSuchElementException: " + noSuchElementException.getMessage());
        }
        catch (ConversionException conversionException) {
            logger.error("ConversionException: " + conversionException.getMessage());
        }
        return bl || bl2;
    }

    public static String formatDatatablesCount(String string) {
        Object[] objectArray = new Object[]{DATATABLES_START, DATATABLES_END, DATATABLES_TOTAL};
        return MessageFormat.format(string, objectArray);
    }

    public static final ResourceBundleWrapper getWebServerResourceBundle(Locale locale) {
        return Utils.getUTF8ResourceBundle(WEBSERVER_I18N_RESOURCE, locale);
    }

    public static final ResourceBundleWrapper getUTF8ResourceBundle(String string, Locale locale) {
        ResourceBundleWrapper resourceBundleWrapper = null;
        if (string != null && locale != null) {
            try {
                resourceBundleWrapper = UTF8ResourceBundle.getBundle(string, locale);
            }
            catch (IllegalArgumentException | MissingResourceException runtimeException) {
                logger.error((Object)runtimeException);
            }
        }
        return resourceBundleWrapper;
    }

    public ArrayList<String> getTls1SupportOs() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = null;
        try {
            if (this.config.containsKey("Networking", "tls1_support_os")) {
                logger.debug("getTls1SupportOs() - found key: {}", (Object)"tls1_support_os");
                string = this.config.getString("Networking", "tls1_support_os");
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            logger.error("getTls1SupportOs() - NoSuchElementException: ", (Throwable)noSuchElementException);
        }
        catch (ConversionException conversionException) {
            logger.error("getTls1SupportOs() - ConversionException: ", (Throwable)conversionException);
        }
        if (string != null) {
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(string, HOST_DELIMITER);
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    arrayList.add(string2);
                    logger.debug("getTls1SupportOs() - added: {} to list", (Object)string2);
                }
            }
            catch (Exception exception) {
                logger.debug("getTls1SupportOs() - Exception: {} while parsing osNames: {}", (Object)exception.getLocalizedMessage(), (Object)string);
            }
        }
        return arrayList;
    }

    public boolean isTls1SupportRequired(String[] stringArray) {
        String string = System.getProperty("os.name");
        logger.debug("isTls1SupportRequired() - start, osNames: {}, os_name: {}", (Object)stringArray, (Object)string);
        for (String string2 : stringArray) {
            if (!string2.equalsIgnoreCase(string)) continue;
            logger.debug("isTls1SupportRequired() - found: {}, older TLS 1.0/1.1 support required", (Object)string2);
            return true;
        }
        for (String string3 : this.getTls1SupportOs()) {
            if (!string3.equalsIgnoreCase(string)) continue;
            logger.debug("isTls1SupportRequired() - found: {}, TLS 1.0/1.1 support required", (Object)string3);
            return true;
        }
        logger.debug("isTls1SupportRequired() - TLS 1.0/1.1 support not required");
        return false;
    }

    public boolean isJapanese() {
        return true;
    }

    public boolean hasVCLSBeenDetectedOnTheCluster() {
        return this.clusterUtils.hasVCLSBeenDetectedOnTheCluster();
    }

    @Generated
    public void setVsanUtils(VsanUtils vsanUtils) {
        this.vsanUtils = vsanUtils;
    }

    @Generated
    public void setAdvancedSetupHelper(AdvancedSetupHelper advancedSetupHelper) {
        this.advancedSetupHelper = advancedSetupHelper;
    }

    @Generated
    public void setConfig(ConfigurationManager configurationManager) {
        this.config = configurationManager;
    }

    @Generated
    public void setVirtualConfigManager(VirtualConfigurationManager virtualConfigurationManager) {
        this.virtualConfigManager = virtualConfigurationManager;
    }

    @Generated
    public void setVmPrioritizationUtils(VMPrioritizationUtils vMPrioritizationUtils) {
        this.vmPrioritizationUtils = vMPrioritizationUtils;
    }

    @Generated
    public void setHostSystemUtils(HostSystemUtils hostSystemUtils) {
        this.hostSystemUtils = hostSystemUtils;
    }

    @Generated
    public void setVxRailUtils(VxRailUtils vxRailUtils) {
        this.vxRailUtils = vxRailUtils;
    }

    @Generated
    public void setClusterUtils(ClusterUtils clusterUtils) {
        this.clusterUtils = clusterUtils;
    }
}

