/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.util;

import com.apcc.m11.components.webserver.html.Container;
import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.html.Text;
import com.apcc.m11.components.webserver.html.list.ListItem;
import com.apcc.m11.components.webserver.html.list.UnOrderedList;
import com.apcc.m11.components.webserver.html.util.Anchor;
import com.apcc.m11.components.webserver.model.Cluster;
import com.apcc.m11.components.webserver.model.Datacenter;
import com.apcc.m11.components.webserver.model.PrioritizedVM;
import com.apcc.m11.components.webserver.model.PrioritizedVMLists;
import com.apcc.m11.components.webserver.model.VM;
import com.apcc.m11.components.webserver.model.VMPriority;
import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.m11.components.webserver.util.virtualization.VMPrioritizationUtils;
import com.apcc.pcns.SpringContextUtil;
import com.apcc.pcns.configservice.VirtualConfigurationManager;
import com.apcc.pcns.util.ResourceBundleWrapper;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VMPriorityTreeHelper {
    private static final Logger logger = LogManager.getLogger(VMPriorityTreeHelper.class);
    public static final String ATTR_REL = "rel";
    protected static final String REF_VM = "vm";
    protected static final String REF_VCSA = "vcsa";
    protected static final String REF_VAPP = "vapp";
    protected static final String REF_PRIORITY = "priority";
    protected static final String REF_PRIORITY_HIGH = "priority-high";
    protected static final String REF_PRIORITY_MEDIUM = "priority-medium";
    protected static final String REF_PRIORITY_LOW = "priority-low";
    protected static final String REF_PRIORITY_GROUP_1 = "priority-group1";
    protected static final String REF_PRIORITY_GROUP_2 = "priority-group2";
    private static final String REF_CLUSTER = "cluster";
    private static final String REF_DATACENTER = "datacenter";
    private static final String REF_CLUSTER_DISABLED = "cluster-disabled";
    private static final String REF_DATACENTER_DISABLED = "datacenter-disabled";
    private static final String REF_MAPPED = "mapped";
    private static final String REF_DISABLED = "disabled";
    private static final String REF_DATACENTER_MAPPED = "datacenter mapped";
    private static final String REF_CLUSTER_MAPPED = "cluster mapped";
    private static final String REF_VM_NAME = "vmname";
    private static final String PARAM_VM_LIST_HIGH = "vmhigh";
    private static final String PARAM_VM_LIST_MEDIUM = "vmmedium";
    private static final String PARAM_VM_LIST_LOW_0 = "vmlow";
    private static final String PARAM_VM_LIST_LOW_1 = "vmgroup1";
    private static final String PARAM_VM_LIST_LOW_2 = "vmgroup2";
    public static final String CLUSTER_NAME_KEY = "VMPrioritization.DefaultClusterName";
    private List<PrioritizedVM> inventoryVMList = null;
    private SpringContextUtil springContextUtil;
    private VirtualConfigurationManager virtualConfigurationManager;
    private VMPrioritizationUtils vmPrioritizationUtils;
    private static Instant created;

    private VMPriorityTreeHelper() {
    }

    private String getDefaultClusterName(Locale locale) {
        ResourceBundleWrapper resourceBundleWrapper = Utils.getWebServerResourceBundle(locale);
        return resourceBundleWrapper.getResourceBundle().getString(CLUSTER_NAME_KEY);
    }

    public synchronized void refreshCache(Locale locale) {
        logger.debug("refreshCache() - start");
        if (this.inventoryVMList == null || created.until(Instant.now(), ChronoUnit.SECONDS) > 20L) {
            logger.debug("refreshCache() - refreshing the inventory");
            this.refreshInventoryList(locale);
            created = Instant.now();
        } else {
            logger.debug("refreshCache() - retaining the cached inventory");
        }
        logger.debug("refreshCache() - end");
    }

    private synchronized void refreshInventoryList(Locale locale) {
        List<PrioritizedVM> list = null;
        if (this.virtualConfigurationManager.isESXi()) {
            logger.debug("refreshInventoryList() - Reading VM inventory list from VCenter...");
            list = this.springContextUtil.getHostSystemUtils().getPrioritizationVMs();
            logger.debug("refreshInventoryList() - Filtering special VMs from inventory list...");
            list = this.filterOutSpecialHCIVMs(list);
        }
        if (this.virtualConfigurationManager.isNutanixAHV()) {
            logger.debug("refreshInventoryList() - Reading VM inventory from Nutanix cluster...");
            list = this.springContextUtil.getNutanixUtils().getPrioritizationVMs(this.getDefaultClusterName(locale));
        }
        if (this.virtualConfigurationManager.isUnmanagedHyperV()) {
            logger.debug("refreshInventoryList() - Reading VM inventory from Hyper-V ...");
            list = this.springContextUtil.getHyperVUtils().getPrioritizationVMs();
        }
        if (list == null) {
            logger.debug("refreshInventoryList() - VM inventory list is null");
        } else {
            logger.debug("refreshInventoryList() - VM Inventory now contains {} items", (Object)list.size());
            this.inventoryVMList = list;
        }
    }

    public List<PrioritizedVM> filterOutSpecialHCIVMs(@NonNull List<PrioritizedVM> list) {
        if (list == null) {
            throw new IllegalArgumentException("anInventoryVMList is marked non-null but is null");
        }
        List<PrioritizedVM> list2 = list;
        if (this.virtualConfigurationManager.isESXi()) {
            if (this.virtualConfigurationManager.isNutanixESXi()) {
                logger.debug("filterOutSpecialHCIVMs() - Filtering Nutanix Special VMs...");
                list2 = this.springContextUtil.getNutanixUtils().filterOutNutanixSpecialFromPrioritizedVMs(list);
            }
            if (this.virtualConfigurationManager.isSimplivity()) {
                logger.debug("filterOutSpecialHCIVMs() - Filtering Simplivity Special VMs...");
                list2 = this.springContextUtil.getSimplivityUtils().filterOVCsFromPrioritizedVMList(list);
            }
            if (this.virtualConfigurationManager.isHyperflex()) {
                logger.debug("filterOutSpecialHCIVMs() - Filtering Hyperflex Special VMs...");
                list2 = this.springContextUtil.getHyperflexUtils().filterOutHyperflexSpecialFromPrioritizedVMs(list);
            }
            if (this.virtualConfigurationManager.isVxRail()) {
                logger.debug("filterOutSpecialHCIVMs() - Filtering VxRail Special VMs...");
                list2 = this.springContextUtil.getVxRailUtils().filterOutVxRailSpecialVmFromPrioritizedVMs(list);
            }
            if (this.virtualConfigurationManager.isManagedESXi() && list2 != null) {
                logger.debug("filterOutSpecialHCIVMs() - Filtering vCLS VMs...");
                list2 = this.springContextUtil.getVirtualMachineUtils().filterOutVCLSVmsFromPrioritizedVMList(list2);
            }
        } else if (this.virtualConfigurationManager.isUnmanagedHyperV()) {
            logger.debug("filterOutSpecialHCIVMs() - Filtering VMs for Hyper-V...");
            list2 = this.springContextUtil.getHyperVUtils().filterOutSpecialVMsFromPrioritizedVMs(list);
        }
        if (list2 == null) {
            logger.debug("filterOutSpecialHCIVMs() - Result set is null, returning an empty list instead...");
            list2 = Collections.emptyList();
        }
        logger.debug("filterOutSpecialHCIVMs() - VM list now contians {} items.", (Object)list2.size());
        return list2;
    }

    public synchronized boolean hasInventoryList() {
        boolean bl = this.inventoryVMList != null;
        logger.debug("hasInventoryList() - Inventory list set: {}", (Object)bl);
        return bl;
    }

    public synchronized int getInventoryVMListSize() {
        int n = this.inventoryVMList == null ? 0 : this.inventoryVMList.size();
        logger.debug("getInventoryVMListSize() - VM Inventory list has {} items.", (Object)n);
        return n;
    }

    public Container getInventoryTreeHTML() {
        logger.trace("getInventoryTreeHTML() called");
        return this.getInventoryTreeHTML(this.vmPrioritizationUtils.readPrioritizedVMListsFromConfig());
    }

    private synchronized Container getInventoryTreeHTML(PrioritizedVMLists prioritizedVMLists) {
        List<Datacenter> list;
        String string = "";
        UnOrderedList unOrderedList = new UnOrderedList();
        if (this.inventoryVMList != null && !this.inventoryVMList.isEmpty() && !(list = this.createDatacenterList()).isEmpty()) {
            for (Datacenter datacenter : list) {
                boolean bl = true;
                ListItem listItem = new ListItem();
                Anchor anchor = new Anchor();
                anchor.setHypertextReference("#");
                anchor.add(new Text(datacenter.getName()));
                listItem.add(anchor);
                UnOrderedList unOrderedList2 = new UnOrderedList();
                listItem.add(unOrderedList2);
                unOrderedList.add(listItem);
                bl = this.displayVMs(unOrderedList2, datacenter.getVMList(), prioritizedVMLists);
                if (bl &= this.displayClusters(unOrderedList2, datacenter.getClusterList(), prioritizedVMLists)) {
                    listItem.setAttribute(ATTR_REL, REF_DATACENTER_DISABLED);
                    listItem.setCssClass(REF_DATACENTER_MAPPED);
                    string = REF_DATACENTER_DISABLED;
                } else {
                    listItem.setAttribute(ATTR_REL, REF_DATACENTER);
                    listItem.setCssClass(REF_DATACENTER);
                    string = REF_DATACENTER;
                }
                listItem.setDataJstree(string);
            }
        }
        return unOrderedList;
    }

    private boolean displayClusters(UnOrderedList unOrderedList, List<Cluster> list, PrioritizedVMLists prioritizedVMLists) {
        String string = "";
        boolean bl = true;
        for (Cluster cluster : list) {
            ListItem listItem = new ListItem();
            Anchor anchor = new Anchor();
            anchor.setHypertextReference("#");
            anchor.add(new Text(cluster.getName()));
            listItem.add(anchor);
            UnOrderedList unOrderedList2 = new UnOrderedList();
            listItem.add(unOrderedList2);
            unOrderedList.add(listItem);
            if (this.displayVMs(unOrderedList2, cluster.getVMList(), prioritizedVMLists)) {
                listItem.setAttribute(ATTR_REL, REF_CLUSTER_DISABLED);
                listItem.setCssClass(REF_CLUSTER_MAPPED);
                string = REF_CLUSTER_DISABLED;
            } else {
                bl = false;
                listItem.setAttribute(ATTR_REL, REF_CLUSTER);
                listItem.setCssClass(REF_CLUSTER);
                string = REF_CLUSTER;
            }
            listItem.setDataJstree(string);
        }
        return bl;
    }

    private boolean displayVMs(UnOrderedList unOrderedList, List<VM> list, PrioritizedVMLists prioritizedVMLists) {
        boolean bl = true;
        for (VM vM : list) {
            if (vM.isvSanWitness()) continue;
            ListItem listItem = new ListItem();
            listItem.setAttribute("data-vmname", vM.getVMName());
            boolean bl2 = this.isVMSelected(vM, prioritizedVMLists);
            Object object = REF_VM;
            Object object2 = REF_VM;
            if (vM.isVirtualApp()) {
                object = REF_VAPP;
                object2 = REF_VAPP;
            } else {
                object = vM.isVCSA() ? REF_VCSA : REF_VM;
                Object object3 = object2 = vM.isVCSA() ? REF_VCSA : REF_VM;
            }
            if (!bl2) {
                bl = false;
            } else {
                object = (String)object + "-disabled";
                object2 = (String)object2 + " mapped";
            }
            listItem.setAttribute(ATTR_REL, (String)object);
            listItem.setCssClass((String)object2);
            listItem.setDataJstree((String)object);
            Anchor anchor = new Anchor();
            anchor.setHypertextReference("#");
            anchor.add(new Text(vM.getVMName()));
            listItem.add(anchor);
            unOrderedList.add(listItem);
        }
        return bl;
    }

    private boolean isVMSelected(VM vM, PrioritizedVMLists prioritizedVMLists) {
        for (PrioritizedVM prioritizedVM : prioritizedVMLists.getHighPriorityVMs()) {
            if (!vM.getVMName().equals(prioritizedVM.getVMName())) continue;
            return true;
        }
        for (PrioritizedVM prioritizedVM : prioritizedVMLists.getMediumPriorityVMs()) {
            if (!vM.getVMName().equals(prioritizedVM.getVMName())) continue;
            return true;
        }
        for (PrioritizedVM prioritizedVM : prioritizedVMLists.getLowPriorityVMs()) {
            if (!vM.getVMName().equals(prioritizedVM.getVMName())) continue;
            return true;
        }
        for (PrioritizedVM prioritizedVM : prioritizedVMLists.getGroup1PriorityVMs()) {
            if (!vM.getVMName().equals(prioritizedVM.getVMName())) continue;
            return true;
        }
        for (PrioritizedVM prioritizedVM : prioritizedVMLists.getGroup2PriorityVMs()) {
            if (!vM.getVMName().equals(prioritizedVM.getVMName())) continue;
            return true;
        }
        return false;
    }

    private synchronized List<Datacenter> createDatacenterList() {
        ArrayList<Datacenter> arrayList = new ArrayList<Datacenter>();
        if (this.inventoryVMList != null) {
            for (PrioritizedVM prioritizedVM : this.inventoryVMList) {
                if (prioritizedVM.getDataCenter() == null) continue;
                Datacenter datacenter = this.findDatacenter(arrayList, prioritizedVM.getDataCenter());
                if (datacenter == null) {
                    datacenter = new Datacenter(prioritizedVM.getDataCenter());
                    arrayList.add(datacenter);
                }
                datacenter.addVM(prioritizedVM);
            }
        }
        return arrayList;
    }

    private Datacenter findDatacenter(List<Datacenter> list, String string) {
        for (Datacenter datacenter : list) {
            if (!datacenter.getName().equals(string)) continue;
            return datacenter;
        }
        return null;
    }

    public List<PrioritizedVM> readPriorityVMListFromRequest(PageContext pageContext, VMPriority vMPriority) {
        Map<String, String[]> map;
        String[] stringArray;
        ArrayList<PrioritizedVM> arrayList = new ArrayList<PrioritizedVM>();
        String string = null;
        switch (vMPriority) {
            case HIGH: {
                string = PARAM_VM_LIST_HIGH;
                break;
            }
            case MEDIUM: {
                string = PARAM_VM_LIST_MEDIUM;
                break;
            }
            case LOW: {
                string = PARAM_VM_LIST_LOW_0;
                break;
            }
            case GROUP_1: {
                string = PARAM_VM_LIST_LOW_1;
                break;
            }
            case GROUP_2: {
                string = PARAM_VM_LIST_LOW_2;
                break;
            }
        }
        if (string != null && (stringArray = (map = pageContext.getPostQueryValues()).get(string)) != null) {
            for (String string2 : stringArray) {
                PrioritizedVM prioritizedVM = this.getVMbyName(string2);
                if (prioritizedVM == null) continue;
                arrayList.add(prioritizedVM);
            }
        }
        return arrayList;
    }

    public Container getPriorityTreeHTML(PrioritizedVMLists prioritizedVMLists, String[] stringArray, String[] stringArray2) {
        UnOrderedList unOrderedList = new UnOrderedList();
        this.addPriorityVMList(unOrderedList, VMPriority.HIGH, stringArray, stringArray2, prioritizedVMLists.getHighPriorityVMs());
        this.addPriorityVMList(unOrderedList, VMPriority.MEDIUM, stringArray, stringArray2, prioritizedVMLists.getMediumPriorityVMs());
        this.addPriorityVMList(unOrderedList, VMPriority.LOW, stringArray, stringArray2, prioritizedVMLists.getLowPriorityVMs());
        this.addPriorityVMList(unOrderedList, VMPriority.GROUP_1, stringArray, stringArray2, prioritizedVMLists.getGroup1PriorityVMs());
        this.addPriorityVMList(unOrderedList, VMPriority.GROUP_2, stringArray, stringArray2, prioritizedVMLists.getGroup2PriorityVMs());
        return unOrderedList;
    }

    private void addPriorityVMList(Container container, VMPriority vMPriority, String[] stringArray, String[] stringArray2, List<PrioritizedVM> list) {
        String string = "";
        ListItem listItem = new ListItem();
        switch (vMPriority) {
            case HIGH: {
                listItem.setCssClass(REF_PRIORITY_HIGH);
                listItem.setAttribute(ATTR_REL, REF_PRIORITY_HIGH);
                string = REF_PRIORITY_HIGH;
                break;
            }
            case MEDIUM: {
                listItem.setCssClass(REF_PRIORITY_MEDIUM);
                listItem.setAttribute(ATTR_REL, REF_PRIORITY_MEDIUM);
                string = REF_PRIORITY_MEDIUM;
                break;
            }
            case LOW: {
                listItem.setCssClass(REF_PRIORITY_LOW);
                listItem.setAttribute(ATTR_REL, REF_PRIORITY_LOW);
                string = REF_PRIORITY_LOW;
                break;
            }
            case GROUP_1: {
                listItem.setCssClass(REF_PRIORITY_GROUP_1);
                listItem.setAttribute(ATTR_REL, REF_PRIORITY_GROUP_1);
                string = REF_PRIORITY_GROUP_1;
                break;
            }
            case GROUP_2: {
                listItem.setCssClass(REF_PRIORITY_GROUP_2);
                listItem.setAttribute(ATTR_REL, REF_PRIORITY_GROUP_2);
                string = REF_PRIORITY_GROUP_2;
                break;
            }
            default: {
                listItem.setCssClass(REF_PRIORITY);
                listItem.setAttribute(ATTR_REL, REF_PRIORITY);
                string = REF_PRIORITY;
            }
        }
        listItem.setDataJstree(string);
        listItem.setAttribute("data-priority", vMPriority.toString());
        Anchor anchor = new Anchor();
        anchor.setHypertextReference("#");
        anchor.add(new Text(stringArray[vMPriority.ordinal()]));
        anchor.setTitle(stringArray2[vMPriority.ordinal()]);
        listItem.add(anchor);
        UnOrderedList unOrderedList = new UnOrderedList();
        listItem.add(unOrderedList);
        container.add(listItem);
        if (list != null && !list.isEmpty()) {
            ListItem listItem2 = null;
            Anchor anchor2 = null;
            String string2 = "";
            for (PrioritizedVM prioritizedVM : list) {
                PrioritizedVM prioritizedVM2 = this.getVMbyName(prioritizedVM.getVMName());
                boolean bl = prioritizedVM2 != null && prioritizedVM2.isVCSA();
                boolean bl2 = prioritizedVM2 != null && prioritizedVM2.isVirtualApp();
                listItem2 = new ListItem();
                if (bl) {
                    listItem2.setCssClass(REF_VCSA);
                    listItem2.setAttribute(ATTR_REL, REF_VCSA);
                    string2 = REF_VCSA;
                } else if (bl2) {
                    listItem2.setCssClass(REF_VAPP);
                    listItem2.setAttribute(ATTR_REL, REF_VAPP);
                    string2 = REF_VAPP;
                } else {
                    listItem2.setCssClass(REF_VM);
                    listItem2.setAttribute(ATTR_REL, REF_VM);
                    string2 = REF_VM;
                }
                listItem2.setDataJstree(string2);
                listItem2.setAttribute("data-vmname", prioritizedVM.getVMName());
                unOrderedList.add(listItem2);
                anchor2 = new Anchor();
                anchor2.setHypertextReference("#");
                anchor2.add(new Text(prioritizedVM.getVMName()));
                listItem2.add(anchor2);
            }
        }
    }

    private synchronized PrioritizedVM getVMbyName(String string) {
        Optional<PrioritizedVM> optional = this.inventoryVMList.stream().filter(prioritizedVM -> prioritizedVM.getVMName().equalsIgnoreCase(string)).findFirst();
        return optional.orElse(null);
    }

    public List<PrioritizedVM> getInventoryList() {
        List<PrioritizedVM> list = new ArrayList<PrioritizedVM>();
        if (this.inventoryVMList != null) {
            list = Collections.unmodifiableList(this.inventoryVMList);
        }
        return list;
    }

    @Generated
    public void setSpringContextUtil(SpringContextUtil springContextUtil) {
        this.springContextUtil = springContextUtil;
    }

    @Generated
    public void setVirtualConfigurationManager(VirtualConfigurationManager virtualConfigurationManager) {
        this.virtualConfigurationManager = virtualConfigurationManager;
    }

    @Generated
    public void setVmPrioritizationUtils(VMPrioritizationUtils vMPrioritizationUtils) {
        this.vmPrioritizationUtils = vMPrioritizationUtils;
    }
}

