/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.util;

import com.apcc.m11.components.webserver.html.Container;
import com.apcc.m11.components.webserver.html.HTML;
import com.apcc.m11.components.webserver.html.HTMLTagWithClassStyle;
import com.apcc.m11.components.webserver.html.HTMLwithId;
import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.html.Text;
import com.apcc.m11.components.webserver.html.apc.ApcHelp;
import com.apcc.m11.components.webserver.html.document.Division;
import com.apcc.m11.components.webserver.html.document.Heading;
import com.apcc.m11.components.webserver.html.document.Span;
import com.apcc.m11.components.webserver.html.form.Input;
import com.apcc.m11.components.webserver.model.VMOperations;
import com.apcc.m11.components.webserver.model.VMPrioritizationDurations;
import com.apcc.m11.components.webserver.model.VMSettings;
import com.apcc.m11.components.webserver.util.FormHelper;
import com.apcc.m11.components.webserver.util.HostNMCMappingHelper;
import com.apcc.m11.components.webserver.util.HostSelectionHTMLHelper;
import com.apcc.m11.components.webserver.util.InventoryTreeHelper;
import com.apcc.m11.components.webserver.util.TargetHostSelectionHelper;
import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.util.ResourceBundleWrapper;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VMSettingsHTMLHelper {
    private static final int SIX_CHAR_LENGTH_VALIDATOR = 6;
    private static final Logger logger = LogManager.getLogger(VMSettingsHTMLHelper.class);
    private static final String kVMSettingsError = "Shutdown.ErrorText";
    private static final String kApplyGlobalVMSettings = "Shutdown.ApplyGlobalVMSettings";
    private static final String kHVStopClusterHeader = "VMSettings.HVStopClusterHeader";
    private static final String kHVStopClusterEnabledLabel = "VMSettings.HVStopClusterEnabledLabel";
    private static final String kHVStopClusterNote = "VMSettings.HVStopClusterNote";
    private static final String kTimeoutForHVStopClusterNote = "VMSettings.TimeoutForHVStopClusterNote";
    private static final String kVMMigrationHeader = "VMSettings.VMMigrationHeader";
    private static final String kVMMigrationEnabledLabel = "VMSettings.VMMigrationEnabledLabel";
    private static final String kVMMigrationTargetEnabledLabel = "VMSettings.VMMigrationTargetEnabledLabel";
    private static final String kVMMigrationTargetEnabledTooltip = "VMSettings.VMMigrationTargetEnabledTooltip";
    private static final String kVMStartupHeader = "VMSettings.VMStartupHeader";
    private static final String kVMVappStartupHeader = "VMSettings.VMVappStartupHeader";
    private static final String kVMShutdownEnabledLabel = "VMSettings.VMShutdownEnabledLabel";
    private static final String kVMVappStartupEnabledLabel = "VMSettings.VMVappStartupEnabledLabel";
    private static final String kVMStartupEnabledLabel = "VMSettings.VMStartupEnabledLabel";
    private static final String kVAppStartupHeader = "VMSettings.VAppStartupHeader";
    private static final String kVMVAppShutdownEnabledLabel = "VMSettings.VMVAppShutdownEnabledLabel";
    private static final String kForceVAppShutdownEnabledLabel = "VMSettings.ForceVAppShutdownEnabledLabel";
    private static final String kVAppStartupEnabledLabel = "VMSettings.VAppStartupEnabledLabel";
    private static final String kVCSAHeader = "VMSettings.VCSAHeader";
    private static final String kVCSAShutdownDurationLabel = "VMSettings.VCSAShutdownDurationLabel";
    private static final String kStartupWaitsForAllHostsOnlineLabel = "VMSettings.StartupWaitsForAllHostsOnlineLabel";
    private static final String kDurationLabel = "VMSettings.DurationLabel";
    private static final String kShutdownDurationLabel = "VMSettings.ShutdownDurationLabel";
    private static final String kStartupDurationLabel = "VMSettings.StartupDurationLabel";
    private static final String kSecondsUnitLabel = "VMSettings.SecondsUnitLabel";
    private static final String kRangeValidation = "PCNS.RangeValidation";
    private static final String kDigitsValidation = "PCNS.DigitsValidation";
    private static final String kRequiredField = "PCNS.RequiredField";
    private static final String kGuestVMMigrationNote = "VMSettings.GuestVMMigrationNote";
    private static final String kTimeoutForGuestVMMigrationNote = "VMSettings.TimeoutForGuestVMMigrationNote";
    private static final String kTimeoutForGuestVMShutdownNote = "VMSettings.TimeoutForGuestVMShutdownNote";
    private static final String kGuestVMShutdownNote = "VMSettings.GuestVMShutdownNote";
    private static final String kGuestVMStartupNote = "VMSettings.GuestVMStartupNote";
    private static final String kTimeoutForGuestVMStartupNote = "VMSettings.TimeoutForGuestVMStartupNote";
    private static final String kVCenterPluginNote = "VMSettings.VCenterPluginNote";
    private static final String kVAppShutdownNote = "VMSettings.VAppShutdownNote";
    private static final String kForceVAppShutdownNote = "VMSettings.ForceVAppShutdownNote";
    private static final String kTimeoutForVAppShutdownNote = "VMSettings.TimeoutForVAppShutdownNote";
    private static final String kVAppStartupNote = "VMSettings.VAppStartupNote";
    private static final String kTimeoutForVAppStartupNote = "VMSettings.TimeoutForVAppStartupNote";
    private static final String kTimeoutForVCSAShutdownNote = "VMSettings.TimeoutForVCSAShutdownNote";
    private static final String kApplyGlobalSettingsNote = "Shutdown.ApplyGlobalSettingsNote";
    private static final String kVSpherePluginHeader = "VMSettings.VCenterPluginHeader";
    private static final String kVSpherePluginLabel = "Configure.VCenterPluginLabel";
    private static final String kVSphereWebPluginLabel = "VMSettings.VCenterWebPluginLabel";
    private static final String kVCenterWebPluginNote = "VMSettings.VCenterWebPluginNote";
    private static final String kStartupWaitsForAllHostsOnlineNote = "VMSettings.StartupWaitsForAllHostsOnlineNote";
    private static final String kEnableHostMaintenance = "VMSettings.EnableHostMaintenance";
    private static final String kHostMaintenanceDuration = "CfgWizard.VMSettingsConfirmPage.HostMaintenanceModeDuration";
    private static final String kHostMaintenanceDurationNote = "CfgWizard.VMSettingsConfirmPage.HostMaintenanceModeDurationNote";
    private static final String kDelayHostMaintenanceMode = "VMSettings.DelayHostMaintenanceMode";
    private static final String kSkipHostMaintenanceMode = "VMSettings.SkipHostMaintenanceMode";
    private static final String kEnableHostShutdown = "VMSettings.EnableHostShutdown";
    private static final String kHostShutdownDuration = "CfgWizard.VMSettingsConfirmPage.HostShutdownDuration";
    private static final String kHostShutdownDurationNote = "CfgWizard.VMSettingsConfirmPage.HostShutdownDurationNote";
    private static final String kRemoveButton = "InventoryHostMapping.RemoveButton";
    private static final String kCheckingCluster = "VMSettings.CheckingCluster";
    private static final String kMultipleSelection = "InventoryHostMapping.MultipleSelection";
    private static final String kCheckingSCVMM = "CfgWizard.HyperVServerDetails.AttemptHyperVConnection";
    private static final String kVMMigrateDDFWarning = "VMSettings.VMMigrateDDFWarning";
    private static final String kHostMaintModeHeader = "VMSettings.HostMaintModeDelayHeader";
    private static final String kRetreatModeHeader = "VMSettings.RetreatMode";
    private static final String kDisablingRetreatModeDuration = "VMSettings.DisablingRetreatModeDuration";
    private static final String kEnablingRetreatModeDuration = "VMSettings.EnablingRetreatModeDuration";
    private static final String kEnableRetreatModeDurationNote = "VMSettings.EnableRetreatModeDurationNote";
    private static final String kDisableRetreatModeDurationNote = "VMSettings.DisableRetreatModeDurationNote";
    private static final String kDisableHADuration = "VMSettings.DisablingHADuration";
    private static final String kDisableHADurationNote = "VMSettings.DisablingHADurationNote";
    private static final String kHAHeader = "VMSettings.HA";
    private static final String kHACheckbox = "VMSettings.HACheckbox";
    private static final String kHANote = "VMSettings.HANote";
    private static final String kEnableHADuration = "VMSettings.EnablingHADuration";
    private static final String kEnableHADurationNote = "VMSettings.EnablingHADurationNote";
    private static final String kVsanHeader = "VMSettings.VSANFTTHeader";
    private static final String kDelayHostMaintModeEnabledLabel = "VMSettings.HostMaintModeDelayEnabledLabel";
    private static final String kSkipHostMaintModeEnabledLabel = "VMSettings.SkipHostMaintModeEnabledLabel";
    private static final String kTimeoutForHostMaintMode = "VMSettings.HostMaintModeTimeoutLabel";
    private static final String kEnableFTTLabel = "VMSettings.EnableFTTLabel";
    private static final String kEnableFTTTooltip = "VMSettings.EnableFTTTooltip";
    private static final String kFTTLevelLabel = "VMSettings.FTTLevelLabel";
    private static final String kShutdownAllClusterVMsLabel = "VMSettings.ShutdownAllClusterVMsLabel";
    private static final String kShutdownAllClusterVMsTooltip = "VMSettings.ShutdownAllClusterVMsTooltip";
    private static final String kVsanSyncTimeoutLabel = "VMSettings.VsanSyncTimeoutLabel";
    private static final String kVsanSyncTimeoutTooltip = "VMSettings.VsanSyncTimeoutTooltip";
    private static final String VSAN_CLUSTER_PREPARE_LABEL = "VMSettings.VsanClusterPrepareLabel";
    private static final String VSAN_CLUSTER_PREPARE_TOOLTIP = "VMSettings.VsanClusterPrepareTooltip";
    private static final String VSAN_CLUSTER_RECOVERY_LABEL = "VMSettings.VsanClusterRecoveryLabel";
    private static final String VSAN_CLUSTER_RECOVERY_TOOLTIP = "VMSettings.VsanClusterRecoveryTooltip";
    private static final String kFTTLevelTooltip = "VMSettings.FTTLevelTooltip";
    private static final String kVMSettingsWarn = "VMSettings.HostMainteananceModeDisabledWarning";
    private static final String kVmShutdownDurationLabel = "VMSettings.VmShutdownDurationLabel";
    private static final String kCvmShutdownHeader = "VMSettings.CvmShutdownHeader";
    private static final String kCvmStartupEnableLabel = "VMSettings.CvmStartupEnableLabel";
    private static final String kAfsShutdownHeader = "VMSettings.AfsShutdownHeader";
    private static final String kAfsShutdownEnableLabel = "VMSettings.AfsShutdownEnableLabel";
    private static final String kAfsStartupEnableLabel = "VMSettings.AfsStartupEnableLabel";
    private static final String kProtectionDomainHeader = "VMSettings.ProtectionDomainHeader";
    private static final String kOngoingReplicationAbortDelayLabel = "VMSettings.OngoingReplicationAbortDelayEnable";
    private static final String kClusterShutdownHeader = "VMSettings.ClusterShutdownHeader";
    private static final String kUvmShutdownDurationNote = "VMSettings.UvmShutdownDurationNote";
    private static final String kUvmStartupEnableNote = "VMSettings.UvmStartupEnableNote";
    private static final String kUvmStartupDurationNote = "VMSettings.UvmStartupDurationNote";
    private static final String kCvmShutdownDurationNote = "VMSettings.CvmShutdownDurationNote";
    private static final String kCvmStartupDurationNote = "VMSettings.CvmStartupDurationNote";
    private static final String kCvmStartupEnableNote = "VMSettings.CvmStartupEnableNote";
    private static final String kAfsShutdownEnableNote = "VMSettings.AfsShutdownEnableNote";
    private static final String kAfsShutdownDurationNote = "VMSettings.AfsShutdownDurationNote";
    private static final String kAfsStartupEnableNote = "VMSettings.AfsStartupEnableNote";
    private static final String kAfsStartupDurationNote = "VMSettings.AfsStartupDurationNote";
    private static final String kOngoingReplicationDelayEnableNote = "VMSettings.OngoingReplicationDelayEnableNote";
    private static final String kOngoingReplicationDelayDurationNote = "VMSettings.OngoingReplicationDelayDurationNote";
    private static final String kMetroAvailDisableLabel = "VMSettings.MetroAvailDisableLabel";
    private static final String kMetroAvailDisableNote = "VMSettings.MetroAvailDisableNote";
    private static final String kClusterShutdownDurationNote = "VMSettings.ClusterShutdownDurationNote";
    private static final String kClusterStartupDurationNote = "VMSettings.ClusterStartupDurationNote";
    private static final String kNutanixSettingsWarning = "VMSettings.NutanixSettingsWarning";
    private static final String ENABLE_SKIP_MAINTENANCE_MODE_WARNING = "TargetHostSelection.PCNSRunningOnVsanHostWarning";
    private static final String VXRAIL_HEADER = "VMSettings.VxRailHeader";
    private static final String SHUTDOWN_DELAY_LABEL = "CfgWizard.VxRailClusterDetails.ShutdownDelay";
    private static final String SHUTDOWN_DELAY_TOOLTIP = "CfgWizard.VxRailClusterDetails.ShutdownDelay.Tooltip";
    private static final String SHUTDOWN_DURATION_LABEL = "CfgWizard.VxRailClusterDetails.ShutdownDuration";
    private static final String SHUTDOWN_DURATION_TOOLTIP = "CfgWizard.VxRailClusterDetails.ShutdownDuration.Tooltip";
    private static final String KOVCSHUTDOWNHEADER = "VMSettings.OvcShutdownHeader";
    private static final String KOVCSTARTUPENABLELABEL = "VMSettings.OvcStartupEnableLabel";
    private static final String KOVCSHUTDOWNDURATIONNOTE = "VMSettings.OvcShutdownDurationNote";
    private static final String KOVCSTARTUPDURATIONNOTE = "VMSettings.OvcStartupDurationNote";
    private static final String KOVCSTARTUPENABLENOTE = "VMSettings.OvcStartupEnableNote";
    public static final String ATTR_VM_SETTINGS = "VMSettings";
    public static final String PARAM_HVSTOPCLUSTER_ENABLED = "hvStopClusterEnabled";
    public static final String PARAM_HVSTOPCLUSTER_DURATION = "hvStopClusterDuration";
    public static final String PARAM_HVSTARTCLUSTER_DURATION = "hvStartClusterDuration";
    public static final String PARAM_VMMIGRATION_TARGET_ENABLED = "vmmigrationtargetEnabled";
    public static final String PARAM_VMMIGRATION_ENABLED = "vmmigrationEnabled";
    public static final String PARAM_VMMIGRATION_DURATION = "vmmigrationDuration";
    public static final String PARAM_VMSHUTDOWN_ENABLED = "vmshutdownEnabled";
    public static final String PARAM_VMSHUTDOWN_DURATION = "vmshutdownDuration";
    public static final String PARAM_VMSTARTUP_ENABLED = "vmstartupEnabled";
    public static final String PARAM_VMSTARTUP_DURATION = "vmstartupDuration";
    public static final String PARAM_FORCE_VAPPSHUTDOWN_ENABLED = "forcevappshutdownEnabled";
    public static final String PARAM_VCSASHUTDOWN_DURATION = "vcsashutdownDuration";
    public static final String PARAM_APPLY_GLOBAL_VMSETTINGS = "globalvmsettings";
    public static final String PARAM_VMSETTINGS_HIDDEN_INPUT = "vmsettingsHiddenInput";
    public static final String PARAM_VSPHERE_PLUGIN_ENABLED = "vspherepluginEnabled";
    public static final String PARAM_VSPHERE_WEB_PLUGIN_ENABLED = "vspherewebpluginEnabled";
    public static final String PARAM_STARTUP_WAITS_FOR_HOSTS = "startupWaitsforHosts";
    public static final String PARAM_HOST_MAINTENANCE_DURATION = "vmmaintenanceDuration";
    public static final String PARAM_HOST_MAINTENANCE_ENABLED = "vmenableHostMaintenance";
    public static final String PARAM_SKIP_HOST_MAINTENANCE_ENABLED = "vmskipHostMaintenance";
    public static final String PARAM_HOST_SHUTDOWN_ENABLED = "vmenableHostShutdown";
    public static final String PARAM_HOST_SHUTDOWN_DURATION = "vmHostShutdownDuration";
    public static final String PARAM_ENABLE_FTT = "enableFTT";
    public static final String PARAM_SHUTDOWN_ALL_CLUSTER_VMS = "shutdownAllClusterVMs";
    public static final String PARAM_VSAN_SYNC_TIMEOUT = "vSanSyncTimeout";
    public static final String PARAM_VSAN_PREPARATION_DURATION = "vsanPrepareDuration";
    public static final String PARAM_VSAN_RECOVERY_DURATION = "vsanRecoveryDuration";
    public static final String PARAM_VSAN_FTT_LEVEL = "vSanFTTLevel";
    public static final String PARAM_HOST_MAINTENANCE_DELAY_ENABLED = "vmHostMaintenanceDelayEnabled";
    public static final String PARAM_HOST_MAINTENANCE_DELAY_TIMEOUT = "vmHostMaintenanceDelayTimeout";
    public static final String PARAM_DISPLAY_HOST_SHUTDOWN_OPTION = "displayHostShutdown";
    public static final String PARAM_CVM_SHUTDOWN_DURATION = "cvmShutdownDuration";
    public static final String PARAM_CVM_STARTUP_ENABLE = "cvmStartupEnable";
    public static final String PARAM_CVM_STARTUP_DURATION = "cvmStartupDuration";
    public static final String PARAM_AFS_SHUTDOWN_ENABLE = "afsShutdownEnable";
    public static final String PARAM_AFS_SHUTDOWN_DURATION = "afsShutdownDuration";
    public static final String PARAM_AFS_STARTUP_ENABLE = "afsStartupEnable";
    public static final String PARAM_AFS_STARTUP_DURATION = "afsStartupDuration";
    public static final String PARAM_ONGOING_REPLICATION_ABORT_DELAY_ENABLE = "ongoingReplicationAbortDelayEnable";
    public static final String PARAM_ONGOING_REPLICATION_ABORT_DELAY_DURATION = "ongoingReplicationAbortDelayDuration";
    public static final String PARAM_METRO_AVAIL_DISABLE = "metroAvailDisable";
    public static final String PARAM_CLUSTER_SHUTDOWN_DURATION = "clusterShutdownDuration";
    public static final String PARAM_CLUSTER_STARTUP_DURATION = "clusterStartupDuration";
    public static final String PARAM_OVC_SHUTDOWN_DURATION = "ovcShutdownDuration";
    public static final String PARAM_OVC_STARTUP_ENABLE = "ovcStartupEnable";
    public static final String PARAM_OVC_STARTUP_DURATION = "ovcStartupDuration";
    public static final String PARAM_VXRAIL_SHUTDOWN_DELAY = "vxRailShutdownDelay";
    public static final String PARAM_VXRAIL_SHUTDOWN_DURATION = "vxRailShutdownDuration";
    public static final String PARAM_ENABLE_RETREAT_MODE_DURATION = "enableRetreatModeDuration";
    public static final String PARAM_DISABLE_HA = "disableHA";
    public static final String PARAM_DISABLE_HA_DURATION = "disableHADuration";
    public static final String PARAM_ENABLE_HA_DURATION = "enableHADuration";
    public static final String PARAM_DISABLE_RETREAT_MODE_DURATION = "disableRetreatModeDuration";
    private static final int INPUT_MAX_LENGTH_6 = 6;
    private Map<String, String> resMap = new HashMap<String, String>();
    private boolean isManaged;
    private boolean isESXi;
    private boolean isHyperV;
    private boolean isVxRail;
    private boolean isVxRailWithOnlyClusterHosts;
    private boolean isNutanixAHV;
    private boolean isNutanixESXi;
    private boolean isSimplivity;
    private boolean isHyperflex;
    private boolean isAdvanced;
    private boolean isPrioritizationEnabled;
    private ServiceManager services;

    public VMSettingsHTMLHelper(Locale locale, @NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        this.services = serviceManager;
        this.getVMSettingsResourceStrings(locale);
        this.isManaged = this.services.getVirtualConfigurationManager().isManagedHost();
        this.isESXi = this.services.getVirtualConfigurationManager().isESXi();
        this.isHyperV = this.services.getVirtualConfigurationManager().isHyperV();
        this.isNutanixAHV = this.services.getVirtualConfigurationManager().isNutanixAHV();
        this.isNutanixESXi = this.services.getVirtualConfigurationManager().isNutanixESXi();
        this.isSimplivity = this.services.getVirtualConfigurationManager().isSimplivity();
        this.isHyperflex = this.services.getVirtualConfigurationManager().isHyperflex();
        this.isVxRail = this.services.getVirtualConfigurationManager().isVxRail();
        if (this.isVxRail) {
            this.isVxRailWithOnlyClusterHosts = !this.services.getVxRailUtils().hasNonClusterHosts();
        }
        this.isAdvanced = this.services.getAdvancedSetupHelper().isAdvancedShutdownMode();
        this.isPrioritizationEnabled = this.services.getVMPrioritizationUtils().isVMPrioritizationEnabled();
    }

    private void resMapput(ResourceBundleWrapper resourceBundleWrapper, String string) {
        this.resMap.put(string, Utils.getResourceString(resourceBundleWrapper, string));
    }

    private void getVMSettingsResourceStrings(Locale locale) {
        ResourceBundleWrapper resourceBundleWrapper = Utils.getWebServerResourceBundle(locale);
        this.resMap.put(kVMSettingsError, Utils.getResourceString(resourceBundleWrapper, kVMSettingsError));
        this.resMap.put(kApplyGlobalVMSettings, Utils.getResourceString(resourceBundleWrapper, kApplyGlobalVMSettings));
        this.resMapput(resourceBundleWrapper, kHVStopClusterHeader);
        this.resMapput(resourceBundleWrapper, kHVStopClusterEnabledLabel);
        this.resMapput(resourceBundleWrapper, kHVStopClusterNote);
        this.resMapput(resourceBundleWrapper, kTimeoutForHVStopClusterNote);
        this.resMap.put(kVMMigrationHeader, Utils.getResourceString(resourceBundleWrapper, kVMMigrationHeader));
        this.resMap.put(kVMMigrationEnabledLabel, Utils.getResourceString(resourceBundleWrapper, kVMMigrationEnabledLabel));
        this.resMap.put(kVMMigrationTargetEnabledLabel, Utils.getResourceString(resourceBundleWrapper, kVMMigrationTargetEnabledLabel));
        this.resMap.put(kVMMigrationTargetEnabledTooltip, Utils.getResourceString(resourceBundleWrapper, kVMMigrationTargetEnabledTooltip));
        this.resMap.put(kVMStartupHeader, Utils.getResourceString(resourceBundleWrapper, kVMStartupHeader));
        this.resMap.put(kVMVappStartupHeader, Utils.getResourceString(resourceBundleWrapper, kVMVappStartupHeader));
        this.resMap.put(kVMShutdownEnabledLabel, Utils.getResourceString(resourceBundleWrapper, kVMShutdownEnabledLabel));
        this.resMap.put(kVMVappStartupEnabledLabel, Utils.getResourceString(resourceBundleWrapper, kVMVappStartupEnabledLabel));
        this.resMap.put(kVMStartupEnabledLabel, Utils.getResourceString(resourceBundleWrapper, kVMStartupEnabledLabel));
        this.resMap.put(kVAppStartupHeader, Utils.getResourceString(resourceBundleWrapper, kVAppStartupHeader));
        this.resMap.put(kVMVAppShutdownEnabledLabel, Utils.getResourceString(resourceBundleWrapper, kVMVAppShutdownEnabledLabel));
        this.resMap.put(kForceVAppShutdownEnabledLabel, Utils.getResourceString(resourceBundleWrapper, kForceVAppShutdownEnabledLabel));
        this.resMap.put(kVAppStartupEnabledLabel, Utils.getResourceString(resourceBundleWrapper, kVAppStartupEnabledLabel));
        this.resMap.put(kVCSAHeader, Utils.getResourceString(resourceBundleWrapper, kVCSAHeader));
        this.resMap.put(kVCSAShutdownDurationLabel, Utils.getResourceString(resourceBundleWrapper, kVCSAShutdownDurationLabel));
        this.resMap.put(kShutdownDurationLabel, Utils.getResourceString(resourceBundleWrapper, kShutdownDurationLabel));
        this.resMap.put(kStartupDurationLabel, Utils.getResourceString(resourceBundleWrapper, kStartupDurationLabel));
        this.resMap.put(kSecondsUnitLabel, Utils.getResourceString(resourceBundleWrapper, kSecondsUnitLabel));
        this.resMap.put(kRangeValidation, Utils.getResourceString(resourceBundleWrapper, kRangeValidation));
        this.resMap.put(kRequiredField, Utils.getResourceString(resourceBundleWrapper, kRequiredField));
        this.resMap.put(kGuestVMMigrationNote, Utils.getResourceString(resourceBundleWrapper, kGuestVMMigrationNote));
        this.resMap.put(kTimeoutForGuestVMMigrationNote, Utils.getResourceString(resourceBundleWrapper, kTimeoutForGuestVMMigrationNote));
        this.resMap.put(kTimeoutForGuestVMShutdownNote, Utils.getResourceString(resourceBundleWrapper, kTimeoutForGuestVMShutdownNote));
        this.resMap.put(kGuestVMShutdownNote, Utils.getResourceString(resourceBundleWrapper, kGuestVMShutdownNote));
        this.resMap.put(kGuestVMStartupNote, Utils.getResourceString(resourceBundleWrapper, kGuestVMStartupNote));
        this.resMap.put(kTimeoutForGuestVMStartupNote, Utils.getResourceString(resourceBundleWrapper, kTimeoutForGuestVMStartupNote));
        this.resMap.put(kVCenterPluginNote, Utils.getResourceString(resourceBundleWrapper, kVCenterPluginNote));
        this.resMap.put(kVCenterWebPluginNote, Utils.getResourceString(resourceBundleWrapper, kVCenterWebPluginNote));
        this.resMap.put(kVAppShutdownNote, Utils.getResourceString(resourceBundleWrapper, kVAppShutdownNote));
        this.resMap.put(kForceVAppShutdownNote, Utils.getResourceString(resourceBundleWrapper, kForceVAppShutdownNote));
        this.resMap.put(kTimeoutForVAppShutdownNote, Utils.getResourceString(resourceBundleWrapper, kTimeoutForVAppShutdownNote));
        this.resMap.put(kVAppStartupNote, Utils.getResourceString(resourceBundleWrapper, kVAppStartupNote));
        this.resMap.put(kTimeoutForVAppStartupNote, Utils.getResourceString(resourceBundleWrapper, kTimeoutForVAppStartupNote));
        this.resMap.put(kTimeoutForVCSAShutdownNote, Utils.getResourceString(resourceBundleWrapper, kTimeoutForVCSAShutdownNote));
        this.resMap.put(kApplyGlobalSettingsNote, Utils.getResourceString(resourceBundleWrapper, kApplyGlobalSettingsNote));
        this.resMap.put(kVSpherePluginLabel, Utils.getResourceString(resourceBundleWrapper, kVSpherePluginLabel));
        this.resMap.put(kVSphereWebPluginLabel, Utils.getResourceString(resourceBundleWrapper, kVSphereWebPluginLabel));
        this.resMap.put(kVSpherePluginHeader, Utils.getResourceString(resourceBundleWrapper, kVSpherePluginHeader));
        this.resMap.put(kStartupWaitsForAllHostsOnlineLabel, Utils.getResourceString(resourceBundleWrapper, kStartupWaitsForAllHostsOnlineLabel));
        this.resMap.put(kStartupWaitsForAllHostsOnlineNote, Utils.getResourceString(resourceBundleWrapper, kStartupWaitsForAllHostsOnlineNote));
        this.resMap.put(kEnableHostMaintenance, Utils.getResourceString(resourceBundleWrapper, kEnableHostMaintenance));
        this.resMap.put(kHostMaintenanceDuration, Utils.getResourceString(resourceBundleWrapper, kHostMaintenanceDuration));
        this.resMap.put(kHostMaintenanceDurationNote, Utils.getResourceString(resourceBundleWrapper, kHostMaintenanceDurationNote));
        this.resMap.put(kEnableHostShutdown, Utils.getResourceString(resourceBundleWrapper, kEnableHostShutdown));
        this.resMap.put(kHostShutdownDuration, Utils.getResourceString(resourceBundleWrapper, kHostShutdownDuration));
        this.resMap.put(kHostShutdownDurationNote, Utils.getResourceString(resourceBundleWrapper, kHostShutdownDurationNote));
        this.resMap.put(kRemoveButton, Utils.getResourceString(resourceBundleWrapper, kRemoveButton));
        this.resMap.put(kDigitsValidation, Utils.getResourceString(resourceBundleWrapper, kDigitsValidation));
        this.resMap.put(kCheckingCluster, Utils.getResourceString(resourceBundleWrapper, kCheckingCluster));
        this.resMap.put(kMultipleSelection, Utils.getResourceString(resourceBundleWrapper, kMultipleSelection));
        this.resMap.put(kCheckingSCVMM, Utils.getResourceString(resourceBundleWrapper, kCheckingSCVMM));
        this.resMap.put(kVMMigrateDDFWarning, Utils.getResourceString(resourceBundleWrapper, kVMMigrateDDFWarning));
        this.resMap.put(kHostMaintModeHeader, Utils.getResourceString(resourceBundleWrapper, kHostMaintModeHeader));
        this.resMap.put(kRetreatModeHeader, Utils.getResourceString(resourceBundleWrapper, kRetreatModeHeader));
        this.resMap.put(kDisablingRetreatModeDuration, Utils.getResourceString(resourceBundleWrapper, kDisablingRetreatModeDuration));
        this.resMap.put(kEnablingRetreatModeDuration, Utils.getResourceString(resourceBundleWrapper, kEnablingRetreatModeDuration));
        this.resMap.put(kEnableRetreatModeDurationNote, Utils.getResourceString(resourceBundleWrapper, kEnableRetreatModeDurationNote));
        this.resMap.put(kDisableRetreatModeDurationNote, Utils.getResourceString(resourceBundleWrapper, kDisableRetreatModeDurationNote));
        this.resMap.put(kDisableHADuration, Utils.getResourceString(resourceBundleWrapper, kDisableHADuration));
        this.resMap.put(kDisableHADurationNote, Utils.getResourceString(resourceBundleWrapper, kDisableHADurationNote));
        this.resMap.put(kHAHeader, Utils.getResourceString(resourceBundleWrapper, kHAHeader));
        this.resMap.put(kHACheckbox, Utils.getResourceString(resourceBundleWrapper, kHACheckbox));
        this.resMap.put(kHANote, Utils.getResourceString(resourceBundleWrapper, kHANote));
        this.resMap.put(kEnableHADuration, Utils.getResourceString(resourceBundleWrapper, kEnableHADuration));
        this.resMap.put(kEnableHADurationNote, Utils.getResourceString(resourceBundleWrapper, kEnableHADurationNote));
        this.resMap.put(kSkipHostMaintModeEnabledLabel, Utils.getResourceString(resourceBundleWrapper, kSkipHostMaintModeEnabledLabel));
        this.resMap.put(kDelayHostMaintModeEnabledLabel, Utils.getResourceString(resourceBundleWrapper, kDelayHostMaintModeEnabledLabel));
        this.resMap.put(kTimeoutForHostMaintMode, Utils.getResourceString(resourceBundleWrapper, kTimeoutForHostMaintMode));
        this.resMap.put(kVsanHeader, Utils.getResourceString(resourceBundleWrapper, kVsanHeader));
        this.resMap.put(kFTTLevelLabel, Utils.getResourceString(resourceBundleWrapper, kFTTLevelLabel));
        this.resMap.put(kEnableFTTLabel, Utils.getResourceString(resourceBundleWrapper, kEnableFTTLabel));
        this.resMap.put(kEnableFTTTooltip, Utils.getResourceString(resourceBundleWrapper, kEnableFTTTooltip));
        this.resMap.put(kShutdownAllClusterVMsLabel, Utils.getResourceString(resourceBundleWrapper, kShutdownAllClusterVMsLabel));
        this.resMap.put(kShutdownAllClusterVMsTooltip, Utils.getResourceString(resourceBundleWrapper, kShutdownAllClusterVMsTooltip));
        this.resMap.put(kVsanSyncTimeoutLabel, Utils.getResourceString(resourceBundleWrapper, kVsanSyncTimeoutLabel));
        this.resMap.put(VSAN_CLUSTER_PREPARE_LABEL, Utils.getResourceString(resourceBundleWrapper, VSAN_CLUSTER_PREPARE_LABEL));
        this.resMap.put(VSAN_CLUSTER_RECOVERY_LABEL, Utils.getResourceString(resourceBundleWrapper, VSAN_CLUSTER_RECOVERY_LABEL));
        this.resMap.put(kVsanSyncTimeoutTooltip, Utils.getResourceString(resourceBundleWrapper, kVsanSyncTimeoutTooltip));
        this.resMap.put(VSAN_CLUSTER_PREPARE_TOOLTIP, Utils.getResourceString(resourceBundleWrapper, VSAN_CLUSTER_PREPARE_TOOLTIP));
        this.resMap.put(VSAN_CLUSTER_RECOVERY_TOOLTIP, Utils.getResourceString(resourceBundleWrapper, VSAN_CLUSTER_RECOVERY_TOOLTIP));
        this.resMap.put(kVMSettingsWarn, Utils.getResourceString(resourceBundleWrapper, kVMSettingsWarn));
        this.resMap.put(KOVCSHUTDOWNHEADER, Utils.getResourceString(resourceBundleWrapper, KOVCSHUTDOWNHEADER));
        this.resMap.put(KOVCSTARTUPENABLELABEL, Utils.getResourceString(resourceBundleWrapper, KOVCSTARTUPENABLELABEL));
        this.resMap.put(kVmShutdownDurationLabel, Utils.getResourceString(resourceBundleWrapper, kVmShutdownDurationLabel));
        this.resMap.put(kCvmShutdownHeader, Utils.getResourceString(resourceBundleWrapper, kCvmShutdownHeader));
        this.resMap.put(kCvmStartupEnableLabel, Utils.getResourceString(resourceBundleWrapper, kCvmStartupEnableLabel));
        this.resMap.put(kAfsShutdownHeader, Utils.getResourceString(resourceBundleWrapper, kAfsShutdownHeader));
        this.resMap.put(kAfsShutdownEnableLabel, Utils.getResourceString(resourceBundleWrapper, kAfsShutdownEnableLabel));
        this.resMap.put(kAfsStartupEnableLabel, Utils.getResourceString(resourceBundleWrapper, kAfsStartupEnableLabel));
        this.resMap.put(kProtectionDomainHeader, Utils.getResourceString(resourceBundleWrapper, kProtectionDomainHeader));
        this.resMap.put(kOngoingReplicationAbortDelayLabel, Utils.getResourceString(resourceBundleWrapper, kOngoingReplicationAbortDelayLabel));
        this.resMap.put(kClusterShutdownHeader, Utils.getResourceString(resourceBundleWrapper, kClusterShutdownHeader));
        this.resMap.put(kNutanixSettingsWarning, Utils.getResourceString(resourceBundleWrapper, kNutanixSettingsWarning));
        this.resMap.put(kUvmShutdownDurationNote, Utils.getResourceString(resourceBundleWrapper, kUvmShutdownDurationNote));
        this.resMap.put(kUvmStartupEnableNote, Utils.getResourceString(resourceBundleWrapper, kUvmStartupEnableNote));
        this.resMap.put(kUvmStartupDurationNote, Utils.getResourceString(resourceBundleWrapper, kUvmStartupDurationNote));
        this.resMap.put(kCvmShutdownDurationNote, Utils.getResourceString(resourceBundleWrapper, kCvmShutdownDurationNote));
        this.resMap.put(kCvmStartupDurationNote, Utils.getResourceString(resourceBundleWrapper, kCvmStartupDurationNote));
        this.resMap.put(kCvmStartupEnableNote, Utils.getResourceString(resourceBundleWrapper, kCvmStartupEnableNote));
        this.resMap.put(kAfsShutdownEnableNote, Utils.getResourceString(resourceBundleWrapper, kAfsShutdownEnableNote));
        this.resMap.put(kAfsShutdownDurationNote, Utils.getResourceString(resourceBundleWrapper, kAfsShutdownDurationNote));
        this.resMap.put(kAfsStartupEnableNote, Utils.getResourceString(resourceBundleWrapper, kAfsStartupEnableNote));
        this.resMap.put(kAfsStartupDurationNote, Utils.getResourceString(resourceBundleWrapper, kAfsStartupDurationNote));
        this.resMap.put(kOngoingReplicationDelayEnableNote, Utils.getResourceString(resourceBundleWrapper, kOngoingReplicationDelayEnableNote));
        this.resMap.put(kOngoingReplicationDelayDurationNote, Utils.getResourceString(resourceBundleWrapper, kOngoingReplicationDelayDurationNote));
        this.resMap.put(kMetroAvailDisableLabel, Utils.getResourceString(resourceBundleWrapper, kMetroAvailDisableLabel));
        this.resMap.put(kMetroAvailDisableNote, Utils.getResourceString(resourceBundleWrapper, kMetroAvailDisableNote));
        this.resMap.put(kClusterShutdownDurationNote, Utils.getResourceString(resourceBundleWrapper, kClusterShutdownDurationNote));
        this.resMap.put(kClusterStartupDurationNote, Utils.getResourceString(resourceBundleWrapper, kClusterStartupDurationNote));
        this.resMap.put(kDurationLabel, Utils.getResourceString(resourceBundleWrapper, kDurationLabel));
        this.resMap.put(ENABLE_SKIP_MAINTENANCE_MODE_WARNING, Utils.getResourceString(resourceBundleWrapper, ENABLE_SKIP_MAINTENANCE_MODE_WARNING));
        this.resMap.put(SHUTDOWN_DELAY_LABEL, Utils.getResourceString(resourceBundleWrapper, SHUTDOWN_DELAY_LABEL));
        this.resMap.put(SHUTDOWN_DELAY_TOOLTIP, Utils.getResourceString(resourceBundleWrapper, SHUTDOWN_DELAY_TOOLTIP));
        this.resMap.put(SHUTDOWN_DURATION_LABEL, Utils.getResourceString(resourceBundleWrapper, SHUTDOWN_DURATION_LABEL));
        this.resMap.put(SHUTDOWN_DURATION_TOOLTIP, Utils.getResourceString(resourceBundleWrapper, SHUTDOWN_DURATION_TOOLTIP));
        this.resMap.put(VXRAIL_HEADER, Utils.getResourceString(resourceBundleWrapper, VXRAIL_HEADER));
    }

    public void createVMSettingsWaitHTML(Container container, VMSettings vMSettings, boolean bl, boolean bl2, boolean bl3) {
        Division division = new Division();
        division.setCssClass("checkClusterDialog");
        division.setId("checkClusterDialog");
        Division division2 = new Division();
        division2.setId("warningDiv");
        division2.setCssClass("warningMsg ConnectionStatusWait");
        if (bl3) {
            division2.add(new Text(this.resMap.get(kCheckingSCVMM)));
        } else {
            division2.add(new Text(this.resMap.get(kCheckingCluster)));
        }
        Span span = new Span();
        span.setId("hyperVData");
        span.setCssClass("hidden");
        span.setAttribute("isWizardPage", String.valueOf(bl));
        span.setAttribute("isGlobal", String.valueOf(bl2));
        span.setAttribute("data-managed", String.valueOf(bl3));
        division.add(division2);
        division.add(span);
        container.add(division);
    }

    public void createVMSettingsHTML(Container container, VMSettings vMSettings, boolean bl, boolean bl2, boolean bl3, boolean bl4, Locale locale, Integer n) {
        HTMLwithId hTMLwithId;
        logger.debug("createVMSettingsHTML() - start");
        Division division = new Division();
        division.setId("errorcontainer");
        division.add(new Text(this.resMap.get(kVMSettingsError)));
        division.setCssClass("ui-state-error ui-corner-all");
        container.add(division);
        Division division2 = new Division();
        division2.setId("maindiv");
        division2.setCssClass("formdiv");
        container.add(division2);
        if (this.isHyperV || this.isManaged || this.isNutanixAHV) {
            this.displayVMSettingsSection(division2, vMSettings, bl, bl2, bl3, bl4, locale, n);
            if (!bl && this.isAdvanced && (this.isManaged || this.isNutanixAHV) && bl3) {
                hTMLwithId = new Division();
                container.add(hTMLwithId);
                ((HTMLTagWithClassStyle)hTMLwithId).setId("globalvmsettingsdiv");
                ((HTMLTagWithClassStyle)hTMLwithId).setCssClass("formdiv");
                ((Container)((Object)hTMLwithId)).add(FormHelper.createLabelCheckboxValueDiv(null, this.resMap.get(kApplyGlobalVMSettings), vMSettings.isApplySettingsToAllGroups(), null, PARAM_APPLY_GLOBAL_VMSETTINGS, this.resMap.get(kApplyGlobalSettingsNote)));
            }
            if (this.isESXi && (bl3 || bl)) {
                hTMLwithId = new Division();
                container.add(hTMLwithId);
                ((HTMLTagWithClassStyle)hTMLwithId).setId("startupwaitsforhostsdiv");
                ((HTMLTagWithClassStyle)hTMLwithId).setCssClass("formdiv");
                ((Container)((Object)hTMLwithId)).add(FormHelper.createLabelCheckboxValueDiv(null, this.resMap.get(kStartupWaitsForAllHostsOnlineLabel), vMSettings.isStartupWaitForAllHostsOnline(), null, PARAM_STARTUP_WAITS_FOR_HOSTS, this.resMap.get(kStartupWaitsForAllHostsOnlineNote)));
            }
        }
        if (bl) {
            hTMLwithId = new Input();
            ((Input)hTMLwithId).setName(PARAM_VMSETTINGS_HIDDEN_INPUT);
            ((Input)hTMLwithId).setId(PARAM_VMSETTINGS_HIDDEN_INPUT);
            ((Input)hTMLwithId).setType("hidden");
            ((Input)hTMLwithId).setValue("X");
            container.add(hTMLwithId);
        }
        if (this.isNutanixAHV) {
            hTMLwithId = new Division();
            ((HTMLTagWithClassStyle)hTMLwithId).setId("isNutanixAHV");
            ((HTMLTagWithClassStyle)hTMLwithId).setCssClass("hidden");
            container.add(hTMLwithId);
        }
        if (this.isVxRailWithOnlyClusterHosts) {
            hTMLwithId = new Division();
            ((HTMLTagWithClassStyle)hTMLwithId).setId("isVxRailStandard");
            ((HTMLTagWithClassStyle)hTMLwithId).setCssClass("hidden");
            container.add(hTMLwithId);
        }
        container.add(this.createShutdownSettingsResourceStrings());
    }

    private void displayVMSettingsSection(Division division, VMSettings vMSettings, boolean bl, boolean bl2, boolean bl3, boolean bl4, Locale locale, Integer n) {
        if (this.isHyperV && !this.isManaged && bl4) {
            this.displayVMMigrationSection(division, vMSettings, bl3, bl, bl2, locale, this.isPrioritizationEnabled, n);
        }
        if (this.isManaged && this.isESXi) {
            this.displayVMMigrationSection(division, vMSettings, bl3, bl, bl2, locale, this.isPrioritizationEnabled, n);
        }
        if (this.isESXi || !this.isManaged || this.isNutanixAHV) {
            this.displayVMStartupSection(division, vMSettings, this.isPrioritizationEnabled);
            if (bl4) {
                this.displayClusterStopSection(division, vMSettings, locale);
            }
        }
        if (this.isManaged && this.isESXi) {
            if (!this.isVxRail && (vMSettings.isVsanCluster() || this.services.getVsanUtils().isVsanCluster())) {
                this.displayVSANFTTSettings(division, vMSettings, bl3, bl);
            }
            if (!this.isVxRailWithOnlyClusterHosts) {
                this.displayHostMaintenanceModeSection(division, vMSettings);
            }
            if (!this.isVxRailWithOnlyClusterHosts && (bl || bl3) && this.services.getHostSystemUtils().isVCenterServerInstalledOnTargetHost()) {
                this.displayVCSASection(division, vMSettings);
            }
            if (!this.isVxRail) {
                if (this.services.getVirtualConfigurationManager().hasVCLSBeenDetectedOnCluster()) {
                    this.displayRetreatModeSection(division, vMSettings);
                }
                this.displayHASection(division, vMSettings);
            }
        }
        if (this.isVxRail) {
            this.displayVxRailSection(division, vMSettings);
        }
        if (this.isNutanixAHV || this.isNutanixESXi) {
            this.displayAfsShutdownSection(division, vMSettings);
            this.displayProtectionDomainSettingsSection(division, vMSettings);
            this.displayClusterShutdownSection(division, vMSettings);
            this.displayCvmShutdownSection(division, vMSettings);
        } else if (this.isSimplivity) {
            this.displayOvcShutdownSection(division, vMSettings);
        } else if (this.isHyperflex) {
            this.displayClusterShutdownSection(division, vMSettings);
            this.displayCvmShutdownSection(division, vMSettings);
        }
    }

    private void displayVxRailSection(Division division, VMSettings vMSettings) {
        Heading heading = Heading.h3();
        heading.add(new Text(this.resMap.get(VXRAIL_HEADER)));
        ApcHelp apcHelp = new ApcHelp();
        apcHelp.setHelpId(ApcHelp.CLUSTER_SHUTDOWN_STARTUP_VXRAIL);
        heading.add(apcHelp);
        division.add(heading);
        Division division2 = new Division();
        division.add(division2);
        division2.add(FormHelper.createLabelTextInputValueDiv("vxRailShutdownDelayDiv", this.resMap.get(SHUTDOWN_DELAY_LABEL), String.valueOf(vMSettings.getVxRailShutdownDelay()), null, PARAM_VXRAIL_SHUTDOWN_DELAY, null, (Integer)6, null, this.resMap.get(kSecondsUnitLabel), this.resMap.get(SHUTDOWN_DELAY_TOOLTIP)));
        division2.add(FormHelper.createLabelTextInputValueDiv("vxRailShutdownDurationDiv", this.resMap.get(SHUTDOWN_DURATION_LABEL), String.valueOf(vMSettings.getVxRailShutdownDuration()), null, PARAM_VXRAIL_SHUTDOWN_DURATION, null, (Integer)6, null, this.resMap.get(kSecondsUnitLabel), this.resMap.get(SHUTDOWN_DURATION_TOOLTIP)));
    }

    private void displayOvcShutdownSection(Division division, VMSettings vMSettings) {
        Heading heading = Heading.h3();
        heading.add(new Text(this.resMap.get(KOVCSHUTDOWNHEADER)));
        ApcHelp apcHelp = new ApcHelp();
        apcHelp.setHelpId(ApcHelp.OMNISTACK_VIRTUAL_CONTROLLER_SHUTDOWN_STARTUP);
        heading.add(apcHelp);
        division.add(heading);
        Division division2 = new Division();
        division.add(division2);
        division2.add(FormHelper.createLabelTextInputValueDiv("ovcShutdownDurationDiv", this.resMap.get(kShutdownDurationLabel), Integer.valueOf(vMSettings.getOvcShutdownDuration()).toString(), null, PARAM_OVC_SHUTDOWN_DURATION, null, (Integer)6, null, this.resMap.get(kSecondsUnitLabel), this.resMap.get(KOVCSHUTDOWNDURATIONNOTE)));
        division2.add(FormHelper.createLabelCheckboxValueDiv("ovcStartupEnableDiv", this.resMap.get(KOVCSTARTUPENABLELABEL), vMSettings.isOvcStartupEnable(), "ovcstartupcheckbox", PARAM_OVC_STARTUP_ENABLE, this.resMap.get(KOVCSTARTUPENABLENOTE)));
        division2.add(FormHelper.createLabelTextInputValueDiv("ovcStartupDurationDiv", this.resMap.get(kStartupDurationLabel), Integer.valueOf(vMSettings.getOvcStartupDuration()).toString(), null, PARAM_OVC_STARTUP_DURATION, null, (Integer)6, null, this.resMap.get(kSecondsUnitLabel), this.resMap.get(KOVCSTARTUPDURATIONNOTE)));
    }

    private void displayCvmShutdownSection(Division division, VMSettings vMSettings) {
        Heading heading = Heading.h3();
        heading.add(new Text(this.resMap.get(kCvmShutdownHeader)));
        ApcHelp apcHelp = new ApcHelp();
        apcHelp.setHelpId(this.getCvmShutdownHelpId());
        heading.add(apcHelp);
        division.add(heading);
        Division division2 = new Division();
        division.add(division2);
        division2.add(FormHelper.createLabelTextInputValueDiv("cvmShutdownDurationDiv", this.resMap.get(kShutdownDurationLabel), Integer.valueOf(vMSettings.getCvmShutdownDuration()).toString(), null, PARAM_CVM_SHUTDOWN_DURATION, null, (Integer)6, null, this.resMap.get(kSecondsUnitLabel), this.resMap.get(kCvmShutdownDurationNote)));
        division2.add(FormHelper.createLabelCheckboxValueDiv("cvmStartupEnableDiv", this.resMap.get(kCvmStartupEnableLabel), vMSettings.isCvmStartupEnable(), "cvmstartupcheckbox", PARAM_CVM_STARTUP_ENABLE, this.resMap.get(kCvmStartupEnableNote)));
        division2.add(FormHelper.createLabelTextInputValueDiv("cvmStartupDurationDiv", this.resMap.get(kStartupDurationLabel), Integer.valueOf(vMSettings.getCvmStartupDuration()).toString(), null, PARAM_CVM_STARTUP_DURATION, null, (Integer)6, null, this.resMap.get(kSecondsUnitLabel), this.resMap.get(kCvmStartupDurationNote)));
    }

    private void displayAfsShutdownSection(Division division, VMSettings vMSettings) {
        Heading heading = Heading.h3();
        heading.add(new Text(this.resMap.get(kAfsShutdownHeader)));
        ApcHelp apcHelp = new ApcHelp();
        apcHelp.setHelpId(this.isNutanixAHV ? ApcHelp.AFS_SHUTDOWN_STARTUP_AHV : ApcHelp.AFS_SHUTDOWN_STARTUP_ESXI);
        heading.add(apcHelp);
        division.add(heading);
        Division division2 = new Division();
        division.add(division2);
        division2.add(FormHelper.createWarningDivision("nutanixAFSDisabledWarning", this.resMap.get(kNutanixSettingsWarning), null));
        division2.add(FormHelper.createLabelCheckboxValueDiv("afsShutdownEnableDiv", this.resMap.get(kAfsShutdownEnableLabel), vMSettings.isAfsShutdownEnable(), "afsshutdowncheckbox", PARAM_AFS_SHUTDOWN_ENABLE, this.resMap.get(kAfsShutdownEnableNote)));
        division2.add(FormHelper.createLabelTextInputValueDiv("afsShutdownDurationDiv", this.resMap.get(kShutdownDurationLabel), Integer.valueOf(vMSettings.getAfsShutdownDuration()).toString(), null, PARAM_AFS_SHUTDOWN_DURATION, null, (Integer)6, null, this.resMap.get(kSecondsUnitLabel), this.resMap.get(kAfsShutdownDurationNote)));
        division2.add(FormHelper.createLabelCheckboxValueDiv("afsStartupEnableDiv", this.resMap.get(kAfsStartupEnableLabel), vMSettings.isAfsStartupEnable(), "afsstartupcheckbox", PARAM_AFS_STARTUP_ENABLE, this.resMap.get(kAfsStartupEnableNote)));
        division2.add(FormHelper.createLabelTextInputValueDiv("afsStartupDurationDiv", this.resMap.get(kStartupDurationLabel), Integer.valueOf(vMSettings.getAfsStartupDuration()).toString(), null, PARAM_AFS_STARTUP_DURATION, null, (Integer)6, null, this.resMap.get(kSecondsUnitLabel), this.resMap.get(kAfsStartupDurationNote)));
    }

    private void displayProtectionDomainSettingsSection(Division division, VMSettings vMSettings) {
        Heading heading = Heading.h3();
        heading.add(new Text(this.resMap.get(kProtectionDomainHeader)));
        ApcHelp apcHelp = new ApcHelp();
        apcHelp.setHelpId(this.isNutanixAHV ? ApcHelp.PROTECTION_DOMAIN_SETTINGS_AHV : ApcHelp.PROTECTION_DOMAIN_SETTINGS_ESXI);
        heading.add(apcHelp);
        division.add(heading);
        Division division2 = new Division();
        division.add(division2);
        division2.add(FormHelper.createWarningDivision("nutanixPDDisabledWarning", this.resMap.get(kNutanixSettingsWarning), null));
        division2.add(FormHelper.createLabelCheckboxValueDiv("ongoingReplicationAbortDelayEnableDiv", this.resMap.get(kOngoingReplicationAbortDelayLabel), vMSettings.isOngoingReplicationAbortDelayEnable(), "ongoingreplicationabortdelaycheckbox", PARAM_ONGOING_REPLICATION_ABORT_DELAY_ENABLE, this.resMap.get(kOngoingReplicationDelayEnableNote)));
        division2.add(FormHelper.createLabelTextInputValueDiv("ongoingReplicationAbortDelayDurationDiv", this.resMap.get(kDurationLabel), Integer.valueOf(vMSettings.getOngoingReplicationAbortDelayDuration()).toString(), null, PARAM_ONGOING_REPLICATION_ABORT_DELAY_DURATION, null, (Integer)6, null, this.resMap.get(kSecondsUnitLabel), this.resMap.get(kOngoingReplicationDelayDurationNote)));
        if (this.services.getVirtualConfigurationManager().isNutanixESXi()) {
            division2.add(FormHelper.createLabelCheckboxValueDiv("metroAvailDisableDiv", this.resMap.get(kMetroAvailDisableLabel), vMSettings.isMetroAvailDisabled(), "metroavaildisablecheckbox", PARAM_METRO_AVAIL_DISABLE, this.resMap.get(kMetroAvailDisableNote)));
        }
    }

    private void displayClusterShutdownSection(Division division, VMSettings vMSettings) {
        Heading heading = Heading.h3();
        heading.add(new Text(this.resMap.get(kClusterShutdownHeader)));
        ApcHelp apcHelp = new ApcHelp();
        apcHelp.setHelpId(this.getCluserShutdownHelpId());
        heading.add(apcHelp);
        division.add(heading);
        Division division2 = new Division();
        division.add(division2);
        division2.add(FormHelper.createLabelTextInputValueDiv("clusterShutdownDurationDiv", this.resMap.get(kShutdownDurationLabel), Integer.valueOf(vMSettings.getClusterShutdownDuration()).toString(), null, PARAM_CLUSTER_SHUTDOWN_DURATION, null, (Integer)6, null, this.resMap.get(kSecondsUnitLabel), this.resMap.get(kClusterShutdownDurationNote)));
        division2.add(FormHelper.createLabelTextInputValueDiv("clusterStartupDurationDiv", this.resMap.get(kStartupDurationLabel), Integer.valueOf(vMSettings.getClusterStartupDuration()).toString(), null, PARAM_CLUSTER_STARTUP_DURATION, null, (Integer)6, null, this.resMap.get(kSecondsUnitLabel), this.resMap.get(kClusterStartupDurationNote)));
    }

    private void displayClusterStopSection(Division division, VMSettings vMSettings, Locale locale) {
        logger.debug("displayStopClusterSection");
        Heading heading = Heading.h3();
        heading.add(new Text(this.resMap.get(kHVStopClusterHeader)));
        ApcHelp apcHelp = new ApcHelp();
        apcHelp.setHelpId(ApcHelp.HYPER_V_CLUSTER_CONFIGURATION);
        heading.add(apcHelp);
        division.add(heading);
        Division division2 = new Division();
        division.add(division2);
        division2.add(FormHelper.createLabelCheckboxValueDiv(null, this.resMap.get(kHVStopClusterEnabledLabel), vMSettings.isHVStopClusterEnabled(), "hvstopclustercheckbox", PARAM_HVSTOPCLUSTER_ENABLED, this.resMap.get(kHVStopClusterNote)));
        division2.add(FormHelper.createLabelTextInputValueDiv("hvstopclusterDurationDiv", this.resMap.get(kShutdownDurationLabel), Integer.valueOf(vMSettings.getHVStopClusterDuration()).toString(), null, PARAM_HVSTOPCLUSTER_DURATION, null, (Integer)6, null, this.resMap.get(kSecondsUnitLabel), this.resMap.get(kTimeoutForHVStopClusterNote)));
        division2.add(FormHelper.createLabelTextInputValueDiv("hvstartclusterDurationDiv", this.resMap.get(kStartupDurationLabel), Integer.valueOf(vMSettings.getHVStartClusterDuration()).toString(), null, PARAM_HVSTARTCLUSTER_DURATION, null, (Integer)6, null, this.resMap.get(kSecondsUnitLabel), null));
    }

    private void displayVMMigrationSection(Division division, VMSettings vMSettings, boolean bl, boolean bl2, boolean bl3, Locale locale, boolean bl4, Integer n) {
        logger.debug("displayVMMigrationSection");
        boolean bl5 = this.services.getVirtualConfigurationManager().isHyperV();
        boolean bl6 = this.services.getHostSystemUtils().isVCenterManagedAdvancedMode();
        Heading heading = Heading.h3();
        heading.add(new Text(this.resMap.get(kVMMigrationHeader)));
        ApcHelp apcHelp = new ApcHelp();
        if (bl5) {
            apcHelp.setHelpId(ApcHelp.VIRTUAL_MACHINE_MIGRATION1);
        } else {
            apcHelp.setHelpId(ApcHelp.VIRTUAL_MACHINE_MIGRATION);
        }
        heading.add(apcHelp);
        heading.setCssClass("vmMigrationDiv");
        division.add(heading);
        Division division2 = new Division();
        division.add(division2);
        if (!bl5) {
            if (bl2 && !bl3 && !this.isVxRail && !this.isNutanixESXi && this.services.getHostSystemUtils().isDRSFullyAuto(n).booleanValue()) {
                logger.debug("displayVMMigrationSection() - DRS set to fully automatic, setting VM Migration enabled to true");
                vMSettings.setGuestVMMigrationEnabled(true);
            }
            division2.add(FormHelper.createErrorDivision("vmmigrationWarn", this.resMap.get(kVMMigrateDDFWarning), null));
        }
        division2.add(FormHelper.createLabelCheckboxValueDiv(null, this.resMap.get(kVMMigrationEnabledLabel), vMSettings.isGuestVMMigrationEnabled(), "vmmigrationcheckbox", PARAM_VMMIGRATION_ENABLED, this.resMap.get(kGuestVMMigrationNote)));
        if (bl4) {
            this.createReadOnlyDurationDiv(division2, VMOperations.MIGRATION);
        } else {
            division2.add(FormHelper.createLabelTextInputValueDiv("vmmigrationDurationDiv", this.resMap.get(kDurationLabel), Integer.valueOf(vMSettings.getGuestVMMigrationDuration()).toString(), null, PARAM_VMMIGRATION_DURATION, null, (Integer)6, null, this.resMap.get(kSecondsUnitLabel), this.resMap.get(kTimeoutForGuestVMMigrationNote)));
        }
        if (!bl6 || !bl && !bl2) {
            Object object;
            String string = null;
            if (!bl5) {
                string = this.resMap.get(kVMMigrationTargetEnabledTooltip);
            }
            division2.add(FormHelper.createLabelCheckboxValueDiv("theVMMigrationTargetEnabledDiv", this.resMap.get(kVMMigrationTargetEnabledLabel), vMSettings.isGuestVMMigrationTargetEnabled(), "vmmigrationtargetcheckbox", PARAM_VMMIGRATION_TARGET_ENABLED, string));
            Division division3 = new Division();
            division3.setId("hostListsContainer");
            if (bl5) {
                object = new TargetHostSelectionHelper(vMSettings.getMigrationTargetHosts(), true, false, this.services);
                ((InventoryTreeHelper)object).initialize();
                Division division4 = new Division();
                division4.setId("multitree");
                ((InventoryTreeHelper)object).displayHostTree(division4);
                ((TargetHostSelectionHelper)object).displayTargetHostTree(division4, false);
                ((InventoryTreeHelper)object).displayButton(division4, "deletebtn", this.resMap.get(kRemoveButton));
                division3.add(division4);
            } else {
                object = new HostSelectionHTMLHelper(locale, true, true, this.services);
                ((HostSelectionHTMLHelper)object).createConnectionWaitHTML(division2);
            }
            division2.add(division3);
            object = new Division();
            ((HTMLTagWithClassStyle)object).setId("res");
            ((HTMLTagWithClassStyle)object).setAttribute("data-ismainui", String.valueOf(true));
            ((HTMLTagWithClassStyle)object).setAttribute("data-isvmsettings", String.valueOf(true));
            division2.add((HTML)object);
        }
    }

    private void createReadOnlyDurationDiv(Container container, VMOperations vMOperations) {
        String string = "";
        String string2 = kDurationLabel;
        VMPrioritizationDurations vMPrioritizationDurations = null;
        switch (vMOperations) {
            case MIGRATION: {
                vMPrioritizationDurations = this.services.getVMPrioritizationUtils().readVMPrioritizationDurationsFromConfig(VMOperations.MIGRATION);
                string = "vmmigrationDurationDiv";
                break;
            }
            case SHUTDOWN: {
                vMPrioritizationDurations = this.services.getVMPrioritizationUtils().readVMPrioritizationDurationsFromConfig(VMOperations.SHUTDOWN);
                string = "vmshutdownDurationDiv";
                string2 = this.services.getVirtualConfigurationManager().isNutanixAHV() ? kVmShutdownDurationLabel : kShutdownDurationLabel;
                break;
            }
            case STARTUP: {
                vMPrioritizationDurations = this.services.getVMPrioritizationUtils().readVMPrioritizationDurationsFromConfig(VMOperations.STARTUP);
                string = "vmstartupDurationDiv";
                string2 = kStartupDurationLabel;
            }
        }
        if (vMPrioritizationDurations != null) {
            container.add(FormHelper.createLabelValueDiv(string, this.resMap.get(string2), String.valueOf(vMPrioritizationDurations.getTotalDuration()), this.resMap.get(kSecondsUnitLabel)));
        }
    }

    private void displayVMStartupSection(Division division, VMSettings vMSettings, boolean bl) {
        String string;
        Heading heading = Heading.h3();
        boolean bl2 = this.isNutanixAHV || this.isHyperV;
        String string2 = bl2 ? kVMStartupHeader : kVMVappStartupHeader;
        heading.add(new Text(this.resMap.get(string2)));
        ApcHelp apcHelp = new ApcHelp();
        if (this.services.getVirtualConfigurationManager().isHyperV()) {
            apcHelp.setHelpId(ApcHelp.VIRTUAL_MACHINE_SHUTDOWN_STARTUP_HYPERV);
        } else if (this.isNutanixAHV) {
            apcHelp.setHelpId(ApcHelp.NUTANIX_VIRTUAL_MACHINE_SHUTDOWN_STARTUP);
        } else {
            apcHelp.setHelpId(ApcHelp.VM_VAPP_STARTUP_SHUTDOWN);
        }
        heading.add(apcHelp);
        heading.setCssClass("vmStartupDiv");
        division.add(heading);
        Division division2 = new Division();
        division.add(division2);
        String string3 = this.resMap.get(kGuestVMShutdownNote);
        String string4 = bl2 ? this.resMap.get(kUvmShutdownDurationNote) : this.resMap.get(kTimeoutForGuestVMShutdownNote);
        String string5 = bl2 ? this.resMap.get(kUvmStartupEnableNote) : this.resMap.get(kGuestVMStartupNote);
        String string6 = bl2 ? this.resMap.get(kUvmStartupDurationNote) : this.resMap.get(kTimeoutForGuestVMStartupNote);
        String string7 = bl2 ? kVmShutdownDurationLabel : kShutdownDurationLabel;
        String string8 = string = bl2 ? kVMStartupEnabledLabel : kVMVappStartupEnabledLabel;
        if (!this.isNutanixAHV) {
            if (this.isHyperV) {
                division2.add(FormHelper.createLabelCheckboxValueDiv(null, this.resMap.get(kVMShutdownEnabledLabel), vMSettings.isGuestVMVAppShutdownEnabled(), "vmshutdowncheckbox", PARAM_VMSHUTDOWN_ENABLED, string3));
            } else {
                division2.add(FormHelper.createLabelCheckboxValueDiv(null, this.resMap.get(kVMVAppShutdownEnabledLabel), vMSettings.isGuestVMVAppShutdownEnabled(), "vmshutdowncheckbox", PARAM_VMSHUTDOWN_ENABLED, string3));
                division2.add(FormHelper.createLabelCheckboxValueDiv("forcevappshutdownEnableDiv", this.resMap.get(kForceVAppShutdownEnabledLabel), vMSettings.isForcevAppShutdownEnabled(), "forcevappshutdowncheckbox", PARAM_FORCE_VAPPSHUTDOWN_ENABLED, this.resMap.get(kForceVAppShutdownNote)));
            }
        }
        if (bl) {
            this.createReadOnlyDurationDiv(division2, VMOperations.SHUTDOWN);
        } else {
            division2.add(FormHelper.createLabelTextInputValueDiv("vmshutdownDurationDiv", this.resMap.get(string7), String.valueOf(vMSettings.getGuestVMVappShutdownDuration()), null, PARAM_VMSHUTDOWN_DURATION, null, (Integer)6, null, this.resMap.get(kSecondsUnitLabel), string4));
        }
        division2.add(FormHelper.createLabelCheckboxValueDiv("vmstartupEnableDiv", this.resMap.get(string), vMSettings.isGuestVMVappStartupEnabled(), "vmstartupcheckbox", PARAM_VMSTARTUP_ENABLED, string5));
        if (bl) {
            this.createReadOnlyDurationDiv(division2, VMOperations.STARTUP);
        } else {
            division2.add(FormHelper.createLabelTextInputValueDiv("vmstartupDurationDiv", this.resMap.get(kStartupDurationLabel), String.valueOf(vMSettings.getGuestVMVappStartupDuration()), null, PARAM_VMSTARTUP_DURATION, null, (Integer)6, null, this.resMap.get(kSecondsUnitLabel), string6));
        }
    }

    private void displayVCSASection(Division division, VMSettings vMSettings) {
        Heading heading = Heading.h3();
        heading.add(new Text(this.resMap.get(kVCSAHeader)));
        ApcHelp apcHelp = new ApcHelp();
        apcHelp.setHelpId(ApcHelp.VCENTER_SERVER_VIRTUAL_MACHINE_SHUTDOWN);
        heading.add(apcHelp);
        division.add(heading);
        Division division2 = new Division();
        division.add(division2);
        division2.add(FormHelper.createLabelTextInputValueDiv("vcsashutdownDurationDiv", this.resMap.get(kVCSAShutdownDurationLabel), Integer.valueOf(vMSettings.getvCSAShutdownDuration()).toString(), null, PARAM_VCSASHUTDOWN_DURATION, null, (Integer)6, null, this.resMap.get(kSecondsUnitLabel), this.resMap.get(kTimeoutForVCSAShutdownNote)));
    }

    private void displayVSANFTTSettings(Division division, VMSettings vMSettings, boolean bl, boolean bl2) {
        logger.debug("displayVSANFTTSettings() - start, global: {}, wizard: {}", (Object)bl, (Object)bl2);
        Heading heading = Heading.h3();
        heading.add(new Text(this.resMap.get(kVsanHeader)));
        ApcHelp apcHelp = new ApcHelp();
        apcHelp.setHelpId(ApcHelp.VSAN_FAULT_TOLERANCE_THRESHOLD_SETTINGS);
        heading.add(apcHelp);
        division.add(heading);
        Division division2 = new Division();
        division.add(division2);
        if (this.services.getAdvancedSetupHelper().isAdvancedShutdownMode() && (bl || bl2)) {
            division2.add(FormHelper.createLabelCheckboxValueDiv("enableFTTDiv", this.resMap.get(kEnableFTTLabel), vMSettings.isFttEnabled(), "enableFTTCheckbox", PARAM_ENABLE_FTT, this.resMap.get(kEnableFTTTooltip)));
            Division division3 = new Division();
            division3.setId("hiddenValidationDiv");
            int n = 3;
            Input input = new Input();
            input.setValue(String.valueOf(n));
            input.setName("maxFTTValue");
            input.setClassName("maxFTTValue");
            division3.add(input);
            division2.add(division3);
            division2.add(FormHelper.createLabelTextInputValueDiv("fttLevelDiv", this.resMap.get(kFTTLevelLabel), String.valueOf(vMSettings.getFttLevel()), null, PARAM_VSAN_FTT_LEVEL, null, (Integer)6, null, null, this.resMap.get(kFTTLevelTooltip)));
            division2.add(FormHelper.createLabelCheckboxValueDiv("shutdownAllClusterVMsDiv", this.resMap.get(kShutdownAllClusterVMsLabel), vMSettings.isShutdownAllClusterVMsEnabled(), "shutdownAllClusterVMsCheckbox", PARAM_SHUTDOWN_ALL_CLUSTER_VMS, this.resMap.get(kShutdownAllClusterVMsTooltip)));
        }
        division2.add(FormHelper.createLabelTextInputValueDiv("vsanSyncTimeoutDiv", this.resMap.get(kVsanSyncTimeoutLabel), String.valueOf(vMSettings.getVsanSyncTimeout()), null, PARAM_VSAN_SYNC_TIMEOUT, null, (Integer)6, null, this.resMap.get(kSecondsUnitLabel), this.resMap.get(kVsanSyncTimeoutTooltip)));
        division2.add(FormHelper.createLabelTextInputValueDiv("vsanPreparationDiv", this.resMap.get(VSAN_CLUSTER_PREPARE_LABEL), String.valueOf(vMSettings.getVsanPrepareDuration()), null, PARAM_VSAN_PREPARATION_DURATION, null, (Integer)6, null, this.resMap.get(kSecondsUnitLabel), this.resMap.get(VSAN_CLUSTER_PREPARE_TOOLTIP)));
        division2.add(FormHelper.createLabelTextInputValueDiv("vsanRecoveryDiv", this.resMap.get(VSAN_CLUSTER_RECOVERY_LABEL), String.valueOf(vMSettings.getVsanRecoveryDuration()), null, PARAM_VSAN_RECOVERY_DURATION, null, (Integer)6, null, this.resMap.get(kSecondsUnitLabel), this.resMap.get(VSAN_CLUSTER_RECOVERY_TOOLTIP)));
    }

    private void displayHostMaintenanceModeSection(Division division, VMSettings vMSettings) {
        Heading heading = Heading.h3();
        heading.add(new Text(this.resMap.get(kHostMaintModeHeader)));
        ApcHelp apcHelp = new ApcHelp();
        apcHelp.setHelpId(ApcHelp.VMWARE_HOST_MAINTENANCE_MODE);
        heading.add(apcHelp);
        division.add(heading);
        Division division2 = new Division();
        division.add(division2);
        division2.add(FormHelper.createWarningDivision("delayHostMaintModeDisabledWarning", this.resMap.get(kVMSettingsWarn), null));
        division2.add(FormHelper.createWarningDivision("enableSkipMaintModeWarning", this.resMap.get(ENABLE_SKIP_MAINTENANCE_MODE_WARNING), null));
        division2.add(FormHelper.createLabelCheckboxValueDiv("hostmaintmodeEnableDiv", this.resMap.get(kDelayHostMaintModeEnabledLabel), vMSettings.isHostMaintenanceModeDelayed(), "delayMaintModeCheckbox", PARAM_HOST_MAINTENANCE_DELAY_ENABLED, this.resMap.get(kDelayHostMaintenanceMode)));
        division2.add(FormHelper.createLabelTextInputValueDiv("hostMaintModeDurationDiv", this.resMap.get(kTimeoutForHostMaintMode), Integer.valueOf(vMSettings.getHostMaintenanceModeTimeout()).toString(), null, PARAM_HOST_MAINTENANCE_DELAY_TIMEOUT, null, (Integer)6, null, this.resMap.get(kSecondsUnitLabel), this.resMap.get(kTimeoutForHostMaintMode)));
        division2.add(FormHelper.createLabelCheckboxValueDiv("skiphostmaintmodeDiv", this.resMap.get(kSkipHostMaintModeEnabledLabel), vMSettings.isSkipMaintenanceModeEnabled(), "skipMaintModeCheckbox", PARAM_SKIP_HOST_MAINTENANCE_ENABLED, this.resMap.get(kSkipHostMaintenanceMode)));
        Division division3 = new Division();
        division3.setId("hiddenValidationDiv");
        String string = vMSettings.isVsanCluster() ? "1" : "0";
        Input input = new Input();
        input.setValue(string);
        input.setName("vsanEnabled");
        input.setId("vsanEnabled");
        division3.add(input);
        Input input2 = new Input();
        String string2 = vMSettings.isPcnsOnVSAN() ? "1" : "0";
        input2.setValue(string2);
        input2.setName("pcnsOnVSAN");
        input2.setId("pcnsOnVSAN");
        division3.add(input2);
        Input input3 = new Input();
        String string3 = this.isVxRail ? "1" : "0";
        input3.setValue(string3);
        input3.setName("vxRail");
        input3.setId("vxRail");
        division3.add(input3);
        division2.add(division3);
    }

    private void displayRetreatModeSection(Division division, VMSettings vMSettings) {
        Heading heading = Heading.h3();
        heading.add(new Text(this.resMap.get(kRetreatModeHeader)));
        ApcHelp apcHelp = new ApcHelp();
        apcHelp.setHelpId(ApcHelp.VSPHERE_CLUSTER_SERVICES);
        heading.add(apcHelp);
        division.add(heading);
        Division division2 = new Division();
        division2.add(FormHelper.createLabelTextInputValueDiv("enableRetreatModeDurationForm", this.resMap.get(kEnablingRetreatModeDuration), Integer.valueOf(vMSettings.getDisableVClsDelay()).toString(), null, PARAM_ENABLE_RETREAT_MODE_DURATION, null, (Integer)6, null, this.resMap.get(kSecondsUnitLabel), this.resMap.get(kEnableRetreatModeDurationNote)));
        division2.add(FormHelper.createLabelTextInputValueDiv("disableRetreatModeDurationForm", this.resMap.get(kDisablingRetreatModeDuration), Integer.valueOf(vMSettings.getEnableVClsDelay()).toString(), null, PARAM_DISABLE_RETREAT_MODE_DURATION, null, (Integer)6, null, this.resMap.get(kSecondsUnitLabel), this.resMap.get(kDisableRetreatModeDurationNote)));
        division.add(division2);
    }

    private void displayHASection(Division division, VMSettings vMSettings) {
        Heading heading = Heading.h3();
        heading.add(new Text(this.resMap.get(kHAHeader)));
        ApcHelp apcHelp = new ApcHelp();
        apcHelp.setHelpId(ApcHelp.VMWARE_HA_MODE);
        heading.add(apcHelp);
        division.add(heading);
        Division division2 = new Division();
        division2.add(FormHelper.createLabelCheckboxValueDiv("disableHAForm", this.resMap.get(kHACheckbox), vMSettings.isDisableHAMode(), "haCheckbox", PARAM_DISABLE_HA, this.resMap.get(kHANote)));
        division2.add(FormHelper.createLabelTextInputValueDiv("disableHADurationForm", this.resMap.get(kDisableHADuration), Integer.valueOf(vMSettings.getDisableHADelay()).toString(), null, PARAM_DISABLE_HA_DURATION, null, (Integer)6, null, this.resMap.get(kSecondsUnitLabel), this.resMap.get(kDisableHADurationNote)));
        division2.add(FormHelper.createLabelTextInputValueDiv("enableHADurationForm", this.resMap.get(kEnableHADuration), Integer.valueOf(vMSettings.getEnableHADelay()).toString(), null, PARAM_ENABLE_HA_DURATION, null, (Integer)6, null, this.resMap.get(kSecondsUnitLabel), this.resMap.get(kEnableHADurationNote)));
        division.add(division2);
    }

    private Division createShutdownSettingsResourceStrings() {
        Division division = new Division();
        division.setId("jsres");
        Span span = new Span(this.resMap.get(kRequiredField));
        span.setId("resRequiredFieldValidation");
        division.add(span);
        span = new Span(this.resMap.get(kRangeValidation));
        span.setId("resRangeValidation");
        division.add(span);
        span = new Span(this.resMap.get(kDigitsValidation));
        span.setId("resDigitsValidation");
        division.add(span);
        span = new Span(this.resMap.get(kMultipleSelection));
        span.setId("res_multiple_selection");
        division.add(span);
        return division;
    }

    private InventoryTreeHelper getInventoryTreeHelper(PageContext pageContext) {
        if (this.services.getAdvancedSetupHelper().isAdvancedShutdownMode()) {
            HostNMCMappingHelper hostNMCMappingHelper = new HostNMCMappingHelper(this.services.getAdvancedSetupHelper().readUPSSetupsFromConfig(), Utils.getNMCList(pageContext, true, true), this.services.getAdvancedSetupHelper().readMappedHostsFromConfig(), this.services);
            hostNMCMappingHelper.initialize();
            return hostNMCMappingHelper;
        }
        return new TargetHostSelectionHelper(this.services.getVirtualConfigurationManager().parseHostListParameter("HostConfigSettings"), true, true, this.services);
    }

    public void createSCVMMVMSettings(Container container, VMSettings vMSettings, boolean bl, boolean bl2, PageContext pageContext) {
        Object object;
        Division division = new Division();
        division.setId("errorcontainer");
        division.add(new Text(this.resMap.get(kVMSettingsError)));
        division.setCssClass("ui-state-error ui-corner-all");
        container.add(division);
        Division division2 = FormHelper.createLabelCheckboxValueDiv("hostMaintenanceLabel", this.resMap.get(kEnableHostMaintenance), vMSettings.getHostMaintenanceEnabled(), PARAM_HOST_MAINTENANCE_ENABLED, PARAM_HOST_MAINTENANCE_ENABLED, this.resMap.get(kEnableHostMaintenance));
        division2.setCssClass("labelvaluediv row");
        container.add(division2);
        Division division3 = FormHelper.createLabelTextInputValueDiv("hostMaintenanceDurationDiv", this.resMap.get(kHostMaintenanceDuration), String.valueOf(vMSettings.getHostMaintenanceDuration()), null, PARAM_HOST_MAINTENANCE_DURATION, null, (Integer)6, null, this.resMap.get(kSecondsUnitLabel), this.resMap.get(kHostMaintenanceDurationNote));
        division3.setCssClass("labelvaluediv row");
        container.add(division3);
        String string = this.services.getVirtualConfigurationManager().getSCVVMMVersion();
        String string2 = "2008";
        boolean bl3 = true;
        if (!string2.equalsIgnoreCase(string)) {
            object = this.getInventoryTreeHelper(pageContext);
            if (object != null) {
                ((InventoryTreeHelper)object).refreshMappedHosts();
                if (!((InventoryTreeHelper)object).isBMCEnabledForAnyMappedHosts()) {
                    bl3 = false;
                }
            }
            if (bl3) {
                Division division4 = FormHelper.createLabelCheckboxValueDiv("hostShutdownLabel", this.resMap.get(kEnableHostShutdown), vMSettings.getHostShutdownEnabled(), PARAM_HOST_SHUTDOWN_ENABLED, PARAM_HOST_SHUTDOWN_ENABLED, this.resMap.get(kEnableHostShutdown));
                division4.setCssClass("labelvaluediv row");
                container.add(division4);
                Division division5 = FormHelper.createLabelTextInputValueDiv("hostShutdownDurationDiv", this.resMap.get(kHostShutdownDuration), String.valueOf(vMSettings.getHostShutdownDuration()), null, PARAM_HOST_SHUTDOWN_DURATION, null, (Integer)6, null, this.resMap.get(kSecondsUnitLabel), this.resMap.get(kHostShutdownDurationNote));
                division5.setCssClass("labelvaluediv row");
                container.add(division5);
            }
        }
        pageContext.getSession().setAttribute(PARAM_DISPLAY_HOST_SHUTDOWN_OPTION, (Object)bl3);
        if (bl) {
            object = new Input();
            ((Input)object).setName(PARAM_VMSETTINGS_HIDDEN_INPUT);
            ((Input)object).setId(PARAM_VMSETTINGS_HIDDEN_INPUT);
            ((Input)object).setType("hidden");
            ((Input)object).setValue("X");
            container.add((HTML)object);
        } else if (bl2 && this.services.getAdvancedSetupHelper().isAdvancedShutdownMode()) {
            object = FormHelper.createLabelCheckboxValueDiv("ApplyToAllCardsLabel", this.resMap.get(kApplyGlobalVMSettings), vMSettings.isApplySettingsToAllGroups(), PARAM_APPLY_GLOBAL_VMSETTINGS, PARAM_APPLY_GLOBAL_VMSETTINGS, this.resMap.get(kApplyGlobalVMSettings));
            ((HTMLTagWithClassStyle)object).setCssClass("labelvaluediv row");
            container.add((HTML)object);
        }
        container.add(this.createShutdownSettingsResourceStrings());
    }

    private Integer getCluserShutdownHelpId() {
        if (this.isNutanixAHV) {
            return ApcHelp.CLUSTER_SHUTDOWN_STARTUP_AHV;
        }
        if (this.isNutanixESXi) {
            return ApcHelp.CLUSTER_SHUTDOWN_STARTUP_ESXI;
        }
        if (this.isHyperflex) {
            return ApcHelp.CLUSTER_SHUTDOWN_STARTUP;
        }
        return ApcHelp.CLUSTER_SHUTDOWN_STARTUP;
    }

    private Integer getCvmShutdownHelpId() {
        if (this.isNutanixAHV) {
            return ApcHelp.CVM_SHUTDOWN_STARTUP_AHV;
        }
        if (this.isNutanixESXi) {
            return ApcHelp.CVM_SHUTDOWN_STARTUP_ESXI;
        }
        if (this.isHyperflex) {
            return ApcHelp.CONTROLLER_VM_SHUTDOWN_STARTUP;
        }
        if (this.isSimplivity) {
            return ApcHelp.OMNISTACK_VIRTUAL_CONTROLLER_SHUTDOWN_STARTUP;
        }
        return ApcHelp.CONTROLLER_VM_SHUTDOWN_STARTUP;
    }
}

