/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.util;

import com.apcc.m11.components.webserver.html.Container;
import com.apcc.m11.components.webserver.html.HTML;
import com.apcc.m11.components.webserver.html.HTMLTagWithClassStyle;
import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.html.Text;
import com.apcc.m11.components.webserver.html.document.Division;
import com.apcc.m11.components.webserver.html.document.Span;
import com.apcc.m11.components.webserver.html.form.Option;
import com.apcc.m11.components.webserver.util.FormHelper;
import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.m11.components.webserver.util.virtualization.vmware.VMWareDetails;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.configservice.VirtualConfigurationManager;
import com.apcc.pcns.configservice.validation.InetAddressValidator;
import com.apcc.pcns.configservice.validation.IntRangeSetValidator;
import com.apcc.pcns.userinterface.HyperconvergedSupport;
import com.apcc.pcns.util.ResourceBundleWrapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import lombok.NonNull;
import org.springframework.lang.Nullable;

public class VMWareHTMLHelper {
    private static final String HIDDEN = "hidden";
    public static final String kVCenterHeaderId = "Configure.VCenterHeader";
    private String theVCenterProtocolLabel;
    private String theVCenterPortLabel;
    private String theVCenterIPLabel;
    public static final String VCENTER_PROTOCOL = "vcenter_server_protocol";
    public static final String VCENTER_PORT = "vcenter_server_port";
    public static final String VCENTER_IP = "vcenter_server_ip";
    public static final String VCENTER_USERNAME = "vcenter_server_username";
    public static final String VCENTER_PASSWORD = "vcenter_server_password";
    public static final String IS_VCSA = "vcenter_installed_on_vm";
    public static final String HYPERCONVERGED_SUPPORT = "hyperconverged_support";
    public static final String ESXI_PROTOCOL = "esxi_host_protocol";
    public static final String ESXI_PORT = "esxi_host_port";
    public static final String ESXI_IP = "esxi_host_ip";
    public static final String ESXI_USERNAME = "esxi_host_username";
    public static final String ESXI_PASSWORD = "esxi_host_password";
    public String kAttemptVCenterServerConnection = "CfgWizard.VCenterServerDetails.AttemptVCenterServerConnection";
    public String kVCenterServerNetworkError = "CfgWizard.VCenterServerDetails.VCenterServerNetworkError";
    private String kVCenterServerError = "Configure.VCenterServerError";
    private static final String kvCenterIPLabel = "CfgWizard.VCenterServerDetails.vCenterIPLabel";
    private static final String kvCenterIPNote = "CfgWizard.VCenterServerDetails.vCenterIPNote";
    private static final String kvCenterIPValidation = "CfgWizard.VCenterServerDetails.vCenterIPValidationNote";
    private static final String kvCenterUsernameLabel = "CfgWizard.VCenterServerDetails.vCenterUsernameLabel";
    private static final String kvCenterUsernameNote = "CfgWizard.VCenterServerDetails.vCenterUsernameNote";
    private static final String kvCenterUsernameValidation = "CfgWizard.VCenterServerDetails.vCenterUsernameValidationNote";
    private static final String kvCenterPasswordLabel = "CfgWizard.VCenterServerDetails.vCenterPasswordLabel";
    private static final String kvCenterPasswordNote = "CfgWizard.VCenterServerDetails.vCenterPasswordNote";
    private static final String kvCenterPasswordValidation = "CfgWizard.VCenterServerDetails.vCenterPasswordValidationNote";
    private static final String kvCenterProtocolLabel = "CfgWizard.VCenterServerDetails.vCenterProtocolLabel";
    private static final String kvCenterPortLabel = "CfgWizard.VCenterServerDetails.vCenterPortLabel";
    private static final String kvCenterPortNote = "CfgWizard.VCenterServerDetails.vCenterPortNote";
    private static final String kvCenterProtocolValidation = "CfgWizard.VCenterServerDetails.vCenterProtocolValidationNote";
    private static final String kvCenterPortValidation = "CfgWizard.VCenterServerDetails.vCenterPortValidationNote";
    private static final String kInvalidCredentials = "CfgWizard.VCenterServerDetails.VCenterServerInvalidCredentials";
    private static final String kNetworkError = "CfgWizard.VCenterServerDetails.VCenterServerNetworkError";
    private static final String kVCenterInstalledOnaVMLabel = "CfgWizard.VCenterServerDetails.VCenterServerInstalledOnaVM";
    private static final String kNutanixSupportLabel = "CfgWizard.VCenterServerDetails.NutanixSupport";
    private static final String kNutanixSupportNote = "CfgWizard.VCenterServerDetails.NutanixSupportNote";
    private static final String HYPERCONVERGED_SUPPORT_LABEL = "CfgWizard.Hyperconverged.Label";
    public static final String kRequiredId = "PCNS.RequiredField";
    public static final String kVSpherePluginName = "VSpherePluginName";
    public static final String kVSphereWebPluginName = "VSphereWebPluginName";
    public static final String KVCenterPluginNote = "VMSettings.VCenterPluginNote";
    public static final String kVCenterWebPluginNote = "VMSettings.VCenterWebPluginNote";
    public static final String kVSpherePlugin = "Configure.VCenterPluginLabel";
    public static final String kVSphereWebPlugin = "VMSettings.VCenterWebPluginLabel";
    public static final String kInvalidIpId = "PCNS.VcenterServerValidation";
    private static final String kRangeValidation = "PCNS.RangeValidation";
    private static final String kChangePasswordText = "PCNS.ChangePasswordText";
    private static final String kConfigureESXiProtocolLabel = "Configure.ESXiHostServerProtocol";
    private static final String kConfigureESXiPortLabel = "Configure.ESXiHostServerPort";
    private static final String kConfigureESXiIpLabel = "Configure.ESXiHostServerIP";
    private static final String kConfigureESXiUsernameLabel = "Configure.ESXiHostUserName";
    private static final String kConfigureESXiPasswordLabel = "Configure.ESXiHostPassword";
    private static final String kESXiIPLabel = "CfgWizard.ESXiHostDetails.ESXiIPLabel";
    private static final String kESXiIPNote = "CfgWizard.ESXiHostDetails.ESXiIPNote";
    private static final String kESXiUsernameLabel = "CfgWizard.ESXiHostDetails.ESXiUsernameLabel";
    private static final String kESXiUsernameNote = "CfgWizard.ESXiHostDetails.ESXiUsernameNote";
    private static final String kESXiUsernameValidation = "CfgWizard.ESXiHostDetails.ESXiUsernameValidationNote";
    private static final String kESXiPasswordLabel = "CfgWizard.ESXiHostDetails.ESXiPasswordLabel";
    private static final String kESXiPasswordNote = "CfgWizard.ESXiHostDetails.ESXiPasswordNote";
    private static final String kESXiPasswordValidation = "CfgWizard.ESXiHostDetails.ESXiPasswordValidationNote";
    private static final String kAttemptESXiServerConnection = "CfgWizard.ESXiHostDetails.AttemptESXiServerConnection";
    private static final String kESXiHostNetworkError = "CfgWizard.ESXiHostDetails.ESXiServerNetworkError";
    private static final String kESXiProtocolLabel = "CfgWizard.ESXiHostDetails.ESXiProtocolLabel";
    private static final String kESXiPortLabel = "CfgWizard.ESXiHostDetails.ESXiPortLabel";
    private static final String kHiddenPasswordId = "PCNS.HiddenPassword";
    private static final String kESXiHostError = "Configure.ESXiHostError";
    public static final String kVCenterInstalledOnaVMNote = "CfgWizard.VCenterServerDetails.VCenterServerInstalledOnaVMNote";
    private static final String NO_HYPERCONVERED_SUPPORT = "CfgWizard.Hyperconverged.NoSupport";
    private static final String HYPERCONVERGED_NUTANIX_LABEL = "CfgWizard.Hyperconverged.Nutanix";
    private static final String HYPERCONVERGED_SIMPLIVITY_LABEL = "CfgWizard.Hyperconverged.Simplivity";
    private static final String HYPERCONVERGED_HYPERFLEX_LABEL = "CfgWizard.Hyperconverged.Hyperflex";
    private static final String HYPERCONVERGED_VXRAIL_LABEL = "CfgWizard.Hyperconverged.Vxrail";
    private static final String UNTRUSTED_CERT_WARNING = "Configure.UntrustedCertWarning";
    public String theAttemptESXiServerConnection;
    private String theESXiPasswordLabel;
    private String theESXiUsernameLabel;
    private String theESXiIPLabel;
    private String theESXiNetworkError;
    private String theESXiProtocolLabel;
    private String theESXiPortLabel;
    private String theInvalidIpText;
    private String theRequiredText;
    private String theInvalidCredentials;
    private String theAttemptVCenterServerConnection;
    private String thevCenterPasswordLabel;
    private String thevCenterUsernameLabel;
    private Map<String, String> resMap = new HashMap<String, String>();
    private ServiceManager services;

    public VMWareHTMLHelper(Locale locale, @NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("sm is marked non-null but is null");
        }
        this.services = serviceManager;
        this.getVMSettingsResourceStrings(locale);
    }

    private void getVMSettingsResourceStrings(Locale locale) {
        ResourceBundleWrapper resourceBundleWrapper = Utils.getWebServerResourceBundle(locale);
        this.resMap.put(kVCenterHeaderId, Utils.getResourceString(resourceBundleWrapper, kVCenterHeaderId));
        this.resMap.put(kRequiredId, Utils.getResourceString(resourceBundleWrapper, kRequiredId));
        this.resMap.put(kInvalidIpId, Utils.getResourceString(resourceBundleWrapper, kInvalidIpId));
        this.resMap.put(kChangePasswordText, Utils.getResourceString(resourceBundleWrapper, kChangePasswordText));
        this.resMap.put(this.kAttemptVCenterServerConnection, Utils.getResourceString(resourceBundleWrapper, this.kAttemptVCenterServerConnection));
        this.resMap.put(this.kVCenterServerNetworkError, Utils.getResourceString(resourceBundleWrapper, this.kVCenterServerNetworkError));
        this.resMap.put(this.kVCenterServerError, Utils.getResourceString(resourceBundleWrapper, this.kVCenterServerError));
        this.resMap.put(kvCenterIPLabel, Utils.getResourceString(resourceBundleWrapper, kvCenterIPLabel));
        this.resMap.put(kvCenterIPNote, Utils.getResourceString(resourceBundleWrapper, kvCenterIPNote));
        this.resMap.put(kvCenterIPValidation, Utils.getResourceString(resourceBundleWrapper, kvCenterIPValidation));
        this.resMap.put(kvCenterUsernameLabel, Utils.getResourceString(resourceBundleWrapper, kvCenterUsernameLabel));
        this.resMap.put(kvCenterUsernameNote, Utils.getResourceString(resourceBundleWrapper, kvCenterUsernameNote));
        this.resMap.put(kvCenterUsernameValidation, Utils.getResourceString(resourceBundleWrapper, kvCenterUsernameValidation));
        this.resMap.put(kvCenterPasswordLabel, Utils.getResourceString(resourceBundleWrapper, kvCenterPasswordLabel));
        this.resMap.put(kvCenterPasswordNote, Utils.getResourceString(resourceBundleWrapper, kvCenterPasswordNote));
        this.resMap.put(kvCenterPasswordValidation, Utils.getResourceString(resourceBundleWrapper, kvCenterPasswordValidation));
        this.resMap.put(kInvalidCredentials, Utils.getResourceString(resourceBundleWrapper, kInvalidCredentials));
        this.resMap.put(kNetworkError, Utils.getResourceString(resourceBundleWrapper, kNetworkError));
        this.resMap.put(kvCenterProtocolLabel, Utils.getResourceString(resourceBundleWrapper, kvCenterProtocolLabel));
        this.resMap.put(kvCenterPortLabel, Utils.getResourceString(resourceBundleWrapper, kvCenterPortLabel));
        this.resMap.put(kvCenterPortNote, Utils.getResourceString(resourceBundleWrapper, kvCenterPortNote));
        this.resMap.put(kvCenterProtocolValidation, Utils.getResourceString(resourceBundleWrapper, kvCenterProtocolValidation));
        this.resMap.put(kvCenterPortValidation, Utils.getResourceString(resourceBundleWrapper, kvCenterPortValidation));
        this.resMap.put(kESXiIPLabel, Utils.getResourceString(resourceBundleWrapper, kESXiIPLabel));
        this.resMap.put(kESXiIPNote, Utils.getResourceString(resourceBundleWrapper, kESXiIPNote));
        this.resMap.put(kESXiUsernameLabel, Utils.getResourceString(resourceBundleWrapper, kESXiUsernameLabel));
        this.resMap.put(kESXiUsernameNote, Utils.getResourceString(resourceBundleWrapper, kESXiUsernameNote));
        this.resMap.put(kESXiUsernameValidation, Utils.getResourceString(resourceBundleWrapper, kESXiUsernameValidation));
        this.resMap.put(kESXiPasswordLabel, Utils.getResourceString(resourceBundleWrapper, kESXiPasswordLabel));
        this.resMap.put(kESXiPasswordNote, Utils.getResourceString(resourceBundleWrapper, kESXiPasswordNote));
        this.resMap.put(kESXiPasswordValidation, Utils.getResourceString(resourceBundleWrapper, kESXiPasswordValidation));
        this.resMap.put(kAttemptESXiServerConnection, Utils.getResourceString(resourceBundleWrapper, kAttemptESXiServerConnection));
        this.resMap.put(kESXiHostNetworkError, Utils.getResourceString(resourceBundleWrapper, kESXiHostNetworkError));
        this.resMap.put(kESXiProtocolLabel, Utils.getResourceString(resourceBundleWrapper, kESXiProtocolLabel));
        this.resMap.put(kESXiPortLabel, Utils.getResourceString(resourceBundleWrapper, kESXiPortLabel));
        this.resMap.put(kRangeValidation, Utils.getResourceString(resourceBundleWrapper, kRangeValidation));
        this.resMap.put(kHiddenPasswordId, Utils.getResourceString(resourceBundleWrapper, kHiddenPasswordId));
        this.resMap.put(kESXiHostError, Utils.getResourceString(resourceBundleWrapper, kESXiHostError));
        this.resMap.put(KVCenterPluginNote, Utils.getResourceString(resourceBundleWrapper, KVCenterPluginNote));
        this.resMap.put(kVCenterWebPluginNote, Utils.getResourceString(resourceBundleWrapper, kVCenterWebPluginNote));
        this.resMap.put(kVSpherePlugin, Utils.getResourceString(resourceBundleWrapper, kVSpherePlugin));
        this.resMap.put(kVSphereWebPlugin, Utils.getResourceString(resourceBundleWrapper, kVSphereWebPlugin));
        this.resMap.put(kConfigureESXiProtocolLabel, Utils.getResourceString(resourceBundleWrapper, kConfigureESXiProtocolLabel));
        this.resMap.put(kConfigureESXiPortLabel, Utils.getResourceString(resourceBundleWrapper, kConfigureESXiPortLabel));
        this.resMap.put(kConfigureESXiIpLabel, Utils.getResourceString(resourceBundleWrapper, kConfigureESXiIpLabel));
        this.resMap.put(kConfigureESXiUsernameLabel, Utils.getResourceString(resourceBundleWrapper, kConfigureESXiUsernameLabel));
        this.resMap.put(kConfigureESXiPasswordLabel, Utils.getResourceString(resourceBundleWrapper, kConfigureESXiPasswordLabel));
        this.resMap.put(kVCenterInstalledOnaVMLabel, Utils.getResourceString(resourceBundleWrapper, kVCenterInstalledOnaVMLabel));
        this.resMap.put(kVCenterInstalledOnaVMNote, Utils.getResourceString(resourceBundleWrapper, kVCenterInstalledOnaVMNote));
        this.resMap.put(kNutanixSupportLabel, Utils.getResourceString(resourceBundleWrapper, kNutanixSupportLabel));
        this.resMap.put(kNutanixSupportNote, Utils.getResourceString(resourceBundleWrapper, kNutanixSupportNote));
        this.resMap.put(NO_HYPERCONVERED_SUPPORT, Utils.getResourceString(resourceBundleWrapper, NO_HYPERCONVERED_SUPPORT));
        this.resMap.put(HYPERCONVERGED_NUTANIX_LABEL, Utils.getResourceString(resourceBundleWrapper, HYPERCONVERGED_NUTANIX_LABEL));
        this.resMap.put(HYPERCONVERGED_SIMPLIVITY_LABEL, Utils.getResourceString(resourceBundleWrapper, HYPERCONVERGED_SIMPLIVITY_LABEL));
        this.resMap.put(HYPERCONVERGED_HYPERFLEX_LABEL, Utils.getResourceString(resourceBundleWrapper, HYPERCONVERGED_HYPERFLEX_LABEL));
        this.resMap.put(HYPERCONVERGED_VXRAIL_LABEL, Utils.getResourceString(resourceBundleWrapper, HYPERCONVERGED_VXRAIL_LABEL));
        this.resMap.put(HYPERCONVERGED_SUPPORT_LABEL, Utils.getResourceString(resourceBundleWrapper, HYPERCONVERGED_SUPPORT_LABEL));
        this.resMap.put(UNTRUSTED_CERT_WARNING, Utils.getResourceString(resourceBundleWrapper, UNTRUSTED_CERT_WARNING));
    }

    private boolean isManagedHost(PageContext pageContext, boolean bl) {
        boolean bl2 = false;
        if (bl && pageContext.getSession().getAttribute("ESXIConfiguration") != null) {
            int n = (Integer)pageContext.getSession().getAttribute("ESXIConfiguration");
            if (n == 2) {
                bl2 = true;
            }
        } else {
            bl2 = this.services.getVirtualConfigurationManager().isManagedHost();
        }
        return bl2;
    }

    public void addResources(Container container, PageContext pageContext, boolean bl) {
        boolean bl2 = this.isManagedHost(pageContext, bl);
        this.theRequiredText = this.resMap.get(kRequiredId);
        Span span = new Span();
        span.add(new Text(this.theRequiredText));
        span.setId("requiredSpan");
        span.setCssClass(HIDDEN);
        container.add(span);
        this.theInvalidIpText = this.resMap.get(kInvalidIpId);
        Span span2 = new Span();
        span2.add(new Text(this.theInvalidIpText));
        span2.setId("invalidIpSpan");
        span2.setCssClass(HIDDEN);
        container.add(span2);
        Span span3 = new Span();
        span3.setId("attemptConnectionSpan");
        span3.setCssClass(HIDDEN);
        container.add(span3);
        Span span4 = new Span();
        Span span5 = new Span();
        if (bl2) {
            span3.add(new Text(this.resMap.get(this.kAttemptVCenterServerConnection)));
            span5.add(new Text(this.resMap.get(this.kVCenterServerError)));
            span4.add(new Text(this.resMap.get(kNetworkError)));
        } else {
            span3.add(new Text(this.resMap.get(kAttemptESXiServerConnection)));
            span5.add(new Text(this.resMap.get(kESXiHostError)));
            span4.add(new Text(this.resMap.get(kESXiHostNetworkError)));
        }
        span5.setId("invalidConnectionSpan");
        span5.setCssClass(HIDDEN);
        container.add(span5);
        span4.setId("networkErrorSpan");
        span4.setCssClass(HIDDEN);
        container.add(span4);
        Span span6 = new Span(this.resMap.get(UNTRUSTED_CERT_WARNING));
        span6.setId("untrustedCertWarning");
        span6.setCssClass(HIDDEN);
        container.add(span6);
        this.theInvalidCredentials = this.resMap.get(kInvalidCredentials);
        Span span7 = new Span();
        span7.add(new Text(this.theInvalidCredentials));
        span7.setId("invalidCredentialsSpan");
        span7.setCssClass(HIDDEN);
        container.add(span7);
        Span span8 = new Span();
        span8.add(new Text(this.resMap.get(kRangeValidation)));
        span8.setId("rangeSpan");
        span8.setCssClass(HIDDEN);
        container.add(span8);
    }

    public HTML createVCenterServerHTML(PageContext pageContext, boolean bl) {
        Object object;
        Division division = new Division();
        division.setId("server");
        if (!bl) {
            division.setCssClass("formdiv");
            object = new Division();
            ((HTMLTagWithClassStyle)object).setCssClass("warningMsg ConnectionStatusWait");
            ((HTMLTagWithClassStyle)object).setId("warningDiv");
            ((Container)object).add(new Text(this.resMap.get(this.kAttemptVCenterServerConnection)));
            division.add((HTML)object);
        }
        object = new VMWareDetails();
        if (bl) {
            if (pageContext.getSession().getAttribute("vmware_details") != null) {
                object = (VMWareDetails)pageContext.getSession().getAttribute("vmware_details");
            }
        } else {
            object = this.services.getVirtualConfigurationManager().loadVCenterServerDetails();
        }
        this.theVCenterProtocolLabel = this.resMap.get(kvCenterProtocolLabel);
        this.theVCenterPortLabel = this.resMap.get(kvCenterPortLabel);
        this.theVCenterIPLabel = this.resMap.get(kvCenterIPLabel);
        this.thevCenterUsernameLabel = this.resMap.get(kvCenterUsernameLabel);
        this.thevCenterPasswordLabel = this.resMap.get(kvCenterPasswordLabel);
        String string = ((VMWareDetails)object).getProtocol();
        String string2 = this.validatePort(string, ((VMWareDetails)object).getPort());
        String string3 = this.validateIpAddress(((VMWareDetails)object).getServerIp());
        ((VMWareDetails)object).setPort(string2);
        if (bl) {
            division.add(this.createProtocolDiv((VMWareDetails)object, this.theVCenterProtocolLabel, VCENTER_PROTOCOL));
            division.add(this.createPortDiv(string2, this.theVCenterPortLabel, VCENTER_PORT));
            division.add(this.createServerIPDiv((VMWareDetails)object, this.theVCenterIPLabel, VCENTER_IP));
            division.add(this.createUsernameDiv((VMWareDetails)object, this.thevCenterUsernameLabel, VCENTER_USERNAME));
            division.add(FormHelper.createPasswordDiv(this.thevCenterPasswordLabel, VCENTER_PASSWORD));
            division.add(this.createVCenterInstalledOnAVMDiv((VMWareDetails)object));
            division.add(this.createHyperConvergedSelectionDiv((VMWareDetails)object));
            Division division2 = new Division();
            division2.setId("validateConnection");
            this.theAttemptVCenterServerConnection = this.resMap.get(this.kAttemptVCenterServerConnection);
            division2.add(new Text(this.theAttemptVCenterServerConnection));
            division2.setCssClass("checkingConnection ConnectionStatusWait");
            Division division3 = new Division();
            division3.setCssClass("waitDialog");
            division3.setId("waitDialog");
            division3.add(division2);
            division.add(division3);
            Division division4 = new Division();
            division4.setId("connectionError");
            division4.add(new Text(this.resMap.get(kNetworkError)));
            division4.setCssClass("scvmmError");
            division.add(division4);
        } else {
            division.add(FormHelper.createLabelAndReadOnlyValueDiv(VCENTER_PROTOCOL, this.theVCenterProtocolLabel, string, null));
            division.add(FormHelper.createLabelAndReadOnlyValueDiv(VCENTER_PORT, this.theVCenterPortLabel, string2, null));
            division.add(FormHelper.createLabelAndReadOnlyValueDiv(VCENTER_IP, this.theVCenterIPLabel, string3, null));
            division.add(this.createUsernameDiv((VMWareDetails)object, this.thevCenterUsernameLabel, VCENTER_USERNAME));
            division.add(FormHelper.createPasswordDiv(this.thevCenterPasswordLabel, VCENTER_PASSWORD));
            division.add(this.createVCenterInstalledOnAVMDiv((VMWareDetails)object));
        }
        this.addResources(division, pageContext, bl);
        return division;
    }

    public HTML createESXiHostHTML(PageContext pageContext, boolean bl) {
        Object object;
        Division division = new Division();
        division.setId("server");
        if (!bl) {
            division.setCssClass("formdiv");
            object = new Division();
            ((HTMLTagWithClassStyle)object).setCssClass("warningMsg ConnectionStatusWait");
            ((HTMLTagWithClassStyle)object).setId("warningDiv");
            ((Container)object).add(new Text(this.resMap.get(this.kAttemptVCenterServerConnection)));
            division.add((HTML)object);
            this.theESXiProtocolLabel = this.resMap.get(kConfigureESXiProtocolLabel);
            this.theESXiPortLabel = this.resMap.get(kConfigureESXiPortLabel);
            this.theESXiIPLabel = this.resMap.get(kConfigureESXiIpLabel);
            this.theESXiUsernameLabel = this.resMap.get(kConfigureESXiUsernameLabel);
            this.theESXiPasswordLabel = this.resMap.get(kConfigureESXiPasswordLabel);
        } else {
            this.theESXiProtocolLabel = this.resMap.get(kESXiProtocolLabel);
            this.theESXiPortLabel = this.resMap.get(kESXiPortLabel);
            this.theESXiIPLabel = this.resMap.get(kESXiIPLabel);
            this.theESXiUsernameLabel = this.resMap.get(kESXiUsernameLabel);
            this.theESXiPasswordLabel = this.resMap.get(kESXiPasswordLabel);
        }
        object = new VMWareDetails();
        object = bl ? (VMWareDetails)pageContext.getSession().getAttribute("vmware_details") : (this.services.getVirtualConfigurationManager().isManagedHost() ? this.services.getVirtualConfigurationManager().loadVCenterServerDetails() : this.services.getVirtualConfigurationManager().loadESXiHostServerDetails());
        if (object == null) {
            object = new VMWareDetails();
        }
        String string = ((VMWareDetails)object).getProtocol();
        String string2 = this.validatePort(string, ((VMWareDetails)object).getPort());
        String string3 = this.validateIpAddress(((VMWareDetails)object).getServerIp());
        if (bl) {
            division.add(this.createProtocolDiv((VMWareDetails)object, this.theESXiProtocolLabel, ESXI_PROTOCOL));
            division.add(this.createPortDiv(string2, this.theESXiPortLabel, ESXI_PORT));
            division.add(this.createServerIPDiv((VMWareDetails)object, this.theESXiIPLabel, ESXI_IP));
            division.add(this.createUsernameDiv((VMWareDetails)object, this.theESXiUsernameLabel, ESXI_USERNAME));
            division.add(FormHelper.createPasswordDiv(this.theESXiPasswordLabel, ESXI_PASSWORD));
            Division division2 = new Division();
            division2.setId("validateConnection");
            this.theAttemptESXiServerConnection = this.resMap.get(kAttemptESXiServerConnection);
            division2.add(new Text(this.theAttemptESXiServerConnection));
            division2.setCssClass("checkingConnection ConnectionStatusWait");
            Division division3 = new Division();
            division3.setCssClass("waitDialog");
            division3.setId("waitDialog");
            division3.add(division2);
            division.add(division3);
            this.theESXiNetworkError = this.resMap.get(kESXiHostNetworkError);
            Division division4 = new Division();
            division4.setId("connectionError");
            division4.add(new Text(this.theESXiNetworkError));
            division4.setCssClass("scvmmError");
            division.add(division4);
        } else {
            division.add(FormHelper.createLabelAndReadOnlyValueDiv(ESXI_PROTOCOL, this.theESXiProtocolLabel, string, null));
            division.add(FormHelper.createLabelAndReadOnlyValueDiv(ESXI_PORT, this.theESXiPortLabel, string2, null));
            division.add(FormHelper.createLabelAndReadOnlyValueDiv(ESXI_IP, this.theESXiIPLabel, string3, null));
            division.add(this.createUsernameDiv((VMWareDetails)object, this.theESXiUsernameLabel, ESXI_USERNAME));
            division.add(FormHelper.createPasswordDiv(this.theESXiPasswordLabel, ESXI_PASSWORD));
        }
        this.addResources(division, pageContext, bl);
        return division;
    }

    private String validatePort(String string, @Nullable String string2) {
        IntRangeSetValidator intRangeSetValidator = new IntRangeSetValidator();
        intRangeSetValidator.add(0, 65353);
        if (string2 == null || string2.isEmpty() || !intRangeSetValidator.isValid(Integer.parseInt(string2))) {
            string2 = string.equalsIgnoreCase("https") ? String.valueOf(VirtualConfigurationManager.DEFAULT_HTTPS_PORT) : String.valueOf(VirtualConfigurationManager.DEFAULT_HTTP_PORT);
        }
        return string2;
    }

    private String validateIpAddress(String string) {
        InetAddressValidator inetAddressValidator = new InetAddressValidator();
        if (inetAddressValidator.isValid(string)) {
            return string;
        }
        if (string != null && string.indexOf(":") != -1 && (string.startsWith("[") || string.endsWith("]"))) {
            string = string.replaceAll("\\[", "").replaceAll("\\]", "");
        }
        return string;
    }

    private HTML createProtocolDiv(VMWareDetails vMWareDetails, String string, String string2) {
        Vector<Option> vector = new Vector<Option>();
        vector.add(0, new Option(""));
        Option option = new Option("https", "https");
        Option option2 = new Option("http", "http");
        if (vMWareDetails.getProtocol().equalsIgnoreCase("https")) {
            option.setSelected(true);
        } else if (vMWareDetails.getProtocol().equalsIgnoreCase("http")) {
            option2.setSelected(true);
        } else {
            option.setSelected(true);
            vMWareDetails.setProtocol("https");
        }
        vector.add(1, option);
        vector.add(2, option2);
        this.theVCenterProtocolLabel = this.resMap.get(kvCenterProtocolLabel);
        return FormHelper.createLabelSelectValueDiv(null, string, "value", null, string2, vector);
    }

    public HTML createPortDiv(String string, String string2, String string3) {
        return FormHelper.createLabelTextInputValueDiv(null, string2, string, null, string3, null, 255, 5, null);
    }

    private HTML createServerIPDiv(VMWareDetails vMWareDetails, String string, String string2) {
        String string3 = this.validateIpAddress(vMWareDetails.getServerIp());
        return FormHelper.createLabelTextInputValueDiv(null, string, string3, null, string2, null, 255, 34, null);
    }

    private HTML createUsernameDiv(VMWareDetails vMWareDetails, String string, String string2) {
        return FormHelper.createLabelTextInputValueDiv(null, string, vMWareDetails.getUsername(), null, string2, null, 255, 34, null);
    }

    private HTML createVCenterInstalledOnAVMDiv(VMWareDetails vMWareDetails) {
        return FormHelper.createLabelCheckboxValueDiv(null, this.resMap.get(kVCenterInstalledOnaVMLabel), vMWareDetails.isVCenterInstalledOnaVM(), IS_VCSA, IS_VCSA, this.resMap.get(kVCenterInstalledOnaVMNote));
    }

    private HTML createHyperConvergedSelectionDiv(VMWareDetails vMWareDetails) {
        ArrayList<Option> arrayList = new ArrayList<Option>();
        Option option = new Option(HyperconvergedSupport.NONE.getIniSetting(), this.resMap.get(NO_HYPERCONVERED_SUPPORT));
        if (HyperconvergedSupport.NONE.equals((Object)vMWareDetails.getHyperconvergedSupport())) {
            option.setSelected(true);
        }
        arrayList.add(option);
        Option option2 = new Option(HyperconvergedSupport.HYPERFLEX.getIniSetting(), this.resMap.get(HYPERCONVERGED_HYPERFLEX_LABEL));
        if (HyperconvergedSupport.HYPERFLEX.equals((Object)vMWareDetails.getHyperconvergedSupport())) {
            option2.setSelected(true);
        }
        arrayList.add(option2);
        Option option3 = new Option(HyperconvergedSupport.NUTANIX.getIniSetting(), this.resMap.get(HYPERCONVERGED_NUTANIX_LABEL));
        if (HyperconvergedSupport.NUTANIX.equals((Object)vMWareDetails.getHyperconvergedSupport())) {
            option3.setSelected(true);
        }
        arrayList.add(option3);
        Option option4 = new Option(HyperconvergedSupport.SIMPLIVITY.getIniSetting(), this.resMap.get(HYPERCONVERGED_SIMPLIVITY_LABEL));
        if (HyperconvergedSupport.SIMPLIVITY.equals((Object)vMWareDetails.getHyperconvergedSupport())) {
            option4.setSelected(true);
        }
        arrayList.add(option4);
        Option option5 = new Option(HyperconvergedSupport.VXRAIL.getIniSetting(), this.resMap.get(HYPERCONVERGED_VXRAIL_LABEL));
        if (HyperconvergedSupport.VXRAIL.equals((Object)vMWareDetails.getHyperconvergedSupport())) {
            option5.setSelected(true);
        }
        arrayList.add(option5);
        return FormHelper.createLabelSelectValueDiv(null, this.resMap.get(HYPERCONVERGED_SUPPORT_LABEL), null, "value", HYPERCONVERGED_SUPPORT, arrayList);
    }
}

