/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.util;

import com.apcc.m11.components.webserver.html.Container;
import com.apcc.m11.components.webserver.html.HTML;
import com.apcc.m11.components.webserver.html.HTMLTagWithClassStyle;
import com.apcc.m11.components.webserver.html.PageContext;
import com.apcc.m11.components.webserver.html.Text;
import com.apcc.m11.components.webserver.html.apc.ApcHelp;
import com.apcc.m11.components.webserver.html.apc.ApcSectionHeader;
import com.apcc.m11.components.webserver.html.document.Division;
import com.apcc.m11.components.webserver.html.document.Span;
import com.apcc.m11.components.webserver.html.form.Input;
import com.apcc.m11.components.webserver.util.FormHelper;
import com.apcc.m11.components.webserver.util.Utils;
import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.util.ResourceBundleWrapper;
import com.apcc.pcns.vxrail.VxRailDetails;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import lombok.NonNull;

public class VxRailHTMLHelper {
    private static final String CSS_HIDDEN = "hidden";
    public static final String VXRAIL_CLUSTER_IP = "vxrail_cluster_ip";
    public static final String ACCEPT_CERTS = "accept_certs";
    public static final String PARAM_SHUTDOWN_DELAY = "shutdown_delay";
    public static final String PARAM_SHUTDOWN_DURATION = "shutdown_duration";
    private static final String CLUSTER_IP_LABEL = "CfgWizard.VxRailClusterDetails.ClusterIpLabel";
    private static final String ATTEMPT_CLUSTER_CONNECTION = "CfgWizard.VxRailClusterDetails.AttemptClusterConnection";
    private static final String HEADER_TEXT = "CfgWizard.VxRailClusterDetails.PageTitle";
    private static final String SUBHEADER_TEXT = "CfgWizard.VxRailClusterDetails.PageDescription";
    private static final String REQUIRED_VALIDATOR = "PCNS.RequiredField";
    private static final String IP_VALIDATOR = "PCNS.NutanixClusterValidation";
    public static final String CLUSTER_NETWORK_ERROR = "Configure.VxRailClusterError";
    private static final String INVALID_CREDENTIALS_ERROR = "CfgWizard.NutanixClusterDetails.NutanixClusterInvalidCredentials";
    private static final String RANGE_VALIDATOR = "PCNS.RangeValidation";
    private static final String ACCEPT_CERTS_LABEL = "CfgWizard.P05UpsDetailsPage.AcceptCertsLabel";
    private static final String ACCEPT_CERTS_TOOLTIP = "CfgWizard.P05UpsDetailsPage.AcceptCertsNote";
    private String clusterIPLabel;
    private String theAcceptCertsLabelText;
    private String theAcceptCertsTooltipText;
    private Map<String, String> resMap;
    private ServiceManager services;

    public VxRailHTMLHelper(Locale locale, @NonNull ServiceManager serviceManager) {
        if (serviceManager == null) {
            throw new IllegalArgumentException("services is marked non-null but is null");
        }
        this.services = serviceManager;
        this.resMap = new HashMap<String, String>();
        this.getVMSettingsResourceStrings(locale);
    }

    private void getVMSettingsResourceStrings(Locale locale) {
        ResourceBundleWrapper resourceBundleWrapper = Utils.getWebServerResourceBundle(locale);
        this.resMap.put(ATTEMPT_CLUSTER_CONNECTION, Utils.getResourceString(resourceBundleWrapper, ATTEMPT_CLUSTER_CONNECTION));
        this.resMap.put(HEADER_TEXT, Utils.getResourceString(resourceBundleWrapper, HEADER_TEXT));
        this.resMap.put(SUBHEADER_TEXT, Utils.getResourceString(resourceBundleWrapper, SUBHEADER_TEXT));
        this.resMap.put(REQUIRED_VALIDATOR, Utils.getResourceString(resourceBundleWrapper, REQUIRED_VALIDATOR));
        this.resMap.put(IP_VALIDATOR, Utils.getResourceString(resourceBundleWrapper, IP_VALIDATOR));
        this.resMap.put(CLUSTER_NETWORK_ERROR, Utils.getResourceString(resourceBundleWrapper, CLUSTER_NETWORK_ERROR));
        this.resMap.put(INVALID_CREDENTIALS_ERROR, Utils.getResourceString(resourceBundleWrapper, INVALID_CREDENTIALS_ERROR));
        this.resMap.put(RANGE_VALIDATOR, Utils.getResourceString(resourceBundleWrapper, RANGE_VALIDATOR));
        this.theAcceptCertsLabelText = Utils.getResourceString(resourceBundleWrapper, ACCEPT_CERTS_LABEL);
        this.theAcceptCertsTooltipText = Utils.getResourceString(resourceBundleWrapper, ACCEPT_CERTS_TOOLTIP);
        this.clusterIPLabel = Utils.getResourceString(resourceBundleWrapper, CLUSTER_IP_LABEL);
    }

    public HTML createConnectionSectionHeader() {
        ApcSectionHeader apcSectionHeader = new ApcSectionHeader(this.resMap.get(HEADER_TEXT), this.resMap.get(SUBHEADER_TEXT));
        apcSectionHeader.setHelpId(ApcHelp.CLUSTER_DETAILS_VXRAIL);
        return apcSectionHeader;
    }

    public Division createVxRailErrorDiv() {
        String string = this.resMap.get(CLUSTER_NETWORK_ERROR);
        return FormHelper.createErrorDivision("connectionError", string, "error-alert");
    }

    public HTML createVxRailConnectionHTML(PageContext pageContext, boolean bl, boolean bl2) {
        Object object;
        Division division = new Division();
        division.setId("vxrail");
        if (!bl && !bl2) {
            division.setCssClass("formdiv");
            object = new Division();
            ((HTMLTagWithClassStyle)object).setCssClass("warningMsg ConnectionStatusWait");
            ((HTMLTagWithClassStyle)object).setId("vxRailCheckInProgress");
            ((Container)object).add(new Text(this.resMap.get(ATTEMPT_CLUSTER_CONNECTION)));
            division.add((HTML)object);
        }
        object = this.getVxRailDetails(pageContext, bl);
        if (bl2) {
            Input input = new Input();
            input.setId("hostSelection");
            input.setType(CSS_HIDDEN);
            division.add(input);
        } else {
            division.add(FormHelper.createServerIPDiv(((VxRailDetails)object).getVxRailManagerIp(), this.clusterIPLabel, VXRAIL_CLUSTER_IP));
            if (bl) {
                String string = this.resMap.get(ATTEMPT_CLUSTER_CONNECTION);
                Division division2 = new Division();
                division2.setId("validateConnection");
                division2.add(new Text(string));
                division2.setCssClass("checkingConnection ConnectionStatusWait");
                Division division3 = new Division();
                division3.setCssClass("waitDialog");
                division3.setId("waitDialog");
                division3.add(division2);
                division.add(division3);
                division.add(this.createVxRailErrorDiv());
            }
        }
        this.addResources(division);
        return division;
    }

    private VxRailDetails getVxRailDetails(PageContext pageContext, boolean bl) {
        VxRailDetails vxRailDetails;
        if (bl) {
            vxRailDetails = (VxRailDetails)pageContext.getSession().getAttribute("vxrail_details");
            if (vxRailDetails == null) {
                vxRailDetails = this.services.getVxRailUtils().loadVxRailDetails();
            }
        } else {
            vxRailDetails = this.services.getVxRailUtils().loadVxRailDetails();
        }
        return vxRailDetails;
    }

    public void addResources(Container container) {
        String string = this.resMap.get(REQUIRED_VALIDATOR);
        Span span = new Span();
        span.add(new Text(string));
        span.setId("requiredSpan");
        span.setCssClass(CSS_HIDDEN);
        container.add(span);
        String string2 = this.resMap.get(IP_VALIDATOR);
        Span span2 = new Span();
        span2.add(new Text(string2));
        span2.setId("invalidIpSpan");
        span2.setCssClass(CSS_HIDDEN);
        container.add(span2);
        Span span3 = new Span();
        span3.setId("attemptConnectionSpan");
        span3.setCssClass(CSS_HIDDEN);
        span3.add(new Text(this.resMap.get(ATTEMPT_CLUSTER_CONNECTION)));
        container.add(span3);
        Span span4 = new Span();
        span4.add(new Text(this.resMap.get(CLUSTER_NETWORK_ERROR)));
        span4.setId("networkErrorSpan");
        span4.setCssClass(CSS_HIDDEN);
        container.add(span4);
        String string3 = this.resMap.get(INVALID_CREDENTIALS_ERROR);
        Span span5 = new Span();
        span5.add(new Text(string3));
        span5.setId("invalidCredentialsSpan");
        span5.setCssClass(CSS_HIDDEN);
        container.add(span5);
    }

    public HTML createConnectionHTML(PageContext pageContext, boolean bl) {
        Division division = new Division();
        division.setId("vxrail");
        VxRailDetails vxRailDetails = this.getVxRailDetails(pageContext, bl);
        String string = vxRailDetails.getVxRailManagerIp();
        if (bl) {
            division.add(FormHelper.createServerIPDiv(string, this.clusterIPLabel, VXRAIL_CLUSTER_IP));
        } else {
            division.setCssClass("formdiv");
            Division division2 = new Division();
            division2.setCssClass("warningMsg ConnectionStatusWait");
            division2.setId("vxRailCheckInProgress");
            division2.add(new Text(this.resMap.get(ATTEMPT_CLUSTER_CONNECTION)));
            division.add(division2);
            division.add(FormHelper.createLabelAndReadOnlyValueDiv(VXRAIL_CLUSTER_IP, this.clusterIPLabel, string, null));
        }
        this.addResources(division);
        return division;
    }
}

