/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.util.virtualization;

import com.apcc.m11.components.webserver.model.PrioritizedVM;
import com.apcc.m11.components.webserver.model.PrioritizedVMLists;
import com.apcc.m11.components.webserver.model.UPSSetup;
import com.apcc.m11.components.webserver.model.VMOperations;
import com.apcc.m11.components.webserver.model.VMPrioritizationDurations;
import com.apcc.m11.components.webserver.model.VMPrioritizationOperations;
import com.apcc.m11.components.webserver.model.VMPriority;
import com.apcc.m11.components.webserver.model.VMPriorityArray;
import com.apcc.m11.components.webserver.model.VMPriorityVector;
import com.apcc.m11.components.webserver.util.AdvancedSetupHelper;
import com.apcc.m11.components.webserver.util.virtualization.VirtualisationStatusStore;
import com.apcc.pcns.configservice.VirtualConfigurationManager;
import com.apcc.pcns.configservice.configurationmanagers.ConfigurationManager;
import com.vmware.vim25.mo.VirtualApp;
import com.vmware.vim25.mo.VirtualMachine;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.configuration2.ex.ConversionException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VMPrioritizationUtils {
    private static Logger logger = LogManager.getLogger(VMPrioritizationUtils.class);
    public static final String VM_DELIMITER = "|";
    private static final String VIRTUAL_APP_SUFFIX = "_vapp";
    private VirtualConfigurationManager configUtils;
    private AdvancedSetupHelper advancedSetupHelper;
    @NonNull
    private ConfigurationManager config;
    @NonNull
    private VirtualisationStatusStore virtualisationStatusStore;

    public void setVirtualConfigurationManager(VirtualConfigurationManager virtualConfigurationManager) {
        this.configUtils = virtualConfigurationManager;
    }

    public void setAdvancedSetupHelper(AdvancedSetupHelper advancedSetupHelper) {
        this.advancedSetupHelper = advancedSetupHelper;
    }

    public boolean isVMPrioritizationEnabled() {
        boolean bl = false;
        try {
            bl = this.config.getBoolean("HostConfigSettings", "vm_prioritization_enabled");
        }
        catch (NoSuchElementException | ConversionException throwable) {
            logger.debug((Object)throwable);
        }
        logger.trace("isVMPrioritizationEnabled() - result: {}", (Object)bl);
        return bl;
    }

    public VMPrioritizationDurations readVMPrioritizationDurationsFromConfig(VMOperations vMOperations) {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        VMPrioritizationDurations vMPrioritizationDurations = new VMPrioritizationDurations();
        switch (vMOperations) {
            case MIGRATION: {
                string = "vm_migration_duration_high";
                string2 = "vm_migration_duration_medium";
                string3 = "vm_migration_duration_low";
                string4 = "vm_migration_duration_group_1";
                string5 = "vm_migration_duration_group_2";
                string6 = "vm_migration_duration_none";
                string7 = "guest_vm_migration_duration";
                break;
            }
            case SHUTDOWN: {
                string = "vm_shutdown_duration_high";
                string2 = "vm_shutdown_duration_medium";
                string3 = "vm_shutdown_duration_low";
                string4 = "vm_shutdown_duration_group_1";
                string5 = "vm_shutdown_duration_group_2";
                string6 = "vm_shutdown_duration_none";
                string7 = this.configUtils.isNutanixAHV() ? "uvm_shutdown_duration" : "guest_vm_vapp_shutdown_duration";
                break;
            }
            case STARTUP: {
                string = "vm_startup_duration_high";
                string2 = "vm_startup_duration_medium";
                string3 = "vm_startup_duration_low";
                string4 = "vm_startup_duration_group_1";
                string5 = "vm_startup_duration_group_2";
                string6 = "vm_startup_duration_none";
                String string8 = string7 = this.configUtils.isNutanixAHV() ? "uvm_startup_duration" : "guest_vm_vapp_startup_duration";
            }
        }
        if (string != null) {
            try {
                vMPrioritizationDurations.setHighDuration(this.config.getInt("VMPrioritization", string));
            }
            catch (NoSuchElementException | ConversionException throwable) {
                logger.debug((Object)throwable);
            }
            try {
                vMPrioritizationDurations.setMediumDuration(this.config.getInt("VMPrioritization", string2));
            }
            catch (NoSuchElementException | ConversionException throwable) {
                logger.debug((Object)throwable);
            }
            try {
                vMPrioritizationDurations.setLowDuration(this.config.getInt("VMPrioritization", string3));
            }
            catch (NoSuchElementException | ConversionException throwable) {
                logger.debug((Object)throwable);
            }
            try {
                vMPrioritizationDurations.setGroup1Duration(this.config.getInt("VMPrioritization", string4));
            }
            catch (NoSuchElementException | ConversionException throwable) {
                logger.debug((Object)throwable);
            }
            try {
                vMPrioritizationDurations.setGroup2Duration(this.config.getInt("VMPrioritization", string5));
            }
            catch (NoSuchElementException | ConversionException throwable) {
                logger.debug((Object)throwable);
            }
            try {
                vMPrioritizationDurations.setUnPrioritizedDuration(this.config.getInt("VMPrioritization", string6));
            }
            catch (NoSuchElementException | ConversionException throwable) {
                logger.debug((Object)throwable);
            }
            if (!this.isVMPrioritizationEnabled() && vMPrioritizationDurations.getTotalDuration() <= 0) {
                try {
                    vMPrioritizationDurations.setUnPrioritizedDuration(this.config.getInt("HostConfigSettings", string7));
                }
                catch (NoSuchElementException | ConversionException throwable) {
                    logger.debug((Object)throwable);
                }
            }
        }
        return vMPrioritizationDurations;
    }

    public void saveVMPrioritizationDurationsToConfig(VMOperations vMOperations, VMPrioritizationDurations vMPrioritizationDurations) {
        if (vMOperations == null || vMPrioritizationDurations == null) {
            return;
        }
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        boolean bl = false;
        bl = this.config.isAutoSave();
        this.config.setAutoSave(false);
        switch (vMOperations) {
            case MIGRATION: {
                string = "vm_migration_duration_high";
                string2 = "vm_migration_duration_medium";
                string3 = "vm_migration_duration_low";
                string4 = "vm_migration_duration_group_1";
                string5 = "vm_migration_duration_group_2";
                string6 = "vm_migration_duration_none";
                string7 = "guest_vm_migration_duration";
                break;
            }
            case SHUTDOWN: {
                string = "vm_shutdown_duration_high";
                string2 = "vm_shutdown_duration_medium";
                string3 = "vm_shutdown_duration_low";
                string4 = "vm_shutdown_duration_group_1";
                string5 = "vm_shutdown_duration_group_2";
                string6 = "vm_shutdown_duration_none";
                string7 = this.configUtils.isNutanixAHV() ? "uvm_shutdown_duration" : "guest_vm_vapp_shutdown_duration";
                break;
            }
            case STARTUP: {
                string = "vm_startup_duration_high";
                string2 = "vm_startup_duration_medium";
                string3 = "vm_startup_duration_low";
                string4 = "vm_startup_duration_group_1";
                string5 = "vm_startup_duration_group_2";
                string6 = "vm_startup_duration_none";
                string7 = this.configUtils.isNutanixAHV() ? "uvm_startup_duration" : "guest_vm_vapp_startup_duration";
            }
        }
        this.config.setProperty("VMPrioritization", string, vMPrioritizationDurations.getHighDuration());
        this.config.setProperty("VMPrioritization", string2, vMPrioritizationDurations.getMediumDuration());
        this.config.setProperty("VMPrioritization", string3, vMPrioritizationDurations.getLowDuration());
        this.config.setProperty("VMPrioritization", string4, vMPrioritizationDurations.getGroup1Duration());
        this.config.setProperty("VMPrioritization", string5, vMPrioritizationDurations.getGroup2Duration());
        this.config.setProperty("VMPrioritization", string6, vMPrioritizationDurations.getUnPrioritizedDuration());
        this.config.setProperty("HostConfigSettings", string7, vMPrioritizationDurations.getTotalDuration());
        if (this.advancedSetupHelper.isAdvancedShutdownMode()) {
            for (String string8 : this.config.getSections()) {
                if (!string8.startsWith("advanced_ups_setup_")) continue;
                try {
                    this.config.getString(string8, "setup_name");
                }
                catch (ConversionException conversionException) {
                    logger.debug((Object)conversionException);
                    continue;
                }
                if (!this.config.containsKey(string8, "hostlist") && !this.config.containsKey(string8, "enable_guest_vm_vapp_shutdown")) continue;
                this.config.setProperty(string8, string7, vMPrioritizationDurations.getTotalDuration());
            }
        }
        this.config.save();
        if (bl) {
            this.config.setAutoSave(true);
        }
    }

    private static String getConfigKeyPriority(VMPriority vMPriority) {
        String string = null;
        switch (vMPriority) {
            case HIGH: {
                string = "vm_list_high";
                break;
            }
            case MEDIUM: {
                string = "vm_list_medium";
                break;
            }
            case LOW: {
                string = "vm_list_low";
                break;
            }
            case GROUP_1: {
                string = "vm_list_group_1";
                break;
            }
            case GROUP_2: {
                string = "vm_list_group_2";
                break;
            }
        }
        return string;
    }

    public ArrayList<PrioritizedVM> readPrioritizedVMListFromConfig(VMPriority vMPriority) {
        String string;
        ArrayList<PrioritizedVM> arrayList = new ArrayList<PrioritizedVM>();
        String string2 = VMPrioritizationUtils.getConfigKeyPriority(vMPriority);
        if (string2 != null && (string = this.getPriorityListFromConfig(string2)) != null) {
            PrioritizedVM prioritizedVM = null;
            StringTokenizer stringTokenizer = new StringTokenizer(string, VM_DELIMITER);
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (string3.trim().isEmpty()) continue;
                prioritizedVM = new PrioritizedVM();
                if (StringUtils.endsWith((CharSequence)string3, (CharSequence)VIRTUAL_APP_SUFFIX)) {
                    prioritizedVM.setVMName(StringUtils.substringBeforeLast((String)string3, (String)VIRTUAL_APP_SUFFIX));
                    prioritizedVM.setVirtualApp(true);
                } else {
                    prioritizedVM.setVMName(string3);
                }
                prioritizedVM.setPriority(vMPriority);
                arrayList.add(prioritizedVM);
            }
        }
        return arrayList;
    }

    private String getPriorityListFromConfig(String string) {
        String string2 = null;
        try {
            string2 = this.config.getString("VMPrioritization", string);
        }
        catch (ConversionException conversionException) {
            logger.debug("getPriorityListFromConfig() - ConversionException: ", (Throwable)conversionException);
        }
        return string2;
    }

    public ArrayList<String> readPrioritizedVAppListFromConfig(VMPriority vMPriority) {
        String string;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = VMPrioritizationUtils.getConfigKeyPriority(vMPriority);
        if (string2 != null && (string = this.getPriorityListFromConfig(string2)) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, VM_DELIMITER);
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (string3.trim().isEmpty() || !StringUtils.endsWith((CharSequence)string3, (CharSequence)VIRTUAL_APP_SUFFIX)) continue;
                arrayList.add(StringUtils.substringBeforeLast((String)string3, (String)VIRTUAL_APP_SUFFIX));
            }
        }
        return arrayList;
    }

    public void savePrioritizedVMListToConfig(VMPriority vMPriority, List<PrioritizedVM> list) {
        String string = VMPrioritizationUtils.getConfigKeyPriority(vMPriority);
        if (string != null) {
            StringBuffer stringBuffer = new StringBuffer();
            if (list != null) {
                for (PrioritizedVM prioritizedVM : list) {
                    StringBuffer stringBuffer2 = new StringBuffer(prioritizedVM.getVMName());
                    if (prioritizedVM.isVirtualApp()) {
                        stringBuffer2.append(VIRTUAL_APP_SUFFIX);
                    }
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(VM_DELIMITER);
                    }
                    stringBuffer.append(stringBuffer2);
                }
            }
            this.config.setProperty("VMPrioritization", string, stringBuffer.toString());
        }
    }

    public PrioritizedVMLists readPrioritizedVMListsFromConfig(List<PrioritizedVM> list) {
        PrioritizedVMLists prioritizedVMLists = this.readPrioritizedVMListsFromConfig();
        if (list != null && !list.isEmpty()) {
            logger.debug("readPrioritizedVMListsFromConfig() - Filtering priority lists by current inventory.");
            prioritizedVMLists.setHighPriorityVMs(this.filterVMsByInventory(list, prioritizedVMLists.getHighPriorityVMs()));
            prioritizedVMLists.setMediumPriorityVMs(this.filterVMsByInventory(list, prioritizedVMLists.getMediumPriorityVMs()));
            prioritizedVMLists.setLowPriorityVMs(this.filterVMsByInventory(list, prioritizedVMLists.getLowPriorityVMs()));
            prioritizedVMLists.setGroup1PriorityVMs(this.filterVMsByInventory(list, prioritizedVMLists.getGroup1PriorityVMs()));
            prioritizedVMLists.setGroup2PriorityVMs(this.filterVMsByInventory(list, prioritizedVMLists.getGroup2PriorityVMs()));
        } else {
            logger.debug("readPrioritizedVMListsFromConfig() - Inventory list is null or empty, No filtering applied.");
        }
        return prioritizedVMLists;
    }

    public PrioritizedVMLists readPrioritizedVMListsFromConfig() {
        PrioritizedVMLists prioritizedVMLists = new PrioritizedVMLists();
        prioritizedVMLists.setHighPriorityVMs(this.readPrioritizedVMListFromConfig(VMPriority.HIGH));
        prioritizedVMLists.setMediumPriorityVMs(this.readPrioritizedVMListFromConfig(VMPriority.MEDIUM));
        prioritizedVMLists.setLowPriorityVMs(this.readPrioritizedVMListFromConfig(VMPriority.LOW));
        prioritizedVMLists.setGroup1PriorityVMs(this.readPrioritizedVMListFromConfig(VMPriority.GROUP_1));
        prioritizedVMLists.setGroup2PriorityVMs(this.readPrioritizedVMListFromConfig(VMPriority.GROUP_2));
        return prioritizedVMLists;
    }

    public List<PrioritizedVM> filterVMsByInventory(List<PrioritizedVM> list, List<PrioritizedVM> list2) {
        if (list == null || list.isEmpty()) {
            logger.debug("filterVMsByInventory() - Inventory list is null or empty, taking no action.");
            return list2;
        }
        List<String> list3 = list.stream().map(prioritizedVM -> prioritizedVM.getVMName()).toList();
        return list2.stream().filter(prioritizedVM -> list3.contains(prioritizedVM.getVMName())).toList();
    }

    public VMPrioritizationOperations readVMPrioritizationFromConfig() {
        return this.readVMPrioritizationFromConfig(null);
    }

    public VMPrioritizationOperations readVMPrioritizationFromConfig(List<PrioritizedVM> list) {
        VMPrioritizationOperations vMPrioritizationOperations = new VMPrioritizationOperations();
        if (!this.configUtils.isNutanixAHV()) {
            vMPrioritizationOperations.setMigrationDurations(this.readVMPrioritizationDurationsFromConfig(VMOperations.MIGRATION));
        }
        vMPrioritizationOperations.setShutdownDurations(this.readVMPrioritizationDurationsFromConfig(VMOperations.SHUTDOWN));
        vMPrioritizationOperations.setStartupDurations(this.readVMPrioritizationDurationsFromConfig(VMOperations.STARTUP));
        vMPrioritizationOperations.setSequencedVMs(this.readPrioritizedVMListsFromConfig(list));
        return vMPrioritizationOperations;
    }

    public void saveVMPrioritizatonEnabledToConfig(boolean bl) {
        this.config.setProperty("HostConfigSettings", "vm_prioritization_enabled", bl);
    }

    public void removeVMPrioritizationKeysFromConfig() {
        this.config.clearSection("VMPrioritization");
        this.config.clearProperty("HostConfigSettings", "vm_prioritization_enabled");
    }

    public List<VirtualMachine> filterVMsByPriority(VirtualMachine[] virtualMachineArray, VMPriority vMPriority) {
        logger.debug("filterVMsByPriority() - start");
        if (virtualMachineArray == null) {
            return new Vector<VirtualMachine>();
        }
        if (vMPriority == null) {
            logger.debug("filterVMsByPriority() - non-prioritized case");
            return new Vector<VirtualMachine>(Arrays.asList(virtualMachineArray));
        }
        if (vMPriority == VMPriority.NONE) {
            VMPriority[] vMPriorityArray;
            logger.debug("filterVMsByPriority() - NONE");
            Vector<VirtualMachine> vector = new Vector<VirtualMachine>(Arrays.asList(virtualMachineArray));
            for (VMPriority vMPriority2 : vMPriorityArray = new VMPriorityArray().getPriorities()) {
                ArrayList<PrioritizedVM> arrayList = this.readPrioritizedVMListFromConfig(vMPriority2);
                for (VirtualMachine virtualMachine : virtualMachineArray) {
                    logger.debug("filterVMsByPriority() - consider: {}", (Object)virtualMachine.getName());
                    for (PrioritizedVM prioritizedVM : arrayList) {
                        if (!prioritizedVM.getVMName().equals(virtualMachine.getName())) continue;
                        logger.debug("filterVMsByPriority() - remove");
                        vector.remove(virtualMachine);
                    }
                }
            }
            return vector;
        }
        logger.debug("filterVMsByPriority: {}", (Object)vMPriority);
        ArrayList<PrioritizedVM> arrayList = this.readPrioritizedVMListFromConfig(vMPriority);
        Vector<VirtualMachine> vector = new Vector<VirtualMachine>();
        for (PrioritizedVM prioritizedVM : arrayList) {
            logger.debug("filterVMsByPriority() - consider: {}", (Object)prioritizedVM.getVMName());
            for (VirtualMachine virtualMachine : virtualMachineArray) {
                if (!prioritizedVM.getVMName().equals(virtualMachine.getName())) continue;
                logger.debug("filterVMsByPriority() - in list");
                vector.add(virtualMachine);
            }
        }
        logger.debug("filterVMsByPriority done, found: {}", (Object)vector.size());
        return vector;
    }

    public List<String> filterVMsByPriority(List<String> list, VMPriority vMPriority) {
        logger.debug("filterVMsByPriority() - string version");
        if (vMPriority == null) {
            logger.debug("filterVMsByPriority() - non-prioritized case");
            return list;
        }
        if (vMPriority == VMPriority.NONE) {
            VMPriority[] vMPriorityArray;
            logger.debug("filterVMsByPriority() - NONE prioritized case");
            Vector<String> vector = new Vector<String>(list);
            for (VMPriority vMPriority2 : vMPriorityArray = new VMPriorityArray().getPriorities()) {
                ArrayList<PrioritizedVM> arrayList = this.readPrioritizedVMListFromConfig(vMPriority2);
                for (String string : list) {
                    logger.debug("filterVMsByPriority() - consider: {}", (Object)string);
                    for (PrioritizedVM prioritizedVM : arrayList) {
                        if (!prioritizedVM.getVMName().equals(string)) continue;
                        logger.debug("filterVMsByPriority() - remove");
                        vector.remove(string);
                    }
                }
            }
            return vector;
        }
        logger.debug("filterVMsByPriority: {}", (Object)vMPriority);
        ArrayList<PrioritizedVM> arrayList = this.readPrioritizedVMListFromConfig(vMPriority);
        Vector<String> vector = new Vector<String>();
        for (String string : list) {
            logger.debug("filterVMsByPriority() - consider: {}", (Object)string);
            for (PrioritizedVM prioritizedVM : arrayList) {
                if (!prioritizedVM.getVMName().equals(string)) continue;
                logger.debug("filterVMsByPriority() - in list");
                vector.add(string);
            }
        }
        logger.debug("filterVMsByPriority done, found: {}", (Object)vector.size());
        return vector;
    }

    public Map<String, String> filterVMsByPriority(Map<String, String> map, VMPriority vMPriority) {
        logger.debug("filterVMsByPriority Map<String, String> version");
        Map<String, String> map2 = null;
        if (vMPriority == null) {
            logger.debug("non-prioritised case");
            return map;
        }
        if (vMPriority == VMPriority.NONE) {
            logger.debug("NONE prioritised case");
            VMPriority[] vMPriorityArray = new VMPriority[]{VMPriority.HIGH, VMPriority.MEDIUM, VMPriority.LOW, VMPriority.GROUP_1, VMPriority.GROUP_2};
            ArrayList arrayList = new ArrayList();
            for (VMPriority vMPriority2 : vMPriorityArray) {
                this.readPrioritizedVMListFromConfig(vMPriority2).stream().map(prioritizedVM -> prioritizedVM.getVMName()).forEach(string -> arrayList.add(string));
            }
            map2 = map.entrySet().stream().filter(entry -> {
                String string = (String)entry.getValue();
                logger.debug("consider: {}", (Object)string);
                return !arrayList.contains(string);
            }).collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> (String)entry.getValue()));
        } else {
            logger.debug("filterVMsByPriority: {}", (Object)vMPriority);
            List list = this.readPrioritizedVMListFromConfig(vMPriority).stream().map(prioritizedVM -> prioritizedVM.getVMName()).collect(Collectors.toList());
            map2 = map.entrySet().stream().filter(entry -> {
                String string = (String)entry.getValue();
                logger.debug("consider: {}", (Object)string);
                return list.contains(string);
            }).collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> (String)entry.getValue()));
        }
        logger.debug("filterVMsByPriority done, found: {}", (Object)map2.size());
        return map2;
    }

    public List<VirtualApp> filterVAppsByPriority(Set<VirtualApp> set, VMPriority vMPriority) {
        List<VirtualApp> list;
        logger.debug("filterVAppsByPriority() - start");
        if (vMPriority == null) {
            logger.debug("filterVAppsByPriority() - no priority");
            list = new Vector<VirtualApp>(set);
        } else if (vMPriority == VMPriority.NONE) {
            VMPriority[] vMPriorityArray;
            logger.debug("filterVAppsByPriority() - priority: none");
            ArrayList<String> arrayList = new ArrayList<String>();
            for (VMPriority vMPriority2 : vMPriorityArray = new VMPriorityArray().getPriorities()) {
                arrayList.addAll(this.readPrioritizedVAppListFromConfig(vMPriority2));
            }
            list = VMPrioritizationUtils.addCriticalVApps(set, true, arrayList);
        } else {
            logger.debug("filterVAppsByPriority() - priority: " + String.valueOf((Object)vMPriority));
            ArrayList<String> arrayList = this.readPrioritizedVAppListFromConfig(vMPriority);
            list = VMPrioritizationUtils.addCriticalVApps(set, false, arrayList);
        }
        logger.debug("filterVAppsByPriority() - done, found: " + list.size());
        return list;
    }

    public List<String> filterVAppsByPriority(List<String> list, VMPriority vMPriority) {
        List<String> list2;
        logger.debug("filterVAppsByPriority() - start");
        if (vMPriority == null) {
            logger.debug("filterVAppsByPriority() - non-prioritized case");
            return list;
        }
        if (vMPriority == VMPriority.NONE) {
            VMPriority[] vMPriorityArray;
            logger.debug("filterVAppsByPriority() - priority: none");
            ArrayList<String> arrayList = new ArrayList<String>();
            for (VMPriority vMPriority2 : vMPriorityArray = new VMPriorityArray().getPriorities()) {
                arrayList.addAll(this.readPrioritizedVAppListFromConfig(vMPriority2));
            }
            list2 = VMPrioritizationUtils.addCriticalVApps(list, true, arrayList);
        } else {
            logger.debug("filterVAppsByPriority() - priority: " + String.valueOf((Object)vMPriority));
            ArrayList<String> arrayList = this.readPrioritizedVAppListFromConfig(vMPriority);
            list2 = VMPrioritizationUtils.addCriticalVApps(list, false, arrayList);
        }
        logger.debug("filterVAppsByPriority() - done, found: " + list2.size());
        return list2;
    }

    private static List<String> addCriticalVApps(List<String> list, boolean bl, List<String> list2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (list2 != null) {
            for (String string : list) {
                logger.debug("addCriticalVApps() - vApp: " + string);
                if (bl && list2.contains(string)) {
                    logger.debug("addCriticalVApps() - excluding: " + string);
                    continue;
                }
                if (!bl && !list2.contains(string)) {
                    logger.debug("addCriticalVApps() - skipping: " + string);
                    continue;
                }
                arrayList.add(string);
            }
        }
        return arrayList;
    }

    private static List<VirtualApp> addCriticalVApps(Set<VirtualApp> set, boolean bl, List<String> list) {
        ArrayList<VirtualApp> arrayList = new ArrayList<VirtualApp>();
        if (list != null) {
            for (VirtualApp virtualApp : set) {
                logger.debug("addCriticalVApps() - vApp: " + virtualApp.getName());
                if (bl && list.contains(virtualApp.getName())) {
                    logger.debug("addCriticalVApps() - excluding: " + virtualApp.getName());
                    continue;
                }
                if (!bl && !list.contains(virtualApp.getName())) {
                    logger.debug("addCriticalVApps() - skipping: " + virtualApp.getName());
                    continue;
                }
                arrayList.add(virtualApp);
            }
        }
        return arrayList;
    }

    public List<VirtualMachine> filterVAppVMsByPriority(VirtualMachine[] virtualMachineArray, Map<String, List<String>> map, VMPriority vMPriority) {
        List<VirtualMachine> list;
        if (vMPriority == null) {
            logger.debug("filterVAppVMsByPriority() - no priority");
            list = VMPrioritizationUtils.addCriticalVAppVMs(virtualMachineArray, map);
        } else if (vMPriority == VMPriority.NONE) {
            VMPriority[] vMPriorityArray;
            logger.debug("filterVAppVMsByPriority() - priority: none");
            ArrayList<String> arrayList = new ArrayList<String>();
            for (VMPriority vMPriority2 : vMPriorityArray = new VMPriorityArray().getPriorities()) {
                arrayList.addAll(this.readPrioritizedVAppListFromConfig(vMPriority2));
            }
            list = VMPrioritizationUtils.addCriticalVAppVMs(virtualMachineArray, map, true, arrayList);
        } else {
            logger.debug("filterVAppVMsByPriority() - priority: " + String.valueOf((Object)vMPriority));
            ArrayList<String> arrayList = this.readPrioritizedVAppListFromConfig(vMPriority);
            list = VMPrioritizationUtils.addCriticalVAppVMs(virtualMachineArray, map, false, arrayList);
        }
        logger.debug("filterVAppVMsByPriority() - done, found: " + list.size());
        return list;
    }

    private static List<VirtualMachine> addCriticalVAppVMs(VirtualMachine[] virtualMachineArray, Map<String, List<String>> map) {
        return VMPrioritizationUtils.addCriticalVAppVMs(virtualMachineArray, map, false, null);
    }

    private static List<VirtualMachine> addCriticalVAppVMs(VirtualMachine[] virtualMachineArray, Map<String, List<String>> map, boolean bl, List<String> list) {
        ArrayList<VirtualMachine> arrayList = new ArrayList<VirtualMachine>();
        if (virtualMachineArray == null) {
            logger.debug("addCriticalVAppVMs() - criticalVMList is null!");
            return arrayList;
        }
        block0: for (VirtualMachine virtualMachine : virtualMachineArray) {
            boolean bl2 = false;
            for (Map.Entry<String, List<String>> entry : map.entrySet()) {
                String string = entry.getKey();
                List<String> list2 = entry.getValue();
                if (bl && list != null && list.contains(string)) {
                    logger.debug("addCriticalVAppVMs() - excluding: " + string);
                    continue;
                }
                if (!bl && list != null && !list.contains(string)) {
                    logger.debug("addCriticalVAppVMs() - skipping: " + string);
                    continue;
                }
                if (list2 == null || list2.isEmpty()) continue;
                for (String string2 : list2) {
                    if (!string2.equals(virtualMachine.getName())) continue;
                    logger.debug("addCriticalVAppVMs() - added to list VM: " + virtualMachine.getName());
                    arrayList.add(virtualMachine);
                    bl2 = true;
                    break;
                }
                if (!bl2) continue;
                continue block0;
            }
        }
        return arrayList;
    }

    public PrioritizedVM checkIfVMExistsInPrioritizedVMList(String string) {
        VMPriority[] vMPriorityArray;
        for (VMPriority vMPriority : vMPriorityArray = new VMPriorityArray().getPriorities()) {
            ArrayList<PrioritizedVM> arrayList = this.readPrioritizedVMListFromConfig(vMPriority);
            for (PrioritizedVM prioritizedVM : arrayList) {
                if (!prioritizedVM.getVMName().equals(string)) continue;
                logger.debug("checkIfVMExistsInPrioritizedVMList() - found VM: {} in priority: {}", (Object)string, (Object)vMPriority);
                return prioritizedVM;
            }
        }
        logger.debug("checkIfVMExistsInPrioritizedVMList() - VM: {} not found", (Object)string);
        return null;
    }

    public boolean isVMInPrioritizedVMList(String string) {
        if (StringUtils.isEmpty((CharSequence)string)) {
            logger.debug("isVMInPrioritizedVMList() - no VM given, returning false");
            return false;
        }
        logger.debug("isVMInPrioritizedVMList() - checking VM: {} ", (Object)string);
        return this.checkIfVMExistsInPrioritizedVMList(string) != null;
    }

    public PrioritizedVM checkIfVCSAVMInVMPrioritizedList() {
        if (!this.isVMPrioritizationEnabled()) {
            logger.debug("checkIfVCSAVMInVMPrioritizedList() - not required, VM prioritization not enabled");
            return null;
        }
        String string = this.virtualisationStatusStore.getProperty("VCSA_VM");
        if (string == null) {
            logger.debug("checkIfVCSAVMInVMPrioritizedList() - vCSAVmName is null");
            return null;
        }
        PrioritizedVM prioritizedVM = this.checkIfVMExistsInPrioritizedVMList(string);
        if (prioritizedVM != null) {
            logger.debug("checkIfVCSAVMInVMPrioritizedList() - vCSAVmName: {} found in VM Prioritization list", (Object)string);
        } else {
            logger.debug("checkIfVCSAVMInVMPrioritizedList() - vCSAVmName: {} not found in VM Prioritization list", (Object)string);
        }
        return prioritizedVM;
    }

    public int getVMVAppStartupDuration(VMPriority vMPriority, VMPrioritizationDurations vMPrioritizationDurations, String string) {
        int n = 0;
        if (vMPriority == null) {
            if (this.advancedSetupHelper.isAdvancedShutdownMode()) {
                UPSSetup uPSSetup = this.advancedSetupHelper.getHostUPSSetup(string);
                if (uPSSetup != null) {
                    n = uPSSetup.getVMSettings().getGuestVMVappStartupDuration();
                } else {
                    logger.debug("getVMVAppStartupDuration() - upSetup is null for host: {}", (Object)string);
                }
            } else {
                String string2 = this.configUtils.isNutanixAHV() ? "uvm_startup_duration" : "guest_vm_vapp_startup_duration";
                n = this.configUtils.getDurationGlobal(string2);
            }
        } else {
            n = vMPrioritizationDurations.getDuration(vMPriority);
        }
        return n;
    }

    public static void logPriorityDurationZero(Map<String, String> map, VMPriority vMPriority) {
        if (!map.isEmpty()) {
            logger.error("logPriorityDurationZero() - duration for priority: {} is 0, skipping startup of VMs: {}", (Object)vMPriority, map);
        } else {
            logger.debug("logPriorityDurationZero() - duration for priority: {} is 0, skipping startup", (Object)vMPriority);
        }
    }

    public Vector<VMPriority> getVMStartupPriorities(boolean bl) {
        Vector<VMPriority> vector = !bl ? new VMPriorityVector(this.isVMPrioritizationEnabled()).getPriorities() : new VMPriorityVector(false).getPriorities();
        return vector;
    }

    public List<VMPriority> getPriorities() {
        boolean bl = this.isVMPrioritizationEnabled();
        return Collections.unmodifiableList(new VMPriorityVector(bl).getPriorities());
    }

    @Generated
    public void setConfig(@NonNull ConfigurationManager configurationManager) {
        if (configurationManager == null) {
            throw new IllegalArgumentException("config is marked non-null but is null");
        }
        this.config = configurationManager;
    }

    @Generated
    public void setVirtualisationStatusStore(@NonNull VirtualisationStatusStore virtualisationStatusStore) {
        if (virtualisationStatusStore == null) {
            throw new IllegalArgumentException("virtualisationStatusStore is marked non-null but is null");
        }
        this.virtualisationStatusStore = virtualisationStatusStore;
    }
}

