/*
 * Decompiled with CFR 0.152.
 */
package com.apcc.m11.components.webserver.util.virtualization;

import com.apcc.pcns.ServiceManager;
import com.apcc.pcns.configservice.VirtualConfigurationManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import lombok.NonNull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VirtualisationStatusStore {
    private static final Logger logger = LogManager.getLogger(VirtualisationStatusStore.class);
    public static final String VIRTUALIZATION_FILE_STORE = "VirtualizationFileStore.properties";
    public static final String VAPP_KEY_SUFFIX = "VApps";
    public static final String VMS_KEY_SUFFIX = "VMs";
    public static final String REATTEMPT_STARTUP_SUFFIX = "Reattempt";
    public static final String RETRY = "Retry";
    public static final String LOCK_VALUE = "true";
    public static final String UNLOCK_VALUE = "false";
    public static final String LOCK_KEY = "LOCK";
    public static final String GROUP_LOCK_KEY = "GroupLock";
    public static final String KEY_SEPARATOR = "_";
    public static final String CLUSTER_VM_LIST = "ClusterVMList";
    public static final String NONCLUSTER_VM_LIST = "NonClusterVMList";
    public static final String VCSA_VM = "VCSA_VM";
    public static final String VCSA_HOST = "VCSA_HOST";
    public static final String VCSA_HOSTNAME = "VCSA_HOSTNAME";
    public static final String VSAN_WITNESS_VM = "Witness_VM";
    public static final String VSAN_WITNESS_VM_HOST = "Witness_VM_HOST";
    public static final String CVM_KEY_SUFFIX = "_CVM";
    public static final String DRS_PARTIALLYAUTOMATED_KEY = "DRS_PARTIALLY_AUTOMATED";
    public static final String NTNX_CLUSTER_STOPPED = "NTNX_STOPPED";
    public static final String HYPERFLEX_CLUSTER_STOPPED = "HYPERFLEX_STOPPED";
    public static final String VCLS_DISABLED = "VCLS_DISABLED";
    public static final String HA_DISABLED = "HA_DISABLED";
    public static final String VSAN_RECOVERY_NEEDED = "VSAN_RECOVERY_NEEDED";
    private static final String SHUTDOWN_ENABLED_KEY = "ShutdownAlreadyEnabled";
    private VirtualConfigurationManager configUtils;
    private String vCSAHostName = null;

    public VirtualisationStatusStore(VirtualConfigurationManager virtualConfigurationManager) {
        logger.debug("create VirtualisationStatusStore");
        this.configUtils = virtualConfigurationManager;
    }

    public synchronized void initialiseHypervKeys() {
        logger.debug("initialiseHypervKeys() - start");
        Properties properties = this.loadProperties();
        if (!properties.containsKey(CLUSTER_VM_LIST)) {
            properties.setProperty(CLUSTER_VM_LIST, "");
        }
        if (!properties.containsKey(NONCLUSTER_VM_LIST)) {
            properties.setProperty(NONCLUSTER_VM_LIST, "");
        }
        this.storeProperties(properties);
    }

    public static synchronized String getVirtualStorePropertyFilePath() {
        File file;
        Object object = ServiceManager.getInstance().getApplicationSettings().getApplicationDirectory();
        if (!((String)object).isEmpty()) {
            object = (String)object + File.separator;
        }
        if (!(file = new File((String)(object = (String)object + VIRTUALIZATION_FILE_STORE))).exists()) {
            try {
                if (!file.createNewFile()) {
                    logger.debug("getVirtualStorePropertyFilePath() - Failed to create file: {}", (Object)file.getAbsolutePath());
                }
            }
            catch (IOException iOException) {
                logger.error((Object)iOException);
            }
        }
        logger.trace("getVirtualStorePropertyFilePath() - end, result: {}", object);
        return object;
    }

    public synchronized LinkedHashSet<String> getHostSetFromVirtualizationFileStore(boolean bl) {
        logger.trace("getLockedHostSetFromVirtualizationFileStore() - start");
        Properties properties = this.loadProperties();
        String string = bl ? LOCK_VALUE : UNLOCK_VALUE;
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        Set<String> set = properties.stringPropertyNames();
        for (String string2 : set) {
            String string3;
            if (!string2.startsWith(LOCK_KEY) || (string3 = properties.getProperty(string2)) == null || !string3.equalsIgnoreCase(string)) continue;
            String string4 = StringUtils.substringAfter((String)string2, (String)KEY_SEPARATOR);
            linkedHashSet.add(string4);
        }
        ArrayList arrayList = new ArrayList(linkedHashSet);
        Collections.reverse(arrayList);
        linkedHashSet.clear();
        linkedHashSet.addAll(arrayList);
        if (!linkedHashSet.isEmpty()) {
            logger.debug("getHostSetFromVirtualizationFileStore() - locked: {} hosts: {}", (Object)bl, linkedHashSet);
        }
        logger.trace("getHostSetFromVirtualizationFileStore() - end, locked: {} hosts: {}", (Object)bl, linkedHashSet);
        return linkedHashSet;
    }

    public synchronized Set<String> getClusterSetWithDrsChanged() {
        logger.debug("getClusterSetWithDrsChanged() - start");
        Properties properties = this.loadProperties();
        HashSet<String> hashSet = new HashSet<String>();
        Set<String> set = properties.stringPropertyNames();
        for (String string : set) {
            String string2;
            if (!string.startsWith(DRS_PARTIALLYAUTOMATED_KEY) || (string2 = properties.getProperty(string)) == null) continue;
            String string3 = StringUtils.substring((String)string, (int)(DRS_PARTIALLYAUTOMATED_KEY.length() + KEY_SEPARATOR.length()));
            hashSet.add(string3);
        }
        logger.debug("getClusterSetWithDrsChanged() - end, result: {}", hashSet);
        return hashSet;
    }

    public synchronized void addClusterDrsChangedKey(String string) {
        logger.debug("addClusterDrsChangedKey() - cluster: {}", (Object)string);
        this.setProperty("DRS_PARTIALLY_AUTOMATED_" + string, "ON");
    }

    public synchronized boolean removeClusterDrsChangedKey(String string) {
        logger.debug("removeClusterDrsChangedKey() - cluster: {}", (Object)string);
        return this.removeProperty("DRS_PARTIALLY_AUTOMATED_" + string);
    }

    public synchronized boolean isGroupLocked(int n) {
        logger.debug("isGroupLocked() - group: {}", (Object)n);
        Properties properties = this.loadProperties();
        String string = "GroupLock_" + n;
        String string2 = properties.getProperty(string);
        logger.debug("isGroupLocked() - key: {}", (Object)string);
        return string2 != null;
    }

    public synchronized Set<Integer> getGroupLocks() {
        logger.debug("getGroupLocks() - start");
        Properties properties = this.loadProperties();
        HashSet<Integer> hashSet = new HashSet<Integer>();
        Set<String> set = properties.stringPropertyNames();
        for (String string : set) {
            if (!string.startsWith(GROUP_LOCK_KEY)) continue;
            int n = 0;
            try {
                logger.debug("getGroupLocks() - propertyKey: {}", (Object)string);
                n = Integer.parseInt(StringUtils.substringAfter((String)string, (String)KEY_SEPARATOR));
                hashSet.add(n);
            }
            catch (NumberFormatException numberFormatException) {
                logger.info("getGroupLocks() - NumberFormatException getting group from propertyKey: {} - ", (Object)string, (Object)numberFormatException);
            }
        }
        logger.debug("getGroupLocks() - end, result: {}", hashSet);
        return hashSet;
    }

    public synchronized void createGroupLock(int n) {
        logger.debug("createGroupLock() - group: {}", (Object)n);
        Properties properties = this.loadProperties();
        String string = "GroupLock_" + n;
        logger.info("createGroupLock() - setting group lock, key: {}, value: {}", (Object)string, (Object)LOCK_VALUE);
        properties.setProperty(string, LOCK_VALUE);
        this.storeProperties(properties);
    }

    public synchronized void removeGroupLock(int n) {
        logger.debug("removeGroupLock() - group: {}", (Object)n);
        this.removeProperty("GroupLock_" + n);
    }

    public synchronized void lockHostForShutdown(String string) {
        logger.info("lockHostForShutdown() - host: {}", (Object)string);
        Properties properties = this.loadProperties();
        properties.setProperty("LOCK_" + string, LOCK_VALUE);
        this.storeProperties(properties);
    }

    public synchronized void unlockHostForShutdown(String string) {
        String string2 = this.configUtils.getFQDNFromIP(string);
        String string3 = this.configUtils.getIPFromHostName(string);
        logger.info("unlockHostForShutdown() - host: {}", (Object)string);
        Properties properties = this.loadProperties();
        String string4 = properties.getProperty("LOCK_" + string2);
        if (StringUtils.isNotEmpty((CharSequence)string4)) {
            logger.debug("unlockHostForShutdown() - found hostFQDN lock key: {}", (Object)string4);
            properties.setProperty("LOCK_" + string2, UNLOCK_VALUE);
            logger.info("unlockHostForShutdown() - setting key: {}, value: {}", (Object)("LOCK_" + string2), (Object)UNLOCK_VALUE);
            this.storeProperties(properties);
        }
        if (StringUtils.isNotEmpty((CharSequence)(string4 = properties.getProperty("LOCK_" + string3)))) {
            logger.debug("unlockHostForShutdown() - found hostIP lock key: {}", (Object)string4);
            properties.setProperty("LOCK_" + string3, UNLOCK_VALUE);
            logger.info("unlockHostForShutdown() - setting key: {}, value: {}", (Object)("LOCK_" + string3), (Object)UNLOCK_VALUE);
            this.storeProperties(properties);
        }
    }

    public synchronized void clearHostForShutdown(String string) {
        logger.debug("clearHostForShutdown() - host: {}", (Object)string);
        String string2 = this.configUtils.getFQDNFromIP(string);
        String string3 = this.configUtils.getIPFromHostName(string);
        Properties properties = this.loadProperties();
        String string4 = "LOCK_" + string3;
        logger.info("clearHostForShutdown() - removing hostIP key: {}", (Object)string4);
        properties.remove(string4);
        string4 = "LOCK_" + string2;
        logger.info("clearHostForShutdown() - removing hostFQDN key: {}", (Object)string4);
        properties.remove(string4);
        this.storeProperties(properties);
    }

    public synchronized void unlockNonCriticalHosts(Set<String> set) {
        logger.info("unlockNonCriticalHosts() - all except: {}", set);
        LinkedHashSet<String> linkedHashSet = this.getHostSetFromVirtualizationFileStore(true);
        for (String string : linkedHashSet) {
            if (set.contains(string) || !this.isHostLockedForShutdown(string)) continue;
            this.unlockHostForShutdown(string);
        }
    }

    public synchronized boolean isHostLockedForShutdown(String string) {
        logger.debug("isHostLockedForShutdown() - host: {}", (Object)string);
        if (string == null) {
            logger.debug("isHostLockedForShutdown() - hostName is null, returning false");
            return false;
        }
        String string2 = this.configUtils.getFQDNFromIP(string);
        String string3 = this.configUtils.getIPFromHostName(string);
        Properties properties = this.loadProperties();
        String string4 = "LOCK_" + string2;
        String string5 = properties.getProperty(string4);
        logger.debug("isHostLockedForShutdown() - FQDN key: {}, value: {}", (Object)string4, (Object)string5);
        String string6 = "LOCK_" + string3;
        String string7 = properties.getProperty(string6);
        logger.debug("isHostLockedForShutdown() - IP key: {}, value: {}", (Object)string6, (Object)string7);
        if (string5 != null && LOCK_VALUE.equalsIgnoreCase(string5)) {
            logger.debug("isHostLockedForShutdown() - FQDN host: {} locked for shutdown", (Object)string2);
            return true;
        }
        if (string7 != null && LOCK_VALUE.equalsIgnoreCase(string7)) {
            logger.debug("isHostLockedForShutdown() - IP host: {} locked for shutdown", (Object)string3);
            return true;
        }
        logger.debug("isHostLockedForShutdown() - not locked");
        return false;
    }

    public synchronized boolean isHostUnlockedForShutdown(String string) {
        logger.debug("isHostUnlockedForShutdown() - host: {}", (Object)string);
        String string2 = this.configUtils.getFQDNFromIP(string);
        String string3 = this.configUtils.getIPFromHostName(string);
        Properties properties = this.loadProperties();
        String string4 = "LOCK_" + string2;
        String string5 = properties.getProperty(string4);
        logger.debug("isHostUnlockedForShutdown() - FQDN key: {}, value: {}", (Object)string4, (Object)string5);
        String string6 = "LOCK_" + string3;
        String string7 = properties.getProperty(string6);
        logger.debug("isHostUnlockedForShutdown() - IP key: {}, value: {}", (Object)string6, (Object)string7);
        if (string5 != null && UNLOCK_VALUE.equalsIgnoreCase(string5)) {
            logger.debug("isHostUnlockedForShutdown() - FQDN host: {} not locked for shutdown value exists", (Object)string2);
            return true;
        }
        if (string7 != null && UNLOCK_VALUE.equalsIgnoreCase(string7)) {
            logger.debug("isHostUnlockedForShutdown() - IP host: {} not locked for shutdown value exists", (Object)string3);
            return true;
        }
        logger.debug("isHostUnlockedForShutdown() - not unlocked");
        return false;
    }

    protected synchronized Properties loadProperties() {
        logger.trace("loadProperties() - start");
        Properties properties = new Properties();
        File file = new File(VirtualisationStatusStore.getVirtualStorePropertyFilePath());
        try (FileInputStream fileInputStream = new FileInputStream(file);
             BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "UTF-8"));){
            properties.load(bufferedReader);
        }
        catch (FileNotFoundException fileNotFoundException) {
            logger.error("loadProperties() - FileNotFoundException: ", (Throwable)fileNotFoundException);
        }
        catch (NullPointerException nullPointerException) {
            logger.error("loadProperties() - NullPointerException: ", (Throwable)nullPointerException);
        }
        catch (IOException iOException) {
            logger.error("loadProperties() - IOException: ", (Throwable)iOException);
        }
        return this.normalizeProperties(properties);
    }

    private Properties normalizeProperties(@NonNull Properties properties) {
        if (properties == null) {
            throw new IllegalArgumentException("properties is marked non-null but is null");
        }
        Properties properties2 = new Properties();
        for (Object object : properties.keySet()) {
            String string = properties.getProperty(object.toString());
            if (StringUtils.isNotBlank((CharSequence)string)) {
                String string2 = Normalizer.normalize(string, Normalizer.Form.NFKC);
                properties2.setProperty(object.toString(), string2);
                if (StringUtils.equals((CharSequence)string, (CharSequence)string2)) continue;
                logger.debug("normalizeProperties() - Normalised '{}' to '{}'", (Object)string, (Object)string2);
                continue;
            }
            properties2.setProperty(object.toString(), string);
        }
        return properties2;
    }

    protected synchronized void storeProperties(Properties properties) {
        logger.debug("storeProperties() - start");
        try (FileOutputStream fileOutputStream = new FileOutputStream(VirtualisationStatusStore.getVirtualStorePropertyFilePath());
             OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");){
            properties.store(outputStreamWriter, null);
        }
        catch (IOException iOException) {
            logger.error("storeProperties() - IOException: ", (Throwable)iOException);
        }
        catch (NullPointerException nullPointerException) {
            logger.error("storeProperties() - NullPointerException: ", (Throwable)nullPointerException);
        }
    }

    public List<String> getStartupvAppList(String string) {
        ArrayList<String> arrayList = null;
        try {
            Properties properties = this.loadProperties();
            String string2 = string + "_VApps";
            String string3 = properties.getProperty(string2);
            if (string3 != null && !string3.isEmpty()) {
                arrayList = new ArrayList<String>(Arrays.asList(string3.split(",")));
                Collections.reverse(arrayList);
            }
        }
        catch (NullPointerException nullPointerException) {
            logger.error("getStartupvAppList() - NullPointerException: ", (Throwable)nullPointerException);
        }
        logger.debug("getStartupvAppList() - end, result: {}", arrayList);
        return arrayList;
    }

    public List<String> getStartupVMList(String string) {
        logger.debug("getStartupVMList() - start: {}", (Object)string);
        List<String> list = Collections.emptyList();
        try {
            Properties properties = this.loadProperties();
            String string2 = string + "_VMs";
            String string3 = properties.getProperty(string2);
            if (string3 != null && !string3.isEmpty()) {
                list = new ArrayList<String>(Arrays.asList(string3.split(",")));
                Collections.reverse(list);
            }
        }
        catch (NullPointerException nullPointerException) {
            logger.error("getStartupVMList() - NullPointerException: {}", (Throwable)nullPointerException);
        }
        logger.debug("getStartupVMList() - end, result: {}", list);
        return list;
    }

    public boolean hasVmsToStart(String string) {
        logger.debug("hasVmsToStart() - start: {}", (Object)string);
        if (!CollectionUtils.isEmpty(this.getStartupVMList(string))) {
            logger.debug("hasVmsToStart() - VMs to start found for: {}", (Object)string);
            return true;
        }
        if (!CollectionUtils.isEmpty(this.getReattemptVMStartupList(string))) {
            logger.debug("hasVmsToStart() - VMs to reattempt start found for: {}", (Object)string);
            return true;
        }
        logger.debug("hasVmsToStart() - no VMs to start found for: {}", (Object)string);
        return false;
    }

    public boolean hasVAppsToStart(String string) {
        logger.debug("hasVAppsToStart() - start: {}", (Object)string);
        if (!CollectionUtils.isEmpty(this.getStartupvAppList(string))) {
            logger.debug("hasVAppsToStart() - vApps to start found for: {}", (Object)string);
            return true;
        }
        if (!CollectionUtils.isEmpty(this.getReattemptvAppStartupList(string))) {
            logger.debug("hasVAppsToStart() - vApps to reattempt start found for: {}", (Object)string);
            return true;
        }
        logger.debug("hasVAppsToStart() - no vApps to start found for: {}", (Object)string);
        return false;
    }

    public synchronized void saveReAttemptVMs(List<String> list, String string) {
        String string2;
        Properties properties = this.loadProperties();
        String string3 = string2 = properties.getProperty("Reattempt_VMs_" + string);
        for (String string4 : list) {
            string3 = this.mergedCSValues(string3, string4);
        }
        logger.info("saveReAttemptVMs() - host: {}, value: {}", (Object)string, (Object)string3);
        properties.setProperty("Reattempt_VMs_" + string, string3);
        this.storeProperties(properties);
    }

    public void clearReattemptVMs(String string) {
        logger.debug("clearReattemptVMs() - host: {}", (Object)string);
        this.removeProperty("Reattempt_VMs_" + string);
    }

    public synchronized void saveReAttemptVApps(List<String> list, String string) {
        String string2;
        Properties properties = this.loadProperties();
        String string3 = string2 = properties.getProperty("Reattempt_VApps_" + string);
        for (String string4 : list) {
            string3 = this.mergedCSValues(string3, string4);
        }
        logger.info("saveReAttemptVApps() - host: {}, value: {}", (Object)string, (Object)string3);
        properties.setProperty("Reattempt_VApps_" + string, string3);
        this.storeProperties(properties);
    }

    public void clearReattemptVApps(String string) {
        logger.debug("clearReattemptVApps() - host: {}", (Object)string);
        this.removeProperty("Reattempt_VApps_" + string);
    }

    public List<String> getReattemptVMStartupList(String string) {
        String string2;
        ArrayList<String> arrayList = null;
        Properties properties = this.loadProperties();
        String string3 = properties.getProperty(string2 = "Reattempt_VMs_" + string);
        if (string3 != null && !string3.isEmpty()) {
            arrayList = new ArrayList<String>(Arrays.asList(string3.split(",")));
        }
        logger.debug("getReattemptVMStartupList() - end, result: {}", arrayList);
        return arrayList;
    }

    public List<String> getReattemptvAppStartupList(String string) {
        String string2;
        ArrayList<String> arrayList = null;
        Properties properties = this.loadProperties();
        String string3 = properties.getProperty(string2 = "Reattempt_VApps_" + string);
        if (string3 != null && !string3.isEmpty()) {
            arrayList = new ArrayList<String>(Arrays.asList(string3.split(",")));
        }
        logger.debug("getReattemptvAppStartupList() - end, result: {}", arrayList);
        return arrayList;
    }

    public LinkedHashSet<String> getVMAndVAppUnlockedHostList() {
        LinkedHashSet<String> linkedHashSet = this.getVMAndVAppHostList();
        Iterator iterator = linkedHashSet.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!this.isHostLockedForShutdown(string)) continue;
            iterator.remove();
        }
        logger.debug("getVMAndVAppUnlockedHostList() - end, result: {}", linkedHashSet);
        return linkedHashSet;
    }

    public LinkedHashSet<String> getVMAndVAppHostList() {
        Properties properties = this.loadProperties();
        Set<String> set = properties.stringPropertyNames();
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (String string : set) {
            String string2;
            if (!string.endsWith(VMS_KEY_SUFFIX) && !string.endsWith(VAPP_KEY_SUFFIX) && !string.startsWith(REATTEMPT_STARTUP_SUFFIX) || linkedHashSet.contains(string2 = this.parseHostName(string))) continue;
            linkedHashSet.add(string2);
        }
        if (!linkedHashSet.isEmpty()) {
            logger.debug("getVMAndVAppHostList() - end, result: {}", linkedHashSet);
        }
        logger.trace("getVMAndVAppHostList() - end, result: {}", linkedHashSet);
        return linkedHashSet;
    }

    private String parseHostName(String string) {
        String string2 = null;
        String[] stringArray = string.split(KEY_SEPARATOR);
        if (!(string.startsWith(LOCK_KEY) || string.startsWith(SHUTDOWN_ENABLED_KEY) || string.startsWith(REATTEMPT_STARTUP_SUFFIX))) {
            string2 = stringArray[0];
        } else if (string.startsWith(LOCK_KEY)) {
            string2 = stringArray[1];
        } else if (string.startsWith(REATTEMPT_STARTUP_SUFFIX)) {
            string2 = stringArray[2];
        }
        logger.debug("parseHostName() - end, result: {}", (Object)string2);
        return string2;
    }

    public synchronized void setVcsaHost(String string, String string2) {
        logger.debug("setVcsaHost() - host: {}, VCSA_HOST: {}", (Object)string2, (Object)string);
        this.setProperty(VCSA_HOST, string);
        this.setProperty(VCSA_HOSTNAME, string2);
        this.vCSAHostName = string2;
    }

    public synchronized String getVcsaHost() {
        String string = this.getProperty(VCSA_HOST);
        logger.trace("getVcsaHost() - end, result: {}", (Object)string);
        return string;
    }

    public synchronized String getVcsaVmName() {
        String string = this.getProperty(VCSA_VM);
        logger.trace("getVcsaVmName() - end, result: {}", (Object)string);
        return string;
    }

    public synchronized String getVcsaHostName() {
        logger.trace("getVcsaHostName() - end, result: {}", (Object)this.vCSAHostName);
        return this.vCSAHostName;
    }

    public synchronized void removeVcsaKeys() {
        logger.info("removeVcsaKeys() - removing VCSA_VM, VCSA_HOST & VCSA_HOSTNAME keys from properties file");
        Properties properties = this.loadProperties();
        properties.remove(VCSA_VM);
        properties.remove(VCSA_HOST);
        properties.remove(VCSA_HOSTNAME);
        this.storeProperties(properties);
    }

    public synchronized void removeVcsaVMKey() {
        logger.info("removeVcsaVMKey() - removing VCSA_VM key from properties file");
        Properties properties = this.loadProperties();
        properties.remove(VCSA_VM);
        this.storeProperties(properties);
    }

    public synchronized boolean removeProperty(String string) {
        boolean bl = false;
        Properties properties = this.loadProperties();
        if (properties != null && properties.containsKey(string)) {
            properties.remove(string);
            this.storeProperties(properties);
            bl = true;
        }
        logger.info("removeProperty() - end, key: {}, result: {}", (Object)string, (Object)bl);
        return bl;
    }

    public String getProperty(String string) {
        Properties properties = this.loadProperties();
        String string2 = properties.getProperty(string);
        logger.trace("getProperty() - {} = {}", (Object)string, (Object)string2);
        return string2;
    }

    public synchronized void setProperty(String string, String string2) {
        logger.info("setProperty() - {} = {}", (Object)string, (Object)string2);
        Properties properties = this.loadProperties();
        properties.setProperty(string, string2);
        this.storeProperties(properties);
    }

    public String mergedCSValues(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string == null || string.equals("")) {
            stringBuffer.append(string2);
        } else {
            stringBuffer.append(string + ",");
            ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(string.split(",")));
            if (!arrayList.contains(string2)) {
                stringBuffer.append(string2 + ",");
            }
            stringBuffer = stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        }
        logger.debug("mergedCSValues() - {}", (Object)stringBuffer);
        return stringBuffer.toString();
    }

    public synchronized void saveVMToPropertyFile(String string, String string2) {
        logger.debug("saveVMToPropertyFile() - host: {}, VM: {}", (Object)string, (Object)string2);
        Properties properties = this.loadProperties();
        String string3 = properties.getProperty(string + "_VMs");
        String string4 = this.mergedCSValues(string3, string2);
        properties.setProperty(string + "_VMs", string4);
        logger.info("saveVMToPropertyFile() - new VM list: {}", (Object)string4);
        this.storeProperties(properties);
    }

    public synchronized void removeVM(@NonNull String string, @NonNull String string2) {
        if (string == null) {
            throw new IllegalArgumentException("hostName is marked non-null but is null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("vmName is marked non-null but is null");
        }
        logger.debug("removeVM() - host: {}, VM: {}", (Object)string, (Object)string2);
        Properties properties = this.loadProperties();
        String string3 = properties.getProperty(string + "_VMs");
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(StringUtils.split((String)string3, (char)',')));
        arrayList.remove(string2);
        String string4 = StringUtils.join(arrayList, (char)',');
        properties.setProperty(string + "_VMs", string4);
        logger.info("removeVM() - new VM list: {}", (Object)string4);
        this.storeProperties(properties);
    }

    public synchronized void saveVMToPropertyFile(String string, Map<String, String> map) {
        map.keySet().forEach(string2 -> {
            logger.debug("saveVMToPropertyFile() - host: {}, VM: {}", (Object)string, string2);
            Properties properties = this.loadProperties();
            String string3 = properties.getProperty(string + "_VMs");
            String string4 = this.mergedCSValues(string3, (String)string2);
            properties.setProperty(string + "_VMs", string4);
            logger.info("saveVMToPropertyFile() - new VM list: {}", (Object)string4);
            this.storeProperties(properties);
        });
    }

    public void clearVMs(String string) {
        logger.debug("clearVMs() - host: {}", (Object)string);
        this.removeProperty(string + "_VMs");
    }

    public synchronized void savevAppToPropertyFile(String string, String string2) {
        Properties properties = this.loadProperties();
        logger.debug("savevAppToPropertyFile() - host: {}, vApp: {}", (Object)string, (Object)string2);
        String string3 = properties.getProperty(string + "_VApps");
        String string4 = this.mergedCSValues(string3, string2);
        properties.setProperty(string + "_VApps", string4);
        logger.info("savevAppToPropertyFile() - new Vapp list: {}", (Object)string4);
        this.storeProperties(properties);
    }

    public void clearVApps(String string) {
        logger.debug("clearVApps() - host: {}", (Object)string);
        this.removeProperty(string + "_VApps");
    }

    public List<List<String>> getVApps() {
        ArrayList<List<String>> arrayList = new ArrayList<List<String>>();
        Properties properties = this.loadProperties();
        Set<String> set = properties.stringPropertyNames();
        for (String string : set) {
            String string2;
            if (!string.endsWith(VAPP_KEY_SUFFIX) || (string2 = properties.getProperty(string)) == null || string2.isEmpty()) continue;
            ArrayList<String> arrayList2 = new ArrayList<String>(Arrays.asList(string2.split(",")));
            arrayList.add(arrayList2);
        }
        logger.debug("getVApps() - end, result: {}", arrayList);
        return arrayList;
    }

    public String getCvmName(String string) {
        String string2 = "";
        logger.debug("getCvmName() - start, host: {}", (Object)string);
        if (StringUtils.isEmpty((CharSequence)string)) {
            logger.debug("getCvmName() - no host, no CVM");
            return string2;
        }
        try {
            Properties properties = this.loadProperties();
            String string3 = string.concat(CVM_KEY_SUFFIX);
            string2 = properties.getProperty(string3);
        }
        catch (NullPointerException nullPointerException) {
            logger.error("getCvmName() - NullPointerException: ", (Throwable)nullPointerException);
        }
        logger.debug("getCvmName() - end, result: {}", (Object)string2);
        return string2;
    }

    public synchronized void saveCvmToPropertyFile(String string, String string2) {
        logger.info("saveCvmToPropertyFile() - start, host: {}, CVM: {}", (Object)string, (Object)string2);
        Properties properties = this.loadProperties();
        properties.setProperty(string.concat(CVM_KEY_SUFFIX), string2);
        this.storeProperties(properties);
    }

    public synchronized void clearCvm(String string) {
        logger.debug("clearCvm() - start, host: {}", (Object)string);
        if (string != null) {
            this.removeProperty(string.concat(CVM_KEY_SUFFIX));
        }
    }

    public synchronized void clearHostVAppsFromPropertyFile(String string) {
        String string2;
        String string3 = string + "_VApps";
        logger.debug("clearHostVAppsFromPropertyFile() - start, host: {}", (Object)string);
        if (this.removeProperty(string3)) {
            logger.debug("clearHostVAppsFromPropertyFile() - removed invalid key: {}", (Object)string3);
        }
        if (this.removeProperty(string2 = "Reattempt_VApps_" + string)) {
            logger.debug("clearHostVAppsFromPropertyFile() - removed invalid key: {}", (Object)string2);
        }
    }

    public synchronized void clearHostVMsFromPropertyFile(String string) {
        String string2;
        String string3 = string + "_VMs";
        logger.debug("clearHostVMsFromPropertyFile() - start, host: {}", (Object)string);
        if (this.removeProperty(string3)) {
            logger.debug("clearHostVMsFromPropertyFile() - removed invalid key: {}", (Object)string3);
        }
        if (this.removeProperty(string2 = "Reattempt_VMs_" + string)) {
            logger.debug("clearHostVMsFromPropertyFile() - removed invalid key: {}", (Object)string2);
        }
    }

    public synchronized void setNutanixClusterStopped() {
        logger.info("setNutanixClusterStopped() - set to true");
        Properties properties = this.loadProperties();
        properties.setProperty(NTNX_CLUSTER_STOPPED, LOCK_VALUE);
        this.storeProperties(properties);
    }

    public synchronized void clearNutanixClusterStopped() {
        logger.debug("clearNutanixClusterStopped() - clearing");
        this.removeProperty(NTNX_CLUSTER_STOPPED);
    }

    public synchronized boolean isNutanixClusterStopped() {
        Properties properties = this.loadProperties();
        String string = properties.getProperty(NTNX_CLUSTER_STOPPED);
        logger.trace("isNutanixClusterStopped() - value: {}", (Object)string);
        if (string != null && LOCK_VALUE.equalsIgnoreCase(string)) {
            logger.debug("isNutanixClusterStopped() - Nutanix Cluster is stopped");
            return true;
        }
        return false;
    }

    public synchronized void setHyperflexClusterStopped() {
        logger.info("setHyperflexClusterStopped() - set to true");
        Properties properties = this.loadProperties();
        properties.setProperty(HYPERFLEX_CLUSTER_STOPPED, LOCK_VALUE);
        this.storeProperties(properties);
    }

    public synchronized void clearHyperflexClusterStopped() {
        logger.debug("clearHyperflexClusterStopped() - clearing");
        this.removeProperty(HYPERFLEX_CLUSTER_STOPPED);
    }

    public synchronized boolean isHyperflexClusterStopped() {
        Properties properties = this.loadProperties();
        String string = properties.getProperty(HYPERFLEX_CLUSTER_STOPPED);
        logger.trace("isHyperflexClusterStopped() - value: {}", (Object)string);
        if (string != null && LOCK_VALUE.equalsIgnoreCase(string)) {
            logger.debug("isHyperflexClusterStopped() - Hyperflex Cluster is stopped");
            return true;
        }
        return false;
    }

    public boolean isHCIClusterStopped() {
        return this.isNutanixClusterStopped() || this.isHyperflexClusterStopped();
    }

    public void setVclsDisabled(boolean bl) {
        logger.trace("setVclsDisabled() - setting");
        this.setProperty(VCLS_DISABLED, Boolean.toString(bl));
    }

    public boolean isVclsDisabled() {
        return Boolean.parseBoolean(this.getProperty(VCLS_DISABLED));
    }

    public void clearVclsDisabled() {
        logger.trace("clearVclsDisabled() - clearing");
        this.removeProperty(VCLS_DISABLED);
    }

    public void setHaDisabled(boolean bl) {
        this.setProperty(HA_DISABLED, Boolean.toString(bl));
    }

    public boolean isHaDisabled() {
        return Boolean.parseBoolean(this.getProperty(HA_DISABLED));
    }

    public void clearHA() {
        logger.debug("clearHA() - clearing");
        this.removeProperty(HA_DISABLED);
    }

    public boolean isHAorVCLSDisabled() {
        return this.isHaDisabled() || this.isVclsDisabled();
    }

    public void setVsanRecoveryNeeded(boolean bl) {
        this.setProperty(VSAN_RECOVERY_NEEDED, Boolean.toString(bl));
    }

    public boolean isVsanRecoveryNeeded() {
        return Boolean.parseBoolean(this.getProperty(VSAN_RECOVERY_NEEDED));
    }

    public void clearVsanRecoveryNeeded() {
        logger.debug("clearVsanRecoveryNeeded() - clearing");
        this.removeProperty(VSAN_RECOVERY_NEEDED);
    }
}

